/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.ui.editors.entity.EntityConfiguratorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class EntityEditorsRegistry {
    private static final String TAG_EDITOR = "editor";
    private static final String TAG_CONFIGURATOR = "configurator";
    private static EntityEditorsRegistry instance = null;
    private final EntityEditorDescriptor defaultEditor;
    private final List<EntityEditorDescriptor> entityEditors = new ArrayList<EntityEditorDescriptor>();
    private final List<EntityConfiguratorDescriptor> entityConfigurators = new ArrayList<EntityConfiguratorDescriptor>();
    private final Map<String, List<EntityEditorDescriptor>> positionsMap = new HashMap<String, List<EntityEditorDescriptor>>();

    public static synchronized EntityEditorsRegistry getInstance() {
        if (instance == null) {
            instance = new EntityEditorsRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public EntityEditorsRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        this.defaultEditor = new EntityEditorDescriptor();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.databaseEditor");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_EDITOR.equals(ext.getName())) {
                descriptor = new EntityEditorDescriptor(ext);
                this.entityEditors.add((EntityEditorDescriptor)descriptor);
                List list = this.positionsMap.computeIfAbsent(descriptor.getPosition(), k -> new ArrayList());
                list.add(descriptor);
            } else if (TAG_CONFIGURATOR.equals(ext.getName())) {
                descriptor = new EntityConfiguratorDescriptor(ext);
                this.entityConfigurators.add((EntityConfiguratorDescriptor)descriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.entityConfigurators.clear();
        this.entityEditors.clear();
    }

    public EntityEditorDescriptor getMainEntityEditor(DBPObject object, IEntityEditorContext context) {
        for (EntityEditorDescriptor descriptor : this.entityEditors) {
            if (!descriptor.appliesTo(object, context) || !descriptor.isMain() || descriptor.getType() != EntityEditorDescriptor.Type.editor) continue;
            return descriptor;
        }
        return this.defaultEditor;
    }

    public List<EntityEditorDescriptor> getEntityEditors() {
        return this.entityEditors;
    }

    public List<EntityEditorDescriptor> getEntityEditors(DBPObject object, IEntityEditorContext context, String position) {
        List<EntityEditorDescriptor> positionList;
        ArrayList<EntityEditorDescriptor> editors = new ArrayList<EntityEditorDescriptor>();
        List<EntityEditorDescriptor> list = positionList = CommonUtils.isEmpty((String)position) ? this.entityEditors : this.positionsMap.get(position);
        if (positionList != null) {
            for (EntityEditorDescriptor descriptor : positionList) {
                if (!descriptor.appliesTo(object, context)) continue;
                editors.add(descriptor);
            }
        }
        return editors;
    }

    public EntityConfiguratorDescriptor getEntityConfigurator(DBPObject object) {
        ArrayList<EntityConfiguratorDescriptor> allDescriptors = new ArrayList<EntityConfiguratorDescriptor>();
        for (EntityConfiguratorDescriptor descriptor : this.entityConfigurators) {
            if (!descriptor.appliesTo(object) || descriptor.getObjectTypes().length <= 0) continue;
            allDescriptors.add(descriptor);
        }
        if (!allDescriptors.isEmpty()) {
            if (allDescriptors.size() > 1) {
                allDescriptors.sort(Comparator.comparingInt(o -> BeanUtils.getInheritanceDistance((Object)object, (Class)o.getObjectTypes()[0].getImplClass())));
            }
            return (EntityConfiguratorDescriptor)((Object)allDescriptors.getFirst());
        }
        return null;
    }

    public EntityEditorDescriptor getEntityEditor(IEditorPart editor) {
        for (EntityEditorDescriptor ed : this.entityEditors) {
            if (!ed.getEditorType().getImplName().equals(editor.getClass().getName())) continue;
            return ed;
        }
        return null;
    }

    @NotNull
    public EntityEditorDescriptor getDefaultEditor() {
        return this.defaultEditor;
    }
}

