/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.JFreeChart;
import org.jkiss.dbeaver.ui.charts.BaseChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewCompositeControl;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemViewDialog;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemViewSettingsDialog;

public class DashboardChartComposite
extends BaseChartComposite
implements DashboardViewCompositeControl {
    private final DashboardContainer viewContainer;
    private final DashboardItemContainer dashboardContainer;

    public DashboardChartComposite(DashboardItemContainer dashboardContainer, DashboardContainer viewContainer, Composite parent, int style, Point preferredSize) {
        super(parent, style, preferredSize);
        this.dashboardContainer = dashboardContainer;
        this.viewContainer = viewContainer;
    }

    public DashboardContainer getViewContainer() {
        return this.viewContainer;
    }

    protected boolean isSingleChartMode() {
        return this.viewContainer.isSingleChartMode();
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.dashboardContainer.fillDashboardContextMenu(manager, this.isSingleChartMode());
        super.fillContextMenu(manager);
    }

    public void setChart(JFreeChart chart) {
        super.setChart(chart);
        if (chart != null && !this.isSingleChartMode()) {
            this.setDomainZoomable(false);
            this.setRangeZoomable(false);
        }
    }

    protected boolean showChartConfigDialog() {
        boolean changed;
        DashboardItemViewSettingsDialog dialog = new DashboardItemViewSettingsDialog(this.getShell(), this.dashboardContainer, this.viewContainer.getViewConfiguration());
        boolean bl = changed = dialog.open() == 0;
        if (changed) {
            this.dashboardContainer.updateDashboardView();
            this.viewContainer.saveChanges();
        }
        return changed;
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.viewContainer.isSingleChartMode()) {
            this.restoreAutoBounds();
        } else {
            DashboardItemViewDialog viewDialog = new DashboardItemViewDialog(this.viewContainer, this.viewContainer.getConfiguration(), (DashboardViewItem)this.dashboardContainer);
            viewDialog.open();
        }
    }

    @Override
    public Control getDashboardControl() {
        return this.getChartCanvas();
    }
}

