/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.BooleanBinding;
import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.CharacterBinding;
import com.sleepycat.bind.tuple.DoubleBinding;
import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.ShortBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;
import java.util.HashMap;
import java.util.Map;

public abstract class TupleBinding<E>
extends TupleBase<E>
implements EntryBinding<E> {
    private static final Map<Class, TupleBinding> primitives = new HashMap<Class, TupleBinding>();

    private static void addPrimitive(Class clazz, Class clazz2, TupleBinding tupleBinding) {
        primitives.put(clazz, tupleBinding);
        primitives.put(clazz2, tupleBinding);
    }

    @Override
    public E entryToObject(DatabaseEntry databaseEntry) {
        return this.entryToObject(TupleBinding.entryToInput(databaseEntry));
    }

    @Override
    public void objectToEntry(E e, DatabaseEntry databaseEntry) {
        TupleOutput tupleOutput = this.getTupleOutput(e);
        this.objectToEntry(e, tupleOutput);
        TupleBinding.outputToEntry(tupleOutput, databaseEntry);
    }

    public abstract E entryToObject(TupleInput var1);

    public abstract void objectToEntry(E var1, TupleOutput var2);

    public static <T> TupleBinding<T> getPrimitiveBinding(Class<T> clazz) {
        return primitives.get(clazz);
    }

    static {
        TupleBinding.addPrimitive(String.class, String.class, new StringBinding());
        TupleBinding.addPrimitive(Character.class, Character.TYPE, new CharacterBinding());
        TupleBinding.addPrimitive(Boolean.class, Boolean.TYPE, new BooleanBinding());
        TupleBinding.addPrimitive(Byte.class, Byte.TYPE, new ByteBinding());
        TupleBinding.addPrimitive(Short.class, Short.TYPE, new ShortBinding());
        TupleBinding.addPrimitive(Integer.class, Integer.TYPE, new IntegerBinding());
        TupleBinding.addPrimitive(Long.class, Long.TYPE, new LongBinding());
        TupleBinding.addPrimitive(Float.class, Float.TYPE, new FloatBinding());
        TupleBinding.addPrimitive(Double.class, Double.TYPE, new DoubleBinding());
    }
}

