/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class MultipleRecnoNIODataEntry
extends MultipleEntry {
    public MultipleRecnoNIODataEntry() {
        super((ByteBuffer)null);
    }

    public MultipleRecnoNIODataEntry(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    int getMultiFlag() {
        this.pos = 0;
        return 16384;
    }

    public boolean next(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if (this.data_nio.capacity() < 12) {
            return false;
        }
        byte[] byArray = new byte[12];
        int n = this.data_nio.position();
        this.data_nio.position(this.pos - 8);
        this.data_nio.get(byArray, 0, 12);
        this.data_nio.position(n);
        int n2 = DbUtil.array2int(byArray, 8);
        if (n2 < 0) {
            return false;
        }
        int n3 = DbUtil.array2int(byArray, 4);
        int n4 = DbUtil.array2int(byArray, 0);
        this.pos -= 12;
        databaseEntry.setDataNIO(this.data_nio);
        databaseEntry.setOffset(n2);
        databaseEntry.setSize(4);
        databaseEntry2.setDataNIO(this.data_nio);
        databaseEntry2.setOffset(n3);
        databaseEntry2.setSize(n4);
        return true;
    }
}

