/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class FloatBinding
extends TupleBinding<Float> {
    private static final int FLOAT_SIZE = 4;

    @Override
    public Float entryToObject(TupleInput tupleInput) {
        return Float.valueOf(tupleInput.readFloat());
    }

    @Override
    public void objectToEntry(Float f, TupleOutput tupleOutput) {
        tupleOutput.writeFloat(f.floatValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Float f) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(DatabaseEntry databaseEntry) {
        return FloatBinding.entryToInput(databaseEntry).readFloat();
    }

    public static void floatToEntry(float f, DatabaseEntry databaseEntry) {
        FloatBinding.outputToEntry(FloatBinding.sizedOutput().writeFloat(f), databaseEntry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

