/*===---- riscv_vector.h - RISC-V V-extension RVVIntrinsics -------------------===
 *
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __RISCV_VECTOR_H
#define __RISCV_VECTOR_H

#include <stdint.h>
#include <stddef.h>

#ifndef __riscv_vector
#error "Vector intrinsics require the vector extension."
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define VE_TAIL_UNDISTURBED 0
#define VE_TAIL_AGNOSTIC 1

#define vsetvl_e8mf8(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 5)
#define vsetvl_e8mf4(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 6)
#define vsetvl_e8mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 7)
#define vsetvl_e8m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 0)
#define vsetvl_e8m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 1)
#define vsetvl_e8m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 2)
#define vsetvl_e8m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 0, 3)

#define vsetvl_e16mf4(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 6)
#define vsetvl_e16mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 7)
#define vsetvl_e16m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 0)
#define vsetvl_e16m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 1)
#define vsetvl_e16m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 2)
#define vsetvl_e16m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 1, 3)

#define vsetvl_e32mf2(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 7)
#define vsetvl_e32m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 0)
#define vsetvl_e32m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 1)
#define vsetvl_e32m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 2)
#define vsetvl_e32m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 2, 3)

#define vsetvl_e64m1(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 0)
#define vsetvl_e64m2(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 1)
#define vsetvl_e64m4(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 2)
#define vsetvl_e64m8(avl) __builtin_rvv_vsetvli((size_t)(avl), 3, 3)


#define vsetvlmax_e8mf8() __builtin_rvv_vsetvlimax(0, 5)
#define vsetvlmax_e8mf4() __builtin_rvv_vsetvlimax(0, 6)
#define vsetvlmax_e8mf2() __builtin_rvv_vsetvlimax(0, 7)
#define vsetvlmax_e8m1() __builtin_rvv_vsetvlimax(0, 0)
#define vsetvlmax_e8m2() __builtin_rvv_vsetvlimax(0, 1)
#define vsetvlmax_e8m4() __builtin_rvv_vsetvlimax(0, 2)
#define vsetvlmax_e8m8() __builtin_rvv_vsetvlimax(0, 3)

#define vsetvlmax_e16mf4() __builtin_rvv_vsetvlimax(1, 6)
#define vsetvlmax_e16mf2() __builtin_rvv_vsetvlimax(1, 7)
#define vsetvlmax_e16m1() __builtin_rvv_vsetvlimax(1, 0)
#define vsetvlmax_e16m2() __builtin_rvv_vsetvlimax(1, 1)
#define vsetvlmax_e16m4() __builtin_rvv_vsetvlimax(1, 2)
#define vsetvlmax_e16m8() __builtin_rvv_vsetvlimax(1, 3)

#define vsetvlmax_e32mf2() __builtin_rvv_vsetvlimax(2, 7)
#define vsetvlmax_e32m1() __builtin_rvv_vsetvlimax(2, 0)
#define vsetvlmax_e32m2() __builtin_rvv_vsetvlimax(2, 1)
#define vsetvlmax_e32m4() __builtin_rvv_vsetvlimax(2, 2)
#define vsetvlmax_e32m8() __builtin_rvv_vsetvlimax(2, 3)

#define vsetvlmax_e64m1() __builtin_rvv_vsetvlimax(3, 0)
#define vsetvlmax_e64m2() __builtin_rvv_vsetvlimax(3, 1)
#define vsetvlmax_e64m4() __builtin_rvv_vsetvlimax(3, 2)
#define vsetvlmax_e64m8() __builtin_rvv_vsetvlimax(3, 3)

typedef __rvv_bool64_t vbool64_t;
typedef __rvv_bool32_t vbool32_t;
typedef __rvv_bool16_t vbool16_t;
typedef __rvv_bool8_t vbool8_t;
typedef __rvv_bool4_t vbool4_t;
typedef __rvv_bool2_t vbool2_t;
typedef __rvv_bool1_t vbool1_t;
typedef __rvv_int8mf8_t vint8mf8_t;
typedef __rvv_uint8mf8_t vuint8mf8_t;
typedef __rvv_int8mf4_t vint8mf4_t;
typedef __rvv_uint8mf4_t vuint8mf4_t;
typedef __rvv_int8mf2_t vint8mf2_t;
typedef __rvv_uint8mf2_t vuint8mf2_t;
typedef __rvv_int8m1_t vint8m1_t;
typedef __rvv_uint8m1_t vuint8m1_t;
typedef __rvv_int8m2_t vint8m2_t;
typedef __rvv_uint8m2_t vuint8m2_t;
typedef __rvv_int8m4_t vint8m4_t;
typedef __rvv_uint8m4_t vuint8m4_t;
typedef __rvv_int8m8_t vint8m8_t;
typedef __rvv_uint8m8_t vuint8m8_t;
typedef __rvv_int16mf4_t vint16mf4_t;
typedef __rvv_uint16mf4_t vuint16mf4_t;
typedef __rvv_int16mf2_t vint16mf2_t;
typedef __rvv_uint16mf2_t vuint16mf2_t;
typedef __rvv_int16m1_t vint16m1_t;
typedef __rvv_uint16m1_t vuint16m1_t;
typedef __rvv_int16m2_t vint16m2_t;
typedef __rvv_uint16m2_t vuint16m2_t;
typedef __rvv_int16m4_t vint16m4_t;
typedef __rvv_uint16m4_t vuint16m4_t;
typedef __rvv_int16m8_t vint16m8_t;
typedef __rvv_uint16m8_t vuint16m8_t;
typedef __rvv_int32mf2_t vint32mf2_t;
typedef __rvv_uint32mf2_t vuint32mf2_t;
typedef __rvv_int32m1_t vint32m1_t;
typedef __rvv_uint32m1_t vuint32m1_t;
typedef __rvv_int32m2_t vint32m2_t;
typedef __rvv_uint32m2_t vuint32m2_t;
typedef __rvv_int32m4_t vint32m4_t;
typedef __rvv_uint32m4_t vuint32m4_t;
typedef __rvv_int32m8_t vint32m8_t;
typedef __rvv_uint32m8_t vuint32m8_t;
typedef __rvv_int64m1_t vint64m1_t;
typedef __rvv_uint64m1_t vuint64m1_t;
typedef __rvv_int64m2_t vint64m2_t;
typedef __rvv_uint64m2_t vuint64m2_t;
typedef __rvv_int64m4_t vint64m4_t;
typedef __rvv_uint64m4_t vuint64m4_t;
typedef __rvv_int64m8_t vint64m8_t;
typedef __rvv_uint64m8_t vuint64m8_t;
#if defined(__riscv_zfh)
typedef __rvv_float16mf4_t vfloat16mf4_t;
typedef __rvv_float16mf2_t vfloat16mf2_t;
typedef __rvv_float16m1_t vfloat16m1_t;
typedef __rvv_float16m2_t vfloat16m2_t;
typedef __rvv_float16m4_t vfloat16m4_t;
typedef __rvv_float16m8_t vfloat16m8_t;
#endif
#if defined(__riscv_f)
typedef __rvv_float32mf2_t vfloat32mf2_t;
typedef __rvv_float32m1_t vfloat32m1_t;
typedef __rvv_float32m2_t vfloat32m2_t;
typedef __rvv_float32m4_t vfloat32m4_t;
typedef __rvv_float32m8_t vfloat32m8_t;
#endif
#if defined(__riscv_d)
typedef __rvv_float64m1_t vfloat64m1_t;
typedef __rvv_float64m2_t vfloat64m2_t;
typedef __rvv_float64m4_t vfloat64m4_t;
typedef __rvv_float64m8_t vfloat64m8_t;
#endif

#define __rvv_ai static __inline__
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8m1_t vadd_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8m1_t vadd_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8m2_t vadd_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8m2_t vadd_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8m4_t vadd_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8m4_t vadd_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8m8_t vadd_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8m8_t vadd_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8mf2_t vadd_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8mf2_t vadd_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8mf4_t vadd_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8mf4_t vadd_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint8mf8_t vadd_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint8mf8_t vadd_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16m1_t vadd_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16m1_t vadd_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16m2_t vadd_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16m2_t vadd_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16m4_t vadd_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16m4_t vadd_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16m8_t vadd_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16m8_t vadd_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16mf2_t vadd_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16mf2_t vadd_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint16mf4_t vadd_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint16mf4_t vadd_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint32m1_t vadd_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint32m1_t vadd_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint32m2_t vadd_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint32m2_t vadd_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint32m4_t vadd_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint32m4_t vadd_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint32m8_t vadd_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint32m8_t vadd_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vint32mf2_t vadd_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vint32mf2_t vadd_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16mf4_t vwaddu_vv_u16mf4(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16mf4_t vwaddu_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16mf2_t vwaddu_vv_u16mf2(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16mf2_t vwaddu_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16m1_t vwaddu_vv_u16m1(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16m1_t vwaddu_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16m2_t vwaddu_vv_u16m2(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16m2_t vwaddu_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16m4_t vwaddu_vv_u16m4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16m4_t vwaddu_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint16m8_t vwaddu_vv_u16m8(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint16m8_t vwaddu_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint32mf2_t vwaddu_vv_u32mf2(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint32mf2_t vwaddu_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint32m1_t vwaddu_vv_u32m1(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint32m1_t vwaddu_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint32m2_t vwaddu_vv_u32m2(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint32m2_t vwaddu_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint32m4_t vwaddu_vv_u32m4(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint32m4_t vwaddu_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv)))
vuint32m8_t vwaddu_vv_u32m8(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vv_m)))
vuint32m8_t vwaddu_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8m1_t vluxei8_v_u8m1(const uint8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8m1_t vluxei8_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8m2_t vluxei8_v_u8m2(const uint8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8m2_t vluxei8_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8m4_t vluxei8_v_u8m4(const uint8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8m4_t vluxei8_v_u8m4_m(vbool2_t, vuint8m4_t, const uint8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8m8_t vluxei8_v_u8m8(const uint8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8m8_t vluxei8_v_u8m8_m(vbool1_t, vuint8m8_t, const uint8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8mf2_t vluxei8_v_u8mf2(const uint8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8mf2_t vluxei8_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8mf4_t vluxei8_v_u8mf4(const uint8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8mf4_t vluxei8_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint8mf8_t vluxei8_v_u8mf8(const uint8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint8mf8_t vluxei8_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16m2(int16_t *, ptrdiff_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16m2_m(vbool8_t, int16_t *, ptrdiff_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16m4(int16_t *, ptrdiff_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16m4_m(vbool4_t, int16_t *, ptrdiff_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16m8(int16_t *, ptrdiff_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16m8_m(vbool2_t, int16_t *, ptrdiff_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16m2(uint16_t *, ptrdiff_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16m2_m(vbool8_t, uint16_t *, ptrdiff_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16m4(uint16_t *, ptrdiff_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16m4_m(vbool4_t, uint16_t *, ptrdiff_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16m8(uint16_t *, ptrdiff_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16m8_m(vbool2_t, uint16_t *, ptrdiff_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v)))
void vsse16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse16_v_m)))
void vsse16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_i32m2(int32_t *, ptrdiff_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_i32m2_m(vbool16_t, int32_t *, ptrdiff_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_i32m4(int32_t *, ptrdiff_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_i32m4_m(vbool8_t, int32_t *, ptrdiff_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_i32m8(int32_t *, ptrdiff_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_i32m8_m(vbool4_t, int32_t *, ptrdiff_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_u32m2(uint32_t *, ptrdiff_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_u32m2_m(vbool16_t, uint32_t *, ptrdiff_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_u32m4(uint32_t *, ptrdiff_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_u32m4_m(vbool8_t, uint32_t *, ptrdiff_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_u32m8(uint32_t *, ptrdiff_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_u32m8_m(vbool4_t, uint32_t *, ptrdiff_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v)))
void vsse32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsse32_v_m)))
void vsse32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_i8m2(int8_t *, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_i8m2_m(vbool4_t, int8_t *, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8m1_t vluxei16_v_i8m1(const int8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8m1_t vluxei16_v_i8m1_m(vbool8_t, vint8m1_t, const int8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8m2_t vluxei16_v_i8m2(const int8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8m2_t vluxei16_v_i8m2_m(vbool4_t, vint8m2_t, const int8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8m4_t vluxei16_v_i8m4(const int8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8m4_t vluxei16_v_i8m4_m(vbool2_t, vint8m4_t, const int8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8mf2_t vluxei16_v_i8mf2(const int8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8mf2_t vluxei16_v_i8mf2_m(vbool16_t, vint8mf2_t, const int8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8mf4_t vluxei16_v_i8mf4(const int8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8mf4_t vluxei16_v_i8mf4_m(vbool32_t, vint8mf4_t, const int8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint8mf8_t vluxei16_v_i8mf8(const int8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint8mf8_t vluxei16_v_i8mf8_m(vbool64_t, vint8mf8_t, const int8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v)))
void vsseg3e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e8_v_m)))
void vsseg3e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_i8m2(int8_t *, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_i8m2_m(vbool4_t, int8_t *, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v)))
void vsseg4e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e8_v_m)))
void vsseg4e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v)))
void vsseg5e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e8_v_m)))
void vsseg5e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v)))
void vsseg6e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e8_v_m)))
void vsseg6e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v)))
void vsseg7e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e8_v_m)))
void vsseg7e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_i8m1(int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_i8mf2(int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_i8mf4(int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_i8mf8(int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8m1_t vluxei16_v_u8m1(const uint8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8m1_t vluxei16_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8m2_t vluxei16_v_u8m2(const uint8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8m2_t vluxei16_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8m4_t vluxei16_v_u8m4(const uint8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8m4_t vluxei16_v_u8m4_m(vbool2_t, vuint8m4_t, const uint8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8mf2_t vluxei16_v_u8mf2(const uint8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8mf2_t vluxei16_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8mf4_t vluxei16_v_u8mf4(const uint8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8mf4_t vluxei16_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint8mf8_t vluxei16_v_u8mf8(const uint8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint8mf8_t vluxei16_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v)))
void vsseg8e8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e8_v_m)))
void vsseg8e8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_i16m2(int16_t *, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_i16m2_m(vbool8_t, int16_t *, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_i16m4(int16_t *, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_i16m4_m(vbool4_t, int16_t *, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_u16m4(uint16_t *, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_u16m4_m(vbool4_t, uint16_t *, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v)))
void vsseg2e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e16_v_m)))
void vsseg2e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_i16m2(int16_t *, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_i16m2_m(vbool8_t, int16_t *, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v)))
void vsseg3e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e16_v_m)))
void vsseg3e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_i16m2(int16_t *, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_i16m2_m(vbool8_t, int16_t *, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v)))
void vsseg4e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e16_v_m)))
void vsseg4e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v)))
void vsseg5e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e16_v_m)))
void vsseg5e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint8m1_t vluxei32_v_i8m1(const int8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint8m1_t vluxei32_v_i8m1_m(vbool8_t, vint8m1_t, const int8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint8m2_t vluxei32_v_i8m2(const int8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint8m2_t vluxei32_v_i8m2_m(vbool4_t, vint8m2_t, const int8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint8mf2_t vluxei32_v_i8mf2(const int8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint8mf2_t vluxei32_v_i8mf2_m(vbool16_t, vint8mf2_t, const int8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint8mf4_t vluxei32_v_i8mf4(const int8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint8mf4_t vluxei32_v_i8mf4_m(vbool32_t, vint8mf4_t, const int8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint8mf8_t vluxei32_v_i8mf8(const int8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint8mf8_t vluxei32_v_i8mf8_m(vbool64_t, vint8mf8_t, const int8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v)))
void vsseg6e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e16_v_m)))
void vsseg6e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v)))
void vsseg7e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e16_v_m)))
void vsseg7e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_i16m1(int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_i16m1_m(vbool16_t, int16_t *, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_i16mf2(int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_i16mf2_m(vbool32_t, int16_t *, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_i16mf4(int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_i16mf4_m(vbool64_t, int16_t *, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v)))
void vsseg8e16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e16_v_m)))
void vsseg8e16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_i32m2(int32_t *, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_i32m2_m(vbool16_t, int32_t *, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_i32m4(int32_t *, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_i32m4_m(vbool8_t, int32_t *, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_u32m4(uint32_t *, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_u32m4_m(vbool8_t, uint32_t *, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v)))
void vsseg2e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg2e32_v_m)))
void vsseg2e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_i32m2(int32_t *, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_i32m2_m(vbool16_t, int32_t *, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v)))
void vsseg3e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg3e32_v_m)))
void vsseg3e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_i32m2(int32_t *, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_i32m2_m(vbool16_t, int32_t *, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint8m1_t vluxei32_v_u8m1(const uint8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint8m1_t vluxei32_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint8m2_t vluxei32_v_u8m2(const uint8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint8m2_t vluxei32_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint8mf2_t vluxei32_v_u8mf2(const uint8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint8mf2_t vluxei32_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint8mf4_t vluxei32_v_u8mf4(const uint8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint8mf4_t vluxei32_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint8mf8_t vluxei32_v_u8mf8(const uint8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint8mf8_t vluxei32_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v)))
void vsseg4e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg4e32_v_m)))
void vsseg4e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v)))
void vsseg5e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v_m)))
void vsseg5e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v)))
void vsseg5e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v_m)))
void vsseg5e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v)))
void vsseg5e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v_m)))
void vsseg5e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v)))
void vsseg5e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg5e32_v_m)))
void vsseg5e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v)))
void vsseg6e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v_m)))
void vsseg6e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v)))
void vsseg6e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v_m)))
void vsseg6e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v)))
void vsseg6e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v_m)))
void vsseg6e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v)))
void vsseg6e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg6e32_v_m)))
void vsseg6e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v)))
void vsseg7e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v_m)))
void vsseg7e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v)))
void vsseg7e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v_m)))
void vsseg7e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v)))
void vsseg7e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v_m)))
void vsseg7e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v)))
void vsseg7e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg7e32_v_m)))
void vsseg7e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v)))
void vsseg8e32_v_i32m1(int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v_m)))
void vsseg8e32_v_i32m1_m(vbool32_t, int32_t *, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v)))
void vsseg8e32_v_i32mf2(int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v_m)))
void vsseg8e32_v_i32mf2_m(vbool64_t, int32_t *, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v)))
void vsseg8e32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v_m)))
void vsseg8e32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v)))
void vsseg8e32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsseg8e32_v_m)))
void vsseg8e32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16m1_t vluxei8_v_i16m1(const int16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16m1_t vluxei8_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16m2_t vluxei8_v_i16m2(const int16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16m2_t vluxei8_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16m4_t vluxei8_v_i16m4(const int16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16m4_t vluxei8_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16m8_t vluxei8_v_i16m8(const int16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16m8_t vluxei8_v_i16m8_m(vbool2_t, vint16m8_t, const int16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16mf2_t vluxei8_v_i16mf2(const int16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16mf2_t vluxei8_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint16mf4_t vluxei8_v_i16mf4(const int16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint16mf4_t vluxei8_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16m1_t vluxei8_v_u16m1(const uint16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16m1_t vluxei8_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16m2_t vluxei8_v_u16m2(const uint16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16m2_t vluxei8_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16m4_t vluxei8_v_u16m4(const uint16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16m4_t vluxei8_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16m8_t vluxei8_v_u16m8(const uint16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16m8_t vluxei8_v_u16m8_m(vbool2_t, vuint16m8_t, const uint16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16mf2_t vluxei8_v_u16mf2(const uint16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16mf2_t vluxei8_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint16mf4_t vluxei8_v_u16mf4(const uint16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint16mf4_t vluxei8_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16m1_t vluxei16_v_i16m1(const int16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16m1_t vluxei16_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16m2_t vluxei16_v_i16m2(const int16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16m2_t vluxei16_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16m4_t vluxei16_v_i16m4(const int16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16m4_t vluxei16_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16m8_t vluxei16_v_i16m8(const int16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16m8_t vluxei16_v_i16m8_m(vbool2_t, vint16m8_t, const int16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16mf2_t vluxei16_v_i16mf2(const int16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16mf2_t vluxei16_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint16mf4_t vluxei16_v_i16mf4(const int16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint16mf4_t vluxei16_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16m1_t vluxei16_v_u16m1(const uint16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16m1_t vluxei16_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16m2_t vluxei16_v_u16m2(const uint16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16m2_t vluxei16_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16m4_t vluxei16_v_u16m4(const uint16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16m4_t vluxei16_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16m8_t vluxei16_v_u16m8(const uint16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16m8_t vluxei16_v_u16m8_m(vbool2_t, vuint16m8_t, const uint16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16mf2_t vluxei16_v_u16mf2(const uint16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16mf2_t vluxei16_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint16mf4_t vluxei16_v_u16mf4(const uint16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint16mf4_t vluxei16_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_i8m2(int8_t *, ptrdiff_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_i8m2_m(vbool4_t, int8_t *, ptrdiff_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_u8m2(uint8_t *, ptrdiff_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_u8m2_m(vbool4_t, uint8_t *, ptrdiff_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v)))
void vssseg3e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e8_v_m)))
void vssseg3e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_i8m2(int8_t *, ptrdiff_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_i8m2_m(vbool4_t, int8_t *, ptrdiff_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_u8m2(uint8_t *, ptrdiff_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_u8m2_m(vbool4_t, uint8_t *, ptrdiff_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v)))
void vssseg4e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e8_v_m)))
void vssseg4e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint16m1_t vluxei32_v_i16m1(const int16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint16m1_t vluxei32_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint16m2_t vluxei32_v_i16m2(const int16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint16m2_t vluxei32_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint16m4_t vluxei32_v_i16m4(const int16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint16m4_t vluxei32_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint16mf2_t vluxei32_v_i16mf2(const int16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint16mf2_t vluxei32_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint16mf4_t vluxei32_v_i16mf4(const int16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint16mf4_t vluxei32_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v)))
void vssseg5e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e8_v_m)))
void vssseg5e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v)))
void vssseg6e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e8_v_m)))
void vssseg6e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v)))
void vssseg7e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e8_v_m)))
void vssseg7e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_i8m1(int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_i8m1_m(vbool8_t, int8_t *, ptrdiff_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_i8mf2(int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_i8mf2_m(vbool16_t, int8_t *, ptrdiff_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_i8mf4(int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_i8mf4_m(vbool32_t, int8_t *, ptrdiff_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_i8mf8(int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_i8mf8_m(vbool64_t, int8_t *, ptrdiff_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_u8m1(uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_u8m1_m(vbool8_t, uint8_t *, ptrdiff_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_u8mf2(uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_u8mf2_m(vbool16_t, uint8_t *, ptrdiff_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_u8mf4(uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_u8mf4_m(vbool32_t, uint8_t *, ptrdiff_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v)))
void vssseg8e8_v_u8mf8(uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e8_v_m)))
void vssseg8e8_v_u8mf8_m(vbool64_t, uint8_t *, ptrdiff_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_i16m2(int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_i16m2_m(vbool8_t, int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_i16m4(int16_t *, ptrdiff_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_i16m4_m(vbool4_t, int16_t *, ptrdiff_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_u16m2(uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_u16m2_m(vbool8_t, uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_u16m4(uint16_t *, ptrdiff_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_u16m4_m(vbool4_t, uint16_t *, ptrdiff_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v)))
void vssseg2e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e16_v_m)))
void vssseg2e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_i16m2(int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_i16m2_m(vbool8_t, int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint16m1_t vluxei32_v_u16m1(const uint16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint16m1_t vluxei32_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint16m2_t vluxei32_v_u16m2(const uint16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint16m2_t vluxei32_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint16m4_t vluxei32_v_u16m4(const uint16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint16m4_t vluxei32_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint16mf2_t vluxei32_v_u16mf2(const uint16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint16mf2_t vluxei32_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint16mf4_t vluxei32_v_u16mf4(const uint16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint16mf4_t vluxei32_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_u16m2(uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_u16m2_m(vbool8_t, uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v)))
void vssseg3e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e16_v_m)))
void vssseg3e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_i16m2(int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_i16m2_m(vbool8_t, int16_t *, ptrdiff_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_u16m2(uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_u16m2_m(vbool8_t, uint16_t *, ptrdiff_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v)))
void vssseg4e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e16_v_m)))
void vssseg4e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v)))
void vssseg5e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e16_v_m)))
void vssseg5e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v)))
void vssseg6e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e16_v_m)))
void vssseg6e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v)))
void vssseg7e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e16_v_m)))
void vssseg7e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_i16m1(int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_i16m1_m(vbool16_t, int16_t *, ptrdiff_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_i16mf2(int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_i16mf2_m(vbool32_t, int16_t *, ptrdiff_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_i16mf4(int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_i16mf4_m(vbool64_t, int16_t *, ptrdiff_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_u16m1(uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_u16m1_m(vbool16_t, uint16_t *, ptrdiff_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_u16mf2(uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_u16mf2_m(vbool32_t, uint16_t *, ptrdiff_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v)))
void vssseg8e16_v_u16mf4(uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e16_v_m)))
void vssseg8e16_v_u16mf4_m(vbool64_t, uint16_t *, ptrdiff_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_i32m2(int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_i32m2_m(vbool16_t, int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_i32m4(int32_t *, ptrdiff_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_i32m4_m(vbool8_t, int32_t *, ptrdiff_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_u32m2(uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_u32m2_m(vbool16_t, uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_u32m4(uint32_t *, ptrdiff_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_u32m4_m(vbool8_t, uint32_t *, ptrdiff_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v)))
void vssseg2e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg2e32_v_m)))
void vssseg2e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_i32m2(int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_i32m2_m(vbool16_t, int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_u32m2(uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_u32m2_m(vbool16_t, uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v)))
void vssseg3e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg3e32_v_m)))
void vssseg3e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_i32m2(int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_i32m2_m(vbool16_t, int32_t *, ptrdiff_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_u32m2(uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_u32m2_m(vbool16_t, uint32_t *, ptrdiff_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v)))
void vssseg4e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg4e32_v_m)))
void vssseg4e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v)))
void vssseg5e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v_m)))
void vssseg5e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v)))
void vssseg5e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v_m)))
void vssseg5e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v)))
void vssseg5e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v_m)))
void vssseg5e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v)))
void vssseg5e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg5e32_v_m)))
void vssseg5e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v)))
void vssseg6e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v_m)))
void vssseg6e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v)))
void vssseg6e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v_m)))
void vssseg6e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v)))
void vssseg6e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v_m)))
void vssseg6e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v)))
void vssseg6e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg6e32_v_m)))
void vssseg6e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v)))
void vssseg7e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v_m)))
void vssseg7e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v)))
void vssseg7e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v_m)))
void vssseg7e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v)))
void vssseg7e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v_m)))
void vssseg7e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v)))
void vssseg7e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg7e32_v_m)))
void vssseg7e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v)))
void vssseg8e32_v_i32m1(int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v_m)))
void vssseg8e32_v_i32m1_m(vbool32_t, int32_t *, ptrdiff_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v)))
void vssseg8e32_v_i32mf2(int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v_m)))
void vssseg8e32_v_i32mf2_m(vbool64_t, int32_t *, ptrdiff_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v)))
void vssseg8e32_v_u32m1(uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v_m)))
void vssseg8e32_v_u32m1_m(vbool32_t, uint32_t *, ptrdiff_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v)))
void vssseg8e32_v_u32mf2(uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vssseg8e32_v_m)))
void vssseg8e32_v_u32mf2_m(vbool64_t, uint32_t *, ptrdiff_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint32m1_t vluxei8_v_i32m1(const int32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint32m1_t vluxei8_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint32m2_t vluxei8_v_i32m2(const int32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint32m2_t vluxei8_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint32m4_t vluxei8_v_i32m4(const int32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint32m4_t vluxei8_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint32m8_t vluxei8_v_i32m8(const int32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint32m8_t vluxei8_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vint32mf2_t vluxei8_v_i32mf2(const int32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vint32mf2_t vluxei8_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint32m1_t vluxei8_v_u32m1(const uint32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint32m1_t vluxei8_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint32m2_t vluxei8_v_u32m2(const uint32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint32m2_t vluxei8_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint32m4_t vluxei8_v_u32m4(const uint32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint32m4_t vluxei8_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint32m8_t vluxei8_v_u32m8(const uint32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint32m8_t vluxei8_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v)))
vuint32mf2_t vluxei8_v_u32mf2(const uint32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei8_v_m)))
vuint32mf2_t vluxei8_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint32m1_t vluxei16_v_i32m1(const int32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint32m1_t vluxei16_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint32m2_t vluxei16_v_i32m2(const int32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint32m2_t vluxei16_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint32m4_t vluxei16_v_i32m4(const int32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint32m4_t vluxei16_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint32m8_t vluxei16_v_i32m8(const int32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint32m8_t vluxei16_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vint32mf2_t vluxei16_v_i32mf2(const int32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vint32mf2_t vluxei16_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint32m1_t vluxei16_v_u32m1(const uint32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint32m1_t vluxei16_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint32m2_t vluxei16_v_u32m2(const uint32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint32m2_t vluxei16_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint32m4_t vluxei16_v_u32m4(const uint32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint32m4_t vluxei16_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint32m8_t vluxei16_v_u32m8(const uint32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint32m8_t vluxei16_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v)))
vuint32mf2_t vluxei16_v_u32mf2(const uint32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei16_v_m)))
vuint32mf2_t vluxei16_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i8m2(int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i8m2_m(vbool4_t, int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i8m2(int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i8m2_m(vbool4_t, int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint32m1_t vluxei32_v_i32m1(const int32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint32m1_t vluxei32_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint32m2_t vluxei32_v_i32m2(const int32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint32m2_t vluxei32_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint32m4_t vluxei32_v_i32m4(const int32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint32m4_t vluxei32_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint32m8_t vluxei32_v_i32m8(const int32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint32m8_t vluxei32_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vint32mf2_t vluxei32_v_i32mf2(const int32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vint32mf2_t vluxei32_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8m4(int8_t *, vuint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8m4_m(vbool2_t, int8_t *, vuint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8m4(uint8_t *, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8m4_m(vbool2_t, uint8_t *, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint32m1_t vluxei32_v_u32m1(const uint32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint32m1_t vluxei32_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint32m2_t vluxei32_v_u32m2(const uint32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint32m2_t vluxei32_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint32m4_t vluxei32_v_u32m4(const uint32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint32m4_t vluxei32_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint32m8_t vluxei32_v_u32m8(const uint32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint32m8_t vluxei32_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v)))
vuint32mf2_t vluxei32_v_u32mf2(const uint32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vluxei32_v_m)))
vuint32mf2_t vluxei32_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i16m4(int16_t *, vuint8m2_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i16m4_m(vbool4_t, int16_t *, vuint8m2_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u16m4(uint16_t *, vuint8m2_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u16m4_m(vbool4_t, uint16_t *, vuint8m2_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i16m4(int16_t *, vuint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i16m4_m(vbool4_t, int16_t *, vuint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u16m4(uint16_t *, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u16m4_m(vbool4_t, uint16_t *, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i16m4(int16_t *, vuint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i16m4_m(vbool4_t, int16_t *, vuint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u16m4(uint16_t *, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u16m4_m(vbool4_t, uint16_t *, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i32m4(int32_t *, vuint8m1_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i32m4_m(vbool8_t, int32_t *, vuint8m1_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u32m4(uint32_t *, vuint8m1_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u32m4_m(vbool8_t, uint32_t *, vuint8m1_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v)))
void vsuxseg2ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei8_v_m)))
void vsuxseg2ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v)))
void vsuxseg3ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei8_v_m)))
void vsuxseg3ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v)))
void vsuxseg4ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei8_v_m)))
void vsuxseg4ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v)))
void vsuxseg5ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei8_v_m)))
void vsuxseg5ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v)))
void vsuxseg6ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei8_v_m)))
void vsuxseg6ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v)))
void vsuxseg7ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei8_v_m)))
void vsuxseg7ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v)))
void vsuxseg8ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei8_v_m)))
void vsuxseg8ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i32m4(int32_t *, vuint16m2_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i32m4_m(vbool8_t, int32_t *, vuint16m2_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u32m4(uint32_t *, vuint16m2_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u32m4_m(vbool8_t, uint32_t *, vuint16m2_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v)))
void vsuxseg2ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei16_v_m)))
void vsuxseg2ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v)))
void vsuxseg3ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei16_v_m)))
void vsuxseg3ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v)))
void vsuxseg4ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei16_v_m)))
void vsuxseg4ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v)))
void vsuxseg5ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei16_v_m)))
void vsuxseg5ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v)))
void vsuxseg6ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei16_v_m)))
void vsuxseg6ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v)))
void vsuxseg7ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei16_v_m)))
void vsuxseg7ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v)))
void vsuxseg8ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei16_v_m)))
void vsuxseg8ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i32m4(int32_t *, vuint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i32m4_m(vbool8_t, int32_t *, vuint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u32m4(uint32_t *, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u32m4_m(vbool8_t, uint32_t *, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v)))
void vsuxseg2ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg2ei32_v_m)))
void vsuxseg2ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v)))
void vsuxseg3ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg3ei32_v_m)))
void vsuxseg3ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v)))
void vsuxseg4ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg4ei32_v_m)))
void vsuxseg4ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v)))
void vsuxseg5ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg5ei32_v_m)))
void vsuxseg5ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v)))
void vsuxseg6ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg6ei32_v_m)))
void vsuxseg6ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v)))
void vsuxseg7ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg7ei32_v_m)))
void vsuxseg7ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v)))
void vsuxseg8ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxseg8ei32_v_m)))
void vsuxseg8ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8m1_t vloxei8_v_i8m1(const int8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8m1_t vloxei8_v_i8m1_m(vbool8_t, vint8m1_t, const int8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8m2_t vloxei8_v_i8m2(const int8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8m2_t vloxei8_v_i8m2_m(vbool4_t, vint8m2_t, const int8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8m4_t vloxei8_v_i8m4(const int8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8m4_t vloxei8_v_i8m4_m(vbool2_t, vint8m4_t, const int8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8m8_t vloxei8_v_i8m8(const int8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8m8_t vloxei8_v_i8m8_m(vbool1_t, vint8m8_t, const int8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8mf2_t vloxei8_v_i8mf2(const int8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8mf2_t vloxei8_v_i8mf2_m(vbool16_t, vint8mf2_t, const int8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8mf4_t vloxei8_v_i8mf4(const int8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8mf4_t vloxei8_v_i8mf4_m(vbool32_t, vint8mf4_t, const int8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint8mf8_t vloxei8_v_i8mf8(const int8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint8mf8_t vloxei8_v_i8mf8_m(vbool64_t, vint8mf8_t, const int8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8m1_t vloxei8_v_u8m1(const uint8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8m1_t vloxei8_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8m2_t vloxei8_v_u8m2(const uint8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8m2_t vloxei8_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8m4_t vloxei8_v_u8m4(const uint8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8m4_t vloxei8_v_u8m4_m(vbool2_t, vuint8m4_t, const uint8_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8m8_t vloxei8_v_u8m8(const uint8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8m8_t vloxei8_v_u8m8_m(vbool1_t, vuint8m8_t, const uint8_t *, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8mf2_t vloxei8_v_u8mf2(const uint8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8mf2_t vloxei8_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8mf4_t vloxei8_v_u8mf4(const uint8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8mf4_t vloxei8_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint8mf8_t vloxei8_v_u8mf8(const uint8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint8mf8_t vloxei8_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8m1_t vloxei16_v_i8m1(const int8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8m1_t vloxei16_v_i8m1_m(vbool8_t, vint8m1_t, const int8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8m2_t vloxei16_v_i8m2(const int8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8m2_t vloxei16_v_i8m2_m(vbool4_t, vint8m2_t, const int8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8m4_t vloxei16_v_i8m4(const int8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8m4_t vloxei16_v_i8m4_m(vbool2_t, vint8m4_t, const int8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8mf2_t vloxei16_v_i8mf2(const int8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8mf2_t vloxei16_v_i8mf2_m(vbool16_t, vint8mf2_t, const int8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8mf4_t vloxei16_v_i8mf4(const int8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8mf4_t vloxei16_v_i8mf4_m(vbool32_t, vint8mf4_t, const int8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint8mf8_t vloxei16_v_i8mf8(const int8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint8mf8_t vloxei16_v_i8mf8_m(vbool64_t, vint8mf8_t, const int8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8m1_t vloxei16_v_u8m1(const uint8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8m1_t vloxei16_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8m2_t vloxei16_v_u8m2(const uint8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8m2_t vloxei16_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8m4_t vloxei16_v_u8m4(const uint8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8m4_t vloxei16_v_u8m4_m(vbool2_t, vuint8m4_t, const uint8_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8mf2_t vloxei16_v_u8mf2(const uint8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8mf2_t vloxei16_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8mf4_t vloxei16_v_u8mf4(const uint8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8mf4_t vloxei16_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint8mf8_t vloxei16_v_u8mf8(const uint8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint8mf8_t vloxei16_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint8m1_t vloxei32_v_i8m1(const int8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint8m1_t vloxei32_v_i8m1_m(vbool8_t, vint8m1_t, const int8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint8m2_t vloxei32_v_i8m2(const int8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint8m2_t vloxei32_v_i8m2_m(vbool4_t, vint8m2_t, const int8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint8mf2_t vloxei32_v_i8mf2(const int8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint8mf2_t vloxei32_v_i8mf2_m(vbool16_t, vint8mf2_t, const int8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint8mf4_t vloxei32_v_i8mf4(const int8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint8mf4_t vloxei32_v_i8mf4_m(vbool32_t, vint8mf4_t, const int8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint8mf8_t vloxei32_v_i8mf8(const int8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint8mf8_t vloxei32_v_i8mf8_m(vbool64_t, vint8mf8_t, const int8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8m2(int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8m2_m(vbool4_t, int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8m4(int8_t *, vuint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8m4_m(vbool2_t, int8_t *, vuint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8m4(uint8_t *, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8m4_m(vbool2_t, uint8_t *, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint8m1_t vloxei32_v_u8m1(const uint8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint8m1_t vloxei32_v_u8m1_m(vbool8_t, vuint8m1_t, const uint8_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint8m2_t vloxei32_v_u8m2(const uint8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint8m2_t vloxei32_v_u8m2_m(vbool4_t, vuint8m2_t, const uint8_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint8mf2_t vloxei32_v_u8mf2(const uint8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint8mf2_t vloxei32_v_u8mf2_m(vbool16_t, vuint8mf2_t, const uint8_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint8mf4_t vloxei32_v_u8mf4(const uint8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint8mf4_t vloxei32_v_u8mf4_m(vbool32_t, vuint8mf4_t, const uint8_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint8mf8_t vloxei32_v_u8mf8(const uint8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint8mf8_t vloxei32_v_u8mf8_m(vbool64_t, vuint8mf8_t, const uint8_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i8m2(int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i8m2_m(vbool4_t, int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i8m2(int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i8m2_m(vbool4_t, int8_t *, vuint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u8m2(uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u8m2_m(vbool4_t, uint8_t *, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i8m1(int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i8m1_m(vbool8_t, int8_t *, vuint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i8mf2(int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i8mf2_m(vbool16_t, int8_t *, vuint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i8mf4(int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i8mf4_m(vbool32_t, int8_t *, vuint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i8mf8(int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i8mf8_m(vbool64_t, int8_t *, vuint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u8m1(uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u8m1_m(vbool8_t, uint8_t *, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u8mf2(uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u8mf2_m(vbool16_t, uint8_t *, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u8mf4(uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u8mf4_m(vbool32_t, uint8_t *, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u8mf8(uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u8mf8_m(vbool64_t, uint8_t *, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8m4(int8_t *, vuint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8m4_m(vbool2_t, int8_t *, vuint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8m4(uint8_t *, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8m4_m(vbool2_t, uint8_t *, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u8mf2(uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u8mf2_m(vbool16_t, uint8_t *, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u8mf4(uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u8mf4_m(vbool32_t, uint8_t *, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u8mf8(uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u8mf8_m(vbool64_t, uint8_t *, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16m1_t vloxei8_v_i16m1(const int16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16m1_t vloxei8_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16m2_t vloxei8_v_i16m2(const int16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16m2_t vloxei8_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16m4_t vloxei8_v_i16m4(const int16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16m4_t vloxei8_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16m8_t vloxei8_v_i16m8(const int16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16m8_t vloxei8_v_i16m8_m(vbool2_t, vint16m8_t, const int16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16mf2_t vloxei8_v_i16mf2(const int16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16mf2_t vloxei8_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint16mf4_t vloxei8_v_i16mf4(const int16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint16mf4_t vloxei8_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i8m2(int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i8m2_m(vbool4_t, int8_t *, vuint32m8_t, vint8m2_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u8m2(uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u8m2_m(vbool4_t, uint8_t *, vuint32m8_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i8m1(int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i8m1_m(vbool8_t, int8_t *, vuint32m4_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i8mf2(int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i8mf2_m(vbool16_t, int8_t *, vuint32m2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i8mf4(int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i8mf4_m(vbool32_t, int8_t *, vuint32m1_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i8mf8(int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i8mf8_m(vbool64_t, int8_t *, vuint32mf2_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u8m1(uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u8m1_m(vbool8_t, uint8_t *, vuint32m4_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u8mf2(uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u8mf2_m(vbool16_t, uint8_t *, vuint32m2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u8mf4(uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u8mf4_m(vbool32_t, uint8_t *, vuint32m1_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u8mf8(uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u8mf8_m(vbool64_t, uint8_t *, vuint32mf2_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16m1_t vloxei8_v_u16m1(const uint16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16m1_t vloxei8_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16m2_t vloxei8_v_u16m2(const uint16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16m2_t vloxei8_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16m4_t vloxei8_v_u16m4(const uint16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16m4_t vloxei8_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16m8_t vloxei8_v_u16m8(const uint16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16m8_t vloxei8_v_u16m8_m(vbool2_t, vuint16m8_t, const uint16_t *, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16mf2_t vloxei8_v_u16mf2(const uint16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16mf2_t vloxei8_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint16mf4_t vloxei8_v_u16mf4(const uint16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint16mf4_t vloxei8_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16m1_t vloxei16_v_i16m1(const int16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16m1_t vloxei16_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16m2_t vloxei16_v_i16m2(const int16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16m2_t vloxei16_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16m4_t vloxei16_v_i16m4(const int16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16m4_t vloxei16_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16m8_t vloxei16_v_i16m8(const int16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16m8_t vloxei16_v_i16m8_m(vbool2_t, vint16m8_t, const int16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16mf2_t vloxei16_v_i16mf2(const int16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16mf2_t vloxei16_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint16mf4_t vloxei16_v_i16mf4(const int16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint16mf4_t vloxei16_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i16m4(int16_t *, vuint8m2_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i16m4_m(vbool4_t, int16_t *, vuint8m2_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u16m4(uint16_t *, vuint8m2_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u16m4_m(vbool4_t, uint16_t *, vuint8m2_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i16m2(int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i16m2_m(vbool8_t, int16_t *, vuint8m1_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u16m2(uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u16m2_m(vbool8_t, uint16_t *, vuint8m1_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16m1_t vloxei16_v_u16m1(const uint16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16m1_t vloxei16_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16m2_t vloxei16_v_u16m2(const uint16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16m2_t vloxei16_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16m4_t vloxei16_v_u16m4(const uint16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16m4_t vloxei16_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16m8_t vloxei16_v_u16m8(const uint16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16m8_t vloxei16_v_u16m8_m(vbool2_t, vuint16m8_t, const uint16_t *, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16mf2_t vloxei16_v_u16mf2(const uint16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16mf2_t vloxei16_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint16mf4_t vloxei16_v_u16mf4(const uint16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint16mf4_t vloxei16_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i16m1(int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i16m1_m(vbool16_t, int16_t *, vuint8mf2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i16mf2(int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i16mf2_m(vbool32_t, int16_t *, vuint8mf4_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i16mf4(int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i16mf4_m(vbool64_t, int16_t *, vuint8mf8_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u16m1(uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u16m1_m(vbool16_t, uint16_t *, vuint8mf2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u16mf2(uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u16mf2_m(vbool32_t, uint16_t *, vuint8mf4_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u16mf4(uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u16mf4_m(vbool64_t, uint16_t *, vuint8mf8_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i16m4(int16_t *, vuint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i16m4_m(vbool4_t, int16_t *, vuint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u16m4(uint16_t *, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u16m4_m(vbool4_t, uint16_t *, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint16m1_t vloxei32_v_i16m1(const int16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint16m1_t vloxei32_v_i16m1_m(vbool16_t, vint16m1_t, const int16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint16m2_t vloxei32_v_i16m2(const int16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint16m2_t vloxei32_v_i16m2_m(vbool8_t, vint16m2_t, const int16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint16m4_t vloxei32_v_i16m4(const int16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint16m4_t vloxei32_v_i16m4_m(vbool4_t, vint16m4_t, const int16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint16mf2_t vloxei32_v_i16mf2(const int16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint16mf2_t vloxei32_v_i16mf2_m(vbool32_t, vint16mf2_t, const int16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint16mf4_t vloxei32_v_i16mf4(const int16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint16mf4_t vloxei32_v_i16mf4_m(vbool64_t, vint16mf4_t, const int16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i16m2(int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i16m2_m(vbool8_t, int16_t *, vuint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u16m2(uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u16m2_m(vbool8_t, uint16_t *, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint16m1_t vloxei32_v_u16m1(const uint16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint16m1_t vloxei32_v_u16m1_m(vbool16_t, vuint16m1_t, const uint16_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint16m2_t vloxei32_v_u16m2(const uint16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint16m2_t vloxei32_v_u16m2_m(vbool8_t, vuint16m2_t, const uint16_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint16m4_t vloxei32_v_u16m4(const uint16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint16m4_t vloxei32_v_u16m4_m(vbool4_t, vuint16m4_t, const uint16_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint16mf2_t vloxei32_v_u16mf2(const uint16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint16mf2_t vloxei32_v_u16mf2_m(vbool32_t, vuint16mf2_t, const uint16_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint16mf4_t vloxei32_v_u16mf4(const uint16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint16mf4_t vloxei32_v_u16mf4_m(vbool64_t, vuint16mf4_t, const uint16_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i16m1(int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i16m1_m(vbool16_t, int16_t *, vuint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i16mf2(int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i16mf2_m(vbool32_t, int16_t *, vuint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i16mf4(int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i16mf4_m(vbool64_t, int16_t *, vuint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u16m1(uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u16m1_m(vbool16_t, uint16_t *, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u16mf2(uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u16mf2_m(vbool32_t, uint16_t *, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u16mf4(uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u16mf4_m(vbool64_t, uint16_t *, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i16m4(int16_t *, vuint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i16m4_m(vbool4_t, int16_t *, vuint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u16m4(uint16_t *, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u16m4_m(vbool4_t, uint16_t *, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i16m2(int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i16m2_m(vbool8_t, int16_t *, vuint32m4_t, vint16m2_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u16m2(uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u16m2_m(vbool8_t, uint16_t *, vuint32m4_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i16m1(int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i16m1_m(vbool16_t, int16_t *, vuint32m2_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i16mf2(int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i16mf2_m(vbool32_t, int16_t *, vuint32m1_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i16mf4(int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i16mf4_m(vbool64_t, int16_t *, vuint32mf2_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u16m1(uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u16m1_m(vbool16_t, uint16_t *, vuint32m2_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u16mf2(uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u16mf2_m(vbool32_t, uint16_t *, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u16mf4(uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u16mf4_m(vbool64_t, uint16_t *, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint32m1_t vloxei8_v_i32m1(const int32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint32m1_t vloxei8_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint32m2_t vloxei8_v_i32m2(const int32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint32m2_t vloxei8_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint32m4_t vloxei8_v_i32m4(const int32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint32m4_t vloxei8_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint32m8_t vloxei8_v_i32m8(const int32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint32m8_t vloxei8_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vint32mf2_t vloxei8_v_i32mf2(const int32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vint32mf2_t vloxei8_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i32m4(int32_t *, vuint8m1_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i32m4_m(vbool8_t, int32_t *, vuint8m1_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u32m4(uint32_t *, vuint8m1_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u32m4_m(vbool8_t, uint32_t *, vuint8m1_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v)))
void vsoxseg2ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei8_v_m)))
void vsoxseg2ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v)))
void vsoxseg3ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei8_v_m)))
void vsoxseg3ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i32m2(int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i32m2_m(vbool16_t, int32_t *, vuint8mf2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u32m2(uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u32m2_m(vbool16_t, uint32_t *, vuint8mf2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v)))
void vsoxseg4ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei8_v_m)))
void vsoxseg4ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v)))
void vsoxseg5ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei8_v_m)))
void vsoxseg5ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v)))
void vsoxseg6ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei8_v_m)))
void vsoxseg6ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint32m1_t vloxei8_v_u32m1(const uint32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint32m1_t vloxei8_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint32m2_t vloxei8_v_u32m2(const uint32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint32m2_t vloxei8_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint32m4_t vloxei8_v_u32m4(const uint32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint32m4_t vloxei8_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint32m8_t vloxei8_v_u32m8(const uint32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint32m8_t vloxei8_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v)))
vuint32mf2_t vloxei8_v_u32mf2(const uint32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei8_v_m)))
vuint32mf2_t vloxei8_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v)))
void vsoxseg7ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei8_v_m)))
void vsoxseg7ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i32m1(int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i32m1_m(vbool32_t, int32_t *, vuint8mf4_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_i32mf2(int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_i32mf2_m(vbool64_t, int32_t *, vuint8mf8_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u32m1(uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u32m1_m(vbool32_t, uint32_t *, vuint8mf4_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v)))
void vsoxseg8ei8_v_u32mf2(uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei8_v_m)))
void vsoxseg8ei8_v_u32mf2_m(vbool64_t, uint32_t *, vuint8mf8_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i32m4(int32_t *, vuint16m2_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i32m4_m(vbool8_t, int32_t *, vuint16m2_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u32m4(uint32_t *, vuint16m2_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u32m4_m(vbool8_t, uint32_t *, vuint16m2_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v)))
void vsoxseg2ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei16_v_m)))
void vsoxseg2ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v)))
void vsoxseg3ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei16_v_m)))
void vsoxseg3ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i32m2(int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i32m2_m(vbool16_t, int32_t *, vuint16m1_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u32m2(uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u32m2_m(vbool16_t, uint32_t *, vuint16m1_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v)))
void vsoxseg4ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei16_v_m)))
void vsoxseg4ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint32m1_t vloxei16_v_i32m1(const int32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint32m1_t vloxei16_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint32m2_t vloxei16_v_i32m2(const int32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint32m2_t vloxei16_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint32m4_t vloxei16_v_i32m4(const int32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint32m4_t vloxei16_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint32m8_t vloxei16_v_i32m8(const int32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint32m8_t vloxei16_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vint32mf2_t vloxei16_v_i32mf2(const int32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vint32mf2_t vloxei16_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v)))
void vsoxseg5ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei16_v_m)))
void vsoxseg5ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v)))
void vsoxseg6ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei16_v_m)))
void vsoxseg6ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v)))
void vsoxseg7ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei16_v_m)))
void vsoxseg7ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i32m1(int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i32m1_m(vbool32_t, int32_t *, vuint16mf2_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_i32mf2(int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_i32mf2_m(vbool64_t, int32_t *, vuint16mf4_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u32m1(uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u32m1_m(vbool32_t, uint32_t *, vuint16mf2_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v)))
void vsoxseg8ei16_v_u32mf2(uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei16_v_m)))
void vsoxseg8ei16_v_u32mf2_m(vbool64_t, uint32_t *, vuint16mf4_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i32m4(int32_t *, vuint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i32m4_m(vbool8_t, int32_t *, vuint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u32m4(uint32_t *, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u32m4_m(vbool8_t, uint32_t *, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v)))
void vsoxseg2ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg2ei32_v_m)))
void vsoxseg2ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint32m1_t vloxei16_v_u32m1(const uint32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint32m1_t vloxei16_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint32m2_t vloxei16_v_u32m2(const uint32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint32m2_t vloxei16_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint32m4_t vloxei16_v_u32m4(const uint32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint32m4_t vloxei16_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint32m8_t vloxei16_v_u32m8(const uint32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint32m8_t vloxei16_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v)))
vuint32mf2_t vloxei16_v_u32mf2(const uint32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei16_v_m)))
vuint32mf2_t vloxei16_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v)))
void vsoxseg3ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg3ei32_v_m)))
void vsoxseg3ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i32m2(int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i32m2_m(vbool16_t, int32_t *, vuint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u32m2(uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u32m2_m(vbool16_t, uint32_t *, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v)))
void vsoxseg4ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg4ei32_v_m)))
void vsoxseg4ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v)))
void vsoxseg5ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg5ei32_v_m)))
void vsoxseg5ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v)))
void vsoxseg6ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg6ei32_v_m)))
void vsoxseg6ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v)))
void vsoxseg7ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg7ei32_v_m)))
void vsoxseg7ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint32m1_t vloxei32_v_i32m1(const int32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint32m1_t vloxei32_v_i32m1_m(vbool32_t, vint32m1_t, const int32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint32m2_t vloxei32_v_i32m2(const int32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint32m2_t vloxei32_v_i32m2_m(vbool16_t, vint32m2_t, const int32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint32m4_t vloxei32_v_i32m4(const int32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint32m4_t vloxei32_v_i32m4_m(vbool8_t, vint32m4_t, const int32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint32m8_t vloxei32_v_i32m8(const int32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint32m8_t vloxei32_v_i32m8_m(vbool4_t, vint32m8_t, const int32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vint32mf2_t vloxei32_v_i32mf2(const int32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vint32mf2_t vloxei32_v_i32mf2_m(vbool64_t, vint32mf2_t, const int32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i32m1(int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i32m1_m(vbool32_t, int32_t *, vuint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_i32mf2(int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_i32mf2_m(vbool64_t, int32_t *, vuint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u32m1(uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u32m1_m(vbool32_t, uint32_t *, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v)))
void vsoxseg8ei32_v_u32mf2(uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsoxseg8ei32_v_m)))
void vsoxseg8ei32_v_u32mf2_m(vbool64_t, uint32_t *, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint32m1_t vloxei32_v_u32m1(const uint32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint32m1_t vloxei32_v_u32m1_m(vbool32_t, vuint32m1_t, const uint32_t *, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint32m2_t vloxei32_v_u32m2(const uint32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint32m2_t vloxei32_v_u32m2_m(vbool16_t, vuint32m2_t, const uint32_t *, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint32m4_t vloxei32_v_u32m4(const uint32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint32m4_t vloxei32_v_u32m4_m(vbool8_t, vuint32m4_t, const uint32_t *, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint32m8_t vloxei32_v_u32m8(const uint32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint32m8_t vloxei32_v_u32m8_m(vbool4_t, vuint32m8_t, const uint32_t *, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v)))
vuint32mf2_t vloxei32_v_u32mf2(const uint32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vloxei32_v_m)))
vuint32mf2_t vloxei32_v_u32mf2_m(vbool64_t, vuint32mf2_t, const uint32_t *, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8m1_t vadd_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8m1_t vadd_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8m2_t vadd_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8m2_t vadd_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8m4_t vadd_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8m4_t vadd_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8m8_t vadd_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8m8_t vadd_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8mf2_t vadd_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8mf2_t vadd_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8mf4_t vadd_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8mf4_t vadd_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint8mf8_t vadd_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint8mf8_t vadd_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16m1_t vadd_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16m1_t vadd_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16m2_t vadd_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16m2_t vadd_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16m4_t vadd_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16m4_t vadd_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16m8_t vadd_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16m8_t vadd_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16mf2_t vadd_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16mf2_t vadd_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint16mf4_t vadd_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint16mf4_t vadd_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint32m1_t vadd_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint32m1_t vadd_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint32m2_t vadd_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint32m2_t vadd_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint32m4_t vadd_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint32m4_t vadd_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint32m8_t vadd_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint32m8_t vadd_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vint32mf2_t vadd_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vint32mf2_t vadd_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8m1_t vadd_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8m1_t vadd_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8m2_t vadd_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8m2_t vadd_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8m4_t vadd_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8m4_t vadd_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8m8_t vadd_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8m8_t vadd_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8mf2_t vadd_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8mf2_t vadd_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8mf4_t vadd_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8mf4_t vadd_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint8mf8_t vadd_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint8mf8_t vadd_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16m1_t vadd_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16m1_t vadd_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16m2_t vadd_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16m2_t vadd_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16m4_t vadd_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16m4_t vadd_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16m8_t vadd_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16m8_t vadd_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16mf2_t vadd_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16mf2_t vadd_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint16mf4_t vadd_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint16mf4_t vadd_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint32m1_t vadd_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint32m1_t vadd_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint32m2_t vadd_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint32m2_t vadd_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint32m4_t vadd_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint32m4_t vadd_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint32m8_t vadd_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint32m8_t vadd_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv)))
vuint32mf2_t vadd_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vv_m)))
vuint32mf2_t vadd_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8m1_t vadd_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8m1_t vadd_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8m2_t vadd_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8m2_t vadd_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8m4_t vadd_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8m4_t vadd_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8m8_t vadd_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8m8_t vadd_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8mf2_t vadd_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8mf2_t vadd_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8mf4_t vadd_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8mf4_t vadd_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint8mf8_t vadd_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint8mf8_t vadd_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16m1_t vadd_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16m1_t vadd_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16m2_t vadd_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16m2_t vadd_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16m4_t vadd_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16m4_t vadd_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16m8_t vadd_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16m8_t vadd_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16mf2_t vadd_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16mf2_t vadd_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint16mf4_t vadd_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint16mf4_t vadd_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint32m1_t vadd_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint32m1_t vadd_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint32m2_t vadd_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint32m2_t vadd_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint32m4_t vadd_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint32m4_t vadd_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint32m8_t vadd_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint32m8_t vadd_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx)))
vuint32mf2_t vadd_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadd_vx_m)))
vuint32mf2_t vadd_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8m1_t vsub_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8m1_t vsub_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8m2_t vsub_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8m2_t vsub_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8m4_t vsub_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8m4_t vsub_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8m8_t vsub_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8m8_t vsub_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8mf2_t vsub_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8mf2_t vsub_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8mf4_t vsub_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8mf4_t vsub_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint8mf8_t vsub_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint8mf8_t vsub_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16m1_t vsub_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16m1_t vsub_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16m2_t vsub_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16m2_t vsub_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16m4_t vsub_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16m4_t vsub_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16m8_t vsub_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16m8_t vsub_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16mf2_t vsub_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16mf2_t vsub_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint16mf4_t vsub_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint16mf4_t vsub_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint32m1_t vsub_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint32m1_t vsub_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint32m2_t vsub_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint32m2_t vsub_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint32m4_t vsub_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint32m4_t vsub_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint32m8_t vsub_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint32m8_t vsub_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vint32mf2_t vsub_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vint32mf2_t vsub_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8m1_t vsub_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8m1_t vsub_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8m2_t vsub_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8m2_t vsub_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8m4_t vsub_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8m4_t vsub_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8m8_t vsub_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8m8_t vsub_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8mf2_t vsub_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8mf2_t vsub_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8mf4_t vsub_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8mf4_t vsub_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint8mf8_t vsub_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint8mf8_t vsub_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16m1_t vsub_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16m1_t vsub_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16m2_t vsub_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16m2_t vsub_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16m4_t vsub_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16m4_t vsub_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16m8_t vsub_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16m8_t vsub_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16mf2_t vsub_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16mf2_t vsub_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint16mf4_t vsub_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint16mf4_t vsub_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint32m1_t vsub_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint32m1_t vsub_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint32m2_t vsub_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint32m2_t vsub_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint32m4_t vsub_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint32m4_t vsub_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint32m8_t vsub_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint32m8_t vsub_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vint32mf2_t vsub_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vint32mf2_t vsub_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8m1_t vsub_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8m1_t vsub_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8m2_t vsub_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8m2_t vsub_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8m4_t vsub_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8m4_t vsub_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8m8_t vsub_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8m8_t vsub_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8mf2_t vsub_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8mf2_t vsub_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8mf4_t vsub_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8mf4_t vsub_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint8mf8_t vsub_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint8mf8_t vsub_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16m1_t vsub_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16m1_t vsub_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16m2_t vsub_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16m2_t vsub_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16m4_t vsub_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16m4_t vsub_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16m8_t vsub_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16m8_t vsub_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16mf2_t vsub_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16mf2_t vsub_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint16mf4_t vsub_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint16mf4_t vsub_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint32m1_t vsub_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint32m1_t vsub_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint32m2_t vsub_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint32m2_t vsub_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint32m4_t vsub_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint32m4_t vsub_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint32m8_t vsub_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint32m8_t vsub_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv)))
vuint32mf2_t vsub_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vv_m)))
vuint32mf2_t vsub_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8m1_t vsub_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8m1_t vsub_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8m2_t vsub_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8m2_t vsub_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8m4_t vsub_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8m4_t vsub_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8m8_t vsub_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8m8_t vsub_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8mf2_t vsub_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8mf2_t vsub_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8mf4_t vsub_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8mf4_t vsub_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint8mf8_t vsub_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint8mf8_t vsub_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16m1_t vsub_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16m1_t vsub_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16m2_t vsub_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16m2_t vsub_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16m4_t vsub_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16m4_t vsub_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16m8_t vsub_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16m8_t vsub_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16mf2_t vsub_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16mf2_t vsub_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint16mf4_t vsub_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint16mf4_t vsub_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint32m1_t vsub_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint32m1_t vsub_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint32m2_t vsub_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint32m2_t vsub_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint32m4_t vsub_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint32m4_t vsub_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint32m8_t vsub_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint32m8_t vsub_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx)))
vuint32mf2_t vsub_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsub_vx_m)))
vuint32mf2_t vsub_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8m1_t vrsub_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8m1_t vrsub_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8m2_t vrsub_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8m2_t vrsub_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8m4_t vrsub_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8m4_t vrsub_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8m8_t vrsub_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8m8_t vrsub_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8mf2_t vrsub_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8mf2_t vrsub_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8mf4_t vrsub_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8mf4_t vrsub_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint8mf8_t vrsub_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint8mf8_t vrsub_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16m1_t vrsub_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16m1_t vrsub_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16m2_t vrsub_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16m2_t vrsub_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16m4_t vrsub_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16m4_t vrsub_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16m8_t vrsub_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16m8_t vrsub_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16mf2_t vrsub_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16mf2_t vrsub_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint16mf4_t vrsub_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint16mf4_t vrsub_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint32m1_t vrsub_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint32m1_t vrsub_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint32m2_t vrsub_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint32m2_t vrsub_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint32m4_t vrsub_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint32m4_t vrsub_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint32m8_t vrsub_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint32m8_t vrsub_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vint32mf2_t vrsub_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vint32mf2_t vrsub_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8m1_t vrsub_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8m1_t vrsub_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8m2_t vrsub_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8m2_t vrsub_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8m4_t vrsub_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8m4_t vrsub_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8m8_t vrsub_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8m8_t vrsub_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8mf2_t vrsub_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8mf2_t vrsub_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8mf4_t vrsub_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8mf4_t vrsub_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint8mf8_t vrsub_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint8mf8_t vrsub_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16m1_t vrsub_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16m1_t vrsub_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16m2_t vrsub_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16m2_t vrsub_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16m4_t vrsub_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16m4_t vrsub_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16m8_t vrsub_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16m8_t vrsub_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16mf2_t vrsub_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16mf2_t vrsub_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint16mf4_t vrsub_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint16mf4_t vrsub_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint32m1_t vrsub_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint32m1_t vrsub_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint32m2_t vrsub_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint32m2_t vrsub_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint32m4_t vrsub_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint32m4_t vrsub_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint32m8_t vrsub_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint32m8_t vrsub_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx)))
vuint32mf2_t vrsub_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vrsub_vx_m)))
vuint32mf2_t vrsub_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16mf4_t vwaddu_vx_u16mf4(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16mf4_t vwaddu_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16mf2_t vwaddu_vx_u16mf2(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16mf2_t vwaddu_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16m1_t vwaddu_vx_u16m1(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16m1_t vwaddu_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16m2_t vwaddu_vx_u16m2(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16m2_t vwaddu_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16m4_t vwaddu_vx_u16m4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16m4_t vwaddu_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint16m8_t vwaddu_vx_u16m8(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint16m8_t vwaddu_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint32mf2_t vwaddu_vx_u32mf2(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint32mf2_t vwaddu_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint32m1_t vwaddu_vx_u32m1(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint32m1_t vwaddu_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint32m2_t vwaddu_vx_u32m2(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint32m2_t vwaddu_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint32m4_t vwaddu_vx_u32m4(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint32m4_t vwaddu_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx)))
vuint32m8_t vwaddu_vx_u32m8(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_vx_m)))
vuint32m8_t vwaddu_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16mf4_t vwsubu_vv_u16mf4(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16mf4_t vwsubu_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16mf2_t vwsubu_vv_u16mf2(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16mf2_t vwsubu_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16m1_t vwsubu_vv_u16m1(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16m1_t vwsubu_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16m2_t vwsubu_vv_u16m2(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16m2_t vwsubu_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16m4_t vwsubu_vv_u16m4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16m4_t vwsubu_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint16m8_t vwsubu_vv_u16m8(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint16m8_t vwsubu_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint32mf2_t vwsubu_vv_u32mf2(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint32mf2_t vwsubu_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint32m1_t vwsubu_vv_u32m1(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint32m1_t vwsubu_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint32m2_t vwsubu_vv_u32m2(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint32m2_t vwsubu_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint32m4_t vwsubu_vv_u32m4(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint32m4_t vwsubu_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv)))
vuint32m8_t vwsubu_vv_u32m8(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vv_m)))
vuint32m8_t vwsubu_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16mf4_t vwsubu_vx_u16mf4(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16mf4_t vwsubu_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16mf2_t vwsubu_vx_u16mf2(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16mf2_t vwsubu_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16m1_t vwsubu_vx_u16m1(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16m1_t vwsubu_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16m2_t vwsubu_vx_u16m2(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16m2_t vwsubu_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16m4_t vwsubu_vx_u16m4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16m4_t vwsubu_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint16m8_t vwsubu_vx_u16m8(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint16m8_t vwsubu_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint32mf2_t vwsubu_vx_u32mf2(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint32mf2_t vwsubu_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint32m1_t vwsubu_vx_u32m1(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint32m1_t vwsubu_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint32m2_t vwsubu_vx_u32m2(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint32m2_t vwsubu_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint32m4_t vwsubu_vx_u32m4(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint32m4_t vwsubu_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx)))
vuint32m8_t vwsubu_vx_u32m8(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_vx_m)))
vuint32m8_t vwsubu_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16mf4_t vwadd_vv_i16mf4(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16mf4_t vwadd_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16mf2_t vwadd_vv_i16mf2(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16mf2_t vwadd_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16m1_t vwadd_vv_i16m1(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16m1_t vwadd_vv_i16m1_m(vbool16_t, vint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16m2_t vwadd_vv_i16m2(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16m2_t vwadd_vv_i16m2_m(vbool8_t, vint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16m4_t vwadd_vv_i16m4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16m4_t vwadd_vv_i16m4_m(vbool4_t, vint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint16m8_t vwadd_vv_i16m8(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint16m8_t vwadd_vv_i16m8_m(vbool2_t, vint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint32mf2_t vwadd_vv_i32mf2(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint32mf2_t vwadd_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint32m1_t vwadd_vv_i32m1(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint32m1_t vwadd_vv_i32m1_m(vbool32_t, vint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint32m2_t vwadd_vv_i32m2(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint32m2_t vwadd_vv_i32m2_m(vbool16_t, vint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint32m4_t vwadd_vv_i32m4(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint32m4_t vwadd_vv_i32m4_m(vbool8_t, vint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv)))
vint32m8_t vwadd_vv_i32m8(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vv_m)))
vint32m8_t vwadd_vv_i32m8_m(vbool4_t, vint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16mf4_t vwadd_vx_i16mf4(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16mf4_t vwadd_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16mf2_t vwadd_vx_i16mf2(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16mf2_t vwadd_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16m1_t vwadd_vx_i16m1(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16m1_t vwadd_vx_i16m1_m(vbool16_t, vint16m1_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16m2_t vwadd_vx_i16m2(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16m2_t vwadd_vx_i16m2_m(vbool8_t, vint16m2_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16m4_t vwadd_vx_i16m4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16m4_t vwadd_vx_i16m4_m(vbool4_t, vint16m4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint16m8_t vwadd_vx_i16m8(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint16m8_t vwadd_vx_i16m8_m(vbool2_t, vint16m8_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint32mf2_t vwadd_vx_i32mf2(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint32mf2_t vwadd_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint32m1_t vwadd_vx_i32m1(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint32m1_t vwadd_vx_i32m1_m(vbool32_t, vint32m1_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint32m2_t vwadd_vx_i32m2(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint32m2_t vwadd_vx_i32m2_m(vbool16_t, vint32m2_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint32m4_t vwadd_vx_i32m4(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint32m4_t vwadd_vx_i32m4_m(vbool8_t, vint32m4_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx)))
vint32m8_t vwadd_vx_i32m8(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_vx_m)))
vint32m8_t vwadd_vx_i32m8_m(vbool4_t, vint32m8_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16mf4_t vwsub_vv_i16mf4(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16mf4_t vwsub_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16mf2_t vwsub_vv_i16mf2(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16mf2_t vwsub_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16m1_t vwsub_vv_i16m1(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16m1_t vwsub_vv_i16m1_m(vbool16_t, vint16m1_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16m2_t vwsub_vv_i16m2(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16m2_t vwsub_vv_i16m2_m(vbool8_t, vint16m2_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16m4_t vwsub_vv_i16m4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16m4_t vwsub_vv_i16m4_m(vbool4_t, vint16m4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint16m8_t vwsub_vv_i16m8(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint16m8_t vwsub_vv_i16m8_m(vbool2_t, vint16m8_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint32mf2_t vwsub_vv_i32mf2(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint32mf2_t vwsub_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint32m1_t vwsub_vv_i32m1(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint32m1_t vwsub_vv_i32m1_m(vbool32_t, vint32m1_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint32m2_t vwsub_vv_i32m2(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint32m2_t vwsub_vv_i32m2_m(vbool16_t, vint32m2_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint32m4_t vwsub_vv_i32m4(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint32m4_t vwsub_vv_i32m4_m(vbool8_t, vint32m4_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv)))
vint32m8_t vwsub_vv_i32m8(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vv_m)))
vint32m8_t vwsub_vv_i32m8_m(vbool4_t, vint32m8_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16mf4_t vwsub_vx_i16mf4(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16mf4_t vwsub_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16mf2_t vwsub_vx_i16mf2(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16mf2_t vwsub_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16m1_t vwsub_vx_i16m1(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16m1_t vwsub_vx_i16m1_m(vbool16_t, vint16m1_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16m2_t vwsub_vx_i16m2(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16m2_t vwsub_vx_i16m2_m(vbool8_t, vint16m2_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16m4_t vwsub_vx_i16m4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16m4_t vwsub_vx_i16m4_m(vbool4_t, vint16m4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint16m8_t vwsub_vx_i16m8(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint16m8_t vwsub_vx_i16m8_m(vbool2_t, vint16m8_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint32mf2_t vwsub_vx_i32mf2(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint32mf2_t vwsub_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint32m1_t vwsub_vx_i32m1(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint32m1_t vwsub_vx_i32m1_m(vbool32_t, vint32m1_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint32m2_t vwsub_vx_i32m2(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint32m2_t vwsub_vx_i32m2_m(vbool16_t, vint32m2_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint32m4_t vwsub_vx_i32m4(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint32m4_t vwsub_vx_i32m4_m(vbool8_t, vint32m4_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx)))
vint32m8_t vwsub_vx_i32m8(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_vx_m)))
vint32m8_t vwsub_vx_i32m8_m(vbool4_t, vint32m8_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16mf4_t vwaddu_wx_u16mf4(vuint16mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16mf4_t vwaddu_wx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16mf2_t vwaddu_wx_u16mf2(vuint16mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16mf2_t vwaddu_wx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16m1_t vwaddu_wx_u16m1(vuint16m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16m1_t vwaddu_wx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16m2_t vwaddu_wx_u16m2(vuint16m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16m2_t vwaddu_wx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16m4_t vwaddu_wx_u16m4(vuint16m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16m4_t vwaddu_wx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint16m8_t vwaddu_wx_u16m8(vuint16m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint16m8_t vwaddu_wx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint32mf2_t vwaddu_wx_u32mf2(vuint32mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint32mf2_t vwaddu_wx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint32m1_t vwaddu_wx_u32m1(vuint32m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint32m1_t vwaddu_wx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint32m2_t vwaddu_wx_u32m2(vuint32m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint32m2_t vwaddu_wx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint32m4_t vwaddu_wx_u32m4(vuint32m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint32m4_t vwaddu_wx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx)))
vuint32m8_t vwaddu_wx_u32m8(vuint32m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wx_m)))
vuint32m8_t vwaddu_wx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16mf4_t vwsubu_wv_u16mf4(vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16mf4_t vwsubu_wv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16mf2_t vwsubu_wv_u16mf2(vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16mf2_t vwsubu_wv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16m1_t vwsubu_wv_u16m1(vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16m1_t vwsubu_wv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16m2_t vwsubu_wv_u16m2(vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16m2_t vwsubu_wv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16m4_t vwsubu_wv_u16m4(vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16m4_t vwsubu_wv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint16m8_t vwsubu_wv_u16m8(vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint16m8_t vwsubu_wv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint32mf2_t vwsubu_wv_u32mf2(vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint32mf2_t vwsubu_wv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint32m1_t vwsubu_wv_u32m1(vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint32m1_t vwsubu_wv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint32m2_t vwsubu_wv_u32m2(vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint32m2_t vwsubu_wv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint32m4_t vwsubu_wv_u32m4(vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint32m4_t vwsubu_wv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv)))
vuint32m8_t vwsubu_wv_u32m8(vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wv_m)))
vuint32m8_t vwsubu_wv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16mf4_t vwsubu_wx_u16mf4(vuint16mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16mf4_t vwsubu_wx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16mf2_t vwsubu_wx_u16mf2(vuint16mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16mf2_t vwsubu_wx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16m1_t vwsubu_wx_u16m1(vuint16m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16m1_t vwsubu_wx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16m2_t vwsubu_wx_u16m2(vuint16m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16m2_t vwsubu_wx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16m4_t vwsubu_wx_u16m4(vuint16m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16m4_t vwsubu_wx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint16m8_t vwsubu_wx_u16m8(vuint16m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint16m8_t vwsubu_wx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint32mf2_t vwsubu_wx_u32mf2(vuint32mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint32mf2_t vwsubu_wx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint32m1_t vwsubu_wx_u32m1(vuint32m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint32m1_t vwsubu_wx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint32m2_t vwsubu_wx_u32m2(vuint32m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint32m2_t vwsubu_wx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint32m4_t vwsubu_wx_u32m4(vuint32m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint32m4_t vwsubu_wx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx)))
vuint32m8_t vwsubu_wx_u32m8(vuint32m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsubu_wx_m)))
vuint32m8_t vwsubu_wx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16mf4_t vwadd_wv_i16mf4(vint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16mf4_t vwadd_wv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16mf2_t vwadd_wv_i16mf2(vint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16mf2_t vwadd_wv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16m1_t vwadd_wv_i16m1(vint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16m1_t vwadd_wv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16m2_t vwadd_wv_i16m2(vint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16m2_t vwadd_wv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16m4_t vwadd_wv_i16m4(vint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16m4_t vwadd_wv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint16m8_t vwadd_wv_i16m8(vint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint16m8_t vwadd_wv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint32mf2_t vwadd_wv_i32mf2(vint32mf2_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint32mf2_t vwadd_wv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint32m1_t vwadd_wv_i32m1(vint32m1_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint32m1_t vwadd_wv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint32m2_t vwadd_wv_i32m2(vint32m2_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint32m2_t vwadd_wv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint32m4_t vwadd_wv_i32m4(vint32m4_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint32m4_t vwadd_wv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv)))
vint32m8_t vwadd_wv_i32m8(vint32m8_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wv_m)))
vint32m8_t vwadd_wv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16mf4_t vwadd_wx_i16mf4(vint16mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16mf4_t vwadd_wx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16mf2_t vwadd_wx_i16mf2(vint16mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16mf2_t vwadd_wx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16m1_t vwadd_wx_i16m1(vint16m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16m1_t vwadd_wx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16m2_t vwadd_wx_i16m2(vint16m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16m2_t vwadd_wx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16m4_t vwadd_wx_i16m4(vint16m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16m4_t vwadd_wx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint16m8_t vwadd_wx_i16m8(vint16m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint16m8_t vwadd_wx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint32mf2_t vwadd_wx_i32mf2(vint32mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint32mf2_t vwadd_wx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint32m1_t vwadd_wx_i32m1(vint32m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint32m1_t vwadd_wx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint32m2_t vwadd_wx_i32m2(vint32m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint32m2_t vwadd_wx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint32m4_t vwadd_wx_i32m4(vint32m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint32m4_t vwadd_wx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx)))
vint32m8_t vwadd_wx_i32m8(vint32m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwadd_wx_m)))
vint32m8_t vwadd_wx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16mf4_t vwsub_wv_i16mf4(vint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16mf4_t vwsub_wv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16mf2_t vwsub_wv_i16mf2(vint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16mf2_t vwsub_wv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16m1_t vwsub_wv_i16m1(vint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16m1_t vwsub_wv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16m2_t vwsub_wv_i16m2(vint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16m2_t vwsub_wv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16m4_t vwsub_wv_i16m4(vint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16m4_t vwsub_wv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint16m8_t vwsub_wv_i16m8(vint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint16m8_t vwsub_wv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint32mf2_t vwsub_wv_i32mf2(vint32mf2_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint32mf2_t vwsub_wv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint32m1_t vwsub_wv_i32m1(vint32m1_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint32m1_t vwsub_wv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint32m2_t vwsub_wv_i32m2(vint32m2_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint32m2_t vwsub_wv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint32m4_t vwsub_wv_i32m4(vint32m4_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint32m4_t vwsub_wv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv)))
vint32m8_t vwsub_wv_i32m8(vint32m8_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wv_m)))
vint32m8_t vwsub_wv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16mf4_t vwsub_wx_i16mf4(vint16mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16mf4_t vwsub_wx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16mf2_t vwsub_wx_i16mf2(vint16mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16mf2_t vwsub_wx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16m1_t vwsub_wx_i16m1(vint16m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16m1_t vwsub_wx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16m2_t vwsub_wx_i16m2(vint16m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16m2_t vwsub_wx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16m4_t vwsub_wx_i16m4(vint16m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16m4_t vwsub_wx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint16m8_t vwsub_wx_i16m8(vint16m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint16m8_t vwsub_wx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint32mf2_t vwsub_wx_i32mf2(vint32mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint32mf2_t vwsub_wx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint32m1_t vwsub_wx_i32m1(vint32m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint32m1_t vwsub_wx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint32m2_t vwsub_wx_i32m2(vint32m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint32m2_t vwsub_wx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint32m4_t vwsub_wx_i32m4(vint32m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint32m4_t vwsub_wx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx)))
vint32m8_t vwsub_wx_i32m8(vint32m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwsub_wx_m)))
vint32m8_t vwsub_wx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16m2_t vwcvt_x_x_v_i16m2(vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16m2_t vwcvt_x_x_v_i16m2_m(vbool8_t, vint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16m4_t vwcvt_x_x_v_i16m4(vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16m4_t vwcvt_x_x_v_i16m4_m(vbool4_t, vint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16m8_t vwcvt_x_x_v_i16m8(vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16m8_t vwcvt_x_x_v_i16m8_m(vbool2_t, vint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16m1_t vwcvt_x_x_v_i16m1(vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16m1_t vwcvt_x_x_v_i16m1_m(vbool16_t, vint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16mf2_t vwcvt_x_x_v_i16mf2(vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16mf2_t vwcvt_x_x_v_i16mf2_m(vbool32_t, vint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint16mf4_t vwcvt_x_x_v_i16mf4(vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint16mf4_t vwcvt_x_x_v_i16mf4_m(vbool64_t, vint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint32m2_t vwcvt_x_x_v_i32m2(vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint32m2_t vwcvt_x_x_v_i32m2_m(vbool16_t, vint32m2_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint32m4_t vwcvt_x_x_v_i32m4(vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint32m4_t vwcvt_x_x_v_i32m4_m(vbool8_t, vint32m4_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint32m8_t vwcvt_x_x_v_i32m8(vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint32m8_t vwcvt_x_x_v_i32m8_m(vbool4_t, vint32m8_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint32m1_t vwcvt_x_x_v_i32m1(vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint32m1_t vwcvt_x_x_v_i32m1_m(vbool32_t, vint32m1_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v)))
vint32mf2_t vwcvt_x_x_v_i32mf2(vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwcvt_x_x_v_m)))
vint32mf2_t vwcvt_x_x_v_i32mf2_m(vbool64_t, vint32mf2_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8m1_t vadc_vvm_i8m1(vint8m1_t, vint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8m2_t vadc_vvm_i8m2(vint8m2_t, vint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8m4_t vadc_vvm_i8m4(vint8m4_t, vint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8m8_t vadc_vvm_i8m8(vint8m8_t, vint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8mf2_t vadc_vvm_i8mf2(vint8mf2_t, vint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8mf4_t vadc_vvm_i8mf4(vint8mf4_t, vint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint8mf8_t vadc_vvm_i8mf8(vint8mf8_t, vint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16m1_t vadc_vvm_i16m1(vint16m1_t, vint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16m2_t vadc_vvm_i16m2(vint16m2_t, vint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16m4_t vadc_vvm_i16m4(vint16m4_t, vint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16m8_t vadc_vvm_i16m8(vint16m8_t, vint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16mf2_t vadc_vvm_i16mf2(vint16mf2_t, vint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint16mf4_t vadc_vvm_i16mf4(vint16mf4_t, vint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint32m1_t vadc_vvm_i32m1(vint32m1_t, vint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint32m2_t vadc_vvm_i32m2(vint32m2_t, vint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint32m4_t vadc_vvm_i32m4(vint32m4_t, vint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint32m8_t vadc_vvm_i32m8(vint32m8_t, vint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vint32mf2_t vadc_vvm_i32mf2(vint32mf2_t, vint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8m1_t vadc_vxm_i8m1(vint8m1_t, int8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8m2_t vadc_vxm_i8m2(vint8m2_t, int8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8m4_t vadc_vxm_i8m4(vint8m4_t, int8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8m8_t vadc_vxm_i8m8(vint8m8_t, int8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8mf2_t vadc_vxm_i8mf2(vint8mf2_t, int8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8mf4_t vadc_vxm_i8mf4(vint8mf4_t, int8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint8mf8_t vadc_vxm_i8mf8(vint8mf8_t, int8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16m1_t vadc_vxm_i16m1(vint16m1_t, int16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16m2_t vadc_vxm_i16m2(vint16m2_t, int16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16m4_t vadc_vxm_i16m4(vint16m4_t, int16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16m8_t vadc_vxm_i16m8(vint16m8_t, int16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16mf2_t vadc_vxm_i16mf2(vint16mf2_t, int16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint16mf4_t vadc_vxm_i16mf4(vint16mf4_t, int16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint32m1_t vadc_vxm_i32m1(vint32m1_t, int32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint32m2_t vadc_vxm_i32m2(vint32m2_t, int32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint32m4_t vadc_vxm_i32m4(vint32m4_t, int32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint32m8_t vadc_vxm_i32m8(vint32m8_t, int32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vint32mf2_t vadc_vxm_i32mf2(vint32mf2_t, int32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8m1_t vadc_vvm_u8m1(vuint8m1_t, vuint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8m2_t vadc_vvm_u8m2(vuint8m2_t, vuint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8m4_t vadc_vvm_u8m4(vuint8m4_t, vuint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8m8_t vadc_vvm_u8m8(vuint8m8_t, vuint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8mf2_t vadc_vvm_u8mf2(vuint8mf2_t, vuint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8mf4_t vadc_vvm_u8mf4(vuint8mf4_t, vuint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint8mf8_t vadc_vvm_u8mf8(vuint8mf8_t, vuint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16m1_t vadc_vvm_u16m1(vuint16m1_t, vuint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16m2_t vadc_vvm_u16m2(vuint16m2_t, vuint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16m4_t vadc_vvm_u16m4(vuint16m4_t, vuint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16m8_t vadc_vvm_u16m8(vuint16m8_t, vuint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16mf2_t vadc_vvm_u16mf2(vuint16mf2_t, vuint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint16mf4_t vadc_vvm_u16mf4(vuint16mf4_t, vuint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint32m1_t vadc_vvm_u32m1(vuint32m1_t, vuint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint32m2_t vadc_vvm_u32m2(vuint32m2_t, vuint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint32m4_t vadc_vvm_u32m4(vuint32m4_t, vuint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint32m8_t vadc_vvm_u32m8(vuint32m8_t, vuint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vvm)))
vuint32mf2_t vadc_vvm_u32mf2(vuint32mf2_t, vuint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8m1_t vadc_vxm_u8m1(vuint8m1_t, uint8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8m2_t vadc_vxm_u8m2(vuint8m2_t, uint8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8m4_t vadc_vxm_u8m4(vuint8m4_t, uint8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8m8_t vadc_vxm_u8m8(vuint8m8_t, uint8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8mf2_t vadc_vxm_u8mf2(vuint8mf2_t, uint8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8mf4_t vadc_vxm_u8mf4(vuint8mf4_t, uint8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint8mf8_t vadc_vxm_u8mf8(vuint8mf8_t, uint8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16m1_t vadc_vxm_u16m1(vuint16m1_t, uint16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16m2_t vadc_vxm_u16m2(vuint16m2_t, uint16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16m4_t vadc_vxm_u16m4(vuint16m4_t, uint16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16m8_t vadc_vxm_u16m8(vuint16m8_t, uint16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16mf2_t vadc_vxm_u16mf2(vuint16mf2_t, uint16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint16mf4_t vadc_vxm_u16mf4(vuint16mf4_t, uint16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint32m1_t vadc_vxm_u32m1(vuint32m1_t, uint32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint32m2_t vadc_vxm_u32m2(vuint32m2_t, uint32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint32m4_t vadc_vxm_u32m4(vuint32m4_t, uint32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint32m8_t vadc_vxm_u32m8(vuint32m8_t, uint32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vadc_vxm)))
vuint32mf2_t vadc_vxm_u32mf2(vuint32mf2_t, uint32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_i8m1_b8(vint8m1_t, vint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_i8m2_b4(vint8m2_t, vint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool2_t vmadc_vvm_i8m4_b2(vint8m4_t, vint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool1_t vmadc_vvm_i8m8_b1(vint8m8_t, vint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_i8mf2_b16(vint8mf2_t, vint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_i8mf4_b32(vint8mf4_t, vint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_i8mf8_b64(vint8mf8_t, vint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_i16m1_b16(vint16m1_t, vint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_i16m2_b8(vint16m2_t, vint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_i16m4_b4(vint16m4_t, vint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool2_t vmadc_vvm_i16m8_b2(vint16m8_t, vint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_i16mf2_b32(vint16mf2_t, vint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_i16mf4_b64(vint16mf4_t, vint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_i32m1_b32(vint32m1_t, vint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_i32m2_b16(vint32m2_t, vint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_i32m4_b8(vint32m4_t, vint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_i32m8_b4(vint32m8_t, vint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_i32mf2_b64(vint32mf2_t, vint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_i8m1_b8(vint8m1_t, int8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_i8m2_b4(vint8m2_t, int8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool2_t vmadc_vxm_i8m4_b2(vint8m4_t, int8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool1_t vmadc_vxm_i8m8_b1(vint8m8_t, int8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_i8mf2_b16(vint8mf2_t, int8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_i8mf4_b32(vint8mf4_t, int8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_i8mf8_b64(vint8mf8_t, int8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_i16m1_b16(vint16m1_t, int16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_i16m2_b8(vint16m2_t, int16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_i16m4_b4(vint16m4_t, int16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool2_t vmadc_vxm_i16m8_b2(vint16m8_t, int16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_i16mf2_b32(vint16mf2_t, int16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_i16mf4_b64(vint16mf4_t, int16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_i32m1_b32(vint32m1_t, int32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_i32m2_b16(vint32m2_t, int32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_i32m4_b8(vint32m4_t, int32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_i32m8_b4(vint32m8_t, int32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_i32mf2_b64(vint32mf2_t, int32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_u8m1_b8(vuint8m1_t, vuint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_u8m2_b4(vuint8m2_t, vuint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool2_t vmadc_vvm_u8m4_b2(vuint8m4_t, vuint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool1_t vmadc_vvm_u8m8_b1(vuint8m8_t, vuint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_u16m1_b16(vuint16m1_t, vuint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_u16m2_b8(vuint16m2_t, vuint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_u16m4_b4(vuint16m4_t, vuint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool2_t vmadc_vvm_u16m8_b2(vuint16m8_t, vuint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool32_t vmadc_vvm_u32m1_b32(vuint32m1_t, vuint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool16_t vmadc_vvm_u32m2_b16(vuint32m2_t, vuint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool8_t vmadc_vvm_u32m4_b8(vuint32m4_t, vuint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool4_t vmadc_vvm_u32m8_b4(vuint32m8_t, vuint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vvm)))
vbool64_t vmadc_vvm_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_u8m1_b8(vuint8m1_t, uint8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_u8m2_b4(vuint8m2_t, uint8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool2_t vmadc_vxm_u8m4_b2(vuint8m4_t, uint8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool1_t vmadc_vxm_u8m8_b1(vuint8m8_t, uint8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_u8mf2_b16(vuint8mf2_t, uint8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_u8mf4_b32(vuint8mf4_t, uint8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_u8mf8_b64(vuint8mf8_t, uint8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_u16m1_b16(vuint16m1_t, uint16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_u16m2_b8(vuint16m2_t, uint16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_u16m4_b4(vuint16m4_t, uint16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool2_t vmadc_vxm_u16m8_b2(vuint16m8_t, uint16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_u16mf2_b32(vuint16mf2_t, uint16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_u16mf4_b64(vuint16mf4_t, uint16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool32_t vmadc_vxm_u32m1_b32(vuint32m1_t, uint32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool16_t vmadc_vxm_u32m2_b16(vuint32m2_t, uint32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool8_t vmadc_vxm_u32m4_b8(vuint32m4_t, uint32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool4_t vmadc_vxm_u32m8_b4(vuint32m8_t, uint32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vxm)))
vbool64_t vmadc_vxm_u32mf2_b64(vuint32mf2_t, uint32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool2_t vmadc_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool1_t vmadc_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool2_t vmadc_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool2_t vmadc_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool1_t vmadc_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool2_t vmadc_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool2_t vmadc_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool1_t vmadc_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool2_t vmadc_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool32_t vmadc_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool16_t vmadc_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool8_t vmadc_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool4_t vmadc_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vv)))
vbool64_t vmadc_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool2_t vmadc_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool1_t vmadc_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool2_t vmadc_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool32_t vmadc_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool16_t vmadc_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool8_t vmadc_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool4_t vmadc_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmadc_vx)))
vbool64_t vmadc_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8m1_t vsbc_vvm_i8m1(vint8m1_t, vint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8m2_t vsbc_vvm_i8m2(vint8m2_t, vint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8m4_t vsbc_vvm_i8m4(vint8m4_t, vint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8m8_t vsbc_vvm_i8m8(vint8m8_t, vint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8mf2_t vsbc_vvm_i8mf2(vint8mf2_t, vint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8mf4_t vsbc_vvm_i8mf4(vint8mf4_t, vint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint8mf8_t vsbc_vvm_i8mf8(vint8mf8_t, vint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16m1_t vsbc_vvm_i16m1(vint16m1_t, vint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16m2_t vsbc_vvm_i16m2(vint16m2_t, vint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16m4_t vsbc_vvm_i16m4(vint16m4_t, vint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16m8_t vsbc_vvm_i16m8(vint16m8_t, vint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16mf2_t vsbc_vvm_i16mf2(vint16mf2_t, vint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint16mf4_t vsbc_vvm_i16mf4(vint16mf4_t, vint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint32m1_t vsbc_vvm_i32m1(vint32m1_t, vint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint32m2_t vsbc_vvm_i32m2(vint32m2_t, vint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint32m4_t vsbc_vvm_i32m4(vint32m4_t, vint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint32m8_t vsbc_vvm_i32m8(vint32m8_t, vint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vint32mf2_t vsbc_vvm_i32mf2(vint32mf2_t, vint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8m1_t vsbc_vxm_i8m1(vint8m1_t, int8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8m2_t vsbc_vxm_i8m2(vint8m2_t, int8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8m4_t vsbc_vxm_i8m4(vint8m4_t, int8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8m8_t vsbc_vxm_i8m8(vint8m8_t, int8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8mf2_t vsbc_vxm_i8mf2(vint8mf2_t, int8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8mf4_t vsbc_vxm_i8mf4(vint8mf4_t, int8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint8mf8_t vsbc_vxm_i8mf8(vint8mf8_t, int8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16m1_t vsbc_vxm_i16m1(vint16m1_t, int16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16m2_t vsbc_vxm_i16m2(vint16m2_t, int16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16m4_t vsbc_vxm_i16m4(vint16m4_t, int16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16m8_t vsbc_vxm_i16m8(vint16m8_t, int16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16mf2_t vsbc_vxm_i16mf2(vint16mf2_t, int16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint16mf4_t vsbc_vxm_i16mf4(vint16mf4_t, int16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint32m1_t vsbc_vxm_i32m1(vint32m1_t, int32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint32m2_t vsbc_vxm_i32m2(vint32m2_t, int32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint32m4_t vsbc_vxm_i32m4(vint32m4_t, int32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint32m8_t vsbc_vxm_i32m8(vint32m8_t, int32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vint32mf2_t vsbc_vxm_i32mf2(vint32mf2_t, int32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8m1_t vsbc_vvm_u8m1(vuint8m1_t, vuint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8m2_t vsbc_vvm_u8m2(vuint8m2_t, vuint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8m4_t vsbc_vvm_u8m4(vuint8m4_t, vuint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8m8_t vsbc_vvm_u8m8(vuint8m8_t, vuint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8mf2_t vsbc_vvm_u8mf2(vuint8mf2_t, vuint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8mf4_t vsbc_vvm_u8mf4(vuint8mf4_t, vuint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint8mf8_t vsbc_vvm_u8mf8(vuint8mf8_t, vuint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16m1_t vsbc_vvm_u16m1(vuint16m1_t, vuint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16m2_t vsbc_vvm_u16m2(vuint16m2_t, vuint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16m4_t vsbc_vvm_u16m4(vuint16m4_t, vuint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16m8_t vsbc_vvm_u16m8(vuint16m8_t, vuint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16mf2_t vsbc_vvm_u16mf2(vuint16mf2_t, vuint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint16mf4_t vsbc_vvm_u16mf4(vuint16mf4_t, vuint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint32m1_t vsbc_vvm_u32m1(vuint32m1_t, vuint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint32m2_t vsbc_vvm_u32m2(vuint32m2_t, vuint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint32m4_t vsbc_vvm_u32m4(vuint32m4_t, vuint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint32m8_t vsbc_vvm_u32m8(vuint32m8_t, vuint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vvm)))
vuint32mf2_t vsbc_vvm_u32mf2(vuint32mf2_t, vuint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8m1_t vsbc_vxm_u8m1(vuint8m1_t, uint8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8m2_t vsbc_vxm_u8m2(vuint8m2_t, uint8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8m4_t vsbc_vxm_u8m4(vuint8m4_t, uint8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8m8_t vsbc_vxm_u8m8(vuint8m8_t, uint8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8mf2_t vsbc_vxm_u8mf2(vuint8mf2_t, uint8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8mf4_t vsbc_vxm_u8mf4(vuint8mf4_t, uint8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint8mf8_t vsbc_vxm_u8mf8(vuint8mf8_t, uint8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16m1_t vsbc_vxm_u16m1(vuint16m1_t, uint16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16m2_t vsbc_vxm_u16m2(vuint16m2_t, uint16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16m4_t vsbc_vxm_u16m4(vuint16m4_t, uint16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16m8_t vsbc_vxm_u16m8(vuint16m8_t, uint16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16mf2_t vsbc_vxm_u16mf2(vuint16mf2_t, uint16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint16mf4_t vsbc_vxm_u16mf4(vuint16mf4_t, uint16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint32m1_t vsbc_vxm_u32m1(vuint32m1_t, uint32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint32m2_t vsbc_vxm_u32m2(vuint32m2_t, uint32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint32m4_t vsbc_vxm_u32m4(vuint32m4_t, uint32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint32m8_t vsbc_vxm_u32m8(vuint32m8_t, uint32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsbc_vxm)))
vuint32mf2_t vsbc_vxm_u32mf2(vuint32mf2_t, uint32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_i8m1_b8(vint8m1_t, vint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_i8m2_b4(vint8m2_t, vint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool2_t vmsbc_vvm_i8m4_b2(vint8m4_t, vint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool1_t vmsbc_vvm_i8m8_b1(vint8m8_t, vint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_i8mf2_b16(vint8mf2_t, vint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_i8mf4_b32(vint8mf4_t, vint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_i8mf8_b64(vint8mf8_t, vint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_i16m1_b16(vint16m1_t, vint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_i16m2_b8(vint16m2_t, vint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_i16m4_b4(vint16m4_t, vint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool2_t vmsbc_vvm_i16m8_b2(vint16m8_t, vint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_i16mf2_b32(vint16mf2_t, vint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_i16mf4_b64(vint16mf4_t, vint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_i32m1_b32(vint32m1_t, vint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_i32m2_b16(vint32m2_t, vint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_i32m4_b8(vint32m4_t, vint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_i32m8_b4(vint32m8_t, vint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_i32mf2_b64(vint32mf2_t, vint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_i8m1_b8(vint8m1_t, int8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_i8m2_b4(vint8m2_t, int8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool2_t vmsbc_vxm_i8m4_b2(vint8m4_t, int8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool1_t vmsbc_vxm_i8m8_b1(vint8m8_t, int8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_i8mf2_b16(vint8mf2_t, int8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_i8mf4_b32(vint8mf4_t, int8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_i8mf8_b64(vint8mf8_t, int8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_i16m1_b16(vint16m1_t, int16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_i16m2_b8(vint16m2_t, int16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_i16m4_b4(vint16m4_t, int16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool2_t vmsbc_vxm_i16m8_b2(vint16m8_t, int16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_i16mf2_b32(vint16mf2_t, int16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_i16mf4_b64(vint16mf4_t, int16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_i32m1_b32(vint32m1_t, int32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_i32m2_b16(vint32m2_t, int32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_i32m4_b8(vint32m4_t, int32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_i32m8_b4(vint32m8_t, int32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_i32mf2_b64(vint32mf2_t, int32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_u8m1_b8(vuint8m1_t, vuint8m1_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_u8m2_b4(vuint8m2_t, vuint8m2_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool2_t vmsbc_vvm_u8m4_b2(vuint8m4_t, vuint8m4_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool1_t vmsbc_vvm_u8m8_b1(vuint8m8_t, vuint8m8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_u16m1_b16(vuint16m1_t, vuint16m1_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_u16m2_b8(vuint16m2_t, vuint16m2_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_u16m4_b4(vuint16m4_t, vuint16m4_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool2_t vmsbc_vvm_u16m8_b2(vuint16m8_t, vuint16m8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool32_t vmsbc_vvm_u32m1_b32(vuint32m1_t, vuint32m1_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool16_t vmsbc_vvm_u32m2_b16(vuint32m2_t, vuint32m2_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool8_t vmsbc_vvm_u32m4_b8(vuint32m4_t, vuint32m4_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool4_t vmsbc_vvm_u32m8_b4(vuint32m8_t, vuint32m8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vvm)))
vbool64_t vmsbc_vvm_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_u8m1_b8(vuint8m1_t, uint8_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_u8m2_b4(vuint8m2_t, uint8_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool2_t vmsbc_vxm_u8m4_b2(vuint8m4_t, uint8_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool1_t vmsbc_vxm_u8m8_b1(vuint8m8_t, uint8_t, vbool1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_u8mf2_b16(vuint8mf2_t, uint8_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_u8mf4_b32(vuint8mf4_t, uint8_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_u8mf8_b64(vuint8mf8_t, uint8_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_u16m1_b16(vuint16m1_t, uint16_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_u16m2_b8(vuint16m2_t, uint16_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_u16m4_b4(vuint16m4_t, uint16_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool2_t vmsbc_vxm_u16m8_b2(vuint16m8_t, uint16_t, vbool2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_u16mf2_b32(vuint16mf2_t, uint16_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_u16mf4_b64(vuint16mf4_t, uint16_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool32_t vmsbc_vxm_u32m1_b32(vuint32m1_t, uint32_t, vbool32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool16_t vmsbc_vxm_u32m2_b16(vuint32m2_t, uint32_t, vbool16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool8_t vmsbc_vxm_u32m4_b8(vuint32m4_t, uint32_t, vbool8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool4_t vmsbc_vxm_u32m8_b4(vuint32m8_t, uint32_t, vbool4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vxm)))
vbool64_t vmsbc_vxm_u32mf2_b64(vuint32mf2_t, uint32_t, vbool64_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool2_t vmsbc_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool1_t vmsbc_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool2_t vmsbc_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool2_t vmsbc_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool1_t vmsbc_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool2_t vmsbc_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool2_t vmsbc_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool1_t vmsbc_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool2_t vmsbc_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool32_t vmsbc_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool16_t vmsbc_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool8_t vmsbc_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool4_t vmsbc_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vv)))
vbool64_t vmsbc_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool2_t vmsbc_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool1_t vmsbc_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool2_t vmsbc_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool32_t vmsbc_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool16_t vmsbc_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool8_t vmsbc_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool4_t vmsbc_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsbc_vx)))
vbool64_t vmsbc_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8m1_t vand_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8m1_t vand_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8m2_t vand_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8m2_t vand_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8m4_t vand_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8m4_t vand_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8m8_t vand_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8m8_t vand_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8mf2_t vand_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8mf2_t vand_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8mf4_t vand_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8mf4_t vand_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint8mf8_t vand_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint8mf8_t vand_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16m1_t vand_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16m1_t vand_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16m2_t vand_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16m2_t vand_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16m4_t vand_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16m4_t vand_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16m8_t vand_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16m8_t vand_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16mf2_t vand_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16mf2_t vand_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint16mf4_t vand_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint16mf4_t vand_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint32m1_t vand_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint32m1_t vand_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint32m2_t vand_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint32m2_t vand_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint32m4_t vand_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint32m4_t vand_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint32m8_t vand_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint32m8_t vand_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vint32mf2_t vand_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vint32mf2_t vand_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8m1_t vand_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8m1_t vand_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8m2_t vand_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8m2_t vand_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8m4_t vand_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8m4_t vand_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8m8_t vand_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8m8_t vand_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8mf2_t vand_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8mf2_t vand_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8mf4_t vand_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8mf4_t vand_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint8mf8_t vand_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint8mf8_t vand_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16m1_t vand_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16m1_t vand_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16m2_t vand_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16m2_t vand_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16m4_t vand_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16m4_t vand_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16m8_t vand_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16m8_t vand_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16mf2_t vand_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16mf2_t vand_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint16mf4_t vand_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint16mf4_t vand_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint32m1_t vand_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint32m1_t vand_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint32m2_t vand_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint32m2_t vand_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint32m4_t vand_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint32m4_t vand_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint32m8_t vand_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint32m8_t vand_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vint32mf2_t vand_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vint32mf2_t vand_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8m1_t vand_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8m1_t vand_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8m2_t vand_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8m2_t vand_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8m4_t vand_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8m4_t vand_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8m8_t vand_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8m8_t vand_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8mf2_t vand_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8mf2_t vand_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8mf4_t vand_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8mf4_t vand_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint8mf8_t vand_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint8mf8_t vand_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16m1_t vand_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16m1_t vand_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16m2_t vand_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16m2_t vand_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16m4_t vand_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16m4_t vand_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16m8_t vand_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16m8_t vand_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16mf2_t vand_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16mf2_t vand_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint16mf4_t vand_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint16mf4_t vand_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint32m1_t vand_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint32m1_t vand_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint32m2_t vand_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint32m2_t vand_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint32m4_t vand_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint32m4_t vand_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint32m8_t vand_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint32m8_t vand_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv)))
vuint32mf2_t vand_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vv_m)))
vuint32mf2_t vand_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8m1_t vand_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8m1_t vand_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8m2_t vand_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8m2_t vand_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8m4_t vand_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8m4_t vand_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8m8_t vand_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8m8_t vand_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8mf2_t vand_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8mf2_t vand_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8mf4_t vand_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8mf4_t vand_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint8mf8_t vand_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint8mf8_t vand_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16m1_t vand_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16m1_t vand_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16m2_t vand_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16m2_t vand_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16m4_t vand_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16m4_t vand_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16m8_t vand_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16m8_t vand_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16mf2_t vand_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16mf2_t vand_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint16mf4_t vand_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint16mf4_t vand_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint32m1_t vand_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint32m1_t vand_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint32m2_t vand_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint32m2_t vand_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint32m4_t vand_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint32m4_t vand_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint32m8_t vand_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint32m8_t vand_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx)))
vuint32mf2_t vand_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vand_vx_m)))
vuint32mf2_t vand_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8m1_t vxor_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8m1_t vxor_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8m2_t vxor_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8m2_t vxor_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8m4_t vxor_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8m4_t vxor_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8m8_t vxor_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8m8_t vxor_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8mf2_t vxor_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8mf2_t vxor_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8mf4_t vxor_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8mf4_t vxor_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint8mf8_t vxor_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint8mf8_t vxor_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16m1_t vxor_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16m1_t vxor_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16m2_t vxor_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16m2_t vxor_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16m4_t vxor_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16m4_t vxor_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16m8_t vxor_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16m8_t vxor_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16mf2_t vxor_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16mf2_t vxor_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint16mf4_t vxor_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint16mf4_t vxor_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint32m1_t vxor_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint32m1_t vxor_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint32m2_t vxor_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint32m2_t vxor_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint32m4_t vxor_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint32m4_t vxor_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint32m8_t vxor_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint32m8_t vxor_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vint32mf2_t vxor_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vint32mf2_t vxor_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8m1_t vxor_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8m1_t vxor_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8m2_t vxor_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8m2_t vxor_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8m4_t vxor_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8m4_t vxor_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8m8_t vxor_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8m8_t vxor_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8mf2_t vxor_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8mf2_t vxor_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8mf4_t vxor_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8mf4_t vxor_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint8mf8_t vxor_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint8mf8_t vxor_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16m1_t vxor_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16m1_t vxor_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16m2_t vxor_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16m2_t vxor_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16m4_t vxor_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16m4_t vxor_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16m8_t vxor_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16m8_t vxor_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16mf2_t vxor_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16mf2_t vxor_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint16mf4_t vxor_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint16mf4_t vxor_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint32m1_t vxor_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint32m1_t vxor_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint32m2_t vxor_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint32m2_t vxor_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint32m4_t vxor_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint32m4_t vxor_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint32m8_t vxor_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint32m8_t vxor_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vint32mf2_t vxor_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vint32mf2_t vxor_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8m1_t vxor_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8m1_t vxor_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8m2_t vxor_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8m2_t vxor_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8m4_t vxor_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8m4_t vxor_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8m8_t vxor_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8m8_t vxor_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8mf2_t vxor_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8mf2_t vxor_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8mf4_t vxor_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8mf4_t vxor_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint8mf8_t vxor_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint8mf8_t vxor_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16m1_t vxor_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16m1_t vxor_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16m2_t vxor_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16m2_t vxor_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16m4_t vxor_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16m4_t vxor_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16m8_t vxor_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16m8_t vxor_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16mf2_t vxor_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16mf2_t vxor_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint16mf4_t vxor_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint16mf4_t vxor_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint32m1_t vxor_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint32m1_t vxor_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint32m2_t vxor_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint32m2_t vxor_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint32m4_t vxor_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint32m4_t vxor_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint32m8_t vxor_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint32m8_t vxor_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv)))
vuint32mf2_t vxor_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vv_m)))
vuint32mf2_t vxor_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8m1_t vxor_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8m1_t vxor_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8m2_t vxor_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8m2_t vxor_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8m4_t vxor_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8m4_t vxor_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8m8_t vxor_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8m8_t vxor_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8mf2_t vxor_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8mf2_t vxor_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8mf4_t vxor_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8mf4_t vxor_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint8mf8_t vxor_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint8mf8_t vxor_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16m1_t vxor_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16m1_t vxor_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16m2_t vxor_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16m2_t vxor_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16m4_t vxor_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16m4_t vxor_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16m8_t vxor_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16m8_t vxor_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16mf2_t vxor_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16mf2_t vxor_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint16mf4_t vxor_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint16mf4_t vxor_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint32m1_t vxor_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint32m1_t vxor_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint32m2_t vxor_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint32m2_t vxor_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint32m4_t vxor_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint32m4_t vxor_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint32m8_t vxor_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint32m8_t vxor_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx)))
vuint32mf2_t vxor_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vxor_vx_m)))
vuint32mf2_t vxor_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8m1_t vor_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8m1_t vor_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8m2_t vor_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8m2_t vor_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8m4_t vor_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8m4_t vor_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8m8_t vor_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8m8_t vor_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8mf2_t vor_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8mf2_t vor_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8mf4_t vor_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8mf4_t vor_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint8mf8_t vor_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint8mf8_t vor_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16m1_t vor_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16m1_t vor_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16m2_t vor_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16m2_t vor_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16m4_t vor_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16m4_t vor_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16m8_t vor_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16m8_t vor_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16mf2_t vor_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16mf2_t vor_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint16mf4_t vor_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint16mf4_t vor_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint32m1_t vor_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint32m1_t vor_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint32m2_t vor_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint32m2_t vor_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint32m4_t vor_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint32m4_t vor_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint32m8_t vor_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint32m8_t vor_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vint32mf2_t vor_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vint32mf2_t vor_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8m1_t vor_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8m1_t vor_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8m2_t vor_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8m2_t vor_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8m4_t vor_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8m4_t vor_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8m8_t vor_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8m8_t vor_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8mf2_t vor_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8mf2_t vor_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8mf4_t vor_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8mf4_t vor_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint8mf8_t vor_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint8mf8_t vor_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16m1_t vor_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16m1_t vor_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16m2_t vor_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16m2_t vor_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16m4_t vor_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16m4_t vor_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16m8_t vor_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16m8_t vor_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16mf2_t vor_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16mf2_t vor_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint16mf4_t vor_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint16mf4_t vor_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint32m1_t vor_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint32m1_t vor_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint32m2_t vor_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint32m2_t vor_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint32m4_t vor_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint32m4_t vor_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint32m8_t vor_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint32m8_t vor_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vint32mf2_t vor_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vint32mf2_t vor_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8m1_t vor_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8m1_t vor_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8m2_t vor_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8m2_t vor_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8m4_t vor_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8m4_t vor_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8m8_t vor_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8m8_t vor_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8mf2_t vor_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8mf2_t vor_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8mf4_t vor_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8mf4_t vor_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint8mf8_t vor_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint8mf8_t vor_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16m1_t vor_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16m1_t vor_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16m2_t vor_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16m2_t vor_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16m4_t vor_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16m4_t vor_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16m8_t vor_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16m8_t vor_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16mf2_t vor_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16mf2_t vor_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint16mf4_t vor_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint16mf4_t vor_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint32m1_t vor_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint32m1_t vor_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint32m2_t vor_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint32m2_t vor_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint32m4_t vor_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint32m4_t vor_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint32m8_t vor_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint32m8_t vor_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv)))
vuint32mf2_t vor_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vv_m)))
vuint32mf2_t vor_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8m1_t vor_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8m1_t vor_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8m2_t vor_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8m2_t vor_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8m4_t vor_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8m4_t vor_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8m8_t vor_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8m8_t vor_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8mf2_t vor_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8mf2_t vor_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8mf4_t vor_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8mf4_t vor_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint8mf8_t vor_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint8mf8_t vor_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16m1_t vor_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16m1_t vor_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16m2_t vor_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16m2_t vor_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16m4_t vor_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16m4_t vor_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16m8_t vor_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16m8_t vor_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16mf2_t vor_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16mf2_t vor_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint16mf4_t vor_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint16mf4_t vor_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint32m1_t vor_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint32m1_t vor_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint32m2_t vor_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint32m2_t vor_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint32m4_t vor_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint32m4_t vor_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint32m8_t vor_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint32m8_t vor_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx)))
vuint32mf2_t vor_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vor_vx_m)))
vuint32mf2_t vor_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8m1_t vsll_vv_i8m1(vint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8m1_t vsll_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8m2_t vsll_vv_i8m2(vint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8m2_t vsll_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8m4_t vsll_vv_i8m4(vint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8m4_t vsll_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8m8_t vsll_vv_i8m8(vint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8m8_t vsll_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8mf2_t vsll_vv_i8mf2(vint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8mf2_t vsll_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8mf4_t vsll_vv_i8mf4(vint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8mf4_t vsll_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint8mf8_t vsll_vv_i8mf8(vint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint8mf8_t vsll_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16m1_t vsll_vv_i16m1(vint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16m1_t vsll_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16m2_t vsll_vv_i16m2(vint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16m2_t vsll_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16m4_t vsll_vv_i16m4(vint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16m4_t vsll_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16m8_t vsll_vv_i16m8(vint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16m8_t vsll_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16mf2_t vsll_vv_i16mf2(vint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16mf2_t vsll_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint16mf4_t vsll_vv_i16mf4(vint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint16mf4_t vsll_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint32m1_t vsll_vv_i32m1(vint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint32m1_t vsll_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint32m2_t vsll_vv_i32m2(vint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint32m2_t vsll_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint32m4_t vsll_vv_i32m4(vint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint32m4_t vsll_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint32m8_t vsll_vv_i32m8(vint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint32m8_t vsll_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vint32mf2_t vsll_vv_i32mf2(vint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vint32mf2_t vsll_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8m1_t vsll_vx_i8m1(vint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8m1_t vsll_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8m2_t vsll_vx_i8m2(vint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8m2_t vsll_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8m4_t vsll_vx_i8m4(vint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8m4_t vsll_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8m8_t vsll_vx_i8m8(vint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8m8_t vsll_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8mf2_t vsll_vx_i8mf2(vint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8mf2_t vsll_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8mf4_t vsll_vx_i8mf4(vint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8mf4_t vsll_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint8mf8_t vsll_vx_i8mf8(vint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint8mf8_t vsll_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16m1_t vsll_vx_i16m1(vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16m1_t vsll_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16m2_t vsll_vx_i16m2(vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16m2_t vsll_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16m4_t vsll_vx_i16m4(vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16m4_t vsll_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16m8_t vsll_vx_i16m8(vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16m8_t vsll_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16mf2_t vsll_vx_i16mf2(vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16mf2_t vsll_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint16mf4_t vsll_vx_i16mf4(vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint16mf4_t vsll_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint32m1_t vsll_vx_i32m1(vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint32m1_t vsll_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint32m2_t vsll_vx_i32m2(vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint32m2_t vsll_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint32m4_t vsll_vx_i32m4(vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint32m4_t vsll_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint32m8_t vsll_vx_i32m8(vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint32m8_t vsll_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vint32mf2_t vsll_vx_i32mf2(vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vint32mf2_t vsll_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8m1_t vsll_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8m1_t vsll_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8m2_t vsll_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8m2_t vsll_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8m4_t vsll_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8m4_t vsll_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8m8_t vsll_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8m8_t vsll_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8mf2_t vsll_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8mf2_t vsll_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8mf4_t vsll_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8mf4_t vsll_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint8mf8_t vsll_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint8mf8_t vsll_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16m1_t vsll_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16m1_t vsll_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16m2_t vsll_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16m2_t vsll_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16m4_t vsll_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16m4_t vsll_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16m8_t vsll_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16m8_t vsll_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16mf2_t vsll_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16mf2_t vsll_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint16mf4_t vsll_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint16mf4_t vsll_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint32m1_t vsll_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint32m1_t vsll_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint32m2_t vsll_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint32m2_t vsll_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint32m4_t vsll_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint32m4_t vsll_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint32m8_t vsll_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint32m8_t vsll_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv)))
vuint32mf2_t vsll_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vv_m)))
vuint32mf2_t vsll_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8m1_t vsll_vx_u8m1(vuint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8m1_t vsll_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8m2_t vsll_vx_u8m2(vuint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8m2_t vsll_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8m4_t vsll_vx_u8m4(vuint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8m4_t vsll_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8m8_t vsll_vx_u8m8(vuint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8m8_t vsll_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8mf2_t vsll_vx_u8mf2(vuint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8mf2_t vsll_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8mf4_t vsll_vx_u8mf4(vuint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8mf4_t vsll_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint8mf8_t vsll_vx_u8mf8(vuint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint8mf8_t vsll_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16m1_t vsll_vx_u16m1(vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16m1_t vsll_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16m2_t vsll_vx_u16m2(vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16m2_t vsll_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16m4_t vsll_vx_u16m4(vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16m4_t vsll_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16m8_t vsll_vx_u16m8(vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16m8_t vsll_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16mf2_t vsll_vx_u16mf2(vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16mf2_t vsll_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint16mf4_t vsll_vx_u16mf4(vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint16mf4_t vsll_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint32m1_t vsll_vx_u32m1(vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint32m1_t vsll_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint32m2_t vsll_vx_u32m2(vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint32m2_t vsll_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint32m4_t vsll_vx_u32m4(vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint32m4_t vsll_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint32m8_t vsll_vx_u32m8(vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint32m8_t vsll_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx)))
vuint32mf2_t vsll_vx_u32mf2(vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsll_vx_m)))
vuint32mf2_t vsll_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8m1_t vsrl_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8m1_t vsrl_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8m2_t vsrl_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8m2_t vsrl_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8m4_t vsrl_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8m4_t vsrl_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8m8_t vsrl_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8m8_t vsrl_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8mf2_t vsrl_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8mf2_t vsrl_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8mf4_t vsrl_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8mf4_t vsrl_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint8mf8_t vsrl_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint8mf8_t vsrl_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16m1_t vsrl_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16m1_t vsrl_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16m2_t vsrl_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16m2_t vsrl_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16m4_t vsrl_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16m4_t vsrl_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16m8_t vsrl_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16m8_t vsrl_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16mf2_t vsrl_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16mf2_t vsrl_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint16mf4_t vsrl_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint16mf4_t vsrl_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint32m1_t vsrl_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint32m1_t vsrl_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint32m2_t vsrl_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint32m2_t vsrl_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint32m4_t vsrl_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint32m4_t vsrl_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint32m8_t vsrl_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint32m8_t vsrl_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv)))
vuint32mf2_t vsrl_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vv_m)))
vuint32mf2_t vsrl_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8m1_t vsrl_vx_u8m1(vuint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8m1_t vsrl_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8m2_t vsrl_vx_u8m2(vuint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8m2_t vsrl_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8m4_t vsrl_vx_u8m4(vuint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8m4_t vsrl_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8m8_t vsrl_vx_u8m8(vuint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8m8_t vsrl_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8mf2_t vsrl_vx_u8mf2(vuint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8mf2_t vsrl_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8mf4_t vsrl_vx_u8mf4(vuint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8mf4_t vsrl_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint8mf8_t vsrl_vx_u8mf8(vuint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint8mf8_t vsrl_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16m1_t vsrl_vx_u16m1(vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16m1_t vsrl_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16m2_t vsrl_vx_u16m2(vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16m2_t vsrl_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16m4_t vsrl_vx_u16m4(vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16m4_t vsrl_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16m8_t vsrl_vx_u16m8(vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16m8_t vsrl_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16mf2_t vsrl_vx_u16mf2(vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16mf2_t vsrl_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint16mf4_t vsrl_vx_u16mf4(vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint16mf4_t vsrl_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint32m1_t vsrl_vx_u32m1(vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint32m1_t vsrl_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint32m2_t vsrl_vx_u32m2(vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint32m2_t vsrl_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint32m4_t vsrl_vx_u32m4(vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint32m4_t vsrl_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint32m8_t vsrl_vx_u32m8(vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint32m8_t vsrl_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx)))
vuint32mf2_t vsrl_vx_u32mf2(vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsrl_vx_m)))
vuint32mf2_t vsrl_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8m1_t vsra_vv_i8m1(vint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8m1_t vsra_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8m2_t vsra_vv_i8m2(vint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8m2_t vsra_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8m4_t vsra_vv_i8m4(vint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8m4_t vsra_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8m8_t vsra_vv_i8m8(vint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8m8_t vsra_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8mf2_t vsra_vv_i8mf2(vint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8mf2_t vsra_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8mf4_t vsra_vv_i8mf4(vint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8mf4_t vsra_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint8mf8_t vsra_vv_i8mf8(vint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint8mf8_t vsra_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16m1_t vsra_vv_i16m1(vint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16m1_t vsra_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16m2_t vsra_vv_i16m2(vint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16m2_t vsra_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16m4_t vsra_vv_i16m4(vint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16m4_t vsra_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16m8_t vsra_vv_i16m8(vint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16m8_t vsra_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16mf2_t vsra_vv_i16mf2(vint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16mf2_t vsra_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint16mf4_t vsra_vv_i16mf4(vint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint16mf4_t vsra_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint32m1_t vsra_vv_i32m1(vint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint32m1_t vsra_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint32m2_t vsra_vv_i32m2(vint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint32m2_t vsra_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint32m4_t vsra_vv_i32m4(vint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint32m4_t vsra_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint32m8_t vsra_vv_i32m8(vint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint32m8_t vsra_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv)))
vint32mf2_t vsra_vv_i32mf2(vint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vv_m)))
vint32mf2_t vsra_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8m1_t vsra_vx_i8m1(vint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8m1_t vsra_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8m2_t vsra_vx_i8m2(vint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8m2_t vsra_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8m4_t vsra_vx_i8m4(vint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8m4_t vsra_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8m8_t vsra_vx_i8m8(vint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8m8_t vsra_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8mf2_t vsra_vx_i8mf2(vint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8mf2_t vsra_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8mf4_t vsra_vx_i8mf4(vint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8mf4_t vsra_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint8mf8_t vsra_vx_i8mf8(vint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint8mf8_t vsra_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16m1_t vsra_vx_i16m1(vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16m1_t vsra_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16m2_t vsra_vx_i16m2(vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16m2_t vsra_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16m4_t vsra_vx_i16m4(vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16m4_t vsra_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16m8_t vsra_vx_i16m8(vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16m8_t vsra_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16mf2_t vsra_vx_i16mf2(vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16mf2_t vsra_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint16mf4_t vsra_vx_i16mf4(vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint16mf4_t vsra_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint32m1_t vsra_vx_i32m1(vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint32m1_t vsra_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint32m2_t vsra_vx_i32m2(vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint32m2_t vsra_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint32m4_t vsra_vx_i32m4(vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint32m4_t vsra_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint32m8_t vsra_vx_i32m8(vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint32m8_t vsra_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx)))
vint32mf2_t vsra_vx_i32mf2(vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsra_vx_m)))
vint32mf2_t vsra_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8m1_t vnsrl_wv_u8m1(vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8m1_t vnsrl_wv_u8m1_m(vbool8_t, vuint8m1_t, vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8m2_t vnsrl_wv_u8m2(vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8m2_t vnsrl_wv_u8m2_m(vbool4_t, vuint8m2_t, vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8m4_t vnsrl_wv_u8m4(vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8m4_t vnsrl_wv_u8m4_m(vbool2_t, vuint8m4_t, vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8mf2_t vnsrl_wv_u8mf2(vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8mf2_t vnsrl_wv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8mf4_t vnsrl_wv_u8mf4(vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8mf4_t vnsrl_wv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint8mf8_t vnsrl_wv_u8mf8(vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint8mf8_t vnsrl_wv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint16m1_t vnsrl_wv_u16m1(vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint16m1_t vnsrl_wv_u16m1_m(vbool16_t, vuint16m1_t, vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint16m2_t vnsrl_wv_u16m2(vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint16m2_t vnsrl_wv_u16m2_m(vbool8_t, vuint16m2_t, vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint16m4_t vnsrl_wv_u16m4(vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint16m4_t vnsrl_wv_u16m4_m(vbool4_t, vuint16m4_t, vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint16mf2_t vnsrl_wv_u16mf2(vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint16mf2_t vnsrl_wv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv)))
vuint16mf4_t vnsrl_wv_u16mf4(vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wv_m)))
vuint16mf4_t vnsrl_wv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8m1_t vnsrl_wx_u8m1(vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8m1_t vnsrl_wx_u8m1_m(vbool8_t, vuint8m1_t, vuint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8m2_t vnsrl_wx_u8m2(vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8m2_t vnsrl_wx_u8m2_m(vbool4_t, vuint8m2_t, vuint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8m4_t vnsrl_wx_u8m4(vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8m4_t vnsrl_wx_u8m4_m(vbool2_t, vuint8m4_t, vuint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8mf2_t vnsrl_wx_u8mf2(vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8mf2_t vnsrl_wx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8mf4_t vnsrl_wx_u8mf4(vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8mf4_t vnsrl_wx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint8mf8_t vnsrl_wx_u8mf8(vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint8mf8_t vnsrl_wx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint16m1_t vnsrl_wx_u16m1(vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint16m1_t vnsrl_wx_u16m1_m(vbool16_t, vuint16m1_t, vuint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint16m2_t vnsrl_wx_u16m2(vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint16m2_t vnsrl_wx_u16m2_m(vbool8_t, vuint16m2_t, vuint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint16m4_t vnsrl_wx_u16m4(vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint16m4_t vnsrl_wx_u16m4_m(vbool4_t, vuint16m4_t, vuint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint16mf2_t vnsrl_wx_u16mf2(vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint16mf2_t vnsrl_wx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx)))
vuint16mf4_t vnsrl_wx_u16mf4(vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsrl_wx_m)))
vuint16mf4_t vnsrl_wx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8m1_t vnsra_wv_i8m1(vint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8m1_t vnsra_wv_i8m1_m(vbool8_t, vint8m1_t, vint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8m2_t vnsra_wv_i8m2(vint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8m2_t vnsra_wv_i8m2_m(vbool4_t, vint8m2_t, vint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8m4_t vnsra_wv_i8m4(vint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8m4_t vnsra_wv_i8m4_m(vbool2_t, vint8m4_t, vint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8mf2_t vnsra_wv_i8mf2(vint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8mf2_t vnsra_wv_i8mf2_m(vbool16_t, vint8mf2_t, vint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8mf4_t vnsra_wv_i8mf4(vint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8mf4_t vnsra_wv_i8mf4_m(vbool32_t, vint8mf4_t, vint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint8mf8_t vnsra_wv_i8mf8(vint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint8mf8_t vnsra_wv_i8mf8_m(vbool64_t, vint8mf8_t, vint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint16m1_t vnsra_wv_i16m1(vint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint16m1_t vnsra_wv_i16m1_m(vbool16_t, vint16m1_t, vint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint16m2_t vnsra_wv_i16m2(vint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint16m2_t vnsra_wv_i16m2_m(vbool8_t, vint16m2_t, vint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint16m4_t vnsra_wv_i16m4(vint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint16m4_t vnsra_wv_i16m4_m(vbool4_t, vint16m4_t, vint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint16mf2_t vnsra_wv_i16mf2(vint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint16mf2_t vnsra_wv_i16mf2_m(vbool32_t, vint16mf2_t, vint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv)))
vint16mf4_t vnsra_wv_i16mf4(vint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wv_m)))
vint16mf4_t vnsra_wv_i16mf4_m(vbool64_t, vint16mf4_t, vint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8m1_t vnsra_wx_i8m1(vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8m1_t vnsra_wx_i8m1_m(vbool8_t, vint8m1_t, vint16m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8m2_t vnsra_wx_i8m2(vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8m2_t vnsra_wx_i8m2_m(vbool4_t, vint8m2_t, vint16m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8m4_t vnsra_wx_i8m4(vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8m4_t vnsra_wx_i8m4_m(vbool2_t, vint8m4_t, vint16m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8mf2_t vnsra_wx_i8mf2(vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8mf2_t vnsra_wx_i8mf2_m(vbool16_t, vint8mf2_t, vint16m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8mf4_t vnsra_wx_i8mf4(vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8mf4_t vnsra_wx_i8mf4_m(vbool32_t, vint8mf4_t, vint16mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint8mf8_t vnsra_wx_i8mf8(vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint8mf8_t vnsra_wx_i8mf8_m(vbool64_t, vint8mf8_t, vint16mf4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint16m1_t vnsra_wx_i16m1(vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint16m1_t vnsra_wx_i16m1_m(vbool16_t, vint16m1_t, vint32m2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint16m2_t vnsra_wx_i16m2(vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint16m2_t vnsra_wx_i16m2_m(vbool8_t, vint16m2_t, vint32m4_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint16m4_t vnsra_wx_i16m4(vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint16m4_t vnsra_wx_i16m4_m(vbool4_t, vint16m4_t, vint32m8_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint16mf2_t vnsra_wx_i16mf2(vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint16mf2_t vnsra_wx_i16mf2_m(vbool32_t, vint16mf2_t, vint32m1_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx)))
vint16mf4_t vnsra_wx_i16mf4(vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vnsra_wx_m)))
vint16mf4_t vnsra_wx_i16mf4_m(vbool64_t, vint16mf4_t, vint32mf2_t, size_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8m1_t vncvt_x_x_w_u8m1(vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8m1_t vncvt_x_x_w_u8m1_m(vbool8_t, vuint8m1_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8m2_t vncvt_x_x_w_u8m2(vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8m2_t vncvt_x_x_w_u8m2_m(vbool4_t, vuint8m2_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8m4_t vncvt_x_x_w_u8m4(vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8m4_t vncvt_x_x_w_u8m4_m(vbool2_t, vuint8m4_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8mf2_t vncvt_x_x_w_u8mf2(vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8mf2_t vncvt_x_x_w_u8mf2_m(vbool16_t, vuint8mf2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8mf4_t vncvt_x_x_w_u8mf4(vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8mf4_t vncvt_x_x_w_u8mf4_m(vbool32_t, vuint8mf4_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint8mf8_t vncvt_x_x_w_u8mf8(vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint8mf8_t vncvt_x_x_w_u8mf8_m(vbool64_t, vuint8mf8_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint16m1_t vncvt_x_x_w_u16m1(vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint16m1_t vncvt_x_x_w_u16m1_m(vbool16_t, vuint16m1_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint16m2_t vncvt_x_x_w_u16m2(vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint16m2_t vncvt_x_x_w_u16m2_m(vbool8_t, vuint16m2_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint16m4_t vncvt_x_x_w_u16m4(vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint16m4_t vncvt_x_x_w_u16m4_m(vbool4_t, vuint16m4_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint16mf2_t vncvt_x_x_w_u16mf2(vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint16mf2_t vncvt_x_x_w_u16mf2_m(vbool32_t, vuint16mf2_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w)))
vuint16mf4_t vncvt_x_x_w_u16mf4(vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vncvt_x_x_w_m)))
vuint16mf4_t vncvt_x_x_w_u16mf4_m(vbool64_t, vuint16mf4_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool2_t vmseq_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool2_t vmseq_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool1_t vmseq_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool1_t vmseq_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool2_t vmseq_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool2_t vmseq_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool2_t vmseq_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool2_t vmseq_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool1_t vmseq_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool1_t vmseq_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool2_t vmseq_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool2_t vmseq_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool2_t vmseq_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool2_t vmseq_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool1_t vmseq_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool1_t vmseq_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool2_t vmseq_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool2_t vmseq_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool32_t vmseq_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool32_t vmseq_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool16_t vmseq_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool16_t vmseq_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool8_t vmseq_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool8_t vmseq_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool4_t vmseq_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool4_t vmseq_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv)))
vbool64_t vmseq_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vv_m)))
vbool64_t vmseq_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool2_t vmseq_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool2_t vmseq_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool1_t vmseq_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool1_t vmseq_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool2_t vmseq_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool2_t vmseq_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool32_t vmseq_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool32_t vmseq_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool16_t vmseq_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool16_t vmseq_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool8_t vmseq_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool8_t vmseq_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool4_t vmseq_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool4_t vmseq_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx)))
vbool64_t vmseq_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmseq_vx_m)))
vbool64_t vmseq_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool2_t vmsne_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool2_t vmsne_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool1_t vmsne_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool1_t vmsne_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool2_t vmsne_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool2_t vmsne_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool2_t vmsne_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool2_t vmsne_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool1_t vmsne_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool1_t vmsne_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool2_t vmsne_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool2_t vmsne_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool2_t vmsne_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool2_t vmsne_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool1_t vmsne_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool1_t vmsne_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool2_t vmsne_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool2_t vmsne_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool32_t vmsne_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool32_t vmsne_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool16_t vmsne_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool16_t vmsne_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool8_t vmsne_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool8_t vmsne_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool4_t vmsne_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool4_t vmsne_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv)))
vbool64_t vmsne_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vv_m)))
vbool64_t vmsne_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool2_t vmsne_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool2_t vmsne_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool1_t vmsne_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool1_t vmsne_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool2_t vmsne_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool2_t vmsne_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool32_t vmsne_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool32_t vmsne_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool16_t vmsne_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool16_t vmsne_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool8_t vmsne_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool8_t vmsne_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool4_t vmsne_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool4_t vmsne_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx)))
vbool64_t vmsne_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsne_vx_m)))
vbool64_t vmsne_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool8_t vmsltu_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool8_t vmsltu_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool4_t vmsltu_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool4_t vmsltu_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool2_t vmsltu_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool2_t vmsltu_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool1_t vmsltu_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool1_t vmsltu_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool16_t vmsltu_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool16_t vmsltu_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool32_t vmsltu_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool32_t vmsltu_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool64_t vmsltu_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool64_t vmsltu_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool16_t vmsltu_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool16_t vmsltu_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool8_t vmsltu_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool8_t vmsltu_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool4_t vmsltu_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool4_t vmsltu_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool2_t vmsltu_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool2_t vmsltu_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool32_t vmsltu_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool32_t vmsltu_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool64_t vmsltu_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool64_t vmsltu_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool32_t vmsltu_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool32_t vmsltu_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool16_t vmsltu_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool16_t vmsltu_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool8_t vmsltu_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool8_t vmsltu_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool4_t vmsltu_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool4_t vmsltu_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv)))
vbool64_t vmsltu_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vv_m)))
vbool64_t vmsltu_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool8_t vmsltu_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool8_t vmsltu_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool4_t vmsltu_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool4_t vmsltu_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool2_t vmsltu_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool2_t vmsltu_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool1_t vmsltu_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool1_t vmsltu_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool16_t vmsltu_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool16_t vmsltu_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool32_t vmsltu_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool32_t vmsltu_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool64_t vmsltu_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool64_t vmsltu_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool16_t vmsltu_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool16_t vmsltu_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool8_t vmsltu_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool8_t vmsltu_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool4_t vmsltu_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool4_t vmsltu_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool2_t vmsltu_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool2_t vmsltu_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool32_t vmsltu_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool32_t vmsltu_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool64_t vmsltu_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool64_t vmsltu_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool32_t vmsltu_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool32_t vmsltu_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool16_t vmsltu_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool16_t vmsltu_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool8_t vmsltu_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool8_t vmsltu_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool4_t vmsltu_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool4_t vmsltu_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx)))
vbool64_t vmsltu_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsltu_vx_m)))
vbool64_t vmsltu_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool8_t vmslt_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool8_t vmslt_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool4_t vmslt_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool4_t vmslt_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool2_t vmslt_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool2_t vmslt_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool1_t vmslt_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool1_t vmslt_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool16_t vmslt_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool16_t vmslt_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool32_t vmslt_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool32_t vmslt_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool64_t vmslt_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool64_t vmslt_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool16_t vmslt_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool16_t vmslt_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool8_t vmslt_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool8_t vmslt_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool4_t vmslt_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool4_t vmslt_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool2_t vmslt_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool2_t vmslt_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool32_t vmslt_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool32_t vmslt_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool64_t vmslt_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool64_t vmslt_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool32_t vmslt_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool32_t vmslt_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool16_t vmslt_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool16_t vmslt_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool8_t vmslt_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool8_t vmslt_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool4_t vmslt_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool4_t vmslt_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv)))
vbool64_t vmslt_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vv_m)))
vbool64_t vmslt_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool8_t vmslt_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool8_t vmslt_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool4_t vmslt_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool4_t vmslt_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool2_t vmslt_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool2_t vmslt_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool1_t vmslt_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool1_t vmslt_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool16_t vmslt_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool16_t vmslt_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool32_t vmslt_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool32_t vmslt_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool64_t vmslt_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool64_t vmslt_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool16_t vmslt_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool16_t vmslt_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool8_t vmslt_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool8_t vmslt_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool4_t vmslt_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool4_t vmslt_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool2_t vmslt_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool2_t vmslt_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool32_t vmslt_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool32_t vmslt_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool64_t vmslt_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool64_t vmslt_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool32_t vmslt_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool32_t vmslt_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool16_t vmslt_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool16_t vmslt_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool8_t vmslt_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool8_t vmslt_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool4_t vmslt_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool4_t vmslt_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx)))
vbool64_t vmslt_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmslt_vx_m)))
vbool64_t vmslt_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool8_t vmsleu_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool8_t vmsleu_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool4_t vmsleu_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool4_t vmsleu_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool2_t vmsleu_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool2_t vmsleu_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool1_t vmsleu_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool1_t vmsleu_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool16_t vmsleu_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool16_t vmsleu_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool32_t vmsleu_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool32_t vmsleu_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool64_t vmsleu_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool64_t vmsleu_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool16_t vmsleu_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool16_t vmsleu_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool8_t vmsleu_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool8_t vmsleu_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool4_t vmsleu_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool4_t vmsleu_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool2_t vmsleu_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool2_t vmsleu_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool32_t vmsleu_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool32_t vmsleu_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool64_t vmsleu_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool64_t vmsleu_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool32_t vmsleu_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool32_t vmsleu_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool16_t vmsleu_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool16_t vmsleu_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool8_t vmsleu_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool8_t vmsleu_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool4_t vmsleu_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool4_t vmsleu_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv)))
vbool64_t vmsleu_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vv_m)))
vbool64_t vmsleu_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool8_t vmsleu_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool8_t vmsleu_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool4_t vmsleu_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool4_t vmsleu_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool2_t vmsleu_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool2_t vmsleu_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool1_t vmsleu_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool1_t vmsleu_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool16_t vmsleu_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool16_t vmsleu_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool32_t vmsleu_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool32_t vmsleu_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool64_t vmsleu_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool64_t vmsleu_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool16_t vmsleu_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool16_t vmsleu_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool8_t vmsleu_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool8_t vmsleu_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool4_t vmsleu_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool4_t vmsleu_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool2_t vmsleu_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool2_t vmsleu_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool32_t vmsleu_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool32_t vmsleu_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool64_t vmsleu_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool64_t vmsleu_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool32_t vmsleu_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool32_t vmsleu_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool16_t vmsleu_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool16_t vmsleu_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool8_t vmsleu_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool8_t vmsleu_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool4_t vmsleu_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool4_t vmsleu_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx)))
vbool64_t vmsleu_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsleu_vx_m)))
vbool64_t vmsleu_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool8_t vmsle_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool8_t vmsle_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool4_t vmsle_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool4_t vmsle_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool2_t vmsle_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool2_t vmsle_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool1_t vmsle_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool1_t vmsle_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool16_t vmsle_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool16_t vmsle_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool32_t vmsle_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool32_t vmsle_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool64_t vmsle_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool64_t vmsle_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool16_t vmsle_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool16_t vmsle_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool8_t vmsle_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool8_t vmsle_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool4_t vmsle_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool4_t vmsle_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool2_t vmsle_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool2_t vmsle_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool32_t vmsle_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool32_t vmsle_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool64_t vmsle_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool64_t vmsle_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool32_t vmsle_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool32_t vmsle_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool16_t vmsle_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool16_t vmsle_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool8_t vmsle_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool8_t vmsle_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool4_t vmsle_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool4_t vmsle_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv)))
vbool64_t vmsle_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vv_m)))
vbool64_t vmsle_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool8_t vmsle_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool8_t vmsle_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool4_t vmsle_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool4_t vmsle_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool2_t vmsle_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool2_t vmsle_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool1_t vmsle_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool1_t vmsle_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool16_t vmsle_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool16_t vmsle_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool32_t vmsle_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool32_t vmsle_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool64_t vmsle_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool64_t vmsle_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool16_t vmsle_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool16_t vmsle_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool8_t vmsle_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool8_t vmsle_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool4_t vmsle_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool4_t vmsle_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool2_t vmsle_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool2_t vmsle_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool32_t vmsle_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool32_t vmsle_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool64_t vmsle_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool64_t vmsle_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool32_t vmsle_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool32_t vmsle_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool16_t vmsle_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool16_t vmsle_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool8_t vmsle_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool8_t vmsle_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool4_t vmsle_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool4_t vmsle_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx)))
vbool64_t vmsle_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsle_vx_m)))
vbool64_t vmsle_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool8_t vmsgtu_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool8_t vmsgtu_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool4_t vmsgtu_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool4_t vmsgtu_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool2_t vmsgtu_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool2_t vmsgtu_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool1_t vmsgtu_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool1_t vmsgtu_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool16_t vmsgtu_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool16_t vmsgtu_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool32_t vmsgtu_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool32_t vmsgtu_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool64_t vmsgtu_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool64_t vmsgtu_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool16_t vmsgtu_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool16_t vmsgtu_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool8_t vmsgtu_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool8_t vmsgtu_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool4_t vmsgtu_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool4_t vmsgtu_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool2_t vmsgtu_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool2_t vmsgtu_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool32_t vmsgtu_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool32_t vmsgtu_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool64_t vmsgtu_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool64_t vmsgtu_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool32_t vmsgtu_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool32_t vmsgtu_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool16_t vmsgtu_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool16_t vmsgtu_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool8_t vmsgtu_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool8_t vmsgtu_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool4_t vmsgtu_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool4_t vmsgtu_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv)))
vbool64_t vmsgtu_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vv_m)))
vbool64_t vmsgtu_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool8_t vmsgtu_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool8_t vmsgtu_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool4_t vmsgtu_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool4_t vmsgtu_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool2_t vmsgtu_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool2_t vmsgtu_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool1_t vmsgtu_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool1_t vmsgtu_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool16_t vmsgtu_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool16_t vmsgtu_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool32_t vmsgtu_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool32_t vmsgtu_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool64_t vmsgtu_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool64_t vmsgtu_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool16_t vmsgtu_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool16_t vmsgtu_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool8_t vmsgtu_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool8_t vmsgtu_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool4_t vmsgtu_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool4_t vmsgtu_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool2_t vmsgtu_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool2_t vmsgtu_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool32_t vmsgtu_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool32_t vmsgtu_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool64_t vmsgtu_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool64_t vmsgtu_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool32_t vmsgtu_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool32_t vmsgtu_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool16_t vmsgtu_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool16_t vmsgtu_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool8_t vmsgtu_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool8_t vmsgtu_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool4_t vmsgtu_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool4_t vmsgtu_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx)))
vbool64_t vmsgtu_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgtu_vx_m)))
vbool64_t vmsgtu_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool8_t vmsgt_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool8_t vmsgt_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool4_t vmsgt_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool4_t vmsgt_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool2_t vmsgt_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool2_t vmsgt_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool1_t vmsgt_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool1_t vmsgt_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool16_t vmsgt_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool16_t vmsgt_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool32_t vmsgt_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool32_t vmsgt_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool64_t vmsgt_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool64_t vmsgt_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool16_t vmsgt_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool16_t vmsgt_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool8_t vmsgt_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool8_t vmsgt_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool4_t vmsgt_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool4_t vmsgt_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool2_t vmsgt_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool2_t vmsgt_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool32_t vmsgt_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool32_t vmsgt_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool64_t vmsgt_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool64_t vmsgt_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool32_t vmsgt_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool32_t vmsgt_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool16_t vmsgt_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool16_t vmsgt_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool8_t vmsgt_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool8_t vmsgt_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool4_t vmsgt_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool4_t vmsgt_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv)))
vbool64_t vmsgt_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vv_m)))
vbool64_t vmsgt_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool8_t vmsgt_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool8_t vmsgt_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool4_t vmsgt_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool4_t vmsgt_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool2_t vmsgt_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool2_t vmsgt_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool1_t vmsgt_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool1_t vmsgt_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool16_t vmsgt_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool16_t vmsgt_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool32_t vmsgt_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool32_t vmsgt_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool64_t vmsgt_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool64_t vmsgt_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool16_t vmsgt_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool16_t vmsgt_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool8_t vmsgt_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool8_t vmsgt_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool4_t vmsgt_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool4_t vmsgt_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool2_t vmsgt_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool2_t vmsgt_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool32_t vmsgt_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool32_t vmsgt_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool64_t vmsgt_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool64_t vmsgt_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool32_t vmsgt_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool32_t vmsgt_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool16_t vmsgt_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool16_t vmsgt_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool8_t vmsgt_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool8_t vmsgt_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool4_t vmsgt_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool4_t vmsgt_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx)))
vbool64_t vmsgt_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgt_vx_m)))
vbool64_t vmsgt_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool8_t vmsgeu_vv_u8m1_b8(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool8_t vmsgeu_vv_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool4_t vmsgeu_vv_u8m2_b4(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool4_t vmsgeu_vv_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool2_t vmsgeu_vv_u8m4_b2(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool2_t vmsgeu_vv_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool1_t vmsgeu_vv_u8m8_b1(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool1_t vmsgeu_vv_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool16_t vmsgeu_vv_u8mf2_b16(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool16_t vmsgeu_vv_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool32_t vmsgeu_vv_u8mf4_b32(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool32_t vmsgeu_vv_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool64_t vmsgeu_vv_u8mf8_b64(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool64_t vmsgeu_vv_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool16_t vmsgeu_vv_u16m1_b16(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool16_t vmsgeu_vv_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool8_t vmsgeu_vv_u16m2_b8(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool8_t vmsgeu_vv_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool4_t vmsgeu_vv_u16m4_b4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool4_t vmsgeu_vv_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool2_t vmsgeu_vv_u16m8_b2(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool2_t vmsgeu_vv_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool32_t vmsgeu_vv_u16mf2_b32(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool32_t vmsgeu_vv_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool64_t vmsgeu_vv_u16mf4_b64(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool64_t vmsgeu_vv_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool32_t vmsgeu_vv_u32m1_b32(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool32_t vmsgeu_vv_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool16_t vmsgeu_vv_u32m2_b16(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool16_t vmsgeu_vv_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool8_t vmsgeu_vv_u32m4_b8(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool8_t vmsgeu_vv_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool4_t vmsgeu_vv_u32m8_b4(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool4_t vmsgeu_vv_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv)))
vbool64_t vmsgeu_vv_u32mf2_b64(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vv_m)))
vbool64_t vmsgeu_vv_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16mf4_t vwaddu_wv_u16mf4(vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16mf4_t vwaddu_wv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16mf2_t vwaddu_wv_u16mf2(vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16mf2_t vwaddu_wv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16m1_t vwaddu_wv_u16m1(vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16m1_t vwaddu_wv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16m2_t vwaddu_wv_u16m2(vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16m2_t vwaddu_wv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16m4_t vwaddu_wv_u16m4(vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16m4_t vwaddu_wv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint16m8_t vwaddu_wv_u16m8(vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint16m8_t vwaddu_wv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint32mf2_t vwaddu_wv_u32mf2(vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint32mf2_t vwaddu_wv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint32m1_t vwaddu_wv_u32m1(vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint32m1_t vwaddu_wv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint32m2_t vwaddu_wv_u32m2(vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint32m2_t vwaddu_wv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint32m4_t vwaddu_wv_u32m4(vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint32m4_t vwaddu_wv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv)))
vuint32m8_t vwaddu_wv_u32m8(vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vwaddu_wv_m)))
vuint32m8_t vwaddu_wv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8m1(int8_t *, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8m1_m(vbool8_t, int8_t *, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8m2(int8_t *, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8m2_m(vbool4_t, int8_t *, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8m4(int8_t *, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8m4_m(vbool2_t, int8_t *, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8m8(int8_t *, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8m8_m(vbool1_t, int8_t *, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8mf2(int8_t *, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8mf2_m(vbool16_t, int8_t *, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8mf4(int8_t *, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8mf4_m(vbool32_t, int8_t *, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v)))
void vse8_v_i8mf8(int8_t *, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vse8_v_m)))
void vse8_v_i8mf8_m(vbool64_t, int8_t *, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8m1(int8_t *, vuint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8m1_m(vbool8_t, int8_t *, vuint16m2_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8m2(int8_t *, vuint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8m2_m(vbool4_t, int8_t *, vuint16m4_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8m4(int8_t *, vuint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8m4_m(vbool2_t, int8_t *, vuint16m8_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8mf2(int8_t *, vuint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8mf2_m(vbool16_t, int8_t *, vuint16m1_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8mf4(int8_t *, vuint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8mf4_m(vbool32_t, int8_t *, vuint16mf2_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_i8mf8(int8_t *, vuint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_i8mf8_m(vbool64_t, int8_t *, vuint16mf4_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool8_t vmsgeu_vx_u8m1_b8(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool8_t vmsgeu_vx_u8m1_b8_m(vbool8_t, vbool8_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool4_t vmsgeu_vx_u8m2_b4(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool4_t vmsgeu_vx_u8m2_b4_m(vbool4_t, vbool4_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool2_t vmsgeu_vx_u8m4_b2(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool2_t vmsgeu_vx_u8m4_b2_m(vbool2_t, vbool2_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool1_t vmsgeu_vx_u8m8_b1(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool1_t vmsgeu_vx_u8m8_b1_m(vbool1_t, vbool1_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool16_t vmsgeu_vx_u8mf2_b16(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool16_t vmsgeu_vx_u8mf2_b16_m(vbool16_t, vbool16_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool32_t vmsgeu_vx_u8mf4_b32(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool32_t vmsgeu_vx_u8mf4_b32_m(vbool32_t, vbool32_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool64_t vmsgeu_vx_u8mf8_b64(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool64_t vmsgeu_vx_u8mf8_b64_m(vbool64_t, vbool64_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool16_t vmsgeu_vx_u16m1_b16(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool16_t vmsgeu_vx_u16m1_b16_m(vbool16_t, vbool16_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool8_t vmsgeu_vx_u16m2_b8(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool8_t vmsgeu_vx_u16m2_b8_m(vbool8_t, vbool8_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool4_t vmsgeu_vx_u16m4_b4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool4_t vmsgeu_vx_u16m4_b4_m(vbool4_t, vbool4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool2_t vmsgeu_vx_u16m8_b2(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool2_t vmsgeu_vx_u16m8_b2_m(vbool2_t, vbool2_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool32_t vmsgeu_vx_u16mf2_b32(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool32_t vmsgeu_vx_u16mf2_b32_m(vbool32_t, vbool32_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool64_t vmsgeu_vx_u16mf4_b64(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool64_t vmsgeu_vx_u16mf4_b64_m(vbool64_t, vbool64_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool32_t vmsgeu_vx_u32m1_b32(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool32_t vmsgeu_vx_u32m1_b32_m(vbool32_t, vbool32_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool16_t vmsgeu_vx_u32m2_b16(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool16_t vmsgeu_vx_u32m2_b16_m(vbool16_t, vbool16_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool8_t vmsgeu_vx_u32m4_b8(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool8_t vmsgeu_vx_u32m4_b8_m(vbool8_t, vbool8_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool4_t vmsgeu_vx_u32m8_b4(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool4_t vmsgeu_vx_u32m8_b4_m(vbool4_t, vbool4_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx)))
vbool64_t vmsgeu_vx_u32mf2_b64(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsgeu_vx_m)))
vbool64_t vmsgeu_vx_u32mf2_b64_m(vbool64_t, vbool64_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool8_t vmsge_vv_i8m1_b8(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool8_t vmsge_vv_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool4_t vmsge_vv_i8m2_b4(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool4_t vmsge_vv_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool2_t vmsge_vv_i8m4_b2(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool2_t vmsge_vv_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool1_t vmsge_vv_i8m8_b1(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool1_t vmsge_vv_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool16_t vmsge_vv_i8mf2_b16(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool16_t vmsge_vv_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool32_t vmsge_vv_i8mf4_b32(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool32_t vmsge_vv_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool64_t vmsge_vv_i8mf8_b64(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool64_t vmsge_vv_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool16_t vmsge_vv_i16m1_b16(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool16_t vmsge_vv_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool8_t vmsge_vv_i16m2_b8(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool8_t vmsge_vv_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool4_t vmsge_vv_i16m4_b4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool4_t vmsge_vv_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool2_t vmsge_vv_i16m8_b2(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool2_t vmsge_vv_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool32_t vmsge_vv_i16mf2_b32(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool32_t vmsge_vv_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool64_t vmsge_vv_i16mf4_b64(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool64_t vmsge_vv_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool32_t vmsge_vv_i32m1_b32(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool32_t vmsge_vv_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool16_t vmsge_vv_i32m2_b16(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool16_t vmsge_vv_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool8_t vmsge_vv_i32m4_b8(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool8_t vmsge_vv_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool4_t vmsge_vv_i32m8_b4(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool4_t vmsge_vv_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv)))
vbool64_t vmsge_vv_i32mf2_b64(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vv_m)))
vbool64_t vmsge_vv_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool8_t vmsge_vx_i8m1_b8(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool8_t vmsge_vx_i8m1_b8_m(vbool8_t, vbool8_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool4_t vmsge_vx_i8m2_b4(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool4_t vmsge_vx_i8m2_b4_m(vbool4_t, vbool4_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool2_t vmsge_vx_i8m4_b2(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool2_t vmsge_vx_i8m4_b2_m(vbool2_t, vbool2_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool1_t vmsge_vx_i8m8_b1(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool1_t vmsge_vx_i8m8_b1_m(vbool1_t, vbool1_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool16_t vmsge_vx_i8mf2_b16(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool16_t vmsge_vx_i8mf2_b16_m(vbool16_t, vbool16_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool32_t vmsge_vx_i8mf4_b32(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool32_t vmsge_vx_i8mf4_b32_m(vbool32_t, vbool32_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool64_t vmsge_vx_i8mf8_b64(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool64_t vmsge_vx_i8mf8_b64_m(vbool64_t, vbool64_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool16_t vmsge_vx_i16m1_b16(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool16_t vmsge_vx_i16m1_b16_m(vbool16_t, vbool16_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool8_t vmsge_vx_i16m2_b8(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool8_t vmsge_vx_i16m2_b8_m(vbool8_t, vbool8_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool4_t vmsge_vx_i16m4_b4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool4_t vmsge_vx_i16m4_b4_m(vbool4_t, vbool4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool2_t vmsge_vx_i16m8_b2(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool2_t vmsge_vx_i16m8_b2_m(vbool2_t, vbool2_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool32_t vmsge_vx_i16mf2_b32(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool32_t vmsge_vx_i16mf2_b32_m(vbool32_t, vbool32_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool64_t vmsge_vx_i16mf4_b64(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool64_t vmsge_vx_i16mf4_b64_m(vbool64_t, vbool64_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool32_t vmsge_vx_i32m1_b32(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool32_t vmsge_vx_i32m1_b32_m(vbool32_t, vbool32_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool16_t vmsge_vx_i32m2_b16(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool16_t vmsge_vx_i32m2_b16_m(vbool16_t, vbool16_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool8_t vmsge_vx_i32m4_b8(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool8_t vmsge_vx_i32m4_b8_m(vbool8_t, vbool8_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool4_t vmsge_vx_i32m8_b4(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool4_t vmsge_vx_i32m8_b4_m(vbool4_t, vbool4_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx)))
vbool64_t vmsge_vx_i32mf2_b64(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmsge_vx_m)))
vbool64_t vmsge_vx_i32mf2_b64_m(vbool64_t, vbool64_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8m1_t vminu_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8m1_t vminu_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8m2_t vminu_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8m2_t vminu_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8m4_t vminu_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8m4_t vminu_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8m8_t vminu_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8m8_t vminu_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8mf2_t vminu_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8mf2_t vminu_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8mf4_t vminu_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8mf4_t vminu_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint8mf8_t vminu_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint8mf8_t vminu_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16m1_t vminu_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16m1_t vminu_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16m2_t vminu_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16m2_t vminu_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16m4_t vminu_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16m4_t vminu_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16m8_t vminu_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16m8_t vminu_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16mf2_t vminu_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16mf2_t vminu_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint16mf4_t vminu_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint16mf4_t vminu_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint32m1_t vminu_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint32m1_t vminu_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint32m2_t vminu_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint32m2_t vminu_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint32m4_t vminu_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint32m4_t vminu_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint32m8_t vminu_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint32m8_t vminu_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv)))
vuint32mf2_t vminu_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vv_m)))
vuint32mf2_t vminu_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8m1_t vminu_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8m1_t vminu_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8m2_t vminu_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8m2_t vminu_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8m4_t vminu_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8m4_t vminu_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8m8_t vminu_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8m8_t vminu_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8mf2_t vminu_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8mf2_t vminu_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8mf4_t vminu_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8mf4_t vminu_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint8mf8_t vminu_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint8mf8_t vminu_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16m1_t vminu_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16m1_t vminu_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16m2_t vminu_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16m2_t vminu_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16m4_t vminu_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16m4_t vminu_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16m8_t vminu_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16m8_t vminu_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16mf2_t vminu_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16mf2_t vminu_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint16mf4_t vminu_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint16mf4_t vminu_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint32m1_t vminu_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint32m1_t vminu_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint32m2_t vminu_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint32m2_t vminu_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint32m4_t vminu_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint32m4_t vminu_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint32m8_t vminu_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint32m8_t vminu_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx)))
vuint32mf2_t vminu_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vminu_vx_m)))
vuint32mf2_t vminu_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8m1_t vmin_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8m1_t vmin_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8m2_t vmin_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8m2_t vmin_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8m4_t vmin_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8m4_t vmin_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8m8_t vmin_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8m8_t vmin_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8mf2_t vmin_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8mf2_t vmin_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8mf4_t vmin_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8mf4_t vmin_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint8mf8_t vmin_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint8mf8_t vmin_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16m1_t vmin_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16m1_t vmin_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16m2_t vmin_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16m2_t vmin_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16m4_t vmin_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16m4_t vmin_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16m8_t vmin_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16m8_t vmin_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16mf2_t vmin_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16mf2_t vmin_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint16mf4_t vmin_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint16mf4_t vmin_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint32m1_t vmin_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint32m1_t vmin_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint32m2_t vmin_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint32m2_t vmin_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint32m4_t vmin_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint32m4_t vmin_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint32m8_t vmin_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint32m8_t vmin_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv)))
vint32mf2_t vmin_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vv_m)))
vint32mf2_t vmin_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8m1_t vmin_vx_i8m1(vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8m1_t vmin_vx_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8m2_t vmin_vx_i8m2(vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8m2_t vmin_vx_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8m4_t vmin_vx_i8m4(vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8m4_t vmin_vx_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8m8_t vmin_vx_i8m8(vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8m8_t vmin_vx_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8mf2_t vmin_vx_i8mf2(vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8mf2_t vmin_vx_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8mf4_t vmin_vx_i8mf4(vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8mf4_t vmin_vx_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint8mf8_t vmin_vx_i8mf8(vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint8mf8_t vmin_vx_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, int8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16m1_t vmin_vx_i16m1(vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16m1_t vmin_vx_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16m2_t vmin_vx_i16m2(vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16m2_t vmin_vx_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16m4_t vmin_vx_i16m4(vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16m4_t vmin_vx_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16m8_t vmin_vx_i16m8(vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16m8_t vmin_vx_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16mf2_t vmin_vx_i16mf2(vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16mf2_t vmin_vx_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint16mf4_t vmin_vx_i16mf4(vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint16mf4_t vmin_vx_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, int16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint32m1_t vmin_vx_i32m1(vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint32m1_t vmin_vx_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint32m2_t vmin_vx_i32m2(vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint32m2_t vmin_vx_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint32m4_t vmin_vx_i32m4(vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint32m4_t vmin_vx_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint32m8_t vmin_vx_i32m8(vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint32m8_t vmin_vx_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx)))
vint32mf2_t vmin_vx_i32mf2(vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmin_vx_m)))
vint32mf2_t vmin_vx_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, int32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8m1_t vmaxu_vv_u8m1(vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8m1_t vmaxu_vv_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8m2_t vmaxu_vv_u8m2(vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8m2_t vmaxu_vv_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8m4_t vmaxu_vv_u8m4(vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8m4_t vmaxu_vv_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, vuint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8m8_t vmaxu_vv_u8m8(vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8m8_t vmaxu_vv_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, vuint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8mf2_t vmaxu_vv_u8mf2(vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8mf2_t vmaxu_vv_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, vuint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8mf4_t vmaxu_vv_u8mf4(vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8mf4_t vmaxu_vv_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, vuint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint8mf8_t vmaxu_vv_u8mf8(vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint8mf8_t vmaxu_vv_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, vuint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16m1_t vmaxu_vv_u16m1(vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16m1_t vmaxu_vv_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, vuint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16m2_t vmaxu_vv_u16m2(vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16m2_t vmaxu_vv_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, vuint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16m4_t vmaxu_vv_u16m4(vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16m4_t vmaxu_vv_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, vuint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16m8_t vmaxu_vv_u16m8(vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16m8_t vmaxu_vv_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, vuint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16mf2_t vmaxu_vv_u16mf2(vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16mf2_t vmaxu_vv_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, vuint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint16mf4_t vmaxu_vv_u16mf4(vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint16mf4_t vmaxu_vv_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, vuint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint32m1_t vmaxu_vv_u32m1(vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint32m1_t vmaxu_vv_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, vuint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint32m2_t vmaxu_vv_u32m2(vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint32m2_t vmaxu_vv_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, vuint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint32m4_t vmaxu_vv_u32m4(vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint32m4_t vmaxu_vv_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, vuint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint32m8_t vmaxu_vv_u32m8(vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint32m8_t vmaxu_vv_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, vuint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv)))
vuint32mf2_t vmaxu_vv_u32mf2(vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vv_m)))
vuint32mf2_t vmaxu_vv_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, vuint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8m1_t vmaxu_vx_u8m1(vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8m1_t vmaxu_vx_u8m1_m(vbool8_t, vuint8m1_t, vuint8m1_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8m2_t vmaxu_vx_u8m2(vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8m2_t vmaxu_vx_u8m2_m(vbool4_t, vuint8m2_t, vuint8m2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8m4_t vmaxu_vx_u8m4(vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8m4_t vmaxu_vx_u8m4_m(vbool2_t, vuint8m4_t, vuint8m4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8m8_t vmaxu_vx_u8m8(vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8m8_t vmaxu_vx_u8m8_m(vbool1_t, vuint8m8_t, vuint8m8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8mf2_t vmaxu_vx_u8mf2(vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8mf2_t vmaxu_vx_u8mf2_m(vbool16_t, vuint8mf2_t, vuint8mf2_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8mf4_t vmaxu_vx_u8mf4(vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8mf4_t vmaxu_vx_u8mf4_m(vbool32_t, vuint8mf4_t, vuint8mf4_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint8mf8_t vmaxu_vx_u8mf8(vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint8mf8_t vmaxu_vx_u8mf8_m(vbool64_t, vuint8mf8_t, vuint8mf8_t, uint8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16m1_t vmaxu_vx_u16m1(vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16m1_t vmaxu_vx_u16m1_m(vbool16_t, vuint16m1_t, vuint16m1_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16m2_t vmaxu_vx_u16m2(vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16m2_t vmaxu_vx_u16m2_m(vbool8_t, vuint16m2_t, vuint16m2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16m4_t vmaxu_vx_u16m4(vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16m4_t vmaxu_vx_u16m4_m(vbool4_t, vuint16m4_t, vuint16m4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16m8_t vmaxu_vx_u16m8(vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16m8_t vmaxu_vx_u16m8_m(vbool2_t, vuint16m8_t, vuint16m8_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16mf2_t vmaxu_vx_u16mf2(vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16mf2_t vmaxu_vx_u16mf2_m(vbool32_t, vuint16mf2_t, vuint16mf2_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint16mf4_t vmaxu_vx_u16mf4(vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint16mf4_t vmaxu_vx_u16mf4_m(vbool64_t, vuint16mf4_t, vuint16mf4_t, uint16_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint32m1_t vmaxu_vx_u32m1(vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint32m1_t vmaxu_vx_u32m1_m(vbool32_t, vuint32m1_t, vuint32m1_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint32m2_t vmaxu_vx_u32m2(vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint32m2_t vmaxu_vx_u32m2_m(vbool16_t, vuint32m2_t, vuint32m2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint32m4_t vmaxu_vx_u32m4(vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint32m4_t vmaxu_vx_u32m4_m(vbool8_t, vuint32m4_t, vuint32m4_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint32m8_t vmaxu_vx_u32m8(vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint32m8_t vmaxu_vx_u32m8_m(vbool4_t, vuint32m8_t, vuint32m8_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx)))
vuint32mf2_t vmaxu_vx_u32mf2(vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmaxu_vx_m)))
vuint32mf2_t vmaxu_vx_u32mf2_m(vbool64_t, vuint32mf2_t, vuint32mf2_t, uint32_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8m1_t vmax_vv_i8m1(vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8m1_t vmax_vv_i8m1_m(vbool8_t, vint8m1_t, vint8m1_t, vint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8m2_t vmax_vv_i8m2(vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8m2_t vmax_vv_i8m2_m(vbool4_t, vint8m2_t, vint8m2_t, vint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8m4_t vmax_vv_i8m4(vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8m4_t vmax_vv_i8m4_m(vbool2_t, vint8m4_t, vint8m4_t, vint8m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8m8_t vmax_vv_i8m8(vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8m8_t vmax_vv_i8m8_m(vbool1_t, vint8m8_t, vint8m8_t, vint8m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8mf2_t vmax_vv_i8mf2(vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8mf2_t vmax_vv_i8mf2_m(vbool16_t, vint8mf2_t, vint8mf2_t, vint8mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8mf4_t vmax_vv_i8mf4(vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8mf4_t vmax_vv_i8mf4_m(vbool32_t, vint8mf4_t, vint8mf4_t, vint8mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint8mf8_t vmax_vv_i8mf8(vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint8mf8_t vmax_vv_i8mf8_m(vbool64_t, vint8mf8_t, vint8mf8_t, vint8mf8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16m1_t vmax_vv_i16m1(vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16m1_t vmax_vv_i16m1_m(vbool16_t, vint16m1_t, vint16m1_t, vint16m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16m2_t vmax_vv_i16m2(vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16m2_t vmax_vv_i16m2_m(vbool8_t, vint16m2_t, vint16m2_t, vint16m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16m4_t vmax_vv_i16m4(vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16m4_t vmax_vv_i16m4_m(vbool4_t, vint16m4_t, vint16m4_t, vint16m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16m8_t vmax_vv_i16m8(vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16m8_t vmax_vv_i16m8_m(vbool2_t, vint16m8_t, vint16m8_t, vint16m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16mf2_t vmax_vv_i16mf2(vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16mf2_t vmax_vv_i16mf2_m(vbool32_t, vint16mf2_t, vint16mf2_t, vint16mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint16mf4_t vmax_vv_i16mf4(vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint16mf4_t vmax_vv_i16mf4_m(vbool64_t, vint16mf4_t, vint16mf4_t, vint16mf4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint32m1_t vmax_vv_i32m1(vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint32m1_t vmax_vv_i32m1_m(vbool32_t, vint32m1_t, vint32m1_t, vint32m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint32m2_t vmax_vv_i32m2(vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint32m2_t vmax_vv_i32m2_m(vbool16_t, vint32m2_t, vint32m2_t, vint32m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint32m4_t vmax_vv_i32m4(vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint32m4_t vmax_vv_i32m4_m(vbool8_t, vint32m4_t, vint32m4_t, vint32m4_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint32m8_t vmax_vv_i32m8(vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint32m8_t vmax_vv_i32m8_m(vbool4_t, vint32m8_t, vint32m8_t, vint32m8_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv)))
vint32mf2_t vmax_vv_i32mf2(vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vmax_vv_m)))
vint32mf2_t vmax_vv_i32mf2_m(vbool64_t, vint32mf2_t, vint32mf2_t, vint32mf2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_u8m1(uint8_t *, vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_u8m1_m(vbool8_t, uint8_t *, vuint16m2_t, vuint8m1_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_u8m2(uint8_t *, vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v_m)))
void vsuxei16_v_u8m2_m(vbool4_t, uint8_t *, vuint16m4_t, vuint8m2_t, size_t);
__rvv_ai __attribute__((__clang_builtin_alias__(__builtin_rvv_vsuxei16_v)))
void vsuxei16_v_u8m4(uint8_t *, vuint16m8_t,