/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoaderDecorator;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class ModuleLayerFromSingleClassLoaderDecorator
implements ClassLoaderDecorator {
    private static final ModuleFinder MODULE_FINDER;
    private static final ModuleDescriptor MODULE_DESCRIPTOR;
    private static final ModuleLayer MODULE_LAYER;
    private static final ModuleLayerController MODULE_LAYER_CONTROLLER;
    private static final Configuration CONFIGURATION;
    private static final Optional OPTIONAL;
    private static final Stream STREAM;
    private static final Path PATH;
    private static final SimpleModuleReference SIMPLE_MODULE_REFERENCE;
    private static final SimpleModuleFinder SIMPLE_MODULE_FINDER;
    @MaybeNull
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
    private final ClassLoader classLoader;
    private final Object moduleLayer;
    private final String name;
    private final Set<String> packages;
    private static final boolean ACCESS_CONTROLLER;

    protected ModuleLayerFromSingleClassLoaderDecorator(@MaybeNull ClassLoader classLoader, Object moduleLayer, String name, Set<String> packages) {
        this.classLoader = classLoader;
        this.moduleLayer = moduleLayer;
        this.name = name;
        this.packages = packages;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    @Override
    public boolean isSkipped(TypeDescription typeDescription) {
        return typeDescription.isModuleType();
    }

    @Override
    @MaybeNull
    public ClassLoader apply(TypeDescription typeDescription) {
        PackageDescription packageDescription = typeDescription.getPackage();
        return packageDescription == null || !this.packages.contains(packageDescription.getName()) ? this.classLoader : MODULE_LAYER.findLoader(this.moduleLayer, this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        MODULE_FINDER = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(ModuleFinder.class));
        MODULE_DESCRIPTOR = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(ModuleDescriptor.class));
        MODULE_LAYER = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(ModuleLayer.class));
        MODULE_LAYER_CONTROLLER = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(ModuleLayerController.class));
        CONFIGURATION = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(Configuration.class));
        OPTIONAL = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(Optional.class));
        STREAM = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(Stream.class));
        PATH = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(Path.class));
        SIMPLE_MODULE_REFERENCE = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(SimpleModuleReference.class, ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(SimpleModuleReference.CreationAction.INSTANCE)));
        SIMPLE_MODULE_FINDER = ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(JavaDispatcher.of(SimpleModuleFinder.class, ModuleLayerFromSingleClassLoaderDecorator.doPrivileged(SimpleModuleFinder.CreationAction.INSTANCE)));
    }

    public boolean equals(@MaybeNull Object object) {
        block12: {
            block11: {
                ClassLoader classLoader;
                block10: {
                    ClassLoader classLoader2;
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.name.equals(((ModuleLayerFromSingleClassLoaderDecorator)object).name)) {
                        return false;
                    }
                    ClassLoader classLoader3 = ((ModuleLayerFromSingleClassLoaderDecorator)object).classLoader;
                    classLoader = classLoader2 = this.classLoader;
                    if (classLoader3 == null) break block10;
                    if (classLoader == null) break block11;
                    if (!classLoader2.equals(classLoader3)) {
                        return false;
                    }
                    break block12;
                }
                if (classLoader == null) break block12;
            }
            return false;
        }
        if (!this.moduleLayer.equals(((ModuleLayerFromSingleClassLoaderDecorator)object).moduleLayer)) {
            return false;
        }
        return ((Object)this.packages).equals(((ModuleLayerFromSingleClassLoaderDecorator)object).packages);
    }

    public int hashCode() {
        int n = this.getClass().hashCode() * 31;
        ClassLoader classLoader = this.classLoader;
        if (classLoader != null) {
            n = n + classLoader.hashCode();
        }
        return ((n * 31 + this.moduleLayer.hashCode()) * 31 + this.name.hashCode()) * 31 + ((Object)this.packages).hashCode();
    }

    public static abstract class AbstractModuleFinder {
        private final String name;
        private final Object moduleReference;

        protected AbstractModuleFinder(String name, Object moduleReference) {
            this.name = name;
            this.moduleReference = moduleReference;
        }

        @MaybeNull
        protected Object doFind(String name) {
            return name.equals(this.name) ? OPTIONAL.of(this.moduleReference) : OPTIONAL.empty();
        }

        protected Set<?> doFindAll() {
            return Collections.singleton(this.moduleReference);
        }
    }

    public static abstract class AbstractModuleReader
    implements Closeable {
        private final Map<String, byte[]> types;

        protected AbstractModuleReader(Map<String, byte[]> types) {
            this.types = types;
        }

        protected Object doFind(String name) {
            String value;
            byte[] binaryRepresentation;
            if (name.endsWith(".class") && (binaryRepresentation = this.types.get(value = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
                return OPTIONAL.of(URI.create("bytebuddy://" + name));
            }
            return OPTIONAL.empty();
        }

        protected Object doList() {
            return STREAM.empty();
        }

        protected Object doOpen(String name) {
            String value;
            byte[] binaryRepresentation;
            if (name.endsWith(".class") && (binaryRepresentation = this.types.get(value = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
                return OPTIONAL.of(new ByteArrayInputStream(binaryRepresentation));
            }
            return OPTIONAL.empty();
        }

        @Override
        public void close() {
        }
    }

    @JavaDispatcher.Proxied(value="java.util.stream.Stream")
    protected static interface Stream {
        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="empty")
        public Object empty();
    }

    @JavaDispatcher.Proxied(value="java.util.Optional")
    protected static interface Optional {
        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="of")
        public Object of(Object var1);

        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="empty")
        public Object empty();
    }

    @JavaDispatcher.Proxied(value="net.bytebuddy.dynamic.loading.SimpleModuleFinder")
    protected static interface SimpleModuleFinder {
        @JavaDispatcher.IsConstructor
        @JavaDispatcher.Proxied(value="newInstance")
        public Object newInstance(String var1, Object var2);

        public static enum CreationAction implements PrivilegedAction<ClassLoader>
        {
            INSTANCE;


            @Override
            @MaybeNull
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but return null.")
            public ClassLoader run() {
                try {
                    return new ByteBuddy().subclass(AbstractModuleFinder.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement(Class.forName("java.lang.module.ModuleFinder")).name("net.bytebuddy.dynamic.loading.SimpleModuleFinder").method(ElementMatchers.named("find").and(ElementMatchers.takesArguments(String.class))).intercept(MethodCall.invoke(AbstractModuleFinder.class.getDeclaredMethod("doFind", String.class)).withAllArguments().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).method(ElementMatchers.named("findAll").and(ElementMatchers.takesArguments(0))).intercept(MethodCall.invoke(AbstractModuleFinder.class.getDeclaredMethod("doFindAll", new Class[0])).withAllArguments().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make().load(ModuleLayerFromSingleClassLoaderDecorator.class.getClassLoader()).getLoaded().getClassLoader();
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        }
    }

    @JavaDispatcher.Proxied(value="net.bytebuddy.dynamic.loading.SimpleModuleReference")
    protected static interface SimpleModuleReference {
        @JavaDispatcher.IsConstructor
        @JavaDispatcher.Proxied(value="newInstance")
        public Object newInstance(@JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor") Object var1, @MaybeNull URI var2, Map<String, byte[]> var3);

        public static enum CreationAction implements PrivilegedAction<ClassLoader>
        {
            INSTANCE;


            @Override
            @MaybeNull
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but return null.")
            public ClassLoader run() {
                try {
                    ByteBuddy byteBuddy = new ByteBuddy();
                    DynamicType.Unloaded simpleModuleReader = byteBuddy.subclass(AbstractModuleReader.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement(Class.forName("java.lang.module.ModuleReader")).name("net.bytebuddy.dynamic.loading.SimpleModuleReader").method(ElementMatchers.named("open").and(ElementMatchers.takesArguments(String.class))).intercept(MethodCall.invoke(AbstractModuleReader.class.getDeclaredMethod("doOpen", String.class)).withAllArguments().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).method(ElementMatchers.named("list").and(ElementMatchers.takesArguments(0))).intercept(MethodCall.invoke(AbstractModuleReader.class.getDeclaredMethod("doList", new Class[0])).withAllArguments().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).method(ElementMatchers.named("find").and(ElementMatchers.takesArguments(String.class))).intercept(MethodCall.invoke(AbstractModuleReader.class.getDeclaredMethod("doFind", String.class)).withAllArguments().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make();
                    Class<?> moduleDescriptor = Class.forName("java.lang.module.ModuleDescriptor");
                    Class<?> moduleReference = Class.forName("java.lang.module.ModuleReference");
                    DynamicType.Unloaded simpleModuleReference = byteBuddy.subclass(moduleReference, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name("net.bytebuddy.dynamic.loading.SimpleModuleReference").defineField("types", (Type)((Object)Map.class), Visibility.PRIVATE, FieldManifestation.FINAL).defineConstructor(Visibility.PUBLIC).withParameters(new Type[]{moduleDescriptor, URI.class, Map.class}).intercept(MethodCall.invoke(moduleReference.getDeclaredConstructor(moduleDescriptor, URI.class)).onSuper().withArgument(0, 1).andThen(FieldAccessor.ofField("types").setsArgumentAt(2))).method(ElementMatchers.named("open")).intercept(MethodCall.construct((MethodDescription)((MethodList)simpleModuleReader.getTypeDescription().getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly()).withField("types").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).make();
                    return simpleModuleReference.include(simpleModuleReader).load(ModuleLayerFromSingleClassLoaderDecorator.class.getClassLoader()).getLoaded().getClassLoader();
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        }
    }

    @JavaDispatcher.Proxied(value="java.nio.file.Path")
    protected static interface Path {
        @JavaDispatcher.Container
        @JavaDispatcher.Proxied(value="of")
        public Object[] of(int var1);
    }

    @JavaDispatcher.Proxied(value="java.lang.module.ModuleFinder")
    protected static interface ModuleFinder {
        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="of")
        public Object of(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object[] var1);
    }

    @JavaDispatcher.Proxied(value="java.lang.module.Configuration")
    protected static interface Configuration {
        @JavaDispatcher.Proxied(value="resolve")
        public Object resolve(Object var1, @JavaDispatcher.Proxied(value="java.lang.module.ModuleFinder") Object var2, @JavaDispatcher.Proxied(value="java.lang.module.ModuleFinder") Object var3, Collection<String> var4);
    }

    @JavaDispatcher.Proxied(value="java.lang.ModuleLayer$Controller")
    protected static interface ModuleLayerController {
        @JavaDispatcher.Proxied(value="layer")
        public Object layer(Object var1);
    }

    @JavaDispatcher.Proxied(value="java.lang.ModuleLayer")
    protected static interface ModuleLayer {
        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="boot")
        public Object boot();

        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="defineModulesWithOneLoader")
        public Object defineModulesWithOneLoader(@JavaDispatcher.Proxied(value="java.lang.module.Configuration") Object var1, List<?> var2, @MaybeNull ClassLoader var3);

        @JavaDispatcher.Proxied(value="configuration")
        public Object configuration(Object var1);

        @MaybeNull
        @JavaDispatcher.Proxied(value="findLoader")
        public ClassLoader findLoader(Object var1, String var2);
    }

    @JavaDispatcher.Proxied(value="java.lang.module.ModuleDescriptor")
    protected static interface ModuleDescriptor {
        @JavaDispatcher.IsStatic
        @JavaDispatcher.Proxied(value="read")
        public Object read(InputStream var1) throws IOException;

        @JavaDispatcher.Proxied(value="name")
        public String name(Object var1);

        @JavaDispatcher.Proxied(value="packages")
        public Set<String> packages(Object var1);
    }

    public static enum Factory implements ClassLoaderDecorator.Factory
    {
        INSTANCE;


        @Override
        public ClassLoaderDecorator make(@MaybeNull ClassLoader classLoader, Map<String, byte[]> typeDefinitions) {
            Object moduleDescriptor;
            if (!typeDefinitions.containsKey("module-info")) {
                return new ClassLoaderDecorator.NoOp(classLoader);
            }
            try {
                moduleDescriptor = MODULE_DESCRIPTOR.read(new ByteArrayInputStream(typeDefinitions.get("module-info")));
            }
            catch (IOException exception) {
                throw new IllegalStateException("Failed to create module layer", exception);
            }
            return new ModuleLayerFromSingleClassLoaderDecorator(classLoader, MODULE_LAYER_CONTROLLER.layer(MODULE_LAYER.defineModulesWithOneLoader(CONFIGURATION.resolve(MODULE_LAYER.configuration(MODULE_LAYER.boot()), SIMPLE_MODULE_FINDER.newInstance(MODULE_DESCRIPTOR.name(moduleDescriptor), SIMPLE_MODULE_REFERENCE.newInstance(moduleDescriptor, null, typeDefinitions)), MODULE_FINDER.of(PATH.of(0)), Collections.singleton(MODULE_DESCRIPTOR.name(moduleDescriptor))), Collections.singletonList(MODULE_LAYER.boot()), classLoader)), MODULE_DESCRIPTOR.name(moduleDescriptor), MODULE_DESCRIPTOR.packages(moduleDescriptor));
        }
    }
}

