/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.log;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.log.Log;
import org.basex.util.log.LogEntry;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum LogTarget {
    STDOUT{

        @Override
        void write(Log log, LogEntry entry) {
            Util.println(entry, new Object[0]);
        }
    }
    ,
    STDERR{

        @Override
        void write(Log log, LogEntry entry) {
            Util.errln(entry, new Object[0]);
        }
    }
    ,
    DATA{

        @Override
        void write(Log log, LogEntry entry) throws IOException {
            log.write(entry);
        }
    }
    ,
    SLF4J{

        @Override
        void write(Log log, LogEntry entry) {
            if (slf4j != null) {
                slf4j.accept(entry.type, entry.toString());
            }
        }
    };

    private static BiConsumer<String, String> slf4j;

    abstract void write(Log var1, LogEntry var2) throws IOException;

    static {
        Class<?> cLoggerFactory = Reflect.find("org.slf4j.LoggerFactory");
        Class<?> cLogger = Reflect.find("org.slf4j.Logger");
        Method mLogger = Reflect.method(cLoggerFactory, "getLogger", String.class);
        Object logger = Reflect.invoke(mLogger, null, "BaseX");
        slf4j = (type, text) -> {
            String level = Strings.eqic(type, "trace", "debug", "warn", "error") ? type.toLowerCase(Locale.ENGLISH) : "info";
            Method method = Reflect.method(cLogger, level, String.class);
            if (method != null) {
                Reflect.invoke(method, logger, text);
            } else {
                Util.errln("SLF4J logger not available.", new Object[0]);
                slf4j = null;
            }
        };
    }
}

