/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.users.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.name.BackupAlter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class DbAlterBackup
extends DbAccessFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String newname;
        String name = this.toName(this.arg(0), qc);
        if (name.equals(newname = this.toName(this.arg(1), qc))) {
            throw QueryError.DB_CONFLICT4_X.get(this.info, name, newname);
        }
        this.checkPerm(qc, Perm.CREATE, name);
        StringList backups = qc.context.databases.backups(name);
        if (backups.isEmpty()) {
            throw QueryError.DB_NOBACKUP_X.get(this.info, name);
        }
        Updates updates = qc.updates();
        for (String backup : backups) {
            updates.add(new BackupAlter(backup, newname, qc, this.info), qc);
        }
        return Empty.VALUE;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.dataLock(this.arg(0), true, visitor) && this.dataLock(this.arg(1), true, visitor) && DbAlterBackup.visitAll(visitor, this.exprs);
    }
}

