/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.LinkedList;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;

public final class FLWORBuilder {
    final CompileContext cc;
    final InputInfo info;
    final int arity;
    public final Var item;
    public final Var pos;

    public FLWORBuilder(int arity, CompileContext cc, InputInfo info) {
        this.arity = arity;
        this.cc = cc;
        this.info = info;
        this.item = cc.vs().addNew(new QNm("item"), Types.ITEM_ZM, cc.qc, info);
        this.pos = cc.vs().addNew(new QNm("pos"), Types.INTEGER_O, cc.qc, info);
    }

    public Expr ref(Var var) {
        return new VarRef(this.info, var).optimize(this.cc);
    }

    public Expr[] refs() {
        ExprList args = new ExprList(this.arity);
        if (this.arity > 0) {
            args.add(this.ref(this.item));
        }
        if (this.arity > 1) {
            args.add(this.ref(this.pos));
        }
        return (Expr[])args.finish();
    }

    public Expr function(StandardFunc sf, int i, boolean updating) throws QueryException {
        Expr func = sf.coerceFunc(i, this.cc, Math.min(2, this.arity));
        return new DynFuncCall(this.info, updating, false, func, this.refs()).optimize(this.cc);
    }

    public Expr finish(Expr input, Expr where, Expr rtrn) throws QueryException {
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        clauses.add(new For(this.item, this.pos, null, input, false).optimize(this.cc));
        if (where != null) {
            clauses.add(new Where(where, this.info).optimize(this.cc));
        }
        return new GFLWOR(this.info, clauses, rtrn).optimize(this.cc);
    }
}

