/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.util.hash.IntSet;

public final class IntMap
extends IntSet {
    private int[] values = new int[this.capacity()];

    public IntMap() {
        this(2L);
    }

    public IntMap(long capacity) {
        super(capacity);
        this.values[0] = Integer.MIN_VALUE;
    }

    public int put(int key, int value) {
        int i = this.put(key);
        int v = this.values[i];
        this.values[i] = value;
        return v;
    }

    public int get(int key) {
        return this.values[this.index(key)];
    }

    public int value(int index) {
        return this.values[index];
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public String toString() {
        ArrayList<Integer> k = new ArrayList<Integer>();
        ArrayList<Integer> v = new ArrayList<Integer>();
        for (int key : this.keys) {
            k.add(key);
        }
        for (int value : this.values) {
            v.add(value);
        }
        return this.toString(k.toArray(), v.toArray());
    }
}

