/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.HofArgs;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;

public final class FnSubsequenceWhere
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter input = this.arg(0).iter(qc);
        final FItem from = this.toFunctionOrNull(this.arg(1), 2, qc);
        final FItem to = this.toFunctionOrNull(this.arg(2), 2, qc);
        return new Iter(){
            final HofArgs args;
            boolean more;
            boolean found;
            {
                this.args = new HofArgs(2, from, to);
                this.more = true;
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.more && (item = qc.next(input)) != null) {
                    this.args.set(0, item).inc();
                    if (!this.found && (from == null || FnSubsequenceWhere.this.test(from, this.args, qc))) {
                        this.found = true;
                    }
                    if (!this.found) continue;
                    if (to != null && FnSubsequenceWhere.this.test(to, this.args, qc)) {
                        this.more = false;
                    }
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        boolean from = this.defined(1);
        boolean to = this.defined(2);
        SeqType ist = input.seqType();
        if (!from && !to || ist.zero()) {
            return input;
        }
        SeqType[] types = new SeqType[]{ist.with(Occ.EXACTLY_ONE), Types.INTEGER_O};
        if (from) {
            this.arg(1, arg -> FnSubsequenceWhere.refineFunc(arg, cc, types));
        }
        if (to) {
            this.arg(2, arg -> FnSubsequenceWhere.refineFunc(arg, cc, types));
        }
        this.exprType.assign(ist);
        return this;
    }

    @Override
    public int hofIndex() {
        boolean from = this.defined(1);
        boolean to = this.defined(2);
        return from && to ? Integer.MAX_VALUE : (from ? 1 : (to ? 2 : -1));
    }
}

