/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.ApktoolProperties;
import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.InFileNotFoundException;
import brut.androlib.exceptions.OutDirExistsException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.res.ResourcesDecoder;
import brut.androlib.src.SmaliDecoder;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.BackgroundWorker;
import brut.util.OS;
import com.android.tools.smali.dexlib2.iface.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ApkDecoder {
    private static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    private static final Pattern NO_COMPRESS_EXT_PATTERN = Pattern.compile("dex|arsc|so|jpg|jpeg|png|gif|wav|mp2|mp3|ogg|aac|mpg|mpeg|mid|midi|smf|jet|rtttl|imy|xmf|mp4|m4a|m4v|3gp|3gpp|3g2|3gpp2|amr|awb|wma|wmv|webm|webp|mkv");
    private final ExtFile mApkFile;
    private final Config mConfig;
    private final AtomicReference<AndrolibException> mBuildError;
    private ApkInfo mApkInfo;
    private ResourcesDecoder mResDecoder;
    private volatile int mMinSdkVersion;
    private BackgroundWorker mWorker;

    public ApkDecoder(ExtFile apkFile, Config config) {
        this.mApkFile = apkFile;
        this.mConfig = config;
        this.mBuildError = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApkInfo decode(File outDir) throws AndrolibException {
        if (!this.mConfig.isForced() && outDir.exists()) {
            throw new OutDirExistsException();
        }
        if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
            throw new InFileNotFoundException();
        }
        if (this.mConfig.getJobs() > 1) {
            this.mWorker = new BackgroundWorker(this.mConfig.getJobs() - 1);
        }
        try {
            this.mApkInfo = new ApkInfo(this.mApkFile);
            this.mResDecoder = new ResourcesDecoder(this.mApkInfo, this.mConfig);
            OS.rmdir(outDir);
            OS.mkdir(outDir);
            LOGGER.info("Using Apktool " + ApktoolProperties.getVersion() + " on " + this.mApkFile.getName() + (this.mWorker != null ? " with " + this.mConfig.getJobs() + " threads" : ""));
            this.decodeSources(outDir);
            this.decodeResources(outDir);
            this.decodeManifest(outDir);
            if (this.mWorker != null) {
                this.mWorker.waitForFinish();
                if (this.mBuildError.get() != null) {
                    throw this.mBuildError.get();
                }
            }
            this.copyOriginalFiles(outDir);
            this.copyRawFiles(outDir);
            this.copyUnknownFiles(outDir);
            this.writeApkInfo(outDir);
            ApkInfo apkInfo = this.mApkInfo;
            return apkInfo;
        }
        finally {
            if (this.mWorker != null) {
                this.mWorker.shutdownNow();
            }
            try {
                this.mApkFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void decodeSources(File outDir) throws AndrolibException {
        if (!this.mApkInfo.hasSources()) {
            return;
        }
        switch (this.mConfig.getDecodeSources()) {
            case NONE: {
                this.copySourcesRaw(outDir, "classes.dex");
                break;
            }
            case FULL: 
            case ONLY_MAIN_CLASSES: {
                this.decodeSourcesSmali(outDir, "classes.dex");
            }
        }
        try {
            Directory in = this.mApkFile.getDirectory();
            for (String fileName : in.getFiles(true)) {
                if (!fileName.endsWith(".dex") || fileName.equals("classes.dex")) continue;
                switch (this.mConfig.getDecodeSources()) {
                    case NONE: {
                        this.copySourcesRaw(outDir, fileName);
                        break;
                    }
                    case FULL: {
                        this.decodeSourcesSmali(outDir, fileName);
                        break;
                    }
                    case ONLY_MAIN_CLASSES: {
                        if (fileName.startsWith("classes")) {
                            this.decodeSourcesSmali(outDir, fileName);
                            break;
                        }
                        this.copySourcesRaw(outDir, fileName);
                    }
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copySourcesRaw(File outDir, String fileName) throws AndrolibException {
        LOGGER.info("Copying raw " + fileName + " file...");
        try {
            Directory in = this.mApkFile.getDirectory();
            in.copyToDir(outDir, fileName);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void decodeSourcesSmali(File outDir, String fileName) throws AndrolibException {
        if (this.mWorker != null) {
            this.mWorker.submit(() -> {
                if (this.mBuildError.get() == null) {
                    try {
                        this.decodeSourcesSmaliJob(outDir, fileName);
                    }
                    catch (AndrolibException ex) {
                        this.mBuildError.compareAndSet(null, ex);
                    }
                }
            });
        } else {
            this.decodeSourcesSmaliJob(outDir, fileName);
        }
    }

    private void decodeSourcesSmaliJob(File outDir, String fileName) throws AndrolibException {
        File smaliDir = fileName.equals("classes.dex") ? new File(outDir, "smali") : new File(outDir, "smali_" + fileName.substring(0, fileName.indexOf(".")));
        OS.rmdir(smaliDir);
        OS.mkdir(smaliDir);
        LOGGER.info("Baksmaling " + fileName + "...");
        SmaliDecoder decoder = new SmaliDecoder(this.mApkFile, fileName, this.mConfig.isBaksmaliDebugMode(), this.mConfig.getBaksmaliApiLevel());
        DexFile dexFile = decoder.decode(smaliDir);
        int minSdkVersion = dexFile.getOpcodes().api;
        if (this.mMinSdkVersion == 0 || this.mMinSdkVersion > minSdkVersion) {
            this.mMinSdkVersion = minSdkVersion;
        }
    }

    private void decodeResources(File outDir) throws AndrolibException {
        if (!this.mApkInfo.hasResources()) {
            return;
        }
        switch (this.mConfig.getDecodeResources()) {
            case NONE: 
            case ONLY_MANIFEST: {
                this.copyResourcesRaw(outDir);
                break;
            }
            case FULL: {
                this.mResDecoder.decodeResources(outDir);
            }
        }
    }

    private void copyResourcesRaw(File outDir) throws AndrolibException {
        LOGGER.info("Copying raw resources...");
        try {
            Directory in = this.mApkFile.getDirectory();
            in.copyToDir(outDir, "resources.arsc");
            in.copyToDir(outDir, ApkInfo.RESOURCES_DIRNAMES);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void decodeManifest(File outDir) throws AndrolibException {
        if (!this.mApkInfo.hasManifest()) {
            return;
        }
        switch (this.mConfig.getDecodeResources()) {
            case NONE: {
                this.copyManifestRaw(outDir);
                break;
            }
            case ONLY_MANIFEST: 
            case FULL: {
                this.mResDecoder.decodeManifest(outDir);
            }
        }
    }

    private void copyManifestRaw(File outDir) throws AndrolibException {
        LOGGER.info("Copying raw manifest...");
        try {
            Directory in = this.mApkFile.getDirectory();
            in.copyToDir(outDir, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyRawFiles(File outDir) throws AndrolibException {
        try {
            Directory in = this.mApkFile.getDirectory();
            for (String dirName : ApkInfo.RAW_DIRNAMES) {
                if (this.mConfig.getDecodeAssets() != Config.DecodeAssets.FULL && dirName.equals("assets") || !in.containsDir(dirName)) continue;
                LOGGER.info("Copying " + dirName + "...");
                for (String fileName : in.getDir(dirName).getFiles(true)) {
                    fileName = dirName + "/" + fileName;
                    if (ApkInfo.ORIGINAL_FILENAMES_PATTERN.matcher(fileName).matches()) continue;
                    in.copyToDir(outDir, fileName);
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyOriginalFiles(File outDir) throws AndrolibException {
        LOGGER.info("Copying original files...");
        try {
            Directory in = this.mApkFile.getDirectory();
            File originalDir = new File(outDir, "original");
            for (String fileName : in.getFiles(true)) {
                if (!ApkInfo.ORIGINAL_FILENAMES_PATTERN.matcher(fileName).matches()) continue;
                in.copyToDir(originalDir, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyUnknownFiles(File outDir) throws AndrolibException {
        LOGGER.info("Copying unknown files...");
        try {
            Directory in = this.mApkFile.getDirectory();
            File unknownDir = new File(outDir, "unknown");
            for (String fileName : in.getFiles(true)) {
                if (ApkInfo.STANDARD_FILENAMES_PATTERN.matcher(fileName).matches()) continue;
                in.copyToDir(unknownDir, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void writeApkInfo(File outDir) throws AndrolibException {
        if (!this.mApkInfo.hasResources() && this.mMinSdkVersion > 0) {
            this.mApkInfo.getSdkInfo().setMinSdkVersion(Integer.toString(this.mMinSdkVersion));
        }
        try {
            String ext;
            Map<String, String> resFileMapping = this.mResDecoder.getResFileMapping();
            HashSet<String> uncompressedExts = new HashSet<String>();
            HashSet<String> uncompressedFiles = new HashSet<String>();
            Directory in = this.mApkFile.getDirectory();
            for (String fileName : in.getFiles(true)) {
                if (in.getCompressionLevel(fileName) != 0) continue;
                if (in.getSize(fileName) > 0L && !(ext = FilenameUtils.getExtension(fileName)).isEmpty() && NO_COMPRESS_EXT_PATTERN.matcher(ext).matches()) {
                    uncompressedExts.add(ext);
                    continue;
                }
                uncompressedFiles.add(resFileMapping.getOrDefault(fileName, fileName));
            }
            if (!uncompressedExts.isEmpty() && !uncompressedFiles.isEmpty()) {
                Iterator it = uncompressedFiles.iterator();
                while (it.hasNext()) {
                    String fileName;
                    fileName = (String)it.next();
                    ext = FilenameUtils.getExtension(fileName);
                    if (!uncompressedExts.contains(ext)) continue;
                    it.remove();
                }
            }
            List<String> doNotCompress = this.mApkInfo.getDoNotCompress();
            if (!uncompressedExts.isEmpty()) {
                ArrayList uncompressedExtsList = new ArrayList(uncompressedExts);
                uncompressedExtsList.sort(null);
                doNotCompress.addAll(uncompressedExtsList);
            }
            if (!uncompressedFiles.isEmpty()) {
                ArrayList uncompressedFilesList = new ArrayList(uncompressedFiles);
                uncompressedFilesList.sort(null);
                doNotCompress.addAll(uncompressedFilesList);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        this.mApkInfo.save(new File(outDir, "apktool.yml"));
    }
}

