/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.ninepatch;

import brut.util.ExtDataInput;
import java.io.IOException;

public class NinePatchData {
    public final int paddingLeft;
    public final int paddingRight;
    public final int paddingTop;
    public final int paddingBottom;
    public final int[] xDivs;
    public final int[] yDivs;

    public NinePatchData(int paddingLeft, int paddingRight, int paddingTop, int paddingBottom, int[] xDivs, int[] yDivs) {
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.xDivs = xDivs;
        this.yDivs = yDivs;
    }

    public static NinePatchData decode(ExtDataInput in) throws IOException {
        in.skipByte();
        int numXDivs = in.readUnsignedByte();
        int numYDivs = in.readUnsignedByte();
        in.skipByte();
        in.skipInt();
        in.skipInt();
        int paddingLeft = in.readInt();
        int paddingRight = in.readInt();
        int paddingTop = in.readInt();
        int paddingBottom = in.readInt();
        in.skipInt();
        int[] xDivs = in.readIntArray(numXDivs);
        int[] yDivs = in.readIntArray(numYDivs);
        return new NinePatchData(paddingLeft, paddingRight, paddingTop, paddingBottom, xDivs, yDivs);
    }
}

