/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.writer.AnnotationSetSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotation;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotationPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotationSet;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BuilderAnnotationSetPool
extends BaseBuilderPool
implements AnnotationSetSection<BuilderAnnotation, BuilderAnnotationSet> {
    @Nonnull
    private final ConcurrentMap<Set<? extends Annotation>, BuilderAnnotationSet> internedItems = new ConcurrentHashMap<Set<? extends Annotation>, BuilderAnnotationSet>();

    public BuilderAnnotationSetPool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderAnnotationSet internAnnotationSet(@Nullable Set<? extends Annotation> annotations) {
        if (annotations == null) {
            return BuilderAnnotationSet.EMPTY;
        }
        BuilderAnnotationSet ret = (BuilderAnnotationSet)this.internedItems.get(annotations);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotationSet annotationSet = new BuilderAnnotationSet(Collections.unmodifiableSet(annotations.stream().map(annotation -> ((BuilderAnnotationPool)this.dexBuilder.annotationSection).internAnnotation((Annotation)annotation)).collect(Collectors.toSet())));
        ret = this.internedItems.putIfAbsent(annotationSet, annotationSet);
        return ret == null ? annotationSet : ret;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderAnnotation> getAnnotations(@Nonnull BuilderAnnotationSet key) {
        return key.annotations;
    }

    @Override
    public int getNullableItemOffset(@Nullable BuilderAnnotationSet key) {
        return key == null ? 0 : key.offset;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderAnnotationSet key) {
        return key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderAnnotationSet, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotationSet>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderAnnotationSet key) {
                return key.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderAnnotationSet key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

