/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptManager;
import brut.androlib.exceptions.AndrolibException;
import brut.util.OSDetection;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class Config {
    private static final String DEFAULT_FRAMEWORK_DIRECTORY;
    private int mJobs = Math.min(Runtime.getRuntime().availableProcessors(), 8);
    private String mFrameworkDirectory = DEFAULT_FRAMEWORK_DIRECTORY;
    private String mFrameworkTag = null;
    private String[] mLibraryFiles = null;
    private boolean mForced = false;
    private boolean mVerbose = false;
    private DecodeSources mDecodeSources = DecodeSources.FULL;
    private boolean mBaksmaliDebugMode = true;
    private int mBaksmaliApiLevel = 0;
    private DecodeResources mDecodeResources = DecodeResources.FULL;
    private DecodeResolve mDecodeResolve = DecodeResolve.REMOVE;
    private boolean mAnalysisMode = false;
    private boolean mKeepBrokenResources = false;
    private DecodeAssets mDecodeAssets = DecodeAssets.FULL;
    private boolean mDebugMode = false;
    private boolean mNetSecConf = false;
    private boolean mCopyOriginalFiles = false;
    private boolean mNoCrunch = false;
    private boolean mNoApk = false;
    private File mAaptBinary = null;
    private int mAaptVersion = 2;

    public int getJobs() {
        return this.mJobs;
    }

    public void setJobs(int jobs) {
        this.mJobs = jobs;
    }

    public String getFrameworkDirectory() {
        return this.mFrameworkDirectory;
    }

    public void setFrameworkDirectory(String frameworkDirectory) {
        if (frameworkDirectory == null || frameworkDirectory.isEmpty()) {
            frameworkDirectory = DEFAULT_FRAMEWORK_DIRECTORY;
        }
        this.mFrameworkDirectory = frameworkDirectory;
    }

    public String getFrameworkTag() {
        return this.mFrameworkTag;
    }

    public void setFrameworkTag(String frameworkTag) {
        if (frameworkTag == null || frameworkTag.isEmpty()) {
            frameworkTag = null;
        }
        this.mFrameworkTag = frameworkTag;
    }

    public String[] getLibraryFiles() {
        return this.mLibraryFiles;
    }

    public void setLibraryFiles(String[] libraryFiles) {
        this.mLibraryFiles = libraryFiles;
    }

    public boolean isForced() {
        return this.mForced;
    }

    public void setForced(boolean forced) {
        this.mForced = forced;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public DecodeSources getDecodeSources() {
        return this.mDecodeSources;
    }

    public void setDecodeSources(DecodeSources decodeSources) {
        assert (decodeSources != null);
        this.mDecodeSources = decodeSources;
    }

    public boolean isBaksmaliDebugMode() {
        return this.mBaksmaliDebugMode;
    }

    public void setBaksmaliDebugMode(boolean baksmaliDebugMode) {
        this.mBaksmaliDebugMode = baksmaliDebugMode;
    }

    public int getBaksmaliApiLevel() {
        return this.mBaksmaliApiLevel;
    }

    public void setBaksmaliApiLevel(int baksmaliApiLevel) {
        this.mBaksmaliApiLevel = baksmaliApiLevel;
    }

    public DecodeResources getDecodeResources() {
        return this.mDecodeResources;
    }

    public void setDecodeResources(DecodeResources decodeResources) {
        assert (decodeResources != null);
        this.mDecodeResources = decodeResources;
    }

    public DecodeAssets getDecodeAssets() {
        return this.mDecodeAssets;
    }

    public void setDecodeAssets(DecodeAssets decodeAssets) {
        assert (decodeAssets != null);
        this.mDecodeAssets = decodeAssets;
    }

    public DecodeResolve getDecodeResolve() {
        return this.mDecodeResolve;
    }

    public void setDecodeResolve(DecodeResolve decodeResolve) {
        assert (decodeResolve != null);
        this.mDecodeResolve = decodeResolve;
    }

    public boolean isKeepBrokenResources() {
        return this.mKeepBrokenResources;
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public boolean isAnalysisMode() {
        return this.mAnalysisMode;
    }

    public void setAnalysisMode(boolean analysisMode) {
        this.mAnalysisMode = analysisMode;
    }

    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.mDebugMode = debugMode;
    }

    public boolean isNetSecConf() {
        return this.mNetSecConf;
    }

    public void setNetSecConf(boolean netSecConf) {
        this.mNetSecConf = netSecConf;
    }

    public boolean isCopyOriginalFiles() {
        return this.mCopyOriginalFiles;
    }

    public void setCopyOriginalFiles(boolean copyOriginalFiles) {
        this.mCopyOriginalFiles = copyOriginalFiles;
    }

    public boolean isNoCrunch() {
        return this.mNoCrunch;
    }

    public void setNoCrunch(boolean noCrunch) {
        this.mNoCrunch = noCrunch;
    }

    public boolean isNoApk() {
        return this.mNoApk;
    }

    public void setNoApk(boolean noApk) {
        this.mNoApk = noApk;
    }

    public File getAaptBinary() {
        return this.mAaptBinary;
    }

    public void setAaptBinary(File aaptBinary) throws AndrolibException {
        this.mAaptBinary = aaptBinary;
        this.mAaptVersion = AaptManager.getAaptVersion(aaptBinary);
    }

    public int getAaptVersion() {
        return this.mAaptVersion;
    }

    public void setAaptVersion(int aaptVersion) {
        this.mAaptVersion = aaptVersion;
    }

    static {
        String xdgDataFolder;
        File parent = new File(System.getProperty("user.home"));
        Path path = OSDetection.isMacOSX() ? Paths.get(parent.getAbsolutePath(), "Library", "apktool", "framework") : (OSDetection.isWindows() ? Paths.get(parent.getAbsolutePath(), "AppData", "Local", "apktool", "framework") : ((xdgDataFolder = System.getenv("XDG_DATA_HOME")) != null ? Paths.get(xdgDataFolder, "apktool", "framework") : Paths.get(parent.getAbsolutePath(), ".local", "share", "apktool", "framework")));
        DEFAULT_FRAMEWORK_DIRECTORY = path.toString();
    }

    public static enum DecodeResolve {
        REMOVE,
        DUMMY,
        KEEP;

    }

    public static enum DecodeAssets {
        NONE,
        FULL;

    }

    public static enum DecodeResources {
        NONE,
        FULL,
        ONLY_MANIFEST;

    }

    public static enum DecodeSources {
        NONE,
        FULL,
        ONLY_MAIN_CLASSES;

    }
}

