/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.smali;

import com.android.tools.smali.smali.AssembleCommand;
import com.android.tools.smali.smali.HelpCommand;
import com.android.tools.smali.smali.PrintTokensCommand;
import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedCommands;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

@ExtendedParameters(includeParametersInUsage=true, commandName="smali", postfixDescription="See smali help <command> for more information about a specific command")
public class Main
extends Command {
    public static final String VERSION = Main.loadVersion();
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @Parameter(names={"-v", "--version"}, help=true, description="Print the version of baksmali and then exit")
    public boolean version;
    private JCommander jc;

    @Override
    public void run() {
    }

    @Override
    protected JCommander getJCommander() {
        return this.jc;
    }

    public Main() {
        super(Lists.newArrayList());
    }

    public static void main(String[] args) {
        JCommander jc;
        Main main = new Main();
        main.jc = jc = new JCommander(main);
        jc.setProgramName("smali");
        List<JCommander> commandHierarchy = main.getCommandHierarchy();
        ExtendedCommands.addExtendedCommand(jc, new AssembleCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand(jc, new PrintTokensCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand(jc, new HelpCommand(commandHierarchy));
        ExtendedCommands.addExtendedCommand(jc, new HelpCommand.HlepCommand(commandHierarchy));
        jc.parse(args);
        if (main.version) {
            Main.version();
        }
        if (jc.getParsedCommand() == null || main.help) {
            main.usage();
            return;
        }
        Command command = (Command)jc.getCommands().get(jc.getParsedCommand()).getObjects().get(0);
        command.run();
    }

    protected static void version() {
        System.out.println("smali " + VERSION + " (http://smali.org)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static String loadVersion() {
        InputStream propertiesStream = Main.class.getClassLoader().getResourceAsStream("smali.properties");
        String version = "[unknown version]";
        if (propertiesStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(propertiesStream);
                version = properties.getProperty("application.version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }
}

