/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.animation;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openstreetmap.josm.gui.animation.IAnimObject;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

class DropImage
implements IAnimObject {
    private static final Random seed = new Random();
    static final int averageFallSpeed = 4;
    private int w;
    private int h;
    private final Point edge = new Point();
    private final int fallSpeed;
    private Image image;

    DropImage(int w, int h) {
        this.w = w;
        this.h = h;
        this.edge.x = seed.nextInt(w - 1);
        this.edge.y = seed.nextInt(h + 1);
        this.fallSpeed = 2 + seed.nextInt(2);
        this.image = this.getImage();
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, this.edge.x, this.edge.y, null);
    }

    @Override
    public void setExtend(int w, int h) {
        this.w = w;
        this.h = h;
    }

    @Override
    public void animate() {
        this.edge.y += this.fallSpeed;
        if (this.edge.x > this.w - 1 || this.edge.y > this.h) {
            this.edge.x = seed.nextInt(this.w - 1);
            this.edge.y = -this.image.getWidth(null) * 2;
            this.image = this.getImage();
        }
    }

    private Image getImage() {
        int size = 15 + seed.nextInt(5);
        String name = "logo";
        try {
            ArrayList<String> result = new ArrayList<String>();
            String path = "images/presets/";
            URL url = DropImage.class.getClassLoader().getResource(path);
            if (url != null && "file".equals(url.getProtocol())) {
                ArrayList<File> dirs = new ArrayList<File>();
                dirs.add(new File(url.toURI()));
                do {
                    File[] files;
                    if ((files = ((File)dirs.remove(0)).listFiles()) == null) continue;
                    for (File f : files) {
                        if (f.isFile()) {
                            result.add(f.getPath());
                            continue;
                        }
                        dirs.add(f);
                    }
                } while (!dirs.isEmpty());
                name = (String)result.get(seed.nextInt(result.size()));
            } else if (url != null && "jar".equals(url.getProtocol())) {
                String jarPath = url.getPath().substring(5, url.getPath().indexOf(33));
                try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String fileName = entries.nextElement().getName();
                        if (!fileName.startsWith(path) || fileName.endsWith("/")) continue;
                        result.add(fileName.substring(7));
                    }
                }
                name = (String)result.get(seed.nextInt(result.size()));
            }
            return new ImageProvider(name).setMaxSize(new Dimension(size, size)).get().getImage();
        }
        catch (Exception ex) {
            Logging.log(Logging.LEVEL_DEBUG, ex);
            return new ImageProvider("logo").setMaxSize(new Dimension(size, size)).get().getImage();
        }
    }
}

