/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheMonitor;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheWatchRepairable;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.ZombieCacheWatch;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private static final Log log = LogManager.getLog(LateralTCPCacheFactory.class);
    private ConcurrentHashMap<String, ICacheServiceNonLocal<?, ?>> csnlInstances;
    private ConcurrentHashMap<String, LateralTCPDiscoveryListener> lTCPDLInstances;
    private LateralCacheMonitor monitor;
    private CacheWatchRepairable lateralWatch;

    public <K, V> LateralCacheNoWaitFacade<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ITCPLateralCacheAttributes lac = (ITCPLateralCacheAttributes)iaca;
        ArrayList noWaits = new ArrayList();
        if (lac.getTcpServers() != null && !lac.getTcpServers().isEmpty()) {
            String[] servers = lac.getTcpServers().split("\\s*,\\s*");
            log.debug("Configured for [{0}] servers.", servers.length);
            for (String server : servers) {
                log.debug("tcp server = {0}", server);
                ITCPLateralCacheAttributes lacClone = (ITCPLateralCacheAttributes)lac.clone();
                lacClone.setTcpServer(server);
                LateralCacheNoWait<K, V> lateralNoWait = this.createCacheNoWait(lacClone, cacheEventLogger, elementSerializer);
                this.addListenerIfNeeded(lacClone, cacheMgr, elementSerializer);
                this.monitorCache(lateralNoWait);
                noWaits.add(lateralNoWait);
            }
        }
        ILateralCacheListener<K, V> listener = LateralTCPCacheFactory.createListener(lac, cacheMgr, elementSerializer);
        LateralCacheNoWaitFacade<K, V> lcnwf = new LateralCacheNoWaitFacade<K, V>(listener, noWaits, (ILateralCacheAttributes)lac);
        this.createDiscoveryService(lac, lcnwf, cacheMgr, cacheEventLogger, elementSerializer);
        return lcnwf;
    }

    public <K, V> LateralCacheNoWait<K, V> createCacheNoWait(ITCPLateralCacheAttributes lca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ICacheServiceNonLocal<K, V> lateralService = this.getCSNLInstance(lca, elementSerializer);
        LateralCache<K, V> cache = new LateralCache<K, V>(lca, lateralService, this.monitor);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        log.debug("Created cache for noWait, cache [{0}]", cache);
        LateralCacheNoWait<K, V> lateralNoWait = new LateralCacheNoWait<K, V>(cache);
        lateralNoWait.setIdentityKey(lca.getTcpServer());
        log.info("Created LateralCacheNoWait for [{0}] LateralCacheNoWait = [{1}]", lca, lateralNoWait);
        return lateralNoWait;
    }

    @Override
    public void initialize() {
        this.csnlInstances = new ConcurrentHashMap();
        this.lTCPDLInstances = new ConcurrentHashMap();
        this.monitor = new LateralCacheMonitor(this);
        this.monitor.setDaemon(true);
        this.monitor.start();
        this.lateralWatch = new CacheWatchRepairable();
        this.lateralWatch.setCacheWatch(new ZombieCacheWatch());
    }

    @Override
    public void dispose() {
        for (ICacheServiceNonLocal<?, ?> service : this.csnlInstances.values()) {
            try {
                service.dispose("");
            }
            catch (IOException e) {
                log.error("Could not dispose service " + service, e);
            }
        }
        this.csnlInstances.clear();
        this.lTCPDLInstances.clear();
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
    }

    @Deprecated
    public <K, V> ICacheServiceNonLocal<K, V> getCSNLInstance(ITCPLateralCacheAttributes lca) {
        return this.getCSNLInstance(lca, new StandardSerializer());
    }

    public <K, V> ICacheServiceNonLocal<K, V> getCSNLInstance(ITCPLateralCacheAttributes lca, IElementSerializer elementSerializer) {
        String key = lca.getTcpServer();
        return this.csnlInstances.compute(key, (name, service) -> {
            ICacheServiceNonLocal newService = service;
            if (service instanceof ZombieCacheServiceNonLocal) {
                log.info("Disposing of zombie service instance for [{0}]", name);
                newService = null;
            }
            if (newService == null) {
                log.info("Instance for [{0}] is null, creating", name);
                try {
                    log.info("Creating TCP service, lca = {0}", lca);
                    newService = new LateralTCPService(lca, elementSerializer);
                }
                catch (IOException ex) {
                    log.error("Failure, lateral instance will use zombie service", ex);
                    newService = new ZombieCacheServiceNonLocal(lca.getZombieQueueMaxSize());
                    this.monitor.notifyError();
                }
            }
            return newService;
        });
    }

    public void monitorCache(LateralCacheNoWait<?, ?> cache) {
        this.monitor.addCache(cache);
    }

    private LateralTCPDiscoveryListener getDiscoveryListener(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        String key = ilca.getUdpDiscoveryAddr() + ":" + ilca.getUdpDiscoveryPort();
        return this.lTCPDLInstances.computeIfAbsent(key, key1 -> {
            log.info("Created new discovery listener for cacheName {0} and request {1}", ilca.getCacheName(), key1);
            return new LateralTCPDiscoveryListener(this.getName(), (CompositeCacheManager)cacheManager, cacheEventLogger, elementSerializer);
        });
    }

    private void addListenerIfNeeded(ITCPLateralCacheAttributes iaca, ICompositeCacheManager cacheMgr, IElementSerializer elementSerializer) {
        if (iaca.isReceive()) {
            try {
                this.addLateralCacheListener(iaca.getCacheName(), LateralTCPCacheFactory.createListener(iaca, cacheMgr, elementSerializer));
            }
            catch (IOException ioe) {
                log.error("Problem creating lateral listener", ioe);
            }
        } else {
            log.debug("Not creating a listener since we are not receiving.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void addLateralCacheListener(String cacheName, ILateralCacheListener<K, V> listener) throws IOException {
        CacheWatchRepairable cacheWatchRepairable = this.lateralWatch;
        synchronized (cacheWatchRepairable) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    private static <K, V> ILateralCacheListener<K, V> createListener(ITCPLateralCacheAttributes attr, ICompositeCacheManager cacheMgr, IElementSerializer elementSerializer) {
        LateralTCPListener listener = null;
        if (attr.isReceive()) {
            log.info("Getting listener for {0}", attr);
            listener = LateralTCPListener.getInstance(attr, cacheMgr, elementSerializer);
            cacheMgr.registerShutdownObserver(listener);
        } else {
            log.debug("Not creating a listener since we are not receiving.");
        }
        return listener;
    }

    private synchronized <K, V> void createDiscoveryService(ITCPLateralCacheAttributes lac, LateralCacheNoWaitFacade<K, V> lcnwf, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        UDPDiscoveryService discovery = null;
        if (lac.isUdpDiscoveryEnabled()) {
            LateralTCPDiscoveryListener discoveryListener = this.getDiscoveryListener(lac, cacheMgr, cacheEventLogger, elementSerializer);
            discoveryListener.addNoWaitFacade(lac.getCacheName(), lcnwf);
            discovery = UDPDiscoveryManager.getInstance().getService(lac.getUdpDiscoveryAddr(), lac.getUdpDiscoveryPort(), lac.getTcpListenerHost(), lac.getTcpListenerPort(), lac.getUdpTTL(), cacheMgr, elementSerializer);
            discovery.addParticipatingCacheName(lac.getCacheName());
            discovery.addDiscoveryListener(discoveryListener);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = lac::getCacheName;
            log.info("Registered TCP lateral cache [{0}] with UDPDiscoveryService.", supplierArray);
        }
    }
}

