// SSDT-UIAC-ALL.dsl
//
// This SSDT can be used as a template to build your own
// customization for USBInjectAll.kext.
//
// This SSDT contains all ports, so using it is the same as without
// a custom SSDT.  Delete ports that are not connected or ports you
// do not need.
//
// Change the UsbConnector or portType as needed to match your
// actual USB configuration.
//
// Note:
// portType=0 seems to indicate normal external USB2 port (as seen in MacBookPro8,1)
// portType=2 seems to indicate "internal device" (as seen in MacBookPro8,1)
// portType=4 is used by MacBookPro8,3 (reason/purpose unknown)
//

DefinitionBlock ("", "SSDT", 2, "hack", "_UIAC", 0)
{
    Device(UIAC)
    {
        Name(_HID, "UIA00000")

        Name(RMCF, Package()
        {
            "HUB1", Package()
            {
                "port-count", Buffer() { 8, 0, 0, 0 },
                "ports", Package()
                {
                    "HP11", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HP12", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HP13", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HP14", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HP15", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HP16", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HP17", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    
                    "HP18", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                },
            },
            "HUB2", Package()
            {
                "port-count", Buffer() { 6, 0, 0, 0 },
                "ports", Package()
                {
                    "HP21", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                                                
                    },
                    
                    "HP22", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                                                
                    },
                    "HP23", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                                                
                    },
                    "HP24", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                                                
                    },
                    "HP25", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                                                
                    },
                    "HP26", Package()
                    {
                        //"UsbConnector", 0,
                        "portType", 0,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                                                
                    },
                },
            },
            "EH01", Package()
            {
                "port-count", Buffer() { 8, 0, 0, 0 },
                "ports", Package()
                {
                    "PR11", Package()
                    {
                        "UsbConnector", 255,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 255,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                                                
                    },
                    "PR12", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                                                
                    },
                    "PR13", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 3, 0, 0, 0 },                        
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },        
                    },
                    "PR14", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                         
                    },
                    "PR15", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                         
                    },
                    "PR16", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                         
                    },
                    "PR17", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                         
                    },
                    "PR18", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                         
                    },
                },
            },
            "EH02", Package()
            {
                "port-count", Buffer() { 6, 0, 0, 0 },
                "ports", Package()
                {
                    "PR21", Package()
                    {
                        "UsbConnector", 255,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 255,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 }, 
                    },
                    "PR22", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 }, 
                    },
                    "PR23", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 }, 
                    },
                    "PR24", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 }, 
                    },
                    "PR25", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 }, 
                    },
                    "PR26", Package()
                    {
                        "UsbConnector", 0,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 0,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 }, 
                    },
                },
            },
            "8086_02ed", Package()
            {
                "port-count", Buffer() { 16, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },            
            "8086_06ed", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },
            "8086_34ed", Package()
            {
                "port-count", Buffer() { 16, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },              
            "8086_1e31", Package()
            {
                "port-count", Buffer() { 8, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                },
            },
            "8086_7ae0", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },
                    },                                 
                },
            },
            "8086_8xxx", Package()
            {
                "port-count", Buffer() { 21, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },                        
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },                        
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    //HS15 is phantom port (port address 15 not used)
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                },
            },
            "8086_9xxx", Package()
            {
                "port-count", Buffer() { 13, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },                        
                    },
                },
            },
            "8086_9cb1", Package()
            {
                "port-count", Buffer() { 15, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                        
                    },
                },
            },
            "8086_a12f", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },                        
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },
                    },     
                },
            },
            "8086_9dxx", Package()  // examples: 0x9d2f, 0x9ded
            {
                "port-count", Buffer() { 18, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                       
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },
                    },     
                },
            },
            "8086_a2af", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },                        
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },
            "8086_a36d", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },                        
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },
            "8086_a3af", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },                        
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            }, 
            "8086_43ed", Package()
            {
                "port-count", Buffer() { 26, 0, 0, 0 },
                "ports", Package()
                {
                    "HS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 1, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 1, 0, 0, 0 },                        
                    },
                    "HS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 2, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 2, 0, 0, 0 },                        
                    },
                    "HS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 3, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 3, 0, 0, 0 },                        
                    },
                    "HS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 4, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 4, 0, 0, 0 },                        
                    },
                    "HS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 5, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 5, 0, 0, 0 },                        
                    },
                    "HS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 6, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 6, 0, 0, 0 },                        
                    },
                    "HS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 7, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 7, 0, 0, 0 },                        
                    },
                    "HS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 8, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 8, 0, 0, 0 },                        
                    },
                    "HS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 9, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 9, 0, 0, 0 },                        
                    },
                    "HS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 10, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 10, 0, 0, 0 },                        
                    },
                    "HS11", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 11, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 11, 0, 0, 0 },                        
                    },
                    "HS12", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 12, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 12, 0, 0, 0 },
                    },
                    "HS13", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 13, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 13, 0, 0, 0 },
                    },
                    "HS14", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 14, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 14, 0, 0, 0 },                        
                    },
                    "SS01", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 17, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 17, 0, 0, 0 },                        
                    },
                    "SS02", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 18, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 18, 0, 0, 0 },                        
                    },
                    "SS03", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 19, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 19, 0, 0, 0 },                        
                    },
                    "SS04", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 20, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 20, 0, 0, 0 },                        
                    },
                    "SS05", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 21, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 21, 0, 0, 0 },                        
                    },
                    "SS06", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 22, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 22, 0, 0, 0 },                        
                    },
                    "SS07", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 23, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 23, 0, 0, 0 },                        
                    },
                    "SS08", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 24, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 24, 0, 0, 0 },                        
                    },
                    "SS09", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 25, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 25, 0, 0, 0 },                        
                    },
                    "SS10", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 26, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 26, 0, 0, 0 },
                    },
                    "USR1", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 15, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 15, 0, 0, 0 },                        
                    },
                    "USR2", Package()
                    {
                        "UsbConnector", 3,
                        "port", Buffer() { 16, 0, 0, 0 },
                        "usb-port-type", 3,
                        "usb-port-number", Buffer() { 16, 0, 0, 0 },                        
                    },
                },
            },           
        })
    }
}
//EOF
