# @TEST-EXEC: zeek -b -r $TRACES/tls/tls-expired-cert.trace %INPUT

# This is a hack: the results of OpenSSL 1.1's vs 1.0's
# X509_verify_cert() -> X509_STORE_CTX_get1_chain() calls
# differ.  Word seems to be that OpenSSL 1.1's cert-chain-building
# code is significantly different/rewritten so may be the reason...

# @TEST-EXEC: cp .stdout stdout-openssl-1.0
# @TEST-EXEC: cp .stdout stdout-openssl-1.1

# @TEST-EXEC: grep -q "ZEEK_HAVE_OPENSSL_1_1" $BUILD/CMakeCache.txt && btest-diff stdout-openssl-1.1 || btest-diff stdout-openssl-1.0

@load base/protocols/ssl

redef SSL::root_certs = {
	["CN=AddTrust External CA Root,OU=AddTrust External TTP Network,O=AddTrust AB,C=SE"] = "\x30\x82\x04\x36\x30\x82\x03\x1E\xA0\x03\x02\x01\x02\x02\x01\x01\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x30\x6F\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x53\x45\x31\x14\x30\x12\x06\x03\x55\x04\x0A\x13\x0B\x41\x64\x64\x54\x72\x75\x73\x74\x20\x41\x42\x31\x26\x30\x24\x06\x03\x55\x04\x0B\x13\x1D\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x54\x54\x50\x20\x4E\x65\x74\x77\x6F\x72\x6B\x31\x22\x30\x20\x06\x03\x55\x04\x03\x13\x19\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x43\x41\x20\x52\x6F\x6F\x74\x30\x1E\x17\x0D\x30\x30\x30\x35\x33\x30\x31\x30\x34\x38\x33\x38\x5A\x17\x0D\x32\x30\x30\x35\x33\x30\x31\x30\x34\x38\x33\x38\x5A\x30\x6F\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x53\x45\x31\x14\x30\x12\x06\x03\x55\x04\x0A\x13\x0B\x41\x64\x64\x54\x72\x75\x73\x74\x20\x41\x42\x31\x26\x30\x24\x06\x03\x55\x04\x0B\x13\x1D\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x54\x54\x50\x20\x4E\x65\x74\x77\x6F\x72\x6B\x31\x22\x30\x20\x06\x03\x55\x04\x03\x13\x19\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x43\x41\x20\x52\x6F\x6F\x74\x30\x82\x01\x22\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x01\x05\x00\x03\x82\x01\x0F\x00\x30\x82\x01\x0A\x02\x82\x01\x01\x00\xB7\xF7\x1A\x33\xE6\xF2\x00\x04\x2D\x39\xE0\x4E\x5B\xED\x1F\xBC\x6C\x0F\xCD\xB5\xFA\x23\xB6\xCE\xDE\x9B\x11\x33\x97\xA4\x29\x4C\x7D\x93\x9F\xBD\x4A\xBC\x93\xED\x03\x1A\xE3\x8F\xCF\xE5\x6D\x50\x5A\xD6\x97\x29\x94\x5A\x80\xB0\x49\x7A\xDB\x2E\x95\xFD\xB8\xCA\xBF\x37\x38\x2D\x1E\x3E\x91\x41\xAD\x70\x56\xC7\xF0\x4F\x3F\xE8\x32\x9E\x74\xCA\xC8\x90\x54\xE9\xC6\x5F\x0F\x78\x9D\x9A\x40\x3C\x0E\xAC\x61\xAA\x5E\x14\x8F\x9E\x87\xA1\x6A\x50\xDC\xD7\x9A\x4E\xAF\x05\xB3\xA6\x71\x94\x9C\x71\xB3\x50\x60\x0A\xC7\x13\x9D\x38\x07\x86\x02\xA8\xE9\xA8\x69\x26\x18\x90\xAB\x4C\xB0\x4F\x23\xAB\x3A\x4F\x84\xD8\xDF\xCE\x9F\xE1\x69\x6F\xBB\xD7\x42\xD7\x6B\x44\xE4\xC7\xAD\xEE\x6D\x41\x5F\x72\x5A\x71\x08\x37\xB3\x79\x65\xA4\x59\xA0\x94\x37\xF7\x00\x2F\x0D\xC2\x92\x72\xDA\xD0\x38\x72\xDB\x14\xA8\x45\xC4\x5D\x2A\x7D\xB7\xB4\xD6\xC4\xEE\xAC\xCD\x13\x44\xB7\xC9\x2B\xDD\x43\x00\x25\xFA\x61\xB9\x69\x6A\x58\x23\x11\xB7\xA7\x33\x8F\x56\x75\x59\xF5\xCD\x29\xD7\x46\xB7\x0A\x2B\x65\xB6\xD3\x42\x6F\x15\xB2\xB8\x7B\xFB\xEF\xE9\x5D\x53\xD5\x34\x5A\x27\x02\x03\x01\x00\x01\xA3\x81\xDC\x30\x81\xD9\x30\x1D\x06\x03\x55\x1D\x0E\x04\x16\x04\x14\xAD\xBD\x98\x7A\x34\xB4\x26\xF7\xFA\xC4\x26\x54\xEF\x03\xBD\xE0\x24\xCB\x54\x1A\x30\x0B\x06\x03\x55\x1D\x0F\x04\x04\x03\x02\x01\x06\x30\x0F\x06\x03\x55\x1D\x13\x01\x01\xFF\x04\x05\x30\x03\x01\x01\xFF\x30\x81\x99\x06\x03\x55\x1D\x23\x04\x81\x91\x30\x81\x8E\x80\x14\xAD\xBD\x98\x7A\x34\xB4\x26\xF7\xFA\xC4\x26\x54\xEF\x03\xBD\xE0\x24\xCB\x54\x1A\xA1\x73\xA4\x71\x30\x6F\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x53\x45\x31\x14\x30\x12\x06\x03\x55\x04\x0A\x13\x0B\x41\x64\x64\x54\x72\x75\x73\x74\x20\x41\x42\x31\x26\x30\x24\x06\x03\x55\x04\x0B\x13\x1D\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x54\x54\x50\x20\x4E\x65\x74\x77\x6F\x72\x6B\x31\x22\x30\x20\x06\x03\x55\x04\x03\x13\x19\x41\x64\x64\x54\x72\x75\x73\x74\x20\x45\x78\x74\x65\x72\x6E\x61\x6C\x20\x43\x41\x20\x52\x6F\x6F\x74\x82\x01\x01\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x03\x82\x01\x01\x00\xB0\x9B\xE0\x85\x25\xC2\xD6\x23\xE2\x0F\x96\x06\x92\x9D\x41\x98\x9C\xD9\x84\x79\x81\xD9\x1E\x5B\x14\x07\x23\x36\x65\x8F\xB0\xD8\x77\xBB\xAC\x41\x6C\x47\x60\x83\x51\xB0\xF9\x32\x3D\xE7\xFC\xF6\x26\x13\xC7\x80\x16\xA5\xBF\x5A\xFC\x87\xCF\x78\x79\x89\x21\x9A\xE2\x4C\x07\x0A\x86\x35\xBC\xF2\xDE\x51\xC4\xD2\x96\xB7\xDC\x7E\x4E\xEE\x70\xFD\x1C\x39\xEB\x0C\x02\x51\x14\x2D\x8E\xBD\x16\xE0\xC1\xDF\x46\x75\xE7\x24\xAD\xEC\xF4\x42\xB4\x85\x93\x70\x10\x67\xBA\x9D\x06\x35\x4A\x18\xD3\x2B\x7A\xCC\x51\x42\xA1\x7A\x63\xD1\xE6\xBB\xA1\xC5\x2B\xC2\x36\xBE\x13\x0D\xE6\xBD\x63\x7E\x79\x7B\xA7\x09\x0D\x40\xAB\x6A\xDD\x8F\x8A\xC3\xF6\xF6\x8C\x1A\x42\x05\x51\xD4\x45\xF5\x9F\xA7\x62\x21\x68\x15\x20\x43\x3C\x99\xE7\x7C\xBD\x24\xD8\xA9\x91\x17\x73\x88\x3F\x56\x1B\x31\x38\x18\xB4\x71\x0F\x9A\xCD\xC8\x0E\x9E\x8E\x2E\x1B\xE1\x8C\x98\x83\xCB\x1F\x31\xF1\x44\x4C\xC6\x04\x73\x49\x76\x60\x0F\xC7\xF8\xBD\x17\x80\x6B\x2E\xE9\xCC\x4C\x0E\x5A\x9A\x79\x0F\x20\x0A\x2E\xD5\x9E\x63\x26\x1E\x55\x92\x94\xD8\x82\x17\x5A\x7B\xD0\xBC\xC7\x8F\x4E\x86\x04",
	["CN=VeriSign Class 3 Public Primary Certification Authority - G3,OU=(c) 1999 VeriSign\, Inc. - For authorized use only,OU=VeriSign Trust Network,O=VeriSign\, Inc.,C=US"] = "\x30\x82\x04\x1A\x30\x82\x03\x02\x02\x11\x00\x9B\x7E\x06\x49\xA3\x3E\x62\xB9\xD5\xEE\x90\x48\x71\x29\xEF\x57\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x30\x81\xCA\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x55\x53\x31\x17\x30\x15\x06\x03\x55\x04\x0A\x13\x0E\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x31\x1F\x30\x1D\x06\x03\x55\x04\x0B\x13\x16\x56\x65\x72\x69\x53\x69\x67\x6E\x20\x54\x72\x75\x73\x74\x20\x4E\x65\x74\x77\x6F\x72\x6B\x31\x3A\x30\x38\x06\x03\x55\x04\x0B\x13\x31\x28\x63\x29\x20\x31\x39\x39\x39\x20\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x20\x2D\x20\x46\x6F\x72\x20\x61\x75\x74\x68\x6F\x72\x69\x7A\x65\x64\x20\x75\x73\x65\x20\x6F\x6E\x6C\x79\x31\x45\x30\x43\x06\x03\x55\x04\x03\x13\x3C\x56\x65\x72\x69\x53\x69\x67\x6E\x20\x43\x6C\x61\x73\x73\x20\x33\x20\x50\x75\x62\x6C\x69\x63\x20\x50\x72\x69\x6D\x61\x72\x79\x20\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x41\x75\x74\x68\x6F\x72\x69\x74\x79\x20\x2D\x20\x47\x33\x30\x1E\x17\x0D\x39\x39\x31\x30\x30\x31\x30\x30\x30\x30\x30\x30\x5A\x17\x0D\x33\x36\x30\x37\x31\x36\x32\x33\x35\x39\x35\x39\x5A\x30\x81\xCA\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x55\x53\x31\x17\x30\x15\x06\x03\x55\x04\x0A\x13\x0E\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x31\x1F\x30\x1D\x06\x03\x55\x04\x0B\x13\x16\x56\x65\x72\x69\x53\x69\x67\x6E\x20\x54\x72\x75\x73\x74\x20\x4E\x65\x74\x77\x6F\x72\x6B\x31\x3A\x30\x38\x06\x03\x55\x04\x0B\x13\x31\x28\x63\x29\x20\x31\x39\x39\x39\x20\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x20\x2D\x20\x46\x6F\x72\x20\x61\x75\x74\x68\x6F\x72\x69\x7A\x65\x64\x20\x75\x73\x65\x20\x6F\x6E\x6C\x79\x31\x45\x30\x43\x06\x03\x55\x04\x03\x13\x3C\x56\x65\x72\x69\x53\x69\x67\x6E\x20\x43\x6C\x61\x73\x73\x20\x33\x20\x50\x75\x62\x6C\x69\x63\x20\x50\x72\x69\x6D\x61\x72\x79\x20\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x41\x75\x74\x68\x6F\x72\x69\x74\x79\x20\x2D\x20\x47\x33\x30\x82\x01\x22\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x01\x05\x00\x03\x82\x01\x0F\x00\x30\x82\x01\x0A\x02\x82\x01\x01\x00\xCB\xBA\x9C\x52\xFC\x78\x1F\x1A\x1E\x6F\x1B\x37\x73\xBD\xF8\xC9\x6B\x94\x12\x30\x4F\xF0\x36\x47\xF5\xD0\x91\x0A\xF5\x17\xC8\xA5\x61\xC1\x16\x40\x4D\xFB\x8A\x61\x90\xE5\x76\x20\xC1\x11\x06\x7D\xAB\x2C\x6E\xA6\xF5\x11\x41\x8E\xFA\x2D\xAD\x2A\x61\x59\xA4\x67\x26\x4C\xD0\xE8\xBC\x52\x5B\x70\x20\x04\x58\xD1\x7A\xC9\xA4\x69\xBC\x83\x17\x64\xAD\x05\x8B\xBC\xD0\x58\xCE\x8D\x8C\xF5\xEB\xF0\x42\x49\x0B\x9D\x97\x27\x67\x32\x6E\xE1\xAE\x93\x15\x1C\x70\xBC\x20\x4D\x2F\x18\xDE\x92\x88\xE8\x6C\x85\x57\x11\x1A\xE9\x7E\xE3\x26\x11\x54\xA2\x45\x96\x55\x83\xCA\x30\x89\xE8\xDC\xD8\xA3\xED\x2A\x80\x3F\x7F\x79\x65\x57\x3E\x15\x20\x66\x08\x2F\x95\x93\xBF\xAA\x47\x2F\xA8\x46\x97\xF0\x12\xE2\xFE\xC2\x0A\x2B\x51\xE6\x76\xE6\xB7\x46\xB7\xE2\x0D\xA6\xCC\xA8\xC3\x4C\x59\x55\x89\xE6\xE8\x53\x5C\x1C\xEA\x9D\xF0\x62\x16\x0B\xA7\xC9\x5F\x0C\xF0\xDE\xC2\x76\xCE\xAF\xF7\x6A\xF2\xFA\x41\xA6\xA2\x33\x14\xC9\xE5\x7A\x63\xD3\x9E\x62\x37\xD5\x85\x65\x9E\x0E\xE6\x53\x24\x74\x1B\x5E\x1D\x12\x53\x5B\xC7\x2C\xE7\x83\x49\x3B\x15\xAE\x8A\x68\xB9\x57\x97\x02\x03\x01\x00\x01\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x05\x05\x00\x03\x82\x01\x01\x00\x11\x14\x96\xC1\xAB\x92\x08\xF7\x3F\x2F\xC9\xB2\xFE\xE4\x5A\x9F\x64\xDE\xDB\x21\x4F\x86\x99\x34\x76\x36\x57\xDD\xD0\x15\x2F\xC5\xAD\x7F\x15\x1F\x37\x62\x73\x3E\xD4\xE7\x5F\xCE\x17\x03\xDB\x35\xFA\x2B\xDB\xAE\x60\x09\x5F\x1E\x5F\x8F\x6E\xBB\x0B\x3D\xEA\x5A\x13\x1E\x0C\x60\x6F\xB5\xC0\xB5\x23\x22\x2E\x07\x0B\xCB\xA9\x74\xCB\x47\xBB\x1D\xC1\xD7\xA5\x6B\xCC\x2F\xD2\x42\xFD\x49\xDD\xA7\x89\xCF\x53\xBA\xDA\x00\x5A\x28\xBF\x82\xDF\xF8\xBA\x13\x1D\x50\x86\x82\xFD\x8E\x30\x8F\x29\x46\xB0\x1E\x3D\x35\xDA\x38\x62\x16\x18\x4A\xAD\xE6\xB6\x51\x6C\xDE\xAF\x62\xEB\x01\xD0\x1E\x24\xFE\x7A\x8F\x12\x1A\x12\x68\xB8\xFB\x66\x99\x14\x14\x45\x5C\xAE\xE7\xAE\x69\x17\x81\x2B\x5A\x37\xC9\x5E\x2A\xF4\xC6\xE2\xA1\x5C\x54\x9B\xA6\x54\x00\xCF\xF0\xF1\xC1\xC7\x98\x30\x1A\x3B\x36\x16\xDB\xA3\x6E\xEA\xFD\xAD\xB2\xC2\xDA\xEF\x02\x47\x13\x8A\xC0\xF1\xB3\x31\xAD\x4F\x1C\xE1\x4F\x9C\xAF\x0F\x0C\x9D\xF7\x78\x0D\xD8\xF4\x35\x56\x80\xDA\xB7\x6D\x17\x8F\x9D\x1E\x81\x64\xE1\xFE\xC5\x45\xBA\xAD\x6B\xB9\x0A\x7A\x4E\x4F\x4B\x84\xEE\x4B\xF1\x7D\xDD\x11",
	["OU=Class 3 Public Primary Certification Authority,O=VeriSign\, Inc.,C=US"] = "\x30\x82\x02\x3C\x30\x82\x01\xA5\x02\x10\x70\xBA\xE4\x1D\x10\xD9\x29\x34\xB6\x38\xCA\x7B\x03\xCC\xBA\xBF\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x02\x05\x00\x30\x5F\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x55\x53\x31\x17\x30\x15\x06\x03\x55\x04\x0A\x13\x0E\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x31\x37\x30\x35\x06\x03\x55\x04\x0B\x13\x2E\x43\x6C\x61\x73\x73\x20\x33\x20\x50\x75\x62\x6C\x69\x63\x20\x50\x72\x69\x6D\x61\x72\x79\x20\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x41\x75\x74\x68\x6F\x72\x69\x74\x79\x30\x1E\x17\x0D\x39\x36\x30\x31\x32\x39\x30\x30\x30\x30\x30\x30\x5A\x17\x0D\x32\x38\x30\x38\x30\x31\x32\x33\x35\x39\x35\x39\x5A\x30\x5F\x31\x0B\x30\x09\x06\x03\x55\x04\x06\x13\x02\x55\x53\x31\x17\x30\x15\x06\x03\x55\x04\x0A\x13\x0E\x56\x65\x72\x69\x53\x69\x67\x6E\x2C\x20\x49\x6E\x63\x2E\x31\x37\x30\x35\x06\x03\x55\x04\x0B\x13\x2E\x43\x6C\x61\x73\x73\x20\x33\x20\x50\x75\x62\x6C\x69\x63\x20\x50\x72\x69\x6D\x61\x72\x79\x20\x43\x65\x72\x74\x69\x66\x69\x63\x61\x74\x69\x6F\x6E\x20\x41\x75\x74\x68\x6F\x72\x69\x74\x79\x30\x81\x9F\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x01\x05\x00\x03\x81\x8D\x00\x30\x81\x89\x02\x81\x81\x00\xC9\x5C\x59\x9E\xF2\x1B\x8A\x01\x14\xB4\x10\xDF\x04\x40\xDB\xE3\x57\xAF\x6A\x45\x40\x8F\x84\x0C\x0B\xD1\x33\xD9\xD9\x11\xCF\xEE\x02\x58\x1F\x25\xF7\x2A\xA8\x44\x05\xAA\xEC\x03\x1F\x78\x7F\x9E\x93\xB9\x9A\x00\xAA\x23\x7D\xD6\xAC\x85\xA2\x63\x45\xC7\x72\x27\xCC\xF4\x4C\xC6\x75\x71\xD2\x39\xEF\x4F\x42\xF0\x75\xDF\x0A\x90\xC6\x8E\x20\x6F\x98\x0F\xF8\xAC\x23\x5F\x70\x29\x36\xA4\xC9\x86\xE7\xB1\x9A\x20\xCB\x53\xA5\x85\xE7\x3D\xBE\x7D\x9A\xFE\x24\x45\x33\xDC\x76\x15\xED\x0F\xA2\x71\x64\x4C\x65\x2E\x81\x68\x45\xA7\x02\x03\x01\x00\x01\x30\x0D\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x01\x02\x05\x00\x03\x81\x81\x00\xBB\x4C\x12\x2B\xCF\x2C\x26\x00\x4F\x14\x13\xDD\xA6\xFB\xFC\x0A\x11\x84\x8C\xF3\x28\x1C\x67\x92\x2F\x7C\xB6\xC5\xFA\xDF\xF0\xE8\x95\xBC\x1D\x8F\x6C\x2C\xA8\x51\xCC\x73\xD8\xA4\xC0\x53\xF0\x4E\xD6\x26\xC0\x76\x01\x57\x81\x92\x5E\x21\xF1\xD1\xB1\xFF\xE7\xD0\x21\x58\xCD\x69\x17\xE3\x44\x1C\x9C\x19\x44\x39\x89\x5C\xDC\x9C\x00\x0F\x56\x8D\x02\x99\xED\xA2\x90\x45\x4C\xE4\xBB\x10\xA4\x3D\xF0\x32\x03\x0E\xF1\xCE\xF8\xE8\xC9\x51\x8C\xE6\x62\x9F\xE6\x9F\xC0\x7D\xB7\x72\x9C\xC9\x36\x3A\x6B\x9F\x4E\xA8\xFF\x64\x0D\x64",
};

event ssl_established(c: connection) &priority=3
	{
	local chain: vector of opaque of x509 = vector();
	for ( i in c$ssl$cert_chain )
		{
		chain[i] = c$ssl$cert_chain[i]$x509$handle;
		}

	local result = x509_verify(chain, SSL::root_certs);
	print fmt("Validation result: %s", result$result_string);
	if ( result$result != 0 ) # not ok
		return;

	print "Resulting chain:";
	for ( i in result$chain_certs )
		{
		local cert = result$chain_certs[i];
		local certinfo = x509_parse(cert);
		local sha1 = sha1_hash(x509_get_certificate_string(cert));
		print fmt("Fingerprint: %s, Subject: %s", sha1, certinfo$subject);
		#print fmt("Fingerprint: %s, Subject: %s, Issuer: %s", sha1, certinfo$subject, certinfo$issuer);
		}
	}
