# C library features
#
# Copyright © 2015 Open Microscopy Environment / University of Dundee
# Copyright © 2021 Roger Leigh <rleigh@codelibre.net>
# Written by Roger Leigh <rleigh@codelibre.net>
#
# Permission to use, copy, modify, distribute, and sell this software and
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the names of
# Sam Leffler and Silicon Graphics may not be used in any advertising or
# publicity relating to the software without the specific, prior written
# permission of Sam Leffler and Silicon Graphics.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.

# Strip chopping
if (FALSE) # XXX(kitware): hide messages.
option(strip-chopping "strip chopping (whether or not to convert single-strip uncompressed images to mutiple strips of specified size to reduce memory usage)" ON)
set(TIFF_DEFAULT_STRIP_SIZE 8192 CACHE STRING "default size of the strip in bytes (when strip chopping is enabled)")
else ()
set(strip-chopping 1)
set(TIFF_DEFAULT_STRIP_SIZE 8192)
endif ()

set(STRIPCHOP_DEFAULT)
if(strip-chopping)
    set(STRIPCHOP_DEFAULT TRUE)
    if(TIFF_DEFAULT_STRIP_SIZE)
        set(STRIP_SIZE_DEFAULT "${TIFF_DEFAULT_STRIP_SIZE}")
    endif()
endif()

set(TIFF_MAX_DIR_COUNT 1048576 CACHE STRING "Maximum number of TIFF directories that libtiff can browse through")
mark_as_advanced(TIFF_MAX_DIR_COUNT)

# Defer loading of strip/tile offsets
if (FALSE) # XXX(kitware): hardcode settings
option(defer-strile-load "enable deferred strip/tile offset/size loading (also available at runtime with the 'D' flag of TIFFOpen())" OFF)
else ()
set(defer-strile-load 0)
endif ()
set(DEFER_STRILE_LOAD ${defer-strile-load})

# CHUNKY_STRIP_READ_SUPPORT
if (FALSE) # XXX(kitware): hardcode settings
option(chunky-strip-read "enable reading large strips in chunks for TIFFReadScanline() (experimental)" OFF)
else ()
set(chunky-strip-read 0)
endif ()
set(CHUNKY_STRIP_READ_SUPPORT ${chunky-strip-read})

# SUBIFD support
set(SUBIFD_SUPPORT 1)

# Default handling of ASSOCALPHA support.
if (FALSE) # XXX(kitware): hardcode settings
option(extrasample-as-alpha "the RGBA interface will treat a fourth sample with no EXTRASAMPLE_ value as being ASSOCALPHA. Many packages produce RGBA files but don't mark the alpha properly" ON)
else ()
set(extrasample-as-alpha 0)
endif ()
if(extrasample-as-alpha)
    set(DEFAULT_EXTRASAMPLE_AS_ALPHA 1)
endif()

# Default handling of YCbCr subsampling support.
# See Bug 168 in Bugzilla, and JPEGFixupTestSubsampling() for details.
if (FALSE) # XXX(kitware): hardcode settings
option(check-ycbcr-subsampling "enable picking up YCbCr subsampling info from the JPEG data stream to support files lacking the tag" ON)
else ()
set(check-ycbcr-subsampling 0)
endif ()
if (check-ycbcr-subsampling)
    set(CHECK_JPEG_YCBCR_SUBSAMPLING 1)
endif()
