/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DISPATCHES_H
#define VN_PROTOCOL_RENDERER_DISPATCHES_H

#include "virgl_util.h"

#include "vn_protocol_renderer_structs.h"
#include "vn_protocol_renderer_transport.h"
#include "vn_protocol_renderer_instance.h"
#include "vn_protocol_renderer_device.h"
#include "vn_protocol_renderer_queue.h"
#include "vn_protocol_renderer_fence.h"
#include "vn_protocol_renderer_semaphore.h"
#include "vn_protocol_renderer_event.h"
#include "vn_protocol_renderer_device_memory.h"
#include "vn_protocol_renderer_image.h"
#include "vn_protocol_renderer_image_view.h"
#include "vn_protocol_renderer_sampler.h"
#include "vn_protocol_renderer_sampler_ycbcr_conversion.h"
#include "vn_protocol_renderer_buffer.h"
#include "vn_protocol_renderer_buffer_view.h"
#include "vn_protocol_renderer_descriptor_pool.h"
#include "vn_protocol_renderer_descriptor_set.h"
#include "vn_protocol_renderer_descriptor_set_layout.h"
#include "vn_protocol_renderer_descriptor_update_template.h"
#include "vn_protocol_renderer_render_pass.h"
#include "vn_protocol_renderer_framebuffer.h"
#include "vn_protocol_renderer_query_pool.h"
#include "vn_protocol_renderer_shader_module.h"
#include "vn_protocol_renderer_pipeline.h"
#include "vn_protocol_renderer_pipeline_layout.h"
#include "vn_protocol_renderer_pipeline_cache.h"
#include "vn_protocol_renderer_command_pool.h"
#include "vn_protocol_renderer_command_buffer.h"
#include "vn_protocol_renderer_private_data_slot.h"

static inline const char *vn_dispatch_command_name(VkCommandTypeEXT type)
{
    switch (type) {
    case VK_COMMAND_TYPE_vkCreateInstance_EXT: return "vkCreateInstance";
    case VK_COMMAND_TYPE_vkDestroyInstance_EXT: return "vkDestroyInstance";
    case VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT: return "vkEnumeratePhysicalDevices";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT: return "vkGetPhysicalDeviceProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT: return "vkGetPhysicalDeviceQueueFamilyProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT: return "vkGetPhysicalDeviceMemoryProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT: return "vkGetPhysicalDeviceFeatures";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT: return "vkGetPhysicalDeviceFormatProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT: return "vkGetPhysicalDeviceImageFormatProperties";
    case VK_COMMAND_TYPE_vkCreateDevice_EXT: return "vkCreateDevice";
    case VK_COMMAND_TYPE_vkDestroyDevice_EXT: return "vkDestroyDevice";
    case VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT: return "vkEnumerateInstanceVersion";
    case VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT: return "vkEnumerateInstanceLayerProperties";
    case VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT: return "vkEnumerateInstanceExtensionProperties";
    case VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT: return "vkEnumerateDeviceLayerProperties";
    case VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT: return "vkEnumerateDeviceExtensionProperties";
    case VK_COMMAND_TYPE_vkGetDeviceQueue_EXT: return "vkGetDeviceQueue";
    case VK_COMMAND_TYPE_vkQueueSubmit_EXT: return "vkQueueSubmit";
    case VK_COMMAND_TYPE_vkQueueWaitIdle_EXT: return "vkQueueWaitIdle";
    case VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT: return "vkDeviceWaitIdle";
    case VK_COMMAND_TYPE_vkAllocateMemory_EXT: return "vkAllocateMemory";
    case VK_COMMAND_TYPE_vkFreeMemory_EXT: return "vkFreeMemory";
    case VK_COMMAND_TYPE_vkUnmapMemory_EXT: return "vkUnmapMemory";
    case VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT: return "vkFlushMappedMemoryRanges";
    case VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT: return "vkInvalidateMappedMemoryRanges";
    case VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT: return "vkGetDeviceMemoryCommitment";
    case VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT: return "vkGetBufferMemoryRequirements";
    case VK_COMMAND_TYPE_vkBindBufferMemory_EXT: return "vkBindBufferMemory";
    case VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT: return "vkGetImageMemoryRequirements";
    case VK_COMMAND_TYPE_vkBindImageMemory_EXT: return "vkBindImageMemory";
    case VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT: return "vkGetImageSparseMemoryRequirements";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT: return "vkGetPhysicalDeviceSparseImageFormatProperties";
    case VK_COMMAND_TYPE_vkQueueBindSparse_EXT: return "vkQueueBindSparse";
    case VK_COMMAND_TYPE_vkCreateFence_EXT: return "vkCreateFence";
    case VK_COMMAND_TYPE_vkDestroyFence_EXT: return "vkDestroyFence";
    case VK_COMMAND_TYPE_vkResetFences_EXT: return "vkResetFences";
    case VK_COMMAND_TYPE_vkGetFenceStatus_EXT: return "vkGetFenceStatus";
    case VK_COMMAND_TYPE_vkWaitForFences_EXT: return "vkWaitForFences";
    case VK_COMMAND_TYPE_vkCreateSemaphore_EXT: return "vkCreateSemaphore";
    case VK_COMMAND_TYPE_vkDestroySemaphore_EXT: return "vkDestroySemaphore";
    case VK_COMMAND_TYPE_vkCreateEvent_EXT: return "vkCreateEvent";
    case VK_COMMAND_TYPE_vkDestroyEvent_EXT: return "vkDestroyEvent";
    case VK_COMMAND_TYPE_vkGetEventStatus_EXT: return "vkGetEventStatus";
    case VK_COMMAND_TYPE_vkSetEvent_EXT: return "vkSetEvent";
    case VK_COMMAND_TYPE_vkResetEvent_EXT: return "vkResetEvent";
    case VK_COMMAND_TYPE_vkCreateQueryPool_EXT: return "vkCreateQueryPool";
    case VK_COMMAND_TYPE_vkDestroyQueryPool_EXT: return "vkDestroyQueryPool";
    case VK_COMMAND_TYPE_vkGetQueryPoolResults_EXT: return "vkGetQueryPoolResults";
    case VK_COMMAND_TYPE_vkResetQueryPool_EXT: return "vkResetQueryPool";
    case VK_COMMAND_TYPE_vkCreateBuffer_EXT: return "vkCreateBuffer";
    case VK_COMMAND_TYPE_vkDestroyBuffer_EXT: return "vkDestroyBuffer";
    case VK_COMMAND_TYPE_vkCreateBufferView_EXT: return "vkCreateBufferView";
    case VK_COMMAND_TYPE_vkDestroyBufferView_EXT: return "vkDestroyBufferView";
    case VK_COMMAND_TYPE_vkCreateImage_EXT: return "vkCreateImage";
    case VK_COMMAND_TYPE_vkDestroyImage_EXT: return "vkDestroyImage";
    case VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT: return "vkGetImageSubresourceLayout";
    case VK_COMMAND_TYPE_vkCreateImageView_EXT: return "vkCreateImageView";
    case VK_COMMAND_TYPE_vkDestroyImageView_EXT: return "vkDestroyImageView";
    case VK_COMMAND_TYPE_vkCreateShaderModule_EXT: return "vkCreateShaderModule";
    case VK_COMMAND_TYPE_vkDestroyShaderModule_EXT: return "vkDestroyShaderModule";
    case VK_COMMAND_TYPE_vkCreatePipelineCache_EXT: return "vkCreatePipelineCache";
    case VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT: return "vkDestroyPipelineCache";
    case VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT: return "vkGetPipelineCacheData";
    case VK_COMMAND_TYPE_vkMergePipelineCaches_EXT: return "vkMergePipelineCaches";
    case VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT: return "vkCreateGraphicsPipelines";
    case VK_COMMAND_TYPE_vkCreateComputePipelines_EXT: return "vkCreateComputePipelines";
    case VK_COMMAND_TYPE_vkDestroyPipeline_EXT: return "vkDestroyPipeline";
    case VK_COMMAND_TYPE_vkCreatePipelineLayout_EXT: return "vkCreatePipelineLayout";
    case VK_COMMAND_TYPE_vkDestroyPipelineLayout_EXT: return "vkDestroyPipelineLayout";
    case VK_COMMAND_TYPE_vkCreateSampler_EXT: return "vkCreateSampler";
    case VK_COMMAND_TYPE_vkDestroySampler_EXT: return "vkDestroySampler";
    case VK_COMMAND_TYPE_vkCreateDescriptorSetLayout_EXT: return "vkCreateDescriptorSetLayout";
    case VK_COMMAND_TYPE_vkDestroyDescriptorSetLayout_EXT: return "vkDestroyDescriptorSetLayout";
    case VK_COMMAND_TYPE_vkCreateDescriptorPool_EXT: return "vkCreateDescriptorPool";
    case VK_COMMAND_TYPE_vkDestroyDescriptorPool_EXT: return "vkDestroyDescriptorPool";
    case VK_COMMAND_TYPE_vkResetDescriptorPool_EXT: return "vkResetDescriptorPool";
    case VK_COMMAND_TYPE_vkAllocateDescriptorSets_EXT: return "vkAllocateDescriptorSets";
    case VK_COMMAND_TYPE_vkFreeDescriptorSets_EXT: return "vkFreeDescriptorSets";
    case VK_COMMAND_TYPE_vkUpdateDescriptorSets_EXT: return "vkUpdateDescriptorSets";
    case VK_COMMAND_TYPE_vkCreateFramebuffer_EXT: return "vkCreateFramebuffer";
    case VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT: return "vkDestroyFramebuffer";
    case VK_COMMAND_TYPE_vkCreateRenderPass_EXT: return "vkCreateRenderPass";
    case VK_COMMAND_TYPE_vkDestroyRenderPass_EXT: return "vkDestroyRenderPass";
    case VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT: return "vkGetRenderAreaGranularity";
    case VK_COMMAND_TYPE_vkCreateCommandPool_EXT: return "vkCreateCommandPool";
    case VK_COMMAND_TYPE_vkDestroyCommandPool_EXT: return "vkDestroyCommandPool";
    case VK_COMMAND_TYPE_vkResetCommandPool_EXT: return "vkResetCommandPool";
    case VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT: return "vkAllocateCommandBuffers";
    case VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT: return "vkFreeCommandBuffers";
    case VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT: return "vkBeginCommandBuffer";
    case VK_COMMAND_TYPE_vkEndCommandBuffer_EXT: return "vkEndCommandBuffer";
    case VK_COMMAND_TYPE_vkResetCommandBuffer_EXT: return "vkResetCommandBuffer";
    case VK_COMMAND_TYPE_vkCmdBindPipeline_EXT: return "vkCmdBindPipeline";
    case VK_COMMAND_TYPE_vkCmdSetViewport_EXT: return "vkCmdSetViewport";
    case VK_COMMAND_TYPE_vkCmdSetScissor_EXT: return "vkCmdSetScissor";
    case VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT: return "vkCmdSetLineWidth";
    case VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT: return "vkCmdSetDepthBias";
    case VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT: return "vkCmdSetBlendConstants";
    case VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT: return "vkCmdSetDepthBounds";
    case VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT: return "vkCmdSetStencilCompareMask";
    case VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT: return "vkCmdSetStencilWriteMask";
    case VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT: return "vkCmdSetStencilReference";
    case VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT: return "vkCmdBindDescriptorSets";
    case VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT: return "vkCmdBindIndexBuffer";
    case VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT: return "vkCmdBindVertexBuffers";
    case VK_COMMAND_TYPE_vkCmdDraw_EXT: return "vkCmdDraw";
    case VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT: return "vkCmdDrawIndexed";
    case VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT: return "vkCmdDrawMultiEXT";
    case VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT: return "vkCmdDrawMultiIndexedEXT";
    case VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT: return "vkCmdDrawIndirect";
    case VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT: return "vkCmdDrawIndexedIndirect";
    case VK_COMMAND_TYPE_vkCmdDispatch_EXT: return "vkCmdDispatch";
    case VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT: return "vkCmdDispatchIndirect";
    case VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT: return "vkCmdCopyBuffer";
    case VK_COMMAND_TYPE_vkCmdCopyImage_EXT: return "vkCmdCopyImage";
    case VK_COMMAND_TYPE_vkCmdBlitImage_EXT: return "vkCmdBlitImage";
    case VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT: return "vkCmdCopyBufferToImage";
    case VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT: return "vkCmdCopyImageToBuffer";
    case VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT: return "vkCmdUpdateBuffer";
    case VK_COMMAND_TYPE_vkCmdFillBuffer_EXT: return "vkCmdFillBuffer";
    case VK_COMMAND_TYPE_vkCmdClearColorImage_EXT: return "vkCmdClearColorImage";
    case VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT: return "vkCmdClearDepthStencilImage";
    case VK_COMMAND_TYPE_vkCmdClearAttachments_EXT: return "vkCmdClearAttachments";
    case VK_COMMAND_TYPE_vkCmdResolveImage_EXT: return "vkCmdResolveImage";
    case VK_COMMAND_TYPE_vkCmdSetEvent_EXT: return "vkCmdSetEvent";
    case VK_COMMAND_TYPE_vkCmdResetEvent_EXT: return "vkCmdResetEvent";
    case VK_COMMAND_TYPE_vkCmdWaitEvents_EXT: return "vkCmdWaitEvents";
    case VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT: return "vkCmdPipelineBarrier";
    case VK_COMMAND_TYPE_vkCmdBeginQuery_EXT: return "vkCmdBeginQuery";
    case VK_COMMAND_TYPE_vkCmdEndQuery_EXT: return "vkCmdEndQuery";
    case VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT: return "vkCmdBeginConditionalRenderingEXT";
    case VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT: return "vkCmdEndConditionalRenderingEXT";
    case VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT: return "vkCmdResetQueryPool";
    case VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT: return "vkCmdWriteTimestamp";
    case VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT: return "vkCmdCopyQueryPoolResults";
    case VK_COMMAND_TYPE_vkCmdPushConstants_EXT: return "vkCmdPushConstants";
    case VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT: return "vkCmdBeginRenderPass";
    case VK_COMMAND_TYPE_vkCmdNextSubpass_EXT: return "vkCmdNextSubpass";
    case VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT: return "vkCmdEndRenderPass";
    case VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT: return "vkCmdExecuteCommands";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT: return "vkGetPhysicalDeviceFeatures2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT: return "vkGetPhysicalDeviceProperties2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT: return "vkGetPhysicalDeviceFormatProperties2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT: return "vkGetPhysicalDeviceImageFormatProperties2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT: return "vkGetPhysicalDeviceQueueFamilyProperties2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT: return "vkGetPhysicalDeviceMemoryProperties2";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT: return "vkGetPhysicalDeviceSparseImageFormatProperties2";
    case VK_COMMAND_TYPE_vkCmdPushDescriptorSetKHR_EXT: return "vkCmdPushDescriptorSetKHR";
    case VK_COMMAND_TYPE_vkTrimCommandPool_EXT: return "vkTrimCommandPool";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT: return "vkGetPhysicalDeviceExternalBufferProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT: return "vkGetPhysicalDeviceExternalSemaphoreProperties";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT: return "vkGetPhysicalDeviceExternalFenceProperties";
    case VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT: return "vkEnumeratePhysicalDeviceGroups";
    case VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT: return "vkGetDeviceGroupPeerMemoryFeatures";
    case VK_COMMAND_TYPE_vkBindBufferMemory2_EXT: return "vkBindBufferMemory2";
    case VK_COMMAND_TYPE_vkBindImageMemory2_EXT: return "vkBindImageMemory2";
    case VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT: return "vkCmdSetDeviceMask";
    case VK_COMMAND_TYPE_vkCmdDispatchBase_EXT: return "vkCmdDispatchBase";
    case VK_COMMAND_TYPE_vkCreateDescriptorUpdateTemplate_EXT: return "vkCreateDescriptorUpdateTemplate";
    case VK_COMMAND_TYPE_vkDestroyDescriptorUpdateTemplate_EXT: return "vkDestroyDescriptorUpdateTemplate";
    case VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT: return "vkGetBufferMemoryRequirements2";
    case VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT: return "vkGetImageMemoryRequirements2";
    case VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT: return "vkGetImageSparseMemoryRequirements2";
    case VK_COMMAND_TYPE_vkGetDeviceBufferMemoryRequirements_EXT: return "vkGetDeviceBufferMemoryRequirements";
    case VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT: return "vkGetDeviceImageMemoryRequirements";
    case VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT: return "vkGetDeviceImageSparseMemoryRequirements";
    case VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT: return "vkCreateSamplerYcbcrConversion";
    case VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT: return "vkDestroySamplerYcbcrConversion";
    case VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT: return "vkGetDeviceQueue2";
    case VK_COMMAND_TYPE_vkGetDescriptorSetLayoutSupport_EXT: return "vkGetDescriptorSetLayoutSupport";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_EXT: return "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT";
    case VK_COMMAND_TYPE_vkGetCalibratedTimestampsEXT_EXT: return "vkGetCalibratedTimestampsEXT";
    case VK_COMMAND_TYPE_vkCreateRenderPass2_EXT: return "vkCreateRenderPass2";
    case VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT: return "vkCmdBeginRenderPass2";
    case VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT: return "vkCmdNextSubpass2";
    case VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT: return "vkCmdEndRenderPass2";
    case VK_COMMAND_TYPE_vkGetSemaphoreCounterValue_EXT: return "vkGetSemaphoreCounterValue";
    case VK_COMMAND_TYPE_vkWaitSemaphores_EXT: return "vkWaitSemaphores";
    case VK_COMMAND_TYPE_vkSignalSemaphore_EXT: return "vkSignalSemaphore";
    case VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT: return "vkCmdDrawIndirectCount";
    case VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT: return "vkCmdDrawIndexedIndirectCount";
    case VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT: return "vkCmdBindTransformFeedbackBuffersEXT";
    case VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT: return "vkCmdBeginTransformFeedbackEXT";
    case VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT: return "vkCmdEndTransformFeedbackEXT";
    case VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT: return "vkCmdBeginQueryIndexedEXT";
    case VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT: return "vkCmdEndQueryIndexedEXT";
    case VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT: return "vkCmdDrawIndirectByteCountEXT";
    case VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT: return "vkGetImageDrmFormatModifierPropertiesEXT";
    case VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT: return "vkGetBufferOpaqueCaptureAddress";
    case VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT: return "vkGetBufferDeviceAddress";
    case VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT: return "vkGetDeviceMemoryOpaqueCaptureAddress";
    case VK_COMMAND_TYPE_vkCmdSetLineStippleEXT_EXT: return "vkCmdSetLineStippleEXT";
    case VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT: return "vkGetPhysicalDeviceToolProperties";
    case VK_COMMAND_TYPE_vkCmdSetCullMode_EXT: return "vkCmdSetCullMode";
    case VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT: return "vkCmdSetFrontFace";
    case VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT: return "vkCmdSetPrimitiveTopology";
    case VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT: return "vkCmdSetViewportWithCount";
    case VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT: return "vkCmdSetScissorWithCount";
    case VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT: return "vkCmdBindVertexBuffers2";
    case VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT: return "vkCmdSetDepthTestEnable";
    case VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT: return "vkCmdSetDepthWriteEnable";
    case VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT: return "vkCmdSetDepthCompareOp";
    case VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT: return "vkCmdSetDepthBoundsTestEnable";
    case VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT: return "vkCmdSetStencilTestEnable";
    case VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT: return "vkCmdSetStencilOp";
    case VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT: return "vkCmdSetPatchControlPointsEXT";
    case VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT: return "vkCmdSetRasterizerDiscardEnable";
    case VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT: return "vkCmdSetDepthBiasEnable";
    case VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT: return "vkCmdSetLogicOpEXT";
    case VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT: return "vkCmdSetPrimitiveRestartEnable";
    case VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT: return "vkCreatePrivateDataSlot";
    case VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT: return "vkDestroyPrivateDataSlot";
    case VK_COMMAND_TYPE_vkSetPrivateData_EXT: return "vkSetPrivateData";
    case VK_COMMAND_TYPE_vkGetPrivateData_EXT: return "vkGetPrivateData";
    case VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT: return "vkCmdCopyBuffer2";
    case VK_COMMAND_TYPE_vkCmdCopyImage2_EXT: return "vkCmdCopyImage2";
    case VK_COMMAND_TYPE_vkCmdBlitImage2_EXT: return "vkCmdBlitImage2";
    case VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT: return "vkCmdCopyBufferToImage2";
    case VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT: return "vkCmdCopyImageToBuffer2";
    case VK_COMMAND_TYPE_vkCmdResolveImage2_EXT: return "vkCmdResolveImage2";
    case VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT: return "vkCmdSetColorWriteEnableEXT";
    case VK_COMMAND_TYPE_vkCmdSetEvent2_EXT: return "vkCmdSetEvent2";
    case VK_COMMAND_TYPE_vkCmdResetEvent2_EXT: return "vkCmdResetEvent2";
    case VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT: return "vkCmdWaitEvents2";
    case VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT: return "vkCmdPipelineBarrier2";
    case VK_COMMAND_TYPE_vkQueueSubmit2_EXT: return "vkQueueSubmit2";
    case VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT: return "vkCmdWriteTimestamp2";
    case VK_COMMAND_TYPE_vkCmdBeginRendering_EXT: return "vkCmdBeginRendering";
    case VK_COMMAND_TYPE_vkCmdEndRendering_EXT: return "vkCmdEndRendering";
    case VK_COMMAND_TYPE_vkSetReplyCommandStreamMESA_EXT: return "vkSetReplyCommandStreamMESA";
    case VK_COMMAND_TYPE_vkSeekReplyCommandStreamMESA_EXT: return "vkSeekReplyCommandStreamMESA";
    case VK_COMMAND_TYPE_vkExecuteCommandStreamsMESA_EXT: return "vkExecuteCommandStreamsMESA";
    case VK_COMMAND_TYPE_vkCreateRingMESA_EXT: return "vkCreateRingMESA";
    case VK_COMMAND_TYPE_vkDestroyRingMESA_EXT: return "vkDestroyRingMESA";
    case VK_COMMAND_TYPE_vkNotifyRingMESA_EXT: return "vkNotifyRingMESA";
    case VK_COMMAND_TYPE_vkWriteRingExtraMESA_EXT: return "vkWriteRingExtraMESA";
    case VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT: return "vkGetMemoryResourcePropertiesMESA";
    case VK_COMMAND_TYPE_vkResetFenceResourceMESA_EXT: return "vkResetFenceResourceMESA";
    case VK_COMMAND_TYPE_vkWaitSemaphoreResourceMESA_EXT: return "vkWaitSemaphoreResourceMESA";
    case VK_COMMAND_TYPE_vkImportSemaphoreResourceMESA_EXT: return "vkImportSemaphoreResourceMESA";
    case VK_COMMAND_TYPE_vkSubmitVirtqueueSeqnoMESA_EXT: return "vkSubmitVirtqueueSeqnoMESA";
    case VK_COMMAND_TYPE_vkWaitVirtqueueSeqnoMESA_EXT: return "vkWaitVirtqueueSeqnoMESA";
    case VK_COMMAND_TYPE_vkWaitRingSeqnoMESA_EXT: return "vkWaitRingSeqnoMESA";
    case VK_COMMAND_TYPE_vkGetDeviceProcAddr_EXT: return "vkGetDeviceProcAddr";
    case VK_COMMAND_TYPE_vkGetInstanceProcAddr_EXT: return "vkGetInstanceProcAddr";
    case VK_COMMAND_TYPE_vkMapMemory_EXT: return "vkMapMemory";
    case VK_COMMAND_TYPE_vkGetMemoryFdKHR_EXT: return "vkGetMemoryFdKHR";
    case VK_COMMAND_TYPE_vkGetMemoryFdPropertiesKHR_EXT: return "vkGetMemoryFdPropertiesKHR";
    case VK_COMMAND_TYPE_vkGetSemaphoreFdKHR_EXT: return "vkGetSemaphoreFdKHR";
    case VK_COMMAND_TYPE_vkImportSemaphoreFdKHR_EXT: return "vkImportSemaphoreFdKHR";
    case VK_COMMAND_TYPE_vkGetFenceFdKHR_EXT: return "vkGetFenceFdKHR";
    case VK_COMMAND_TYPE_vkImportFenceFdKHR_EXT: return "vkImportFenceFdKHR";
    case VK_COMMAND_TYPE_vkUpdateDescriptorSetWithTemplate_EXT: return "vkUpdateDescriptorSetWithTemplate";
    case VK_COMMAND_TYPE_vkCmdPushDescriptorSetWithTemplateKHR_EXT: return "vkCmdPushDescriptorSetWithTemplateKHR";
    default: return "unknown";
    }
}

static void (*const vn_dispatch_table[255])(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags) = {
    [VK_COMMAND_TYPE_vkCreateInstance_EXT] = vn_dispatch_vkCreateInstance,
    [VK_COMMAND_TYPE_vkDestroyInstance_EXT] = vn_dispatch_vkDestroyInstance,
    [VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT] = vn_dispatch_vkEnumeratePhysicalDevices,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceMemoryProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT] = vn_dispatch_vkGetPhysicalDeviceFeatures,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceFormatProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceImageFormatProperties,
    [VK_COMMAND_TYPE_vkCreateDevice_EXT] = vn_dispatch_vkCreateDevice,
    [VK_COMMAND_TYPE_vkDestroyDevice_EXT] = vn_dispatch_vkDestroyDevice,
    [VK_COMMAND_TYPE_vkEnumerateInstanceVersion_EXT] = vn_dispatch_vkEnumerateInstanceVersion,
    [VK_COMMAND_TYPE_vkEnumerateInstanceLayerProperties_EXT] = vn_dispatch_vkEnumerateInstanceLayerProperties,
    [VK_COMMAND_TYPE_vkEnumerateInstanceExtensionProperties_EXT] = vn_dispatch_vkEnumerateInstanceExtensionProperties,
    [VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT] = vn_dispatch_vkEnumerateDeviceLayerProperties,
    [VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT] = vn_dispatch_vkEnumerateDeviceExtensionProperties,
    [VK_COMMAND_TYPE_vkGetDeviceQueue_EXT] = vn_dispatch_vkGetDeviceQueue,
    [VK_COMMAND_TYPE_vkQueueSubmit_EXT] = vn_dispatch_vkQueueSubmit,
    [VK_COMMAND_TYPE_vkQueueWaitIdle_EXT] = vn_dispatch_vkQueueWaitIdle,
    [VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT] = vn_dispatch_vkDeviceWaitIdle,
    [VK_COMMAND_TYPE_vkAllocateMemory_EXT] = vn_dispatch_vkAllocateMemory,
    [VK_COMMAND_TYPE_vkFreeMemory_EXT] = vn_dispatch_vkFreeMemory,
    [VK_COMMAND_TYPE_vkUnmapMemory_EXT] = vn_dispatch_vkUnmapMemory,
    [VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT] = vn_dispatch_vkFlushMappedMemoryRanges,
    [VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT] = vn_dispatch_vkInvalidateMappedMemoryRanges,
    [VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT] = vn_dispatch_vkGetDeviceMemoryCommitment,
    [VK_COMMAND_TYPE_vkGetBufferMemoryRequirements_EXT] = vn_dispatch_vkGetBufferMemoryRequirements,
    [VK_COMMAND_TYPE_vkBindBufferMemory_EXT] = vn_dispatch_vkBindBufferMemory,
    [VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT] = vn_dispatch_vkGetImageMemoryRequirements,
    [VK_COMMAND_TYPE_vkBindImageMemory_EXT] = vn_dispatch_vkBindImageMemory,
    [VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT] = vn_dispatch_vkGetImageSparseMemoryRequirements,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties,
    [VK_COMMAND_TYPE_vkQueueBindSparse_EXT] = vn_dispatch_vkQueueBindSparse,
    [VK_COMMAND_TYPE_vkCreateFence_EXT] = vn_dispatch_vkCreateFence,
    [VK_COMMAND_TYPE_vkDestroyFence_EXT] = vn_dispatch_vkDestroyFence,
    [VK_COMMAND_TYPE_vkResetFences_EXT] = vn_dispatch_vkResetFences,
    [VK_COMMAND_TYPE_vkGetFenceStatus_EXT] = vn_dispatch_vkGetFenceStatus,
    [VK_COMMAND_TYPE_vkWaitForFences_EXT] = vn_dispatch_vkWaitForFences,
    [VK_COMMAND_TYPE_vkCreateSemaphore_EXT] = vn_dispatch_vkCreateSemaphore,
    [VK_COMMAND_TYPE_vkDestroySemaphore_EXT] = vn_dispatch_vkDestroySemaphore,
    [VK_COMMAND_TYPE_vkCreateEvent_EXT] = vn_dispatch_vkCreateEvent,
    [VK_COMMAND_TYPE_vkDestroyEvent_EXT] = vn_dispatch_vkDestroyEvent,
    [VK_COMMAND_TYPE_vkGetEventStatus_EXT] = vn_dispatch_vkGetEventStatus,
    [VK_COMMAND_TYPE_vkSetEvent_EXT] = vn_dispatch_vkSetEvent,
    [VK_COMMAND_TYPE_vkResetEvent_EXT] = vn_dispatch_vkResetEvent,
    [VK_COMMAND_TYPE_vkCreateQueryPool_EXT] = vn_dispatch_vkCreateQueryPool,
    [VK_COMMAND_TYPE_vkDestroyQueryPool_EXT] = vn_dispatch_vkDestroyQueryPool,
    [VK_COMMAND_TYPE_vkGetQueryPoolResults_EXT] = vn_dispatch_vkGetQueryPoolResults,
    [VK_COMMAND_TYPE_vkResetQueryPool_EXT] = vn_dispatch_vkResetQueryPool,
    [VK_COMMAND_TYPE_vkCreateBuffer_EXT] = vn_dispatch_vkCreateBuffer,
    [VK_COMMAND_TYPE_vkDestroyBuffer_EXT] = vn_dispatch_vkDestroyBuffer,
    [VK_COMMAND_TYPE_vkCreateBufferView_EXT] = vn_dispatch_vkCreateBufferView,
    [VK_COMMAND_TYPE_vkDestroyBufferView_EXT] = vn_dispatch_vkDestroyBufferView,
    [VK_COMMAND_TYPE_vkCreateImage_EXT] = vn_dispatch_vkCreateImage,
    [VK_COMMAND_TYPE_vkDestroyImage_EXT] = vn_dispatch_vkDestroyImage,
    [VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT] = vn_dispatch_vkGetImageSubresourceLayout,
    [VK_COMMAND_TYPE_vkCreateImageView_EXT] = vn_dispatch_vkCreateImageView,
    [VK_COMMAND_TYPE_vkDestroyImageView_EXT] = vn_dispatch_vkDestroyImageView,
    [VK_COMMAND_TYPE_vkCreateShaderModule_EXT] = vn_dispatch_vkCreateShaderModule,
    [VK_COMMAND_TYPE_vkDestroyShaderModule_EXT] = vn_dispatch_vkDestroyShaderModule,
    [VK_COMMAND_TYPE_vkCreatePipelineCache_EXT] = vn_dispatch_vkCreatePipelineCache,
    [VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT] = vn_dispatch_vkDestroyPipelineCache,
    [VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT] = vn_dispatch_vkGetPipelineCacheData,
    [VK_COMMAND_TYPE_vkMergePipelineCaches_EXT] = vn_dispatch_vkMergePipelineCaches,
    [VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT] = vn_dispatch_vkCreateGraphicsPipelines,
    [VK_COMMAND_TYPE_vkCreateComputePipelines_EXT] = vn_dispatch_vkCreateComputePipelines,
    [VK_COMMAND_TYPE_vkDestroyPipeline_EXT] = vn_dispatch_vkDestroyPipeline,
    [VK_COMMAND_TYPE_vkCreatePipelineLayout_EXT] = vn_dispatch_vkCreatePipelineLayout,
    [VK_COMMAND_TYPE_vkDestroyPipelineLayout_EXT] = vn_dispatch_vkDestroyPipelineLayout,
    [VK_COMMAND_TYPE_vkCreateSampler_EXT] = vn_dispatch_vkCreateSampler,
    [VK_COMMAND_TYPE_vkDestroySampler_EXT] = vn_dispatch_vkDestroySampler,
    [VK_COMMAND_TYPE_vkCreateDescriptorSetLayout_EXT] = vn_dispatch_vkCreateDescriptorSetLayout,
    [VK_COMMAND_TYPE_vkDestroyDescriptorSetLayout_EXT] = vn_dispatch_vkDestroyDescriptorSetLayout,
    [VK_COMMAND_TYPE_vkCreateDescriptorPool_EXT] = vn_dispatch_vkCreateDescriptorPool,
    [VK_COMMAND_TYPE_vkDestroyDescriptorPool_EXT] = vn_dispatch_vkDestroyDescriptorPool,
    [VK_COMMAND_TYPE_vkResetDescriptorPool_EXT] = vn_dispatch_vkResetDescriptorPool,
    [VK_COMMAND_TYPE_vkAllocateDescriptorSets_EXT] = vn_dispatch_vkAllocateDescriptorSets,
    [VK_COMMAND_TYPE_vkFreeDescriptorSets_EXT] = vn_dispatch_vkFreeDescriptorSets,
    [VK_COMMAND_TYPE_vkUpdateDescriptorSets_EXT] = vn_dispatch_vkUpdateDescriptorSets,
    [VK_COMMAND_TYPE_vkCreateFramebuffer_EXT] = vn_dispatch_vkCreateFramebuffer,
    [VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT] = vn_dispatch_vkDestroyFramebuffer,
    [VK_COMMAND_TYPE_vkCreateRenderPass_EXT] = vn_dispatch_vkCreateRenderPass,
    [VK_COMMAND_TYPE_vkDestroyRenderPass_EXT] = vn_dispatch_vkDestroyRenderPass,
    [VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT] = vn_dispatch_vkGetRenderAreaGranularity,
    [VK_COMMAND_TYPE_vkCreateCommandPool_EXT] = vn_dispatch_vkCreateCommandPool,
    [VK_COMMAND_TYPE_vkDestroyCommandPool_EXT] = vn_dispatch_vkDestroyCommandPool,
    [VK_COMMAND_TYPE_vkResetCommandPool_EXT] = vn_dispatch_vkResetCommandPool,
    [VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT] = vn_dispatch_vkAllocateCommandBuffers,
    [VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT] = vn_dispatch_vkFreeCommandBuffers,
    [VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT] = vn_dispatch_vkBeginCommandBuffer,
    [VK_COMMAND_TYPE_vkEndCommandBuffer_EXT] = vn_dispatch_vkEndCommandBuffer,
    [VK_COMMAND_TYPE_vkResetCommandBuffer_EXT] = vn_dispatch_vkResetCommandBuffer,
    [VK_COMMAND_TYPE_vkCmdBindPipeline_EXT] = vn_dispatch_vkCmdBindPipeline,
    [VK_COMMAND_TYPE_vkCmdSetViewport_EXT] = vn_dispatch_vkCmdSetViewport,
    [VK_COMMAND_TYPE_vkCmdSetScissor_EXT] = vn_dispatch_vkCmdSetScissor,
    [VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT] = vn_dispatch_vkCmdSetLineWidth,
    [VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT] = vn_dispatch_vkCmdSetDepthBias,
    [VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT] = vn_dispatch_vkCmdSetBlendConstants,
    [VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT] = vn_dispatch_vkCmdSetDepthBounds,
    [VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT] = vn_dispatch_vkCmdSetStencilCompareMask,
    [VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT] = vn_dispatch_vkCmdSetStencilWriteMask,
    [VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT] = vn_dispatch_vkCmdSetStencilReference,
    [VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT] = vn_dispatch_vkCmdBindDescriptorSets,
    [VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT] = vn_dispatch_vkCmdBindIndexBuffer,
    [VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT] = vn_dispatch_vkCmdBindVertexBuffers,
    [VK_COMMAND_TYPE_vkCmdDraw_EXT] = vn_dispatch_vkCmdDraw,
    [VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT] = vn_dispatch_vkCmdDrawIndexed,
    [VK_COMMAND_TYPE_vkCmdDrawMultiEXT_EXT] = vn_dispatch_vkCmdDrawMultiEXT,
    [VK_COMMAND_TYPE_vkCmdDrawMultiIndexedEXT_EXT] = vn_dispatch_vkCmdDrawMultiIndexedEXT,
    [VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT] = vn_dispatch_vkCmdDrawIndirect,
    [VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT] = vn_dispatch_vkCmdDrawIndexedIndirect,
    [VK_COMMAND_TYPE_vkCmdDispatch_EXT] = vn_dispatch_vkCmdDispatch,
    [VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT] = vn_dispatch_vkCmdDispatchIndirect,
    [VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT] = vn_dispatch_vkCmdCopyBuffer,
    [VK_COMMAND_TYPE_vkCmdCopyImage_EXT] = vn_dispatch_vkCmdCopyImage,
    [VK_COMMAND_TYPE_vkCmdBlitImage_EXT] = vn_dispatch_vkCmdBlitImage,
    [VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT] = vn_dispatch_vkCmdCopyBufferToImage,
    [VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT] = vn_dispatch_vkCmdCopyImageToBuffer,
    [VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT] = vn_dispatch_vkCmdUpdateBuffer,
    [VK_COMMAND_TYPE_vkCmdFillBuffer_EXT] = vn_dispatch_vkCmdFillBuffer,
    [VK_COMMAND_TYPE_vkCmdClearColorImage_EXT] = vn_dispatch_vkCmdClearColorImage,
    [VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT] = vn_dispatch_vkCmdClearDepthStencilImage,
    [VK_COMMAND_TYPE_vkCmdClearAttachments_EXT] = vn_dispatch_vkCmdClearAttachments,
    [VK_COMMAND_TYPE_vkCmdResolveImage_EXT] = vn_dispatch_vkCmdResolveImage,
    [VK_COMMAND_TYPE_vkCmdSetEvent_EXT] = vn_dispatch_vkCmdSetEvent,
    [VK_COMMAND_TYPE_vkCmdResetEvent_EXT] = vn_dispatch_vkCmdResetEvent,
    [VK_COMMAND_TYPE_vkCmdWaitEvents_EXT] = vn_dispatch_vkCmdWaitEvents,
    [VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT] = vn_dispatch_vkCmdPipelineBarrier,
    [VK_COMMAND_TYPE_vkCmdBeginQuery_EXT] = vn_dispatch_vkCmdBeginQuery,
    [VK_COMMAND_TYPE_vkCmdEndQuery_EXT] = vn_dispatch_vkCmdEndQuery,
    [VK_COMMAND_TYPE_vkCmdBeginConditionalRenderingEXT_EXT] = vn_dispatch_vkCmdBeginConditionalRenderingEXT,
    [VK_COMMAND_TYPE_vkCmdEndConditionalRenderingEXT_EXT] = vn_dispatch_vkCmdEndConditionalRenderingEXT,
    [VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT] = vn_dispatch_vkCmdResetQueryPool,
    [VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT] = vn_dispatch_vkCmdWriteTimestamp,
    [VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT] = vn_dispatch_vkCmdCopyQueryPoolResults,
    [VK_COMMAND_TYPE_vkCmdPushConstants_EXT] = vn_dispatch_vkCmdPushConstants,
    [VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT] = vn_dispatch_vkCmdBeginRenderPass,
    [VK_COMMAND_TYPE_vkCmdNextSubpass_EXT] = vn_dispatch_vkCmdNextSubpass,
    [VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT] = vn_dispatch_vkCmdEndRenderPass,
    [VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT] = vn_dispatch_vkCmdExecuteCommands,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT] = vn_dispatch_vkGetPhysicalDeviceFeatures2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceProperties2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceFormatProperties2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceImageFormatProperties2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceMemoryProperties2,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT] = vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2,
    [VK_COMMAND_TYPE_vkCmdPushDescriptorSetKHR_EXT] = vn_dispatch_vkCmdPushDescriptorSetKHR,
    [VK_COMMAND_TYPE_vkTrimCommandPool_EXT] = vn_dispatch_vkTrimCommandPool,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceExternalBufferProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceExternalFenceProperties,
    [VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT] = vn_dispatch_vkEnumeratePhysicalDeviceGroups,
    [VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT] = vn_dispatch_vkGetDeviceGroupPeerMemoryFeatures,
    [VK_COMMAND_TYPE_vkBindBufferMemory2_EXT] = vn_dispatch_vkBindBufferMemory2,
    [VK_COMMAND_TYPE_vkBindImageMemory2_EXT] = vn_dispatch_vkBindImageMemory2,
    [VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT] = vn_dispatch_vkCmdSetDeviceMask,
    [VK_COMMAND_TYPE_vkCmdDispatchBase_EXT] = vn_dispatch_vkCmdDispatchBase,
    [VK_COMMAND_TYPE_vkCreateDescriptorUpdateTemplate_EXT] = vn_dispatch_vkCreateDescriptorUpdateTemplate,
    [VK_COMMAND_TYPE_vkDestroyDescriptorUpdateTemplate_EXT] = vn_dispatch_vkDestroyDescriptorUpdateTemplate,
    [VK_COMMAND_TYPE_vkGetBufferMemoryRequirements2_EXT] = vn_dispatch_vkGetBufferMemoryRequirements2,
    [VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT] = vn_dispatch_vkGetImageMemoryRequirements2,
    [VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT] = vn_dispatch_vkGetImageSparseMemoryRequirements2,
    [VK_COMMAND_TYPE_vkGetDeviceBufferMemoryRequirements_EXT] = vn_dispatch_vkGetDeviceBufferMemoryRequirements,
    [VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT] = vn_dispatch_vkGetDeviceImageMemoryRequirements,
    [VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT] = vn_dispatch_vkGetDeviceImageSparseMemoryRequirements,
    [VK_COMMAND_TYPE_vkCreateSamplerYcbcrConversion_EXT] = vn_dispatch_vkCreateSamplerYcbcrConversion,
    [VK_COMMAND_TYPE_vkDestroySamplerYcbcrConversion_EXT] = vn_dispatch_vkDestroySamplerYcbcrConversion,
    [VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT] = vn_dispatch_vkGetDeviceQueue2,
    [VK_COMMAND_TYPE_vkGetDescriptorSetLayoutSupport_EXT] = vn_dispatch_vkGetDescriptorSetLayoutSupport,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_EXT] = vn_dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT,
    [VK_COMMAND_TYPE_vkGetCalibratedTimestampsEXT_EXT] = vn_dispatch_vkGetCalibratedTimestampsEXT,
    [VK_COMMAND_TYPE_vkCreateRenderPass2_EXT] = vn_dispatch_vkCreateRenderPass2,
    [VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT] = vn_dispatch_vkCmdBeginRenderPass2,
    [VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT] = vn_dispatch_vkCmdNextSubpass2,
    [VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT] = vn_dispatch_vkCmdEndRenderPass2,
    [VK_COMMAND_TYPE_vkGetSemaphoreCounterValue_EXT] = vn_dispatch_vkGetSemaphoreCounterValue,
    [VK_COMMAND_TYPE_vkWaitSemaphores_EXT] = vn_dispatch_vkWaitSemaphores,
    [VK_COMMAND_TYPE_vkSignalSemaphore_EXT] = vn_dispatch_vkSignalSemaphore,
    [VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT] = vn_dispatch_vkCmdDrawIndirectCount,
    [VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT] = vn_dispatch_vkCmdDrawIndexedIndirectCount,
    [VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT] = vn_dispatch_vkCmdBindTransformFeedbackBuffersEXT,
    [VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT] = vn_dispatch_vkCmdBeginTransformFeedbackEXT,
    [VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT] = vn_dispatch_vkCmdEndTransformFeedbackEXT,
    [VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT] = vn_dispatch_vkCmdBeginQueryIndexedEXT,
    [VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT] = vn_dispatch_vkCmdEndQueryIndexedEXT,
    [VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT] = vn_dispatch_vkCmdDrawIndirectByteCountEXT,
    [VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT] = vn_dispatch_vkGetImageDrmFormatModifierPropertiesEXT,
    [VK_COMMAND_TYPE_vkGetBufferOpaqueCaptureAddress_EXT] = vn_dispatch_vkGetBufferOpaqueCaptureAddress,
    [VK_COMMAND_TYPE_vkGetBufferDeviceAddress_EXT] = vn_dispatch_vkGetBufferDeviceAddress,
    [VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT] = vn_dispatch_vkGetDeviceMemoryOpaqueCaptureAddress,
    [VK_COMMAND_TYPE_vkCmdSetLineStippleEXT_EXT] = vn_dispatch_vkCmdSetLineStippleEXT,
    [VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT] = vn_dispatch_vkGetPhysicalDeviceToolProperties,
    [VK_COMMAND_TYPE_vkCmdSetCullMode_EXT] = vn_dispatch_vkCmdSetCullMode,
    [VK_COMMAND_TYPE_vkCmdSetFrontFace_EXT] = vn_dispatch_vkCmdSetFrontFace,
    [VK_COMMAND_TYPE_vkCmdSetPrimitiveTopology_EXT] = vn_dispatch_vkCmdSetPrimitiveTopology,
    [VK_COMMAND_TYPE_vkCmdSetViewportWithCount_EXT] = vn_dispatch_vkCmdSetViewportWithCount,
    [VK_COMMAND_TYPE_vkCmdSetScissorWithCount_EXT] = vn_dispatch_vkCmdSetScissorWithCount,
    [VK_COMMAND_TYPE_vkCmdBindVertexBuffers2_EXT] = vn_dispatch_vkCmdBindVertexBuffers2,
    [VK_COMMAND_TYPE_vkCmdSetDepthTestEnable_EXT] = vn_dispatch_vkCmdSetDepthTestEnable,
    [VK_COMMAND_TYPE_vkCmdSetDepthWriteEnable_EXT] = vn_dispatch_vkCmdSetDepthWriteEnable,
    [VK_COMMAND_TYPE_vkCmdSetDepthCompareOp_EXT] = vn_dispatch_vkCmdSetDepthCompareOp,
    [VK_COMMAND_TYPE_vkCmdSetDepthBoundsTestEnable_EXT] = vn_dispatch_vkCmdSetDepthBoundsTestEnable,
    [VK_COMMAND_TYPE_vkCmdSetStencilTestEnable_EXT] = vn_dispatch_vkCmdSetStencilTestEnable,
    [VK_COMMAND_TYPE_vkCmdSetStencilOp_EXT] = vn_dispatch_vkCmdSetStencilOp,
    [VK_COMMAND_TYPE_vkCmdSetPatchControlPointsEXT_EXT] = vn_dispatch_vkCmdSetPatchControlPointsEXT,
    [VK_COMMAND_TYPE_vkCmdSetRasterizerDiscardEnable_EXT] = vn_dispatch_vkCmdSetRasterizerDiscardEnable,
    [VK_COMMAND_TYPE_vkCmdSetDepthBiasEnable_EXT] = vn_dispatch_vkCmdSetDepthBiasEnable,
    [VK_COMMAND_TYPE_vkCmdSetLogicOpEXT_EXT] = vn_dispatch_vkCmdSetLogicOpEXT,
    [VK_COMMAND_TYPE_vkCmdSetPrimitiveRestartEnable_EXT] = vn_dispatch_vkCmdSetPrimitiveRestartEnable,
    [VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT] = vn_dispatch_vkCreatePrivateDataSlot,
    [VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT] = vn_dispatch_vkDestroyPrivateDataSlot,
    [VK_COMMAND_TYPE_vkSetPrivateData_EXT] = vn_dispatch_vkSetPrivateData,
    [VK_COMMAND_TYPE_vkGetPrivateData_EXT] = vn_dispatch_vkGetPrivateData,
    [VK_COMMAND_TYPE_vkCmdCopyBuffer2_EXT] = vn_dispatch_vkCmdCopyBuffer2,
    [VK_COMMAND_TYPE_vkCmdCopyImage2_EXT] = vn_dispatch_vkCmdCopyImage2,
    [VK_COMMAND_TYPE_vkCmdBlitImage2_EXT] = vn_dispatch_vkCmdBlitImage2,
    [VK_COMMAND_TYPE_vkCmdCopyBufferToImage2_EXT] = vn_dispatch_vkCmdCopyBufferToImage2,
    [VK_COMMAND_TYPE_vkCmdCopyImageToBuffer2_EXT] = vn_dispatch_vkCmdCopyImageToBuffer2,
    [VK_COMMAND_TYPE_vkCmdResolveImage2_EXT] = vn_dispatch_vkCmdResolveImage2,
    [VK_COMMAND_TYPE_vkCmdSetColorWriteEnableEXT_EXT] = vn_dispatch_vkCmdSetColorWriteEnableEXT,
    [VK_COMMAND_TYPE_vkCmdSetEvent2_EXT] = vn_dispatch_vkCmdSetEvent2,
    [VK_COMMAND_TYPE_vkCmdResetEvent2_EXT] = vn_dispatch_vkCmdResetEvent2,
    [VK_COMMAND_TYPE_vkCmdWaitEvents2_EXT] = vn_dispatch_vkCmdWaitEvents2,
    [VK_COMMAND_TYPE_vkCmdPipelineBarrier2_EXT] = vn_dispatch_vkCmdPipelineBarrier2,
    [VK_COMMAND_TYPE_vkQueueSubmit2_EXT] = vn_dispatch_vkQueueSubmit2,
    [VK_COMMAND_TYPE_vkCmdWriteTimestamp2_EXT] = vn_dispatch_vkCmdWriteTimestamp2,
    [VK_COMMAND_TYPE_vkCmdBeginRendering_EXT] = vn_dispatch_vkCmdBeginRendering,
    [VK_COMMAND_TYPE_vkCmdEndRendering_EXT] = vn_dispatch_vkCmdEndRendering,
    [VK_COMMAND_TYPE_vkSetReplyCommandStreamMESA_EXT] = vn_dispatch_vkSetReplyCommandStreamMESA,
    [VK_COMMAND_TYPE_vkSeekReplyCommandStreamMESA_EXT] = vn_dispatch_vkSeekReplyCommandStreamMESA,
    [VK_COMMAND_TYPE_vkExecuteCommandStreamsMESA_EXT] = vn_dispatch_vkExecuteCommandStreamsMESA,
    [VK_COMMAND_TYPE_vkCreateRingMESA_EXT] = vn_dispatch_vkCreateRingMESA,
    [VK_COMMAND_TYPE_vkDestroyRingMESA_EXT] = vn_dispatch_vkDestroyRingMESA,
    [VK_COMMAND_TYPE_vkNotifyRingMESA_EXT] = vn_dispatch_vkNotifyRingMESA,
    [VK_COMMAND_TYPE_vkWriteRingExtraMESA_EXT] = vn_dispatch_vkWriteRingExtraMESA,
    [VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT] = vn_dispatch_vkGetMemoryResourcePropertiesMESA,
    [VK_COMMAND_TYPE_vkResetFenceResourceMESA_EXT] = vn_dispatch_vkResetFenceResourceMESA,
    [VK_COMMAND_TYPE_vkWaitSemaphoreResourceMESA_EXT] = vn_dispatch_vkWaitSemaphoreResourceMESA,
    [VK_COMMAND_TYPE_vkImportSemaphoreResourceMESA_EXT] = vn_dispatch_vkImportSemaphoreResourceMESA,
    [VK_COMMAND_TYPE_vkSubmitVirtqueueSeqnoMESA_EXT] = vn_dispatch_vkSubmitVirtqueueSeqnoMESA,
    [VK_COMMAND_TYPE_vkWaitVirtqueueSeqnoMESA_EXT] = vn_dispatch_vkWaitVirtqueueSeqnoMESA,
    [VK_COMMAND_TYPE_vkWaitRingSeqnoMESA_EXT] = vn_dispatch_vkWaitRingSeqnoMESA,
};

static inline void vn_dispatch_command(struct vn_dispatch_context *ctx)
{
    VkCommandTypeEXT cmd_type;
    VkCommandFlagsEXT cmd_flags;

    vn_decode_VkCommandTypeEXT(ctx->decoder, &cmd_type);
    vn_decode_VkFlags(ctx->decoder, &cmd_flags);

    {
#ifdef DEBUG
        TRACE_SCOPE_SLOW(vn_dispatch_command_name(cmd_type));
#endif
        if (cmd_type < 255 && vn_dispatch_table[cmd_type])
            vn_dispatch_table[cmd_type](ctx, cmd_flags);
        else
            vn_cs_decoder_set_fatal(ctx->decoder);
    }

    if (vn_cs_decoder_get_fatal(ctx->decoder))
        vn_dispatch_debug_log(ctx, "%s resulted in CS error", vn_dispatch_command_name(cmd_type));
}

#endif /* VN_PROTOCOL_RENDERER_DISPATCHES_H */
