#include "tsk/util/crypto.hpp"

#ifdef HAVE_LIBCRYPTO

#include <cstring>

#include "catch.hpp"

/* AES key */
static const unsigned char wrap_key[] = {
  0xee, 0xbc, 0x1f, 0x57, 0x48, 0x7f, 0x51, 0x92,
  0x1c, 0x04, 0x65, 0x66, 0x5f, 0x8a, 0xe6, 0xd1,
  0x65, 0x8b, 0xb2, 0x6d, 0xe6, 0xf8, 0xa0, 0x69,
  0xa3, 0x52, 0x02, 0x93, 0xa5, 0x72, 0x07, 0x8f
};

/* Unique initialisation vector */
static const unsigned char wrap_iv[] = {
  0x99, 0xaa, 0x3e, 0x68, 0xed, 0x81, 0x73, 0xa0,
  0xee, 0xd0, 0x66, 0x84, 0x99, 0xaa, 0x3e, 0x68
};

/* Plaintext */
static const unsigned char wrap_pt[] = {
  0xad, 0x4f, 0xc9, 0xfc, 0x77, 0x69, 0xc9, 0xea,
  0xfc, 0xdf, 0x00, 0xac, 0x34, 0xec, 0x40, 0xbc,
  0x28, 0x3f, 0xa4, 0x5e, 0xd8, 0x99, 0xe4, 0x5d,
  0x5e, 0x7a, 0xc4, 0xe6, 0xca, 0x7b, 0xa5, 0xb7
};

/* Ciphertext */
static const unsigned char wrap_ct[] = {
  0x97, 0x99, 0x55, 0xca, 0xf6, 0x3e, 0x95, 0x54,
  0x39, 0xd6, 0xaf, 0x63, 0xff, 0x2c, 0xe3, 0x96,
  0xf7, 0x0d, 0x2c, 0x9c, 0xc7, 0x43, 0xc0, 0xb6,
  0x31, 0x43, 0xb9, 0x20, 0xac, 0x6b, 0xd3, 0x67,
  0xad, 0x01, 0xaf, 0xa7, 0x32, 0x74, 0x26, 0x92
};

TEST_CASE("rf3394_key_unwrap") {
  const auto out = rfc3394_key_unwrap(
    wrap_key, sizeof(wrap_key),
    wrap_ct, sizeof(wrap_ct),
    wrap_iv
  );
  REQUIRE(out);
  REQUIRE(!std::memcmp(out.get(), wrap_pt, sizeof(wrap_pt)));
}

#endif
