
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                      table_tools                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//            table_change_datetime_format.h             //
//                                                       //
//                 Copyright (C) 2025 by                 //
//                  Justus Spitzmueller                  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     j.spitzmueller@posteo.de               //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#pragma once


///////////////////////////////////////////////////////////
//														 //
//                                                       //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include <saga_api/saga_api.h>


///////////////////////////////////////////////////////////
//														 //
//                                                       //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CTable_Change_DateTime_Format : public CSG_Tool
{
public:

	CTable_Change_DateTime_Format(void);
	
	virtual CSG_String			Get_MenuPath			(void)	{	return( _TL("A:Table|Date and Time") );	}

protected:

	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	
	virtual int					On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool				On_Execute				(void);

private:
	
	int m_Max_Num = 0;
};


class CDateTime_Base : public CSG_Tool
{
public:

	CDateTime_Base(void);

protected:

	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	
	virtual int					On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	bool 						Add_DateTime_Parameter	(CSG_String Identifier, CSG_String Name, double JDN_Offset = 0.0 );

	bool 						Check_DateTime_Parameter(CSG_String Identifier, CSG_String &Error_Message);
	
	CSG_DateTime	 			Get_DateTime 			(CSG_String Identifier, CSG_Table_Record *pRecord);
	
	void						Set_Enable_DateTime 	(CSG_Parameters *pParameters, CSG_String Identifier, bool Enable);

private:
	
};

class CDateTime_Difference : public CDateTime_Base
{
public:
	CDateTime_Difference(void);

	virtual CSG_String			Get_MenuPath			(void)	{	return( _TL("A:Table|Date and Time") );	}

protected:

	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	
	virtual int					On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool				On_Execute				(void);


private:
	
};

class CDateTime_Logic : public CDateTime_Base
{
public:

	CDateTime_Logic(void);

	virtual CSG_String			Get_MenuPath			(void)	{	return( _TL("A:Table|Date and Time") );	}

protected:

	virtual int					On_Parameters_Enable	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);
	
	virtual int					On_Parameter_Changed	(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool				On_Execute				(void);

private:
	
};
