/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file XmlNode.qpp defines the XmlNode class */
/*
    QC_XmlNode.qpp

    Qore Programming Language

    Copyright 2003 - 2022 Qore Technologies, s.r.o.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <libxml/xmlreader.h>

#include "qore-xml-module.h"
#include "QC_XmlNode.h"
#include "ql_xml.h"

static QoreObject* doObject(QoreXmlNodeData *data) {
   return data ? new QoreObject(QC_XMLNODE, getProgram(), data) : 0;
}

#ifdef HAVE_XMLTEXTREADERSETSCHEMA
#define XML_CONST_HAVE_XMLTEXTREADERSETSCHEMA 1
#else
#define XML_CONST_HAVE_XMLTEXTREADERSETSCHEMA 0
#endif

#ifdef HAVE_XMLTEXTREADERRELAXNGSETSCHEMA
#define XML_CONST_HAVE_XMLTEXTREADERRELAXNGSETSCHEMA 1
#else
#define XML_CONST_HAVE_XMLTEXTREADERRELAXNGSETSCHEMA 0
#endif
/* Qore class Qore::Xml::XmlNode */

qore_classid_t CID_XMLNODE;
QoreClass* QC_XMLNODE;

// int XmlNode::childElementCount(){}
static QoreValue XmlNode_childElementCount(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 256 "QC_XmlNode.qpp"
    return xn->childElementCount();
}

// XmlNode::constructor() {}
static void XmlNode_constructor(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 236 "QC_XmlNode.qpp"
xsink->raiseException("XMLNODE-CONSTRUCTOR-ERROR", "this class cannot be constructed directly");
}

// XmlNode::copy() {}
static void XmlNode_copy(QoreObject* self, QoreObject* old, QoreXmlNodeData* xn, ExceptionSink* xsink) {
# 246 "QC_XmlNode.qpp"
self->setPrivate(CID_XMLNODE, new QoreXmlNodeData(*xn));
}

// *XmlNode XmlNode::firstElementChild(){}
static QoreValue XmlNode_firstElementChild(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 304 "QC_XmlNode.qpp"
    return doObject(xn->firstElementChild());
}

// *string XmlNode::getContent(){}
static QoreValue XmlNode_getContent(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 397 "QC_XmlNode.qpp"
    return xn->getContent();
}

// int XmlNode::getElementType(){}
static QoreValue XmlNode_getElementType(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 283 "QC_XmlNode.qpp"
    return xn->getElementType();
}

// *string XmlNode::getElementTypeName(){}
static QoreValue XmlNode_getElementTypeName(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 293 "QC_XmlNode.qpp"
    const char *nt = get_xml_element_type_name((int)xn->getElementType());
   return nt ? new QoreStringNode(nt) : 0;
}

// *string XmlNode::getLang(){}
static QoreValue XmlNode_getLang(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 417 "QC_XmlNode.qpp"
    return xn->getLang();
}

// *XmlNode XmlNode::getLastChild(){}
static QoreValue XmlNode_getLastChild(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 314 "QC_XmlNode.qpp"
    return doObject(xn->getLastChild());
}

// *string XmlNode::getName(){}
static QoreValue XmlNode_getName(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 407 "QC_XmlNode.qpp"
    return xn->getName();
}

// *string XmlNode::getNsProp(string prop, string ns){}
static QoreValue XmlNode_getNsProp_VsVs(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* prop = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* ns = HARD_QORE_VALUE_STRING(args, 1);
# 369 "QC_XmlNode.qpp"
    return xn->getNsProp(prop->getBuffer(), ns->getBuffer());
}

// string XmlNode::getPath(){}
static QoreValue XmlNode_getPath(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 356 "QC_XmlNode.qpp"
    return xn->getPath(xsink);
}

// *string XmlNode::getProp(string prop){}
static QoreValue XmlNode_getProp_Vs(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* prop = HARD_QORE_VALUE_STRING(args, 0);
# 381 "QC_XmlNode.qpp"
    return xn->getProp(prop->getBuffer());
}

// int XmlNode::getSpacePreserve(){}
static QoreValue XmlNode_getSpacePreserve(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 266 "QC_XmlNode.qpp"
    return xn->getSpacePreserve();
}

// *string XmlNode::getXML(){}
static QoreValue XmlNode_getXML(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 447 "QC_XmlNode.qpp"
    return xn->getXML();
}

// bool XmlNode::isBlank(){}
static QoreValue XmlNode_isBlank(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 437 "QC_XmlNode.qpp"
    return xn->isBlank();
}

// bool XmlNode::isText(){}
static QoreValue XmlNode_isText(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 427 "QC_XmlNode.qpp"
    return xn->isText();
}

// *XmlNode XmlNode::lastElementChild(){}
static QoreValue XmlNode_lastElementChild(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 324 "QC_XmlNode.qpp"
    return doObject(xn->lastElementChild());
}

// *XmlNode XmlNode::nextElementSibling(){}
static QoreValue XmlNode_nextElementSibling(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 334 "QC_XmlNode.qpp"
    return doObject(xn->nextElementSibling());
}

// *XmlNode XmlNode::previousElementSibling(){}
static QoreValue XmlNode_previousElementSibling(QoreObject* self, QoreXmlNodeData* xn, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 344 "QC_XmlNode.qpp"
    return doObject(xn->previousElementSibling());
}

DLLLOCAL void preinitXmlNodeClass() {
    QC_XMLNODE = new QoreBuiltinClass("XmlNode", "::Qore::Xml::XmlNode", QDOM_DEFAULT);
    CID_XMLNODE = QC_XMLNODE->getID();
    QC_XMLNODE->setSystem();
}

DLLLOCAL QoreClass* initXmlNodeClass(QoreNamespace& ns) {
    if (!QC_XMLNODE)
        preinitXmlNodeClass();

    // int XmlNode::childElementCount(){}
    QC_XMLNODE->addMethod("childElementCount", (q_method_n_t)XmlNode_childElementCount, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // XmlNode::constructor() {}
    QC_XMLNODE->addConstructor(XmlNode_constructor, Public, QCF_NO_FLAGS, QDOM_DEFAULT);

    // XmlNode::copy() {}
    QC_XMLNODE->setCopy((q_copy_t)XmlNode_copy);

    // *XmlNode XmlNode::firstElementChild(){}
    QC_XMLNODE->addMethod("firstElementChild", (q_method_n_t)XmlNode_firstElementChild, Public, QCF_CONSTANT, QDOM_DEFAULT, QC_XMLNODE->getOrNothingTypeInfo());

    // *string XmlNode::getContent(){}
    QC_XMLNODE->addMethod("getContent", (q_method_n_t)XmlNode_getContent, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // int XmlNode::getElementType(){}
    QC_XMLNODE->addMethod("getElementType", (q_method_n_t)XmlNode_getElementType, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // *string XmlNode::getElementTypeName(){}
    QC_XMLNODE->addMethod("getElementTypeName", (q_method_n_t)XmlNode_getElementTypeName, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlNode::getLang(){}
    QC_XMLNODE->addMethod("getLang", (q_method_n_t)XmlNode_getLang, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *XmlNode XmlNode::getLastChild(){}
    QC_XMLNODE->addMethod("getLastChild", (q_method_n_t)XmlNode_getLastChild, Public, QCF_CONSTANT, QDOM_DEFAULT, QC_XMLNODE->getOrNothingTypeInfo());

    // *string XmlNode::getName(){}
    QC_XMLNODE->addMethod("getName", (q_method_n_t)XmlNode_getName, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlNode::getNsProp(string prop, string ns){}
    QC_XMLNODE->addMethod("getNsProp", (q_method_n_t)XmlNode_getNsProp_VsVs, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 2, stringTypeInfo, QORE_PARAM_NO_ARG, "prop", stringTypeInfo, QORE_PARAM_NO_ARG, "ns");

    // string XmlNode::getPath(){}
    QC_XMLNODE->addMethod("getPath", (q_method_n_t)XmlNode_getPath, Public, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, stringTypeInfo);

    // *string XmlNode::getProp(string prop){}
    QC_XMLNODE->addMethod("getProp", (q_method_n_t)XmlNode_getProp_Vs, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "prop");

    // int XmlNode::getSpacePreserve(){}
    QC_XMLNODE->addMethod("getSpacePreserve", (q_method_n_t)XmlNode_getSpacePreserve, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // *string XmlNode::getXML(){}
    QC_XMLNODE->addMethod("getXML", (q_method_n_t)XmlNode_getXML, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // bool XmlNode::isBlank(){}
    QC_XMLNODE->addMethod("isBlank", (q_method_n_t)XmlNode_isBlank, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlNode::isText(){}
    QC_XMLNODE->addMethod("isText", (q_method_n_t)XmlNode_isText, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // *XmlNode XmlNode::lastElementChild(){}
    QC_XMLNODE->addMethod("lastElementChild", (q_method_n_t)XmlNode_lastElementChild, Public, QCF_CONSTANT, QDOM_DEFAULT, QC_XMLNODE->getOrNothingTypeInfo());

    // *XmlNode XmlNode::nextElementSibling(){}
    QC_XMLNODE->addMethod("nextElementSibling", (q_method_n_t)XmlNode_nextElementSibling, Public, QCF_CONSTANT, QDOM_DEFAULT, QC_XMLNODE->getOrNothingTypeInfo());

    // *XmlNode XmlNode::previousElementSibling(){}
    QC_XMLNODE->addMethod("previousElementSibling", (q_method_n_t)XmlNode_previousElementSibling, Public, QCF_CONSTANT, QDOM_DEFAULT, QC_XMLNODE->getOrNothingTypeInfo());
# 48 "QC_XmlNode.qpp"
# 55 "QC_XmlNode.qpp"
# 58 "QC_XmlNode.qpp"
# 61 "QC_XmlNode.qpp"
# 64 "QC_XmlNode.qpp"
# 67 "QC_XmlNode.qpp"
# 70 "QC_XmlNode.qpp"
# 73 "QC_XmlNode.qpp"
# 76 "QC_XmlNode.qpp"
# 79 "QC_XmlNode.qpp"
# 82 "QC_XmlNode.qpp"
# 85 "QC_XmlNode.qpp"
# 88 "QC_XmlNode.qpp"
# 91 "QC_XmlNode.qpp"
# 94 "QC_XmlNode.qpp"
# 97 "QC_XmlNode.qpp"
# 100 "QC_XmlNode.qpp"
# 103 "QC_XmlNode.qpp"
# 106 "QC_XmlNode.qpp"
# 109 "QC_XmlNode.qpp"
# 112 "QC_XmlNode.qpp"
# 115 "QC_XmlNode.qpp"
# 118 "QC_XmlNode.qpp"
    QoreHashNode* hash_ElementTypeMap = new QoreHashNode(autoTypeInfo);
    hash_ElementTypeMap->setKeyValue("1", new QoreStringNode("XML_ELEMENT_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("2", new QoreStringNode("XML_ATTRIBUTE_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("3", new QoreStringNode("XML_TEXT_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("4", new QoreStringNode("XML_CDATA_SECTION_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("5", new QoreStringNode("XML_ENTITY_REF_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("6", new QoreStringNode("XML_ENTITY_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("7", new QoreStringNode("XML_PI_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("8", new QoreStringNode("XML_COMMENT_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("9", new QoreStringNode("XML_DOCUMENT_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("10", new QoreStringNode("XML_DOCUMENT_TYPE_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("11", new QoreStringNode("XML_DOCUMENT_FRAG_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("12", new QoreStringNode("XML_NOTATION_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("13", new QoreStringNode("XML_HTML_DOCUMENT_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("14", new QoreStringNode("XML_DTD_NODE"), 0);
    hash_ElementTypeMap->setKeyValue("15", new QoreStringNode("XML_ELEMENT_DECL"), 0);
    hash_ElementTypeMap->setKeyValue("16", new QoreStringNode("XML_ATTRIBUTE_DECL"), 0);
    hash_ElementTypeMap->setKeyValue("17", new QoreStringNode("XML_ENTITY_DECL"), 0);
    hash_ElementTypeMap->setKeyValue("18", new QoreStringNode("XML_NAMESPACE_DECL"), 0);
    hash_ElementTypeMap->setKeyValue("19", new QoreStringNode("XML_XINCLUDE_START"), 0);
    hash_ElementTypeMap->setKeyValue("20", new QoreStringNode("XML_XINCLUDE_END"), 0);
    hash_ElementTypeMap->setKeyValue("21", new QoreStringNode("XML_DOCB_DOCUMENT_NODE"), 0);

    ns.addConstant("ElementTypeMap", hash_ElementTypeMap);
    ns.addConstant("XML_ATTRIBUTE_DECL", ((int64)XML_ATTRIBUTE_DECL));
    ns.addConstant("XML_ATTRIBUTE_NODE", ((int64)XML_ATTRIBUTE_NODE));
    ns.addConstant("XML_CDATA_SECTION_NODE", ((int64)XML_CDATA_SECTION_NODE));
    ns.addConstant("XML_COMMENT_NODE", ((int64)XML_COMMENT_NODE));
    ns.addConstant("XML_DOCB_DOCUMENT_NODE", ((int64)XML_DOCB_DOCUMENT_NODE));
    ns.addConstant("XML_DOCUMENT_FRAG_NODE", ((int64)XML_DOCUMENT_FRAG_NODE));
    ns.addConstant("XML_DOCUMENT_NODE", ((int64)XML_DOCUMENT_NODE));
    ns.addConstant("XML_DOCUMENT_TYPE_NODE", ((int64)XML_DOCUMENT_TYPE_NODE));
    ns.addConstant("XML_DTD_NODE", ((int64)XML_DTD_NODE));
    ns.addConstant("XML_ELEMENT_DECL", ((int64)XML_ELEMENT_DECL));
    ns.addConstant("XML_ELEMENT_NODE", ((int64)XML_ELEMENT_NODE));
    ns.addConstant("XML_ENTITY_DECL", ((int64)XML_ENTITY_DECL));
    ns.addConstant("XML_ENTITY_NODE", ((int64)XML_ENTITY_NODE));
    ns.addConstant("XML_ENTITY_REF_NODE", ((int64)XML_ENTITY_REF_NODE));
    ns.addConstant("XML_HTML_DOCUMENT_NODE", ((int64)XML_HTML_DOCUMENT_NODE));
    ns.addConstant("XML_NAMESPACE_DECL", ((int64)XML_NAMESPACE_DECL));
    ns.addConstant("XML_NOTATION_NODE", ((int64)XML_NOTATION_NODE));
    ns.addConstant("XML_PI_NODE", ((int64)XML_PI_NODE));
    ns.addConstant("XML_TEXT_NODE", ((int64)XML_TEXT_NODE));
    ns.addConstant("XML_XINCLUDE_END", ((int64)XML_XINCLUDE_END));
    ns.addConstant("XML_XINCLUDE_START", ((int64)XML_XINCLUDE_START));
# 144 "QC_XmlNode.qpp"
# 151 "QC_XmlNode.qpp"
# 154 "QC_XmlNode.qpp"
# 157 "QC_XmlNode.qpp"
# 160 "QC_XmlNode.qpp"
# 163 "QC_XmlNode.qpp"
# 166 "QC_XmlNode.qpp"
# 169 "QC_XmlNode.qpp"
# 172 "QC_XmlNode.qpp"
# 175 "QC_XmlNode.qpp"
# 178 "QC_XmlNode.qpp"
# 181 "QC_XmlNode.qpp"
# 184 "QC_XmlNode.qpp"
# 187 "QC_XmlNode.qpp"
# 190 "QC_XmlNode.qpp"
# 193 "QC_XmlNode.qpp"
# 196 "QC_XmlNode.qpp"
# 199 "QC_XmlNode.qpp"
# 202 "QC_XmlNode.qpp"
# 205 "QC_XmlNode.qpp"
    QoreHashNode* hash_NodeTypeMap = new QoreHashNode(autoTypeInfo);
    hash_NodeTypeMap->setKeyValue("0", new QoreStringNode("XML_NODE_TYPE_NONE"), 0);
    hash_NodeTypeMap->setKeyValue("1", new QoreStringNode("XML_NODE_TYPE_ELEMENT"), 0);
    hash_NodeTypeMap->setKeyValue("2", new QoreStringNode("XML_NODE_TYPE_ATTRIBUTE"), 0);
    hash_NodeTypeMap->setKeyValue("3", new QoreStringNode("XML_NODE_TYPE_TEXT"), 0);
    hash_NodeTypeMap->setKeyValue("4", new QoreStringNode("XML_NODE_TYPE_CDATA"), 0);
    hash_NodeTypeMap->setKeyValue("5", new QoreStringNode("XML_NODE_TYPE_ENTITY_REFERENCE"), 0);
    hash_NodeTypeMap->setKeyValue("6", new QoreStringNode("XML_NODE_TYPE_ENTITY"), 0);
    hash_NodeTypeMap->setKeyValue("7", new QoreStringNode("XML_NODE_TYPE_PROCESSING_INSTRUCTION"), 0);
    hash_NodeTypeMap->setKeyValue("8", new QoreStringNode("XML_NODE_TYPE_COMMENT"), 0);
    hash_NodeTypeMap->setKeyValue("9", new QoreStringNode("XML_NODE_TYPE_DOCUMENT"), 0);
    hash_NodeTypeMap->setKeyValue("10", new QoreStringNode("XML_NODE_TYPE_DOCUMENT_TYPE"), 0);
    hash_NodeTypeMap->setKeyValue("11", new QoreStringNode("XML_NODE_TYPE_DOCUMENT_FRAGMENT"), 0);
    hash_NodeTypeMap->setKeyValue("12", new QoreStringNode("XML_NODE_TYPE_NOTATION"), 0);
    hash_NodeTypeMap->setKeyValue("13", new QoreStringNode("XML_NODE_TYPE_WHITESPACE"), 0);
    hash_NodeTypeMap->setKeyValue("14", new QoreStringNode("XML_NODE_TYPE_SIGNIFICANT_WHITESPACE"), 0);
    hash_NodeTypeMap->setKeyValue("15", new QoreStringNode("XML_NODE_TYPE_END_ELEMENT"), 0);
    hash_NodeTypeMap->setKeyValue("16", new QoreStringNode("XML_NODE_TYPE_END_ENTITY"), 0);
    hash_NodeTypeMap->setKeyValue("17", new QoreStringNode("XML_NODE_TYPE_XML_DECLARATION"), 0);

    ns.addConstant("NodeTypeMap", hash_NodeTypeMap);
    ns.addConstant("XML_NODE_TYPE_ATTRIBUTE", ((int64)XML_READER_TYPE_ATTRIBUTE));
    ns.addConstant("XML_NODE_TYPE_CDATA", ((int64)XML_READER_TYPE_CDATA));
    ns.addConstant("XML_NODE_TYPE_COMMENT", ((int64)XML_READER_TYPE_COMMENT));
    ns.addConstant("XML_NODE_TYPE_DOCUMENT", ((int64)XML_READER_TYPE_DOCUMENT));
    ns.addConstant("XML_NODE_TYPE_DOCUMENT_FRAGMENT", ((int64)XML_READER_TYPE_DOCUMENT_FRAGMENT));
    ns.addConstant("XML_NODE_TYPE_DOCUMENT_TYPE", ((int64)XML_READER_TYPE_DOCUMENT_TYPE));
    ns.addConstant("XML_NODE_TYPE_ELEMENT", ((int64)XML_READER_TYPE_ELEMENT));
    ns.addConstant("XML_NODE_TYPE_END_ELEMENT", ((int64)XML_READER_TYPE_END_ELEMENT));
    ns.addConstant("XML_NODE_TYPE_END_ENTITY", ((int64)XML_READER_TYPE_END_ENTITY));
    ns.addConstant("XML_NODE_TYPE_ENTITY", ((int64)XML_READER_TYPE_ENTITY));
    ns.addConstant("XML_NODE_TYPE_ENTITY_REFERENCE", ((int64)XML_READER_TYPE_ENTITY_REFERENCE));
    ns.addConstant("XML_NODE_TYPE_NONE", ((int64)XML_READER_TYPE_NONE));
    ns.addConstant("XML_NODE_TYPE_NOTATION", ((int64)XML_READER_TYPE_NOTATION));
    ns.addConstant("XML_NODE_TYPE_PROCESSING_INSTRUCTION", ((int64)XML_READER_TYPE_PROCESSING_INSTRUCTION));
    ns.addConstant("XML_NODE_TYPE_SIGNIFICANT_WHITESPACE", ((int64)XML_READER_TYPE_SIGNIFICANT_WHITESPACE));
    ns.addConstant("XML_NODE_TYPE_TEXT", ((int64)XML_READER_TYPE_TEXT));
    ns.addConstant("XML_NODE_TYPE_WHITESPACE", ((int64)XML_READER_TYPE_WHITESPACE));
    ns.addConstant("XML_NODE_TYPE_XML_DECLARATION", ((int64)XML_READER_TYPE_XML_DECLARATION));

    return QC_XMLNODE;
}
/*
// line numbers are not activated by default and no option is provided to activate them
int XmlNode::getLineNumber() {
   return xn->getLineNumber();
}
*/

/*
static AbstractQoreNode *XMLNODE_getBase(QoreObject *self, QoreXmlNodeData *xn, const QoreListNode *params, ExceptionSink *xsink) {
   return xn->getBase();
}
*/
