import sys

import objc
from objc import NO, YES
from PyObjCTest.fnd import NSPriorDayDesignations
from PyObjCTest.testbndl2 import PyObjC_TestClass1, PyObjC_TestClass2
from PyObjCTools.TestSupport import TestCase, main, onlyIf


# Several types are encoded slightly different on 32-bit vs. 64-bit
# - NSPoint and NSRect: the actual type is different
# - @encode(long) is _C_LNG_LNG instead of _C_LNG on 64-bit builds
if sys.maxsize > 2 ** 32:
    NSPoint_tp = b"{_NSPoint=dd}"
    NSRect_tp = b"{_NSRect={_NSPoint=dd}{_NSSize=dd}}"
    long_tp = b"q"
    ulong_tp = b"Q"

else:
    NSPoint_tp = b"{_NSPoint=ff}"
    NSRect_tp = b"{_NSRect={_NSPoint=ff}{_NSSize=ff}}"
    long_tp = b"l"
    ulong_tp = b"L"


#
# NSInvocation in macOS 10.2 doesn't like some struct definition, it
# garbles the contents of those structs. These unittests disable NSInvocation
# tests that fail because of this problem.
#
# ctests.CheckNSInvoke checks if NSInvocation has this problem, it does so
# in pure Objective-C code and will therefore not mask problems with the
# bridge.
#
try:
    objc._ctests["CheckNSInvoke"]()
    nsinvoke_ok = 1
except AssertionError:
    nsinvoke_ok = 0

NSArray = objc.lookUpClass("NSArray")

# Note: @encode(unsigned char*) gives the wrong result at least upto 9A337a,
# hence the 'type=b' annotations in several lines
for method, argmeta in [
    (b"BOOLInArg:", {2: {"type_modifier": b"n"}}),
    (b"BOOLInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"BOOLOutArg:", {2: {"type_modifier": b"o"}}),
    (b"NSPointInArg:", {2: {"type_modifier": b"n"}}),
    (b"NSPointInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"NSPointOutArg:", {2: {"type_modifier": b"o"}}),
    (b"NSRectInArg:", {2: {"type_modifier": b"n"}}),
    (b"NSRectInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"NSRectOutArg:", {2: {"type_modifier": b"o"}}),
    (b"boolInArg:", {2: {"type_modifier": b"n"}}),
    (b"boolInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"boolOutArg:", {2: {"type_modifier": b"o"}}),
    (b"charInArg:", {2: {"type_modifier": b"n"}}),
    (b"charInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"charOutArg:", {2: {"type_modifier": b"o"}}),
    (b"charPtrInArg:", {2: {"type_modifier": b"n"}}),
    (b"charPtrInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"charPtrOutArg:", {2: {"type_modifier": b"o"}}),
    (b"doubleInArg:", {2: {"type_modifier": b"n"}}),
    (b"doubleInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"doubleOutArg:", {2: {"type_modifier": b"o"}}),
    (b"floatInArg:", {2: {"type_modifier": b"n"}}),
    (b"floatInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"floatOutArg:", {2: {"type_modifier": b"o"}}),
    (b"idInArg:", {2: {"type_modifier": b"n"}}),
    (b"idInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"idOutArg:", {2: {"type_modifier": b"o"}}),
    (b"signedintInArg:", {2: {"type_modifier": b"n"}}),
    (b"signedintInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"signedintOutArg:", {2: {"type_modifier": b"o"}}),
    (b"signedlongInArg:", {2: {"type_modifier": b"n"}}),
    (b"signedlongInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"signedlongOutArg:", {2: {"type_modifier": b"o"}}),
    (b"signedlonglongInArg:", {2: {"type_modifier": b"n"}}),
    (b"signedlonglongInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"signedlonglongOutArg:", {2: {"type_modifier": b"o"}}),
    (b"signedshortInArg:", {2: {"type_modifier": b"n"}}),
    (b"signedshortInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"signedshortOutArg:", {2: {"type_modifier": b"o"}}),
    (b"structTestStruct1InArg:", {2: {"type_modifier": b"n"}}),
    (b"structTestStruct1InOutArg:", {2: {"type_modifier": b"N"}}),
    (b"structTestStruct1OutArg:", {2: {"type_modifier": b"o"}}),
    (b"structTestStruct2InArg:", {2: {"type_modifier": b"n"}}),
    (b"structTestStruct2InOutArg:", {2: {"type_modifier": b"N"}}),
    (b"structTestStruct2OutArg:", {2: {"type_modifier": b"o"}}),
    (b"structTestStruct3InArg:", {2: {"type_modifier": b"n"}}),
    (b"structTestStruct3InOutArg:", {2: {"type_modifier": b"N"}}),
    (b"structTestStruct3OutArg:", {2: {"type_modifier": b"o"}}),
    (b"structTestStruct4InArg:", {2: {"type_modifier": b"n"}}),
    (b"structTestStruct4InOutArg:", {2: {"type_modifier": b"N"}}),
    (b"structTestStruct4OutArg:", {2: {"type_modifier": b"o"}}),
    (b"structTestStruct5InArg:", {2: {"type_modifier": b"n"}}),
    (b"structTestStruct5InOutArg:", {2: {"type_modifier": b"N"}}),
    (b"structTestStruct5OutArg:", {2: {"type_modifier": b"o"}}),
    (b"unsignedcharInArg:", {2: {"type_modifier": b"n", "type": b"^C"}}),
    (b"unsignedcharInOutArg:", {2: {"type_modifier": b"N", "type": b"^C"}}),
    (b"unsignedcharOutArg:", {2: {"type_modifier": b"o", "type": b"^C"}}),
    (b"unsignedintInArg:", {2: {"type_modifier": b"n"}}),
    (b"unsignedintInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"unsignedintOutArg:", {2: {"type_modifier": b"o"}}),
    (b"unsignedlongInArg:", {2: {"type_modifier": b"n"}}),
    (b"unsignedlongInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"unsignedlongOutArg:", {2: {"type_modifier": b"o"}}),
    (b"unsignedlonglongInArg:", {2: {"type_modifier": b"n"}}),
    (b"unsignedlonglongInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"unsignedlonglongOutArg:", {2: {"type_modifier": b"o"}}),
    (b"unsignedshortInArg:", {2: {"type_modifier": b"n"}}),
    (b"unsignedshortInOutArg:", {2: {"type_modifier": b"N"}}),
    (b"unsignedshortOutArg:", {2: {"type_modifier": b"o"}}),
]:

    objc.registerMetaDataForSelector(
        b"PyObjC_TestClass1", method, {"arguments": argmeta}
    )


for method, argmeta in [
    (b"callBOOLInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callBOOLInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callBOOLOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callNSPointInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callNSPointInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callNSPointOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callNSRectInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callNSRectInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callNSRectOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callboolInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callboolInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callboolOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callcharInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callcharInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callcharOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callcharPtrInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callcharPtrInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callcharPtrOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"calldoubleInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"calldoubleInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"calldoubleOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callfloatInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callfloatInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callfloatOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callidInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callidInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callidOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callsignedintInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callsignedintInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callsignedintOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callsignedlongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callsignedlongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callsignedlongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callsignedlonglongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callsignedlonglongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callsignedlonglongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callsignedshortInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callsignedshortInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callsignedshortOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callstructTestStruct1InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callstructTestStruct1InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callstructTestStruct1OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callstructTestStruct2InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callstructTestStruct2InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callstructTestStruct2OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callstructTestStruct3InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callstructTestStruct3InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callstructTestStruct3OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callstructTestStruct4InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callstructTestStruct4InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callstructTestStruct4OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callstructTestStruct5InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callstructTestStruct5InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callstructTestStruct5OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callunsignedcharInArg:of:", {2: {"type_modifier": b"n", "type": b"^C"}}),
    (b"callunsignedcharInOutArg:of:", {2: {"type_modifier": b"N", "type": b"^C"}}),
    (b"callunsignedcharOutArg:of:", {2: {"type_modifier": b"o", "type": b"^C"}}),
    (b"callunsignedintInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callunsignedintInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callunsignedintOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callunsignedlongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callunsignedlongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callunsignedlongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callunsignedlonglongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callunsignedlonglongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callunsignedlonglongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"callunsignedshortInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"callunsignedshortInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"callunsignedshortOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeBOOLInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeBOOLInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeBOOLOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeNSPointInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeNSPointInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeNSPointOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeNSRectInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeNSRectInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeNSRectOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeboolInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeboolInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeboolOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokecharInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokecharInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokecharOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokecharPtrInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokecharPtrInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokecharPtrOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokedoubleInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokedoubleInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokedoubleOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokefloatInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokefloatInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokefloatOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeidInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeidInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeidOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokesignedintInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokesignedintInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokesignedintOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokesignedlongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokesignedlongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokesignedlongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokesignedlonglongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokesignedlonglongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokesignedlonglongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokesignedshortInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokesignedshortInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokesignedshortOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokestructTestStruct1InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokestructTestStruct1InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokestructTestStruct1OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokestructTestStruct2InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokestructTestStruct2InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokestructTestStruct2OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokestructTestStruct3InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokestructTestStruct3InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokestructTestStruct3OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokestructTestStruct4InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokestructTestStruct4InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokestructTestStruct4OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokestructTestStruct5InArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokestructTestStruct5InOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokestructTestStruct5OutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeunsignedcharInArg:of:", {2: {"type_modifier": b"n", "type": b"^C"}}),
    (b"invokeunsignedcharInOutArg:of:", {2: {"type_modifier": b"N", "type": b"^C"}}),
    (b"invokeunsignedcharOutArg:of:", {2: {"type_modifier": b"o", "type": b"^C"}}),
    (b"invokeunsignedintInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeunsignedintInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeunsignedintOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeunsignedlongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeunsignedlongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeunsignedlongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeunsignedlonglongInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeunsignedlonglongInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeunsignedlonglongOutArg:of:", {2: {"type_modifier": b"o"}}),
    (b"invokeunsignedshortInArg:of:", {2: {"type_modifier": b"n"}}),
    (b"invokeunsignedshortInOutArg:of:", {2: {"type_modifier": b"N"}}),
    (b"invokeunsignedshortOutArg:of:", {2: {"type_modifier": b"o"}}),
]:

    objc.registerMetaDataForSelector(
        b"PyObjC_TestClass2", method, {"arguments": argmeta}
    )


class PyToObjC(TestCase):
    # Test calling Objective-C from Python
    # Simple returns from class methods

    def testClsboolResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.boolClsMethod(), YES)
        self.assertEqual(PyObjC_TestClass1.boolClsMethod(), NO)

    def testClsBOOLResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.BOOLClsMethod(), YES)
        self.assertEqual(PyObjC_TestClass1.BOOLClsMethod(), NO)

    def testClscharResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.charClsMethod(), -128)
        self.assertEqual(PyObjC_TestClass1.charClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.charClsMethod(), 127)

    def testClssignedshortResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.signedshortClsMethod(), -(1 << 14))
        self.assertEqual(PyObjC_TestClass1.signedshortClsMethod(), -42)
        self.assertEqual(PyObjC_TestClass1.signedshortClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.signedshortClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.signedshortClsMethod(), 1 << 14)

    def testClssignedintResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.signedintClsMethod(), -(1 << 30))
        self.assertEqual(PyObjC_TestClass1.signedintClsMethod(), -42)
        self.assertEqual(PyObjC_TestClass1.signedintClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.signedintClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.signedintClsMethod(), 1 << 30)

    def testClssignedlongResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.signedlongClsMethod(), -(1 << 30))
        self.assertEqual(PyObjC_TestClass1.signedlongClsMethod(), -42)
        self.assertEqual(PyObjC_TestClass1.signedlongClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.signedlongClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.signedlongClsMethod(), 1 << 30)

    def testClssignedlonglongResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.signedlonglongClsMethod(), -(1 << 60))
        self.assertEqual(PyObjC_TestClass1.signedlonglongClsMethod(), -42)
        self.assertEqual(PyObjC_TestClass1.signedlonglongClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.signedlonglongClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.signedlonglongClsMethod(), 1 << 60)

    def testClsunsignedcharResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.unsignedcharClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.unsignedcharClsMethod(), 128)
        self.assertEqual(PyObjC_TestClass1.unsignedcharClsMethod(), 255)

    def testClsunsignedshortResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.unsignedshortClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.unsignedshortClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.unsignedshortClsMethod(), 1 << 14)

    def testClsunsignedintResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.unsignedintClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.unsignedintClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.unsignedintClsMethod(), 1 << 30)

    def testClsunsignedlongResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.unsignedlongClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.unsignedlongClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.unsignedlongClsMethod(), 1 << 30)

    def testClsunsignedlonglongResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.unsignedlonglongClsMethod(), 0)
        self.assertEqual(PyObjC_TestClass1.unsignedlonglongClsMethod(), 42)
        self.assertEqual(PyObjC_TestClass1.unsignedlonglongClsMethod(), 1 << 62)

    def testClsfloatResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertAlmostEqual(PyObjC_TestClass1.floatClsMethod(), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass1.floatClsMethod(), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass1.floatClsMethod(), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass1.floatClsMethod(), 1e10)

    def testClsdoubleResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertAlmostEqual(PyObjC_TestClass1.doubleClsMethod(), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass1.doubleClsMethod(), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass1.doubleClsMethod(), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass1.doubleClsMethod(), 1e10)

    def testClsidResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.idClsMethod(), NSPriorDayDesignations)

    def testClscharPtrResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.charPtrClsMethod(), b"hello")
        self.assertEqual(PyObjC_TestClass1.charPtrClsMethod(), b"world")
        self.assertEqual(PyObjC_TestClass1.charPtrClsMethod(), b"foobar")

    def testClsNSPointResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.NSPointClsMethod(), (1, 2))
        self.assertEqual(PyObjC_TestClass1.NSPointClsMethod(), (3, 4))

    def testClsNSRectResult(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.NSRectClsMethod(), ((1, 2), (3, 4)))
        self.assertEqual(PyObjC_TestClass1.NSRectClsMethod(), ((7, 8), (9, 10)))

    def testClsstructTestStruct1Result(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(
            PyObjC_TestClass1.structTestStruct1ClsMethod(), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(
            PyObjC_TestClass1.structTestStruct1ClsMethod(), (9, 8, (-1, -2, -3, -4, -5))
        )

    def testClsstructTestStruct2Result(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(
            PyObjC_TestClass1.structTestStruct2ClsMethod(), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(
            PyObjC_TestClass1.structTestStruct2ClsMethod(), (9, 8, (-1, -2, -3, -4, -5))
        )

    def testClsstructTestStruct3Result(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.structTestStruct3ClsMethod(), (1, 2))
        self.assertEqual(PyObjC_TestClass1.structTestStruct3ClsMethod(), (2, 4))

    def testClsstructTestStruct4Result(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.structTestStruct4ClsMethod(), (1, 1 << 60))
        self.assertEqual(PyObjC_TestClass1.structTestStruct4ClsMethod(), (2, 4))

    def testClsstructTestStruct5Result(self):
        PyObjC_TestClass1.clsReset()
        self.assertEqual(PyObjC_TestClass1.structTestStruct5ClsMethod(), (1, 2.5))
        self.assertEqual(PyObjC_TestClass1.structTestStruct5ClsMethod(), (2, 4.5))

    # Simple returns from instance methods

    def testboolResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.boolMethod(), YES)
        self.assertEqual(o.boolMethod(), NO)

    def testBOOLResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.BOOLMethod(), YES)
        self.assertEqual(o.BOOLMethod(), NO)

    def testcharResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.charMethod(), -128)
        self.assertEqual(o.charMethod(), 0)
        self.assertEqual(o.charMethod(), 127)

    def testsignedshortResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.signedshortMethod(), -(1 << 14))
        self.assertEqual(o.signedshortMethod(), -42)
        self.assertEqual(o.signedshortMethod(), 0)
        self.assertEqual(o.signedshortMethod(), 42)
        self.assertEqual(o.signedshortMethod(), 1 << 14)

    def testsignedintResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.signedintMethod(), -(1 << 30))
        self.assertEqual(o.signedintMethod(), -42)
        self.assertEqual(o.signedintMethod(), 0)
        self.assertEqual(o.signedintMethod(), 42)
        self.assertEqual(o.signedintMethod(), 1 << 30)

    def testsignedlongResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.signedlongMethod(), -(1 << 30))
        self.assertEqual(o.signedlongMethod(), -42)
        self.assertEqual(o.signedlongMethod(), 0)
        self.assertEqual(o.signedlongMethod(), 42)
        self.assertEqual(o.signedlongMethod(), 1 << 30)

    def testsignedlonglongResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.signedlonglongMethod(), -(1 << 60))
        self.assertEqual(o.signedlonglongMethod(), -42)
        self.assertEqual(o.signedlonglongMethod(), 0)
        self.assertEqual(o.signedlonglongMethod(), 42)
        self.assertEqual(o.signedlonglongMethod(), 1 << 60)

    def testunsignedcharResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.unsignedcharMethod(), 0)
        self.assertEqual(o.unsignedcharMethod(), 128)
        self.assertEqual(o.unsignedcharMethod(), 255)

    def testunsignedshortResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.unsignedshortMethod(), 0)
        self.assertEqual(o.unsignedshortMethod(), 42)
        self.assertEqual(o.unsignedshortMethod(), 1 << 14)

    def testunsignedintResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.unsignedintMethod(), 0)
        self.assertEqual(o.unsignedintMethod(), 42)
        self.assertEqual(o.unsignedintMethod(), 1 << 30)

    def testunsignedlongResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.unsignedlongMethod(), 0)
        self.assertEqual(o.unsignedlongMethod(), 42)
        self.assertEqual(o.unsignedlongMethod(), 1 << 30)

    def testunsignedlonglongResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.unsignedlonglongMethod(), 0)
        self.assertEqual(o.unsignedlonglongMethod(), 42)
        self.assertEqual(o.unsignedlonglongMethod(), 1 << 62)

    def testfloatResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(o.floatMethod(), 0.128)
        self.assertAlmostEqual(o.floatMethod(), 1.0)
        self.assertAlmostEqual(o.floatMethod(), 42.0)
        self.assertAlmostEqual(o.floatMethod(), 1e10)

    def testdoubleResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(o.doubleMethod(), 0.128)
        self.assertAlmostEqual(o.doubleMethod(), 1.0)
        self.assertAlmostEqual(o.doubleMethod(), 42.0)
        self.assertAlmostEqual(o.doubleMethod(), 1e10)

    def testidResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.idMethod(), NSPriorDayDesignations)

    def testcharPtrResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.charPtrMethod(), b"hello")
        self.assertEqual(o.charPtrMethod(), b"world")
        self.assertEqual(o.charPtrMethod(), b"foobar")

    def testNSPointResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.NSPointMethod(), (1, 2))
        self.assertEqual(o.NSPointMethod(), (3, 4))

    def testNSRectResult(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.NSRectMethod(), ((1, 2), (3, 4)))
        self.assertEqual(o.NSRectMethod(), ((7, 8), (9, 10)))

    def teststructTestStruct1Result(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.structTestStruct1Method(), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(o.structTestStruct1Method(), (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2Result(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.structTestStruct2Method(), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(o.structTestStruct2Method(), (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3Result(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.structTestStruct3Method(), (1, 2))
        self.assertEqual(o.structTestStruct3Method(), (2, 4))

    def teststructTestStruct4Result(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.structTestStruct4Method(), (1, 1 << 60))
        self.assertEqual(o.structTestStruct4Method(), (2, 4))

    def teststructTestStruct5Result(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(o.structTestStruct5Method(), (1, 2.5))
        self.assertEqual(o.structTestStruct5Method(), (2, 4.5))

    # One argument

    def testboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_(YES)
        self.assertEqual(r, YES)
        r = o.boolArg_(NO)
        self.assertEqual(r, NO)

    def testBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_(YES)
        self.assertEqual(r, YES)
        r = o.BOOLArg_(NO)
        self.assertEqual(r, NO)

    def testcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_(-128)
        self.assertEqual(r, -128)
        r = o.charArg_(0)
        self.assertEqual(r, 0)
        r = o.charArg_(127)
        self.assertEqual(r, 127)

    def testsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_(-(1 << 14))
        self.assertEqual(r, -(1 << 14))
        r = o.signedshortArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedshortArg_(0)
        self.assertEqual(r, 0)
        r = o.signedshortArg_(42)
        self.assertEqual(r, 42)
        r = o.signedshortArg_(1 << 14)
        self.assertEqual(r, 1 << 14)

    def testsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_(-(1 << 30))
        self.assertEqual(r, -(1 << 30))
        r = o.signedintArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedintArg_(0)
        self.assertEqual(r, 0)
        r = o.signedintArg_(42)
        self.assertEqual(r, 42)
        r = o.signedintArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_(-(1 << 30))
        self.assertEqual(r, -(1 << 30))
        r = o.signedlongArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedlongArg_(0)
        self.assertEqual(r, 0)
        r = o.signedlongArg_(42)
        self.assertEqual(r, 42)
        r = o.signedlongArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_(-(1 << 60))
        self.assertEqual(r, -(1 << 60))
        r = o.signedlonglongArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedlonglongArg_(0)
        self.assertEqual(r, 0)
        r = o.signedlonglongArg_(42)
        self.assertEqual(r, 42)
        r = o.signedlonglongArg_(1 << 60)
        self.assertEqual(r, 1 << 60)

    def testunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedcharArg_(128)
        self.assertEqual(r, 128)
        r = o.unsignedcharArg_(255)
        self.assertEqual(r, 255)

    def testunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedshortArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedshortArg_(1 << 14)
        self.assertEqual(r, 1 << 14)

    def testunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedintArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedintArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedlongArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedlongArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedlonglongArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedlonglongArg_(1 << 62)
        self.assertEqual(r, 1 << 62)

    def testfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_(0.128)
        self.assertAlmostEqual(r, 0.128)
        r = o.floatArg_(1.0)
        self.assertAlmostEqual(r, 1.0)
        r = o.floatArg_(42.0)
        self.assertAlmostEqual(r, 42.0)
        r = o.floatArg_(1e10)
        self.assertAlmostEqual(r, 1e10)

    def testdoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_(0.128)
        self.assertAlmostEqual(r, 0.128)
        r = o.doubleArg_(1.0)
        self.assertAlmostEqual(r, 1.0)
        r = o.doubleArg_(42.0)
        self.assertAlmostEqual(r, 42.0)
        r = o.doubleArg_(1e10)
        self.assertAlmostEqual(r, 1e10)

    def testidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_(NSPriorDayDesignations)
        self.assertEqual(r, NSPriorDayDesignations)

    def testcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_(b"hello")
        self.assertEqual(r, b"hello")
        r = o.charPtrArg_(b"world")
        self.assertEqual(r, b"world")
        r = o.charPtrArg_(b"foobar")
        self.assertEqual(r, b"foobar")

    def testNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_((1, 2))
        self.assertEqual(r, (1, 2))
        r = o.NSPointArg_((3, 4))
        self.assertEqual(r, (3, 4))

    def testNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_(((1, 2), (3, 4)))
        self.assertEqual(r, ((1, 2), (3, 4)))
        r = o.NSRectArg_(((7, 8), (9, 10)))
        self.assertEqual(r, ((7, 8), (9, 10)))

    def teststructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_((1, 2))
        self.assertEqual(r, (1, 2))
        r = o.structTestStruct3Arg_((2, 4))
        self.assertEqual(r, (2, 4))

    def teststructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_((1, 1 << 60))
        self.assertEqual(r, (1, 1 << 60))
        r = o.structTestStruct4Arg_((2, 4))
        self.assertEqual(r, (2, 4))

    def teststructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_((1, 2.5))
        self.assertEqual(r, (1, 2.5))
        r = o.structTestStruct5Arg_((2, 4.5))
        self.assertEqual(r, (2, 4.5))

    # Two arguments

    def testboolAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andboolArg_(YES, YES)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = o.boolArg_andboolArg_(YES, NO)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = o.boolArg_andboolArg_(NO, YES)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = o.boolArg_andboolArg_(NO, NO)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testboolAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andBOOLArg_(YES, YES)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = o.boolArg_andBOOLArg_(YES, NO)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = o.boolArg_andBOOLArg_(NO, YES)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = o.boolArg_andBOOLArg_(NO, NO)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testboolAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andcharArg_(YES, -128)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -128)
        r = o.boolArg_andcharArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andcharArg_(YES, 127)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 127)
        r = o.boolArg_andcharArg_(NO, -128)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -128)
        r = o.boolArg_andcharArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andcharArg_(NO, 127)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 127)

    def testboolAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andsignedshortArg_(YES, -(1 << 14))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 14))
        r = o.boolArg_andsignedshortArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedshortArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedshortArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedshortArg_(YES, 1 << 14)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = o.boolArg_andsignedshortArg_(NO, -(1 << 14))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 14))
        r = o.boolArg_andsignedshortArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedshortArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedshortArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedshortArg_(NO, 1 << 14)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testboolAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andsignedintArg_(YES, -(1 << 30))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = o.boolArg_andsignedintArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedintArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedintArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedintArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.boolArg_andsignedintArg_(NO, -(1 << 30))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = o.boolArg_andsignedintArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedintArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedintArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedintArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testboolAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andsignedlongArg_(YES, -(1 << 30))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = o.boolArg_andsignedlongArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedlongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedlongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedlongArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.boolArg_andsignedlongArg_(NO, -(1 << 30))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = o.boolArg_andsignedlongArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedlongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedlongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedlongArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testboolAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andsignedlonglongArg_(YES, -(1 << 60))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 60))
        r = o.boolArg_andsignedlonglongArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedlonglongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedlonglongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedlonglongArg_(YES, 1 << 60)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 60)
        r = o.boolArg_andsignedlonglongArg_(NO, -(1 << 60))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 60))
        r = o.boolArg_andsignedlonglongArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.boolArg_andsignedlonglongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andsignedlonglongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andsignedlonglongArg_(NO, 1 << 60)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 60)

    def testboolAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andunsignedcharArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedcharArg_(YES, 128)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 128)
        r = o.boolArg_andunsignedcharArg_(YES, 255)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 255)
        r = o.boolArg_andunsignedcharArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedcharArg_(NO, 128)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 128)
        r = o.boolArg_andunsignedcharArg_(NO, 255)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 255)

    def testboolAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andunsignedshortArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedshortArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedshortArg_(YES, 1 << 14)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = o.boolArg_andunsignedshortArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedshortArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedshortArg_(NO, 1 << 14)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testboolAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andunsignedintArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedintArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedintArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.boolArg_andunsignedintArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedintArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedintArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testboolAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andunsignedlongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedlongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedlongArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.boolArg_andunsignedlongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedlongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedlongArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testboolAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andunsignedlonglongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedlonglongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedlonglongArg_(YES, 1 << 62)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 62)
        r = o.boolArg_andunsignedlonglongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.boolArg_andunsignedlonglongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.boolArg_andunsignedlonglongArg_(NO, 1 << 62)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 62)

    def testboolAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andfloatArg_(YES, 0.128)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.boolArg_andfloatArg_(YES, 1.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.boolArg_andfloatArg_(YES, 42.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.boolArg_andfloatArg_(YES, 1e10)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.boolArg_andfloatArg_(NO, 0.128)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.boolArg_andfloatArg_(NO, 1.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.boolArg_andfloatArg_(NO, 42.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.boolArg_andfloatArg_(NO, 1e10)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1e10)

    def testboolAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_anddoubleArg_(YES, 0.128)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.boolArg_anddoubleArg_(YES, 1.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.boolArg_anddoubleArg_(YES, 42.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.boolArg_anddoubleArg_(YES, 1e10)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.boolArg_anddoubleArg_(NO, 0.128)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.boolArg_anddoubleArg_(NO, 1.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.boolArg_anddoubleArg_(NO, 42.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.boolArg_anddoubleArg_(NO, 1e10)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1e10)

    def testboolAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andidArg_(YES, NSPriorDayDesignations)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.boolArg_andidArg_(NO, NSPriorDayDesignations)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testboolAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andcharPtrArg_(YES, b"hello")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"hello")
        r = o.boolArg_andcharPtrArg_(YES, b"world")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"world")
        r = o.boolArg_andcharPtrArg_(YES, b"foobar")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"foobar")
        r = o.boolArg_andcharPtrArg_(NO, b"hello")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"hello")
        r = o.boolArg_andcharPtrArg_(NO, b"world")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"world")
        r = o.boolArg_andcharPtrArg_(NO, b"foobar")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"foobar")

    def testboolAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andNSPointArg_(YES, (1, 2))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2))
        r = o.boolArg_andNSPointArg_(YES, (3, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (3, 4))
        r = o.boolArg_andNSPointArg_(NO, (1, 2))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2))
        r = o.boolArg_andNSPointArg_(NO, (3, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (3, 4))

    def testboolAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andNSRectArg_(YES, ((1, 2), (3, 4)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.boolArg_andNSRectArg_(YES, ((7, 8), (9, 10)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.boolArg_andNSRectArg_(NO, ((1, 2), (3, 4)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.boolArg_andNSRectArg_(NO, ((7, 8), (9, 10)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testboolAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andstructTestStruct1Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.boolArg_andstructTestStruct1Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.boolArg_andstructTestStruct1Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.boolArg_andstructTestStruct1Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testboolAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andstructTestStruct2Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.boolArg_andstructTestStruct2Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.boolArg_andstructTestStruct2Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.boolArg_andstructTestStruct2Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testboolAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andstructTestStruct3Arg_(YES, (1, 2))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2))
        r = o.boolArg_andstructTestStruct3Arg_(YES, (2, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4))
        r = o.boolArg_andstructTestStruct3Arg_(NO, (1, 2))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2))
        r = o.boolArg_andstructTestStruct3Arg_(NO, (2, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4))

    def testboolAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andstructTestStruct4Arg_(YES, (1, 1 << 60))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.boolArg_andstructTestStruct4Arg_(YES, (2, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4))
        r = o.boolArg_andstructTestStruct4Arg_(NO, (1, 1 << 60))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.boolArg_andstructTestStruct4Arg_(NO, (2, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4))

    def testboolAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolArg_andstructTestStruct5Arg_(YES, (1, 2.5))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2.5))
        r = o.boolArg_andstructTestStruct5Arg_(YES, (2, 4.5))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4.5))
        r = o.boolArg_andstructTestStruct5Arg_(NO, (1, 2.5))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2.5))
        r = o.boolArg_andstructTestStruct5Arg_(NO, (2, 4.5))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4.5))

    def testBOOLAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andboolArg_(YES, YES)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = o.BOOLArg_andboolArg_(YES, NO)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = o.BOOLArg_andboolArg_(NO, YES)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = o.BOOLArg_andboolArg_(NO, NO)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testBOOLAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andBOOLArg_(YES, YES)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = o.BOOLArg_andBOOLArg_(YES, NO)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = o.BOOLArg_andBOOLArg_(NO, YES)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = o.BOOLArg_andBOOLArg_(NO, NO)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testBOOLAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andcharArg_(YES, -128)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -128)
        r = o.BOOLArg_andcharArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andcharArg_(YES, 127)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 127)
        r = o.BOOLArg_andcharArg_(NO, -128)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -128)
        r = o.BOOLArg_andcharArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andcharArg_(NO, 127)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 127)

    def testBOOLAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andsignedshortArg_(YES, -(1 << 14))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 14))
        r = o.BOOLArg_andsignedshortArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedshortArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedshortArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedshortArg_(YES, 1 << 14)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = o.BOOLArg_andsignedshortArg_(NO, -(1 << 14))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 14))
        r = o.BOOLArg_andsignedshortArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedshortArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedshortArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedshortArg_(NO, 1 << 14)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testBOOLAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andsignedintArg_(YES, -(1 << 30))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = o.BOOLArg_andsignedintArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedintArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedintArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedintArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.BOOLArg_andsignedintArg_(NO, -(1 << 30))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = o.BOOLArg_andsignedintArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedintArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedintArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedintArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testBOOLAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andsignedlongArg_(YES, -(1 << 30))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = o.BOOLArg_andsignedlongArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedlongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedlongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedlongArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.BOOLArg_andsignedlongArg_(NO, -(1 << 30))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = o.BOOLArg_andsignedlongArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedlongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedlongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedlongArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testBOOLAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andsignedlonglongArg_(YES, -(1 << 60))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 60))
        r = o.BOOLArg_andsignedlonglongArg_(YES, -42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedlonglongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedlonglongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedlonglongArg_(YES, 1 << 60)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 60)
        r = o.BOOLArg_andsignedlonglongArg_(NO, -(1 << 60))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 60))
        r = o.BOOLArg_andsignedlonglongArg_(NO, -42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = o.BOOLArg_andsignedlonglongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andsignedlonglongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andsignedlonglongArg_(NO, 1 << 60)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 60)

    def testBOOLAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andunsignedcharArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedcharArg_(YES, 128)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 128)
        r = o.BOOLArg_andunsignedcharArg_(YES, 255)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 255)
        r = o.BOOLArg_andunsignedcharArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedcharArg_(NO, 128)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 128)
        r = o.BOOLArg_andunsignedcharArg_(NO, 255)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 255)

    def testBOOLAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andunsignedshortArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedshortArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedshortArg_(YES, 1 << 14)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = o.BOOLArg_andunsignedshortArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedshortArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedshortArg_(NO, 1 << 14)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testBOOLAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andunsignedintArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedintArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedintArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.BOOLArg_andunsignedintArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedintArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedintArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testBOOLAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andunsignedlongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedlongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedlongArg_(YES, 1 << 30)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = o.BOOLArg_andunsignedlongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedlongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedlongArg_(NO, 1 << 30)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testBOOLAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andunsignedlonglongArg_(YES, 0)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedlonglongArg_(YES, 42)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedlonglongArg_(YES, 1 << 62)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 62)
        r = o.BOOLArg_andunsignedlonglongArg_(NO, 0)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = o.BOOLArg_andunsignedlonglongArg_(NO, 42)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = o.BOOLArg_andunsignedlonglongArg_(NO, 1 << 62)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 62)

    def testBOOLAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andfloatArg_(YES, 0.128)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.BOOLArg_andfloatArg_(YES, 1.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.BOOLArg_andfloatArg_(YES, 42.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.BOOLArg_andfloatArg_(YES, 1e10)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.BOOLArg_andfloatArg_(NO, 0.128)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.BOOLArg_andfloatArg_(NO, 1.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.BOOLArg_andfloatArg_(NO, 42.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.BOOLArg_andfloatArg_(NO, 1e10)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1e10)

    def testBOOLAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_anddoubleArg_(YES, 0.128)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.BOOLArg_anddoubleArg_(YES, 1.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.BOOLArg_anddoubleArg_(YES, 42.0)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.BOOLArg_anddoubleArg_(YES, 1e10)
        self.assertEqual(r[0], YES)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.BOOLArg_anddoubleArg_(NO, 0.128)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.BOOLArg_anddoubleArg_(NO, 1.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.BOOLArg_anddoubleArg_(NO, 42.0)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.BOOLArg_anddoubleArg_(NO, 1e10)
        self.assertEqual(r[0], NO)
        self.assertAlmostEqual(r[1], 1e10)

    def testBOOLAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andidArg_(YES, NSPriorDayDesignations)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.BOOLArg_andidArg_(NO, NSPriorDayDesignations)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testBOOLAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andcharPtrArg_(YES, b"hello")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"hello")
        r = o.BOOLArg_andcharPtrArg_(YES, b"world")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"world")
        r = o.BOOLArg_andcharPtrArg_(YES, b"foobar")
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], b"foobar")
        r = o.BOOLArg_andcharPtrArg_(NO, b"hello")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"hello")
        r = o.BOOLArg_andcharPtrArg_(NO, b"world")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"world")
        r = o.BOOLArg_andcharPtrArg_(NO, b"foobar")
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], b"foobar")

    def testBOOLAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andNSPointArg_(YES, (1, 2))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2))
        r = o.BOOLArg_andNSPointArg_(YES, (3, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (3, 4))
        r = o.BOOLArg_andNSPointArg_(NO, (1, 2))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2))
        r = o.BOOLArg_andNSPointArg_(NO, (3, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (3, 4))

    def testBOOLAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andNSRectArg_(YES, ((1, 2), (3, 4)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.BOOLArg_andNSRectArg_(YES, ((7, 8), (9, 10)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.BOOLArg_andNSRectArg_(NO, ((1, 2), (3, 4)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.BOOLArg_andNSRectArg_(NO, ((7, 8), (9, 10)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testBOOLAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andstructTestStruct1Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.BOOLArg_andstructTestStruct1Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.BOOLArg_andstructTestStruct1Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.BOOLArg_andstructTestStruct1Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testBOOLAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andstructTestStruct2Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.BOOLArg_andstructTestStruct2Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.BOOLArg_andstructTestStruct2Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.BOOLArg_andstructTestStruct2Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testBOOLAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andstructTestStruct3Arg_(YES, (1, 2))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2))
        r = o.BOOLArg_andstructTestStruct3Arg_(YES, (2, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4))
        r = o.BOOLArg_andstructTestStruct3Arg_(NO, (1, 2))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2))
        r = o.BOOLArg_andstructTestStruct3Arg_(NO, (2, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4))

    def testBOOLAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andstructTestStruct4Arg_(YES, (1, 1 << 60))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.BOOLArg_andstructTestStruct4Arg_(YES, (2, 4))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4))
        r = o.BOOLArg_andstructTestStruct4Arg_(NO, (1, 1 << 60))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.BOOLArg_andstructTestStruct4Arg_(NO, (2, 4))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4))

    def testBOOLAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLArg_andstructTestStruct5Arg_(YES, (1, 2.5))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (1, 2.5))
        r = o.BOOLArg_andstructTestStruct5Arg_(YES, (2, 4.5))
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], (2, 4.5))
        r = o.BOOLArg_andstructTestStruct5Arg_(NO, (1, 2.5))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (1, 2.5))
        r = o.BOOLArg_andstructTestStruct5Arg_(NO, (2, 4.5))
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], (2, 4.5))

    def testcharAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andboolArg_(-128, YES)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], YES)
        r = o.charArg_andboolArg_(-128, NO)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], NO)
        r = o.charArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.charArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.charArg_andboolArg_(127, YES)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], YES)
        r = o.charArg_andboolArg_(127, NO)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], NO)

    def testcharAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andBOOLArg_(-128, YES)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], YES)
        r = o.charArg_andBOOLArg_(-128, NO)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], NO)
        r = o.charArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.charArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.charArg_andBOOLArg_(127, YES)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], YES)
        r = o.charArg_andBOOLArg_(127, NO)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], NO)

    def testcharAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andcharArg_(-128, -128)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -128)
        r = o.charArg_andcharArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andcharArg_(-128, 127)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 127)
        r = o.charArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.charArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.charArg_andcharArg_(127, -128)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -128)
        r = o.charArg_andcharArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andcharArg_(127, 127)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 127)

    def testcharAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andsignedshortArg_(-128, -(1 << 14))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -(1 << 14))
        r = o.charArg_andsignedshortArg_(-128, -42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedshortArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedshortArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedshortArg_(-128, 1 << 14)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 14)
        r = o.charArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.charArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.charArg_andsignedshortArg_(127, -(1 << 14))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -(1 << 14))
        r = o.charArg_andsignedshortArg_(127, -42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedshortArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedshortArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedshortArg_(127, 1 << 14)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 14)

    def testcharAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andsignedintArg_(-128, -(1 << 30))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedintArg_(-128, -42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedintArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedintArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedintArg_(-128, 1 << 30)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andsignedintArg_(127, -(1 << 30))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedintArg_(127, -42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedintArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedintArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedintArg_(127, 1 << 30)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 30)

    def testcharAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andsignedlongArg_(-128, -(1 << 30))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedlongArg_(-128, -42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlongArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlongArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlongArg_(-128, 1 << 30)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andsignedlongArg_(127, -(1 << 30))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -(1 << 30))
        r = o.charArg_andsignedlongArg_(127, -42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlongArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlongArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlongArg_(127, 1 << 30)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 30)

    def testcharAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andsignedlonglongArg_(-128, -(1 << 60))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -(1 << 60))
        r = o.charArg_andsignedlonglongArg_(-128, -42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlonglongArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlonglongArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlonglongArg_(-128, 1 << 60)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 60)
        r = o.charArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.charArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.charArg_andsignedlonglongArg_(127, -(1 << 60))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -(1 << 60))
        r = o.charArg_andsignedlonglongArg_(127, -42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -42)
        r = o.charArg_andsignedlonglongArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andsignedlonglongArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andsignedlonglongArg_(127, 1 << 60)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 60)

    def testcharAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andunsignedcharArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedcharArg_(-128, 128)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 128)
        r = o.charArg_andunsignedcharArg_(-128, 255)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 255)
        r = o.charArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.charArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.charArg_andunsignedcharArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedcharArg_(127, 128)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 128)
        r = o.charArg_andunsignedcharArg_(127, 255)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 255)

    def testcharAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andunsignedshortArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedshortArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedshortArg_(-128, 1 << 14)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 14)
        r = o.charArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.charArg_andunsignedshortArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedshortArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedshortArg_(127, 1 << 14)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 14)

    def testcharAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andunsignedintArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedintArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedintArg_(-128, 1 << 30)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andunsignedintArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedintArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedintArg_(127, 1 << 30)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 30)

    def testcharAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andunsignedlongArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlongArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlongArg_(-128, 1 << 30)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.charArg_andunsignedlongArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlongArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlongArg_(127, 1 << 30)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 30)

    def testcharAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andunsignedlonglongArg_(-128, 0)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlonglongArg_(-128, 42)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlonglongArg_(-128, 1 << 62)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 1 << 62)
        r = o.charArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.charArg_andunsignedlonglongArg_(127, 0)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 0)
        r = o.charArg_andunsignedlonglongArg_(127, 42)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 42)
        r = o.charArg_andunsignedlonglongArg_(127, 1 << 62)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], 1 << 62)

    def testcharAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andfloatArg_(-128, 0.128)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_andfloatArg_(-128, 1.0)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_andfloatArg_(-128, 42.0)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_andfloatArg_(-128, 1e10)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charArg_andfloatArg_(127, 0.128)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_andfloatArg_(127, 1.0)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_andfloatArg_(127, 42.0)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_andfloatArg_(127, 1e10)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 1e10)

    def testcharAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_anddoubleArg_(-128, 0.128)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_anddoubleArg_(-128, 1.0)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_anddoubleArg_(-128, 42.0)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_anddoubleArg_(-128, 1e10)
        self.assertEqual(r[0], -128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charArg_anddoubleArg_(127, 0.128)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charArg_anddoubleArg_(127, 1.0)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charArg_anddoubleArg_(127, 42.0)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charArg_anddoubleArg_(127, 1e10)
        self.assertEqual(r[0], 127)
        self.assertAlmostEqual(r[1], 1e10)

    def testcharAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andidArg_(-128, NSPriorDayDesignations)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.charArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.charArg_andidArg_(127, NSPriorDayDesignations)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testcharAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andcharPtrArg_(-128, b"hello")
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], b"hello")
        r = o.charArg_andcharPtrArg_(-128, b"world")
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], b"world")
        r = o.charArg_andcharPtrArg_(-128, b"foobar")
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], b"foobar")
        r = o.charArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.charArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.charArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.charArg_andcharPtrArg_(127, b"hello")
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], b"hello")
        r = o.charArg_andcharPtrArg_(127, b"world")
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], b"world")
        r = o.charArg_andcharPtrArg_(127, b"foobar")
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], b"foobar")

    def testcharAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andNSPointArg_(-128, (1, 2))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andNSPointArg_(-128, (3, 4))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (3, 4))
        r = o.charArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.charArg_andNSPointArg_(127, (1, 2))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andNSPointArg_(127, (3, 4))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (3, 4))

    def testcharAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andNSRectArg_(-128, ((1, 2), (3, 4)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charArg_andNSRectArg_(-128, ((7, 8), (9, 10)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.charArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.charArg_andNSRectArg_(127, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charArg_andNSRectArg_(127, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testcharAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andstructTestStruct1Arg_(-128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct1Arg_(-128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charArg_andstructTestStruct1Arg_(127, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct1Arg_(127, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testcharAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andstructTestStruct2Arg_(-128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct2Arg_(-128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charArg_andstructTestStruct2Arg_(127, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charArg_andstructTestStruct2Arg_(127, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testcharAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andstructTestStruct3Arg_(-128, (1, 2))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andstructTestStruct3Arg_(-128, (2, 4))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (2, 4))
        r = o.charArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.charArg_andstructTestStruct3Arg_(127, (1, 2))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 2))
        r = o.charArg_andstructTestStruct3Arg_(127, (2, 4))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (2, 4))

    def testcharAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andstructTestStruct4Arg_(-128, (1, 1 << 60))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charArg_andstructTestStruct4Arg_(-128, (2, 4))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (2, 4))
        r = o.charArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.charArg_andstructTestStruct4Arg_(127, (1, 1 << 60))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charArg_andstructTestStruct4Arg_(127, (2, 4))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (2, 4))

    def testcharAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charArg_andstructTestStruct5Arg_(-128, (1, 2.5))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (1, 2.5))
        r = o.charArg_andstructTestStruct5Arg_(-128, (2, 4.5))
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], (2, 4.5))
        r = o.charArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.charArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.charArg_andstructTestStruct5Arg_(127, (1, 2.5))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (1, 2.5))
        r = o.charArg_andstructTestStruct5Arg_(127, (2, 4.5))
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], (2, 4.5))

    def testsignedshortAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andboolArg_(-(1 << 14), YES)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andboolArg_(-(1 << 14), NO)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andboolArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andboolArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andboolArg_(1 << 14, YES)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andboolArg_(1 << 14, NO)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NO)

    def testsignedshortAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andBOOLArg_(-(1 << 14), YES)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andBOOLArg_(-(1 << 14), NO)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andBOOLArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andBOOLArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedshortArg_andBOOLArg_(1 << 14, YES)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], YES)
        r = o.signedshortArg_andBOOLArg_(1 << 14, NO)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NO)

    def testsignedshortAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andcharArg_(-(1 << 14), -128)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -128)
        r = o.signedshortArg_andcharArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andcharArg_(-(1 << 14), 127)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 127)
        r = o.signedshortArg_andcharArg_(-42, -128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -128)
        r = o.signedshortArg_andcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andcharArg_(-42, 127)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 127)
        r = o.signedshortArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.signedshortArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.signedshortArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.signedshortArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.signedshortArg_andcharArg_(1 << 14, -128)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -128)
        r = o.signedshortArg_andcharArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andcharArg_(1 << 14, 127)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 127)

    def testsignedshortAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andsignedshortArg_(-(1 << 14), -(1 << 14))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortArg_andsignedshortArg_(-(1 << 14), -42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedshortArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedshortArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedshortArg_(-(1 << 14), 1 << 14)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andsignedshortArg_(-42, -(1 << 14))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortArg_andsignedshortArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andsignedshortArg_(1 << 14, -(1 << 14))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortArg_andsignedshortArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedshortArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedshortArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedshortArg_(1 << 14, 1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 14)

    def testsignedshortAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andsignedintArg_(-(1 << 14), -(1 << 30))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedintArg_(-(1 << 14), -42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedintArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedintArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedintArg_(-(1 << 14), 1 << 30)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedintArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedintArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedintArg_(1 << 14, -(1 << 30))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedintArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedintArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedintArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedintArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testsignedshortAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andsignedlongArg_(-(1 << 14), -(1 << 30))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedlongArg_(-(1 << 14), -42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlongArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlongArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlongArg_(-(1 << 14), 1 << 30)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedlongArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedlongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andsignedlongArg_(1 << 14, -(1 << 30))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedshortArg_andsignedlongArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlongArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testsignedshortAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andsignedlonglongArg_(-(1 << 14), -(1 << 60))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedshortArg_andsignedlonglongArg_(-(1 << 14), -42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlonglongArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlonglongArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlonglongArg_(-(1 << 14), 1 << 60)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 60)
        r = o.signedshortArg_andsignedlonglongArg_(-42, -(1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedshortArg_andsignedlonglongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlonglongArg_(-42, 1 << 60)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedshortArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedshortArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedshortArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedshortArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedshortArg_andsignedlonglongArg_(1 << 14, -(1 << 60))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedshortArg_andsignedlonglongArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 1 << 60)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 60)

    def testsignedshortAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andunsignedcharArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedcharArg_(-(1 << 14), 128)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 128)
        r = o.signedshortArg_andunsignedcharArg_(-(1 << 14), 255)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 255)
        r = o.signedshortArg_andunsignedcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedcharArg_(-42, 128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 128)
        r = o.signedshortArg_andunsignedcharArg_(-42, 255)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 255)
        r = o.signedshortArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.signedshortArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.signedshortArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.signedshortArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.signedshortArg_andunsignedcharArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedcharArg_(1 << 14, 128)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 128)
        r = o.signedshortArg_andunsignedcharArg_(1 << 14, 255)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 255)

    def testsignedshortAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andunsignedshortArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedshortArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedshortArg_(-(1 << 14), 1 << 14)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andunsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedshortArg_andunsignedshortArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedshortArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedshortArg_(1 << 14, 1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 14)

    def testsignedshortAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andunsignedintArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedintArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedintArg_(-(1 << 14), 1 << 30)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedintArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedintArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedintArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testsignedshortAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andunsignedlongArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlongArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlongArg_(-(1 << 14), 1 << 30)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedshortArg_andunsignedlongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlongArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testsignedshortAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andunsignedlonglongArg_(-(1 << 14), 0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlonglongArg_(-(1 << 14), 42)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlonglongArg_(-(1 << 14), 1 << 62)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 62)
        r = o.signedshortArg_andunsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlonglongArg_(-42, 1 << 62)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedshortArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedshortArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 1 << 62)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 62)

    def testsignedshortAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andfloatArg_(-(1 << 14), 0.128)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_andfloatArg_(-(1 << 14), 1.0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_andfloatArg_(-(1 << 14), 42.0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_andfloatArg_(-(1 << 14), 1e10)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_andfloatArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_andfloatArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_andfloatArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_andfloatArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_andfloatArg_(1 << 14, 0.128)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_andfloatArg_(1 << 14, 1.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_andfloatArg_(1 << 14, 42.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_andfloatArg_(1 << 14, 1e10)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedshortAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_anddoubleArg_(-(1 << 14), 0.128)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_anddoubleArg_(-(1 << 14), 1.0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_anddoubleArg_(-(1 << 14), 42.0)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_anddoubleArg_(-(1 << 14), 1e10)
        self.assertEqual(r[0], -(1 << 14))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_anddoubleArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_anddoubleArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_anddoubleArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_anddoubleArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedshortArg_anddoubleArg_(1 << 14, 0.128)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedshortArg_anddoubleArg_(1 << 14, 1.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedshortArg_anddoubleArg_(1 << 14, 42.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedshortArg_anddoubleArg_(1 << 14, 1e10)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedshortAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andidArg_(-(1 << 14), NSPriorDayDesignations)
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedshortArg_andidArg_(-42, NSPriorDayDesignations)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedshortArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedshortArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedshortArg_andidArg_(1 << 14, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testsignedshortAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andcharPtrArg_(-(1 << 14), b"hello")
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], b"hello")
        r = o.signedshortArg_andcharPtrArg_(-(1 << 14), b"world")
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], b"world")
        r = o.signedshortArg_andcharPtrArg_(-(1 << 14), b"foobar")
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], b"foobar")
        r = o.signedshortArg_andcharPtrArg_(-42, b"hello")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"hello")
        r = o.signedshortArg_andcharPtrArg_(-42, b"world")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"world")
        r = o.signedshortArg_andcharPtrArg_(-42, b"foobar")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedshortArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.signedshortArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.signedshortArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.signedshortArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.signedshortArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.signedshortArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedshortArg_andcharPtrArg_(1 << 14, b"hello")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"hello")
        r = o.signedshortArg_andcharPtrArg_(1 << 14, b"world")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"world")
        r = o.signedshortArg_andcharPtrArg_(1 << 14, b"foobar")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"foobar")

    def testsignedshortAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andNSPointArg_(-(1 << 14), (1, 2))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andNSPointArg_(-(1 << 14), (3, 4))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (3, 4))
        r = o.signedshortArg_andNSPointArg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andNSPointArg_(-42, (3, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedshortArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.signedshortArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedshortArg_andNSPointArg_(1 << 14, (1, 2))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andNSPointArg_(1 << 14, (3, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (3, 4))

    def testsignedshortAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andNSRectArg_(-(1 << 14), ((1, 2), (3, 4)))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedshortArg_andNSRectArg_(-(1 << 14), ((7, 8), (9, 10)))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedshortArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedshortArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedshortArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedshortArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedshortArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedshortArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedshortArg_andNSRectArg_(1 << 14, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedshortArg_andNSRectArg_(1 << 14, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testsignedshortAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andstructTestStruct1Arg_(
            -(1 << 14), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(
            -(1 << 14), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(1 << 14, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct1Arg_(
            1 << 14, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedshortAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andstructTestStruct2Arg_(
            -(1 << 14), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(
            -(1 << 14), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(1 << 14, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedshortArg_andstructTestStruct2Arg_(
            1 << 14, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedshortAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andstructTestStruct3Arg_(-(1 << 14), (1, 2))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andstructTestStruct3Arg_(-(1 << 14), (2, 4))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct3Arg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andstructTestStruct3Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct3Arg_(1 << 14, (1, 2))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2))
        r = o.signedshortArg_andstructTestStruct3Arg_(1 << 14, (2, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4))

    def testsignedshortAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andstructTestStruct4Arg_(-(1 << 14), (1, 1 << 60))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedshortArg_andstructTestStruct4Arg_(-(1 << 14), (2, 4))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct4Arg_(-42, (1, 1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedshortArg_andstructTestStruct4Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedshortArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedshortArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedshortArg_andstructTestStruct4Arg_(1 << 14, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedshortArg_andstructTestStruct4Arg_(1 << 14, (2, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4))

    def testsignedshortAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortArg_andstructTestStruct5Arg_(-(1 << 14), (1, 2.5))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(-(1 << 14), (2, 4.5))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(-42, (1, 2.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(-42, (2, 4.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(1 << 14, (1, 2.5))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedshortArg_andstructTestStruct5Arg_(1 << 14, (2, 4.5))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4.5))

    def testsignedintAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andboolArg_(-(1 << 30), YES)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andboolArg_(-(1 << 30), NO)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andboolArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andboolArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andboolArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andboolArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testsignedintAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andBOOLArg_(-(1 << 30), YES)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andBOOLArg_(-(1 << 30), NO)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andBOOLArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andBOOLArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedintArg_andBOOLArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.signedintArg_andBOOLArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testsignedintAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andcharArg_(-(1 << 30), -128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -128)
        r = o.signedintArg_andcharArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andcharArg_(-(1 << 30), 127)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 127)
        r = o.signedintArg_andcharArg_(-42, -128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -128)
        r = o.signedintArg_andcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andcharArg_(-42, 127)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 127)
        r = o.signedintArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.signedintArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.signedintArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.signedintArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.signedintArg_andcharArg_(1 << 30, -128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -128)
        r = o.signedintArg_andcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andcharArg_(1 << 30, 127)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 127)

    def testsignedintAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andsignedshortArg_(-(1 << 30), -(1 << 14))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedintArg_andsignedshortArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedshortArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedshortArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedshortArg_(-(1 << 30), 1 << 14)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andsignedshortArg_(-42, -(1 << 14))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedintArg_andsignedshortArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedintArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedintArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andsignedshortArg_(1 << 30, -(1 << 14))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedintArg_andsignedshortArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testsignedintAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andsignedintArg_(-(1 << 30), -(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedintArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedintArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedintArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedintArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedintArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedintArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedintArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedintArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedintAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andsignedlongArg_(-(1 << 30), -(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedlongArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlongArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedlongArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedlongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andsignedlongArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintArg_andsignedlongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedintAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andsignedlonglongArg_(-(1 << 30), -(1 << 60))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedintArg_andsignedlonglongArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlonglongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlonglongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlonglongArg_(-(1 << 30), 1 << 60)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 60)
        r = o.signedintArg_andsignedlonglongArg_(-42, -(1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedintArg_andsignedlonglongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlonglongArg_(-42, 1 << 60)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedintArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedintArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedintArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedintArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedintArg_andsignedlonglongArg_(1 << 30, -(1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedintArg_andsignedlonglongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedintArg_andsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andsignedlonglongArg_(1 << 30, 1 << 60)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 60)

    def testsignedintAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andunsignedcharArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedcharArg_(-(1 << 30), 128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 128)
        r = o.signedintArg_andunsignedcharArg_(-(1 << 30), 255)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 255)
        r = o.signedintArg_andunsignedcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedcharArg_(-42, 128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 128)
        r = o.signedintArg_andunsignedcharArg_(-42, 255)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 255)
        r = o.signedintArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.signedintArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.signedintArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.signedintArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.signedintArg_andunsignedcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedcharArg_(1 << 30, 128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 128)
        r = o.signedintArg_andunsignedcharArg_(1 << 30, 255)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 255)

    def testsignedintAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andunsignedshortArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedshortArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedshortArg_(-(1 << 30), 1 << 14)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andunsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedintArg_andunsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testsignedintAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andunsignedintArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedintArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedintArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedintAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andunsignedlongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlongArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedintArg_andunsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedintAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andunsignedlonglongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlonglongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlonglongArg_(-(1 << 30), 1 << 62)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 62)
        r = o.signedintArg_andunsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlonglongArg_(-42, 1 << 62)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedintArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedintArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 1 << 62)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 62)

    def testsignedintAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andfloatArg_(-(1 << 30), 0.128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_andfloatArg_(-(1 << 30), 1.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_andfloatArg_(-(1 << 30), 42.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_andfloatArg_(-(1 << 30), 1e10)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_andfloatArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_andfloatArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_andfloatArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_andfloatArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_andfloatArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_andfloatArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_andfloatArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_andfloatArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedintAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_anddoubleArg_(-(1 << 30), 0.128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_anddoubleArg_(-(1 << 30), 1.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_anddoubleArg_(-(1 << 30), 42.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_anddoubleArg_(-(1 << 30), 1e10)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_anddoubleArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_anddoubleArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_anddoubleArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_anddoubleArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedintArg_anddoubleArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedintArg_anddoubleArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedintArg_anddoubleArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedintArg_anddoubleArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedintAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andidArg_(-(1 << 30), NSPriorDayDesignations)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedintArg_andidArg_(-42, NSPriorDayDesignations)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedintArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedintArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedintArg_andidArg_(1 << 30, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testsignedintAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andcharPtrArg_(-(1 << 30), b"hello")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"hello")
        r = o.signedintArg_andcharPtrArg_(-(1 << 30), b"world")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"world")
        r = o.signedintArg_andcharPtrArg_(-(1 << 30), b"foobar")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"foobar")
        r = o.signedintArg_andcharPtrArg_(-42, b"hello")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"hello")
        r = o.signedintArg_andcharPtrArg_(-42, b"world")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"world")
        r = o.signedintArg_andcharPtrArg_(-42, b"foobar")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedintArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.signedintArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.signedintArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.signedintArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.signedintArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.signedintArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedintArg_andcharPtrArg_(1 << 30, b"hello")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"hello")
        r = o.signedintArg_andcharPtrArg_(1 << 30, b"world")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"world")
        r = o.signedintArg_andcharPtrArg_(1 << 30, b"foobar")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"foobar")

    def testsignedintAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andNSPointArg_(-(1 << 30), (1, 2))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andNSPointArg_(-(1 << 30), (3, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (3, 4))
        r = o.signedintArg_andNSPointArg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andNSPointArg_(-42, (3, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedintArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.signedintArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedintArg_andNSPointArg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andNSPointArg_(1 << 30, (3, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (3, 4))

    def testsignedintAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andNSRectArg_(-(1 << 30), ((1, 2), (3, 4)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedintArg_andNSRectArg_(-(1 << 30), ((7, 8), (9, 10)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedintArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedintArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedintArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedintArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedintArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedintArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedintArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedintArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testsignedintAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andstructTestStruct1Arg_(-(1 << 30), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct1Arg_(
            -(1 << 30), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct1Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedintAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andstructTestStruct2Arg_(-(1 << 30), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct2Arg_(
            -(1 << 30), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedintArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedintArg_andstructTestStruct2Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedintAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andstructTestStruct3Arg_(-(1 << 30), (1, 2))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andstructTestStruct3Arg_(-(1 << 30), (2, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct3Arg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andstructTestStruct3Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.signedintArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testsignedintAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andstructTestStruct4Arg_(-(1 << 30), (1, 1 << 60))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedintArg_andstructTestStruct4Arg_(-(1 << 30), (2, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct4Arg_(-42, (1, 1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedintArg_andstructTestStruct4Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedintArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedintArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedintArg_andstructTestStruct4Arg_(1 << 30, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedintArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testsignedintAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintArg_andstructTestStruct5Arg_(-(1 << 30), (1, 2.5))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedintArg_andstructTestStruct5Arg_(-(1 << 30), (2, 4.5))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedintArg_andstructTestStruct5Arg_(-42, (1, 2.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedintArg_andstructTestStruct5Arg_(-42, (2, 4.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedintArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedintArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedintArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedintArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedintArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedintArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4.5))

    def testsignedlongAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andboolArg_(-(1 << 30), YES)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andboolArg_(-(1 << 30), NO)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andboolArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andboolArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andboolArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andboolArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testsignedlongAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andBOOLArg_(-(1 << 30), YES)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andBOOLArg_(-(1 << 30), NO)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andBOOLArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andBOOLArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedlongArg_andBOOLArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.signedlongArg_andBOOLArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testsignedlongAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andcharArg_(-(1 << 30), -128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -128)
        r = o.signedlongArg_andcharArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andcharArg_(-(1 << 30), 127)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 127)
        r = o.signedlongArg_andcharArg_(-42, -128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -128)
        r = o.signedlongArg_andcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andcharArg_(-42, 127)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 127)
        r = o.signedlongArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.signedlongArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.signedlongArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.signedlongArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.signedlongArg_andcharArg_(1 << 30, -128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -128)
        r = o.signedlongArg_andcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andcharArg_(1 << 30, 127)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 127)

    def testsignedlongAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andsignedshortArg_(-(1 << 30), -(1 << 14))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlongArg_andsignedshortArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedshortArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedshortArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedshortArg_(-(1 << 30), 1 << 14)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andsignedshortArg_(-42, -(1 << 14))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlongArg_andsignedshortArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlongArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlongArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andsignedshortArg_(1 << 30, -(1 << 14))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlongArg_andsignedshortArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testsignedlongAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andsignedintArg_(-(1 << 30), -(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedintArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedintArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedintArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedintArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedintArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedintArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedintArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedintArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlongAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andsignedlongArg_(-(1 << 30), -(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedlongArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlongArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedlongArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedlongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andsignedlongArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongArg_andsignedlongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlongAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andsignedlonglongArg_(-(1 << 30), -(1 << 60))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlongArg_andsignedlonglongArg_(-(1 << 30), -42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlonglongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlonglongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlonglongArg_(-(1 << 30), 1 << 60)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlongArg_andsignedlonglongArg_(-42, -(1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlongArg_andsignedlonglongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlonglongArg_(-42, 1 << 60)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlongArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlongArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlongArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlongArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlongArg_andsignedlonglongArg_(1 << 30, -(1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlongArg_andsignedlonglongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 1 << 60)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 60)

    def testsignedlongAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andunsignedcharArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedcharArg_(-(1 << 30), 128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 128)
        r = o.signedlongArg_andunsignedcharArg_(-(1 << 30), 255)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 255)
        r = o.signedlongArg_andunsignedcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedcharArg_(-42, 128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 128)
        r = o.signedlongArg_andunsignedcharArg_(-42, 255)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 255)
        r = o.signedlongArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.signedlongArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.signedlongArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.signedlongArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.signedlongArg_andunsignedcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedcharArg_(1 << 30, 128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 128)
        r = o.signedlongArg_andunsignedcharArg_(1 << 30, 255)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 255)

    def testsignedlongAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andunsignedshortArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedshortArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedshortArg_(-(1 << 30), 1 << 14)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andunsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlongArg_andunsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testsignedlongAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andunsignedintArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedintArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedintArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlongAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andunsignedlongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlongArg_(-(1 << 30), 1 << 30)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlongArg_andunsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlongAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andunsignedlonglongArg_(-(1 << 30), 0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlonglongArg_(-(1 << 30), 42)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlonglongArg_(-(1 << 30), 1 << 62)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlongArg_andunsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlonglongArg_(-42, 1 << 62)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlongArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlongArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 1 << 62)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 62)

    def testsignedlongAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andfloatArg_(-(1 << 30), 0.128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_andfloatArg_(-(1 << 30), 1.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_andfloatArg_(-(1 << 30), 42.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_andfloatArg_(-(1 << 30), 1e10)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_andfloatArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_andfloatArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_andfloatArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_andfloatArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_andfloatArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_andfloatArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_andfloatArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_andfloatArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedlongAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_anddoubleArg_(-(1 << 30), 0.128)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_anddoubleArg_(-(1 << 30), 1.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_anddoubleArg_(-(1 << 30), 42.0)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_anddoubleArg_(-(1 << 30), 1e10)
        self.assertEqual(r[0], -(1 << 30))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_anddoubleArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_anddoubleArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_anddoubleArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_anddoubleArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlongArg_anddoubleArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlongArg_anddoubleArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlongArg_anddoubleArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlongArg_anddoubleArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedlongAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andidArg_(-(1 << 30), NSPriorDayDesignations)
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlongArg_andidArg_(-42, NSPriorDayDesignations)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlongArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlongArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlongArg_andidArg_(1 << 30, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testsignedlongAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andcharPtrArg_(-(1 << 30), b"hello")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"hello")
        r = o.signedlongArg_andcharPtrArg_(-(1 << 30), b"world")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"world")
        r = o.signedlongArg_andcharPtrArg_(-(1 << 30), b"foobar")
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], b"foobar")
        r = o.signedlongArg_andcharPtrArg_(-42, b"hello")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"hello")
        r = o.signedlongArg_andcharPtrArg_(-42, b"world")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"world")
        r = o.signedlongArg_andcharPtrArg_(-42, b"foobar")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlongArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.signedlongArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.signedlongArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlongArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.signedlongArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.signedlongArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlongArg_andcharPtrArg_(1 << 30, b"hello")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"hello")
        r = o.signedlongArg_andcharPtrArg_(1 << 30, b"world")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"world")
        r = o.signedlongArg_andcharPtrArg_(1 << 30, b"foobar")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"foobar")

    def testsignedlongAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andNSPointArg_(-(1 << 30), (1, 2))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andNSPointArg_(-(1 << 30), (3, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (3, 4))
        r = o.signedlongArg_andNSPointArg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andNSPointArg_(-42, (3, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlongArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlongArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlongArg_andNSPointArg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andNSPointArg_(1 << 30, (3, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (3, 4))

    def testsignedlongAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andNSRectArg_(-(1 << 30), ((1, 2), (3, 4)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlongArg_andNSRectArg_(-(1 << 30), ((7, 8), (9, 10)))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlongArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlongArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlongArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlongArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testsignedlongAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andstructTestStruct1Arg_(
            -(1 << 30), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(
            -(1 << 30), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct1Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedlongAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andstructTestStruct2Arg_(
            -(1 << 30), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(
            -(1 << 30), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlongArg_andstructTestStruct2Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedlongAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andstructTestStruct3Arg_(-(1 << 30), (1, 2))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andstructTestStruct3Arg_(-(1 << 30), (2, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct3Arg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andstructTestStruct3Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlongArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testsignedlongAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andstructTestStruct4Arg_(-(1 << 30), (1, 1 << 60))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlongArg_andstructTestStruct4Arg_(-(1 << 30), (2, 4))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct4Arg_(-42, (1, 1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlongArg_andstructTestStruct4Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlongArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlongArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlongArg_andstructTestStruct4Arg_(1 << 30, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlongArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testsignedlongAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongArg_andstructTestStruct5Arg_(-(1 << 30), (1, 2.5))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(-(1 << 30), (2, 4.5))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(-42, (1, 2.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(-42, (2, 4.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlongArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4.5))

    def testsignedlonglongAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andboolArg_(-(1 << 60), YES)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andboolArg_(-(1 << 60), NO)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andboolArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andboolArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andboolArg_(1 << 60, YES)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andboolArg_(1 << 60, NO)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], NO)

    def testsignedlonglongAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andBOOLArg_(-(1 << 60), YES)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andBOOLArg_(-(1 << 60), NO)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andBOOLArg_(-42, YES)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andBOOLArg_(-42, NO)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.signedlonglongArg_andBOOLArg_(1 << 60, YES)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], YES)
        r = o.signedlonglongArg_andBOOLArg_(1 << 60, NO)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], NO)

    def testsignedlonglongAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andcharArg_(-(1 << 60), -128)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -128)
        r = o.signedlonglongArg_andcharArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andcharArg_(-(1 << 60), 127)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 127)
        r = o.signedlonglongArg_andcharArg_(-42, -128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -128)
        r = o.signedlonglongArg_andcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andcharArg_(-42, 127)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 127)
        r = o.signedlonglongArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.signedlonglongArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.signedlonglongArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.signedlonglongArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.signedlonglongArg_andcharArg_(1 << 60, -128)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -128)
        r = o.signedlonglongArg_andcharArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andcharArg_(1 << 60, 127)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 127)

    def testsignedlonglongAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andsignedshortArg_(-(1 << 60), -(1 << 14))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlonglongArg_andsignedshortArg_(-(1 << 60), -42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedshortArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedshortArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedshortArg_(-(1 << 60), 1 << 14)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andsignedshortArg_(-42, -(1 << 14))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlonglongArg_andsignedshortArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlonglongArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlonglongArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andsignedshortArg_(1 << 60, -(1 << 14))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedlonglongArg_andsignedshortArg_(1 << 60, -42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedshortArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedshortArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedshortArg_(1 << 60, 1 << 14)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 14)

    def testsignedlonglongAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andsignedintArg_(-(1 << 60), -(1 << 30))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedintArg_(-(1 << 60), -42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedintArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedintArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedintArg_(-(1 << 60), 1 << 30)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedintArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedintArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedintArg_(1 << 60, -(1 << 30))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedintArg_(1 << 60, -42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedintArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedintArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedintArg_(1 << 60, 1 << 30)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlonglongAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andsignedlongArg_(-(1 << 60), -(1 << 30))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedlongArg_(-(1 << 60), -42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlongArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlongArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlongArg_(-(1 << 60), 1 << 30)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedlongArg_(-42, -(1 << 30))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedlongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andsignedlongArg_(1 << 60, -(1 << 30))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlonglongArg_andsignedlongArg_(1 << 60, -42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlongArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlongArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlongArg_(1 << 60, 1 << 30)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlonglongAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andsignedlonglongArg_(-(1 << 60), -(1 << 60))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongArg_andsignedlonglongArg_(-(1 << 60), -42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlonglongArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlonglongArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlonglongArg_(-(1 << 60), 1 << 60)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlonglongArg_andsignedlonglongArg_(-42, -(1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongArg_andsignedlonglongArg_(-42, -42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlonglongArg_(-42, 1 << 60)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlonglongArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlonglongArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.signedlonglongArg_andsignedlonglongArg_(1 << 60, -(1 << 60))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongArg_andsignedlonglongArg_(1 << 60, -42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongArg_andsignedlonglongArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andsignedlonglongArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andsignedlonglongArg_(1 << 60, 1 << 60)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 60)

    def testsignedlonglongAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andunsignedcharArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedcharArg_(-(1 << 60), 128)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 128)
        r = o.signedlonglongArg_andunsignedcharArg_(-(1 << 60), 255)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 255)
        r = o.signedlonglongArg_andunsignedcharArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedcharArg_(-42, 128)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 128)
        r = o.signedlonglongArg_andunsignedcharArg_(-42, 255)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 255)
        r = o.signedlonglongArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.signedlonglongArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.signedlonglongArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.signedlonglongArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.signedlonglongArg_andunsignedcharArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedcharArg_(1 << 60, 128)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 128)
        r = o.signedlonglongArg_andunsignedcharArg_(1 << 60, 255)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 255)

    def testsignedlonglongAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andunsignedshortArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedshortArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedshortArg_(-(1 << 60), 1 << 14)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andunsignedshortArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedshortArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedshortArg_(-42, 1 << 14)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.signedlonglongArg_andunsignedshortArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedshortArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedshortArg_(1 << 60, 1 << 14)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 14)

    def testsignedlonglongAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andunsignedintArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedintArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedintArg_(-(1 << 60), 1 << 30)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedintArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedintArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedintArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedintArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedintArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedintArg_(1 << 60, 1 << 30)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlonglongAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andunsignedlongArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlongArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlongArg_(-(1 << 60), 1 << 30)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedlongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlongArg_(-42, 1 << 30)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.signedlonglongArg_andunsignedlongArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlongArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlongArg_(1 << 60, 1 << 30)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 30)

    def testsignedlonglongAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-(1 << 60), 0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-(1 << 60), 42)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-(1 << 60), 1 << 62)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 0)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 1 << 62)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlonglongArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlonglongArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.signedlonglongArg_andunsignedlonglongArg_(1 << 60, 0)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongArg_andunsignedlonglongArg_(1 << 60, 42)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongArg_andunsignedlonglongArg_(1 << 60, 1 << 62)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], 1 << 62)

    def testsignedlonglongAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andfloatArg_(-(1 << 60), 0.128)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_andfloatArg_(-(1 << 60), 1.0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_andfloatArg_(-(1 << 60), 42.0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_andfloatArg_(-(1 << 60), 1e10)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_andfloatArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_andfloatArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_andfloatArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_andfloatArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_andfloatArg_(1 << 60, 0.128)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_andfloatArg_(1 << 60, 1.0)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_andfloatArg_(1 << 60, 42.0)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_andfloatArg_(1 << 60, 1e10)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedlonglongAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_anddoubleArg_(-(1 << 60), 0.128)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_anddoubleArg_(-(1 << 60), 1.0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_anddoubleArg_(-(1 << 60), 42.0)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_anddoubleArg_(-(1 << 60), 1e10)
        self.assertEqual(r[0], -(1 << 60))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_anddoubleArg_(-42, 0.128)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_anddoubleArg_(-42, 1.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_anddoubleArg_(-42, 42.0)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_anddoubleArg_(-42, 1e10)
        self.assertEqual(r[0], -42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.signedlonglongArg_anddoubleArg_(1 << 60, 0.128)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.signedlonglongArg_anddoubleArg_(1 << 60, 1.0)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.signedlonglongArg_anddoubleArg_(1 << 60, 42.0)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.signedlonglongArg_anddoubleArg_(1 << 60, 1e10)
        self.assertEqual(r[0], 1 << 60)
        self.assertAlmostEqual(r[1], 1e10)

    def testsignedlonglongAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andidArg_(-(1 << 60), NSPriorDayDesignations)
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlonglongArg_andidArg_(-42, NSPriorDayDesignations)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlonglongArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlonglongArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.signedlonglongArg_andidArg_(1 << 60, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testsignedlonglongAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andcharPtrArg_(-(1 << 60), b"hello")
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], b"hello")
        r = o.signedlonglongArg_andcharPtrArg_(-(1 << 60), b"world")
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], b"world")
        r = o.signedlonglongArg_andcharPtrArg_(-(1 << 60), b"foobar")
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], b"foobar")
        r = o.signedlonglongArg_andcharPtrArg_(-42, b"hello")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"hello")
        r = o.signedlonglongArg_andcharPtrArg_(-42, b"world")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"world")
        r = o.signedlonglongArg_andcharPtrArg_(-42, b"foobar")
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlonglongArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.signedlonglongArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.signedlonglongArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlonglongArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.signedlonglongArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.signedlonglongArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.signedlonglongArg_andcharPtrArg_(1 << 60, b"hello")
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], b"hello")
        r = o.signedlonglongArg_andcharPtrArg_(1 << 60, b"world")
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], b"world")
        r = o.signedlonglongArg_andcharPtrArg_(1 << 60, b"foobar")
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], b"foobar")

    def testsignedlonglongAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andNSPointArg_(-(1 << 60), (1, 2))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andNSPointArg_(-(1 << 60), (3, 4))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (3, 4))
        r = o.signedlonglongArg_andNSPointArg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andNSPointArg_(-42, (3, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlonglongArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlonglongArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.signedlonglongArg_andNSPointArg_(1 << 60, (1, 2))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andNSPointArg_(1 << 60, (3, 4))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (3, 4))

    def testsignedlonglongAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andNSRectArg_(-(1 << 60), ((1, 2), (3, 4)))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlonglongArg_andNSRectArg_(-(1 << 60), ((7, 8), (9, 10)))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlonglongArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlonglongArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlonglongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlonglongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlonglongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlonglongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.signedlonglongArg_andNSRectArg_(1 << 60, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.signedlonglongArg_andNSRectArg_(1 << 60, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testsignedlonglongAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            -(1 << 60), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            -(1 << 60), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            -42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            0, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            1 << 60, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct1Arg_(
            1 << 60, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedlonglongAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            -(1 << 60), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            -(1 << 60), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            -42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            0, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            1 << 60, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.signedlonglongArg_andstructTestStruct2Arg_(
            1 << 60, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testsignedlonglongAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andstructTestStruct3Arg_(-(1 << 60), (1, 2))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(-(1 << 60), (2, 4))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(-42, (1, 2))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(1 << 60, (1, 2))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 2))
        r = o.signedlonglongArg_andstructTestStruct3Arg_(1 << 60, (2, 4))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (2, 4))

    def testsignedlonglongAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andstructTestStruct4Arg_(-(1 << 60), (1, 1 << 60))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(-(1 << 60), (2, 4))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(-42, (1, 1 << 60))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(-42, (2, 4))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(1 << 60, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.signedlonglongArg_andstructTestStruct4Arg_(1 << 60, (2, 4))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (2, 4))

    def testsignedlonglongAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongArg_andstructTestStruct5Arg_(-(1 << 60), (1, 2.5))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(-(1 << 60), (2, 4.5))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(-42, (1, 2.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(-42, (2, 4.5))
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(1 << 60, (1, 2.5))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (1, 2.5))
        r = o.signedlonglongArg_andstructTestStruct5Arg_(1 << 60, (2, 4.5))
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], (2, 4.5))

    def testunsignedcharAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedcharArg_andboolArg_(128, YES)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andboolArg_(128, NO)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], NO)
        r = o.unsignedcharArg_andboolArg_(255, YES)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andboolArg_(255, NO)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], NO)

    def testunsignedcharAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedcharArg_andBOOLArg_(128, YES)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andBOOLArg_(128, NO)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], NO)
        r = o.unsignedcharArg_andBOOLArg_(255, YES)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], YES)
        r = o.unsignedcharArg_andBOOLArg_(255, NO)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], NO)

    def testunsignedcharAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.unsignedcharArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.unsignedcharArg_andcharArg_(128, -128)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -128)
        r = o.unsignedcharArg_andcharArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andcharArg_(128, 127)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 127)
        r = o.unsignedcharArg_andcharArg_(255, -128)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -128)
        r = o.unsignedcharArg_andcharArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andcharArg_(255, 127)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 127)

    def testunsignedcharAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedcharArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedcharArg_andsignedshortArg_(128, -(1 << 14))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedcharArg_andsignedshortArg_(128, -42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedshortArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedshortArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedshortArg_(128, 1 << 14)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedcharArg_andsignedshortArg_(255, -(1 << 14))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedcharArg_andsignedshortArg_(255, -42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedshortArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedshortArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedshortArg_(255, 1 << 14)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedcharAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andsignedintArg_(128, -(1 << 30))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedintArg_(128, -42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedintArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedintArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedintArg_(128, 1 << 30)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andsignedintArg_(255, -(1 << 30))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedintArg_(255, -42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedintArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedintArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedintArg_(255, 1 << 30)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedcharAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andsignedlongArg_(128, -(1 << 30))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedlongArg_(128, -42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlongArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlongArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlongArg_(128, 1 << 30)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andsignedlongArg_(255, -(1 << 30))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedcharArg_andsignedlongArg_(255, -42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlongArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlongArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlongArg_(255, 1 << 30)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedcharAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedcharArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedcharArg_andsignedlonglongArg_(128, -(1 << 60))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedcharArg_andsignedlonglongArg_(128, -42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlonglongArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlonglongArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlonglongArg_(128, 1 << 60)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedcharArg_andsignedlonglongArg_(255, -(1 << 60))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedcharArg_andsignedlonglongArg_(255, -42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], -42)
        r = o.unsignedcharArg_andsignedlonglongArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andsignedlonglongArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andsignedlonglongArg_(255, 1 << 60)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 60)

    def testunsignedcharAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.unsignedcharArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.unsignedcharArg_andunsignedcharArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedcharArg_(128, 128)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 128)
        r = o.unsignedcharArg_andunsignedcharArg_(128, 255)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 255)
        r = o.unsignedcharArg_andunsignedcharArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedcharArg_(255, 128)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 128)
        r = o.unsignedcharArg_andunsignedcharArg_(255, 255)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 255)

    def testunsignedcharAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedcharArg_andunsignedshortArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedshortArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedshortArg_(128, 1 << 14)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedcharArg_andunsignedshortArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedshortArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedshortArg_(255, 1 << 14)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedcharAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andunsignedintArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedintArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedintArg_(128, 1 << 30)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andunsignedintArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedintArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedintArg_(255, 1 << 30)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedcharAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andunsignedlongArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlongArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlongArg_(128, 1 << 30)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedcharArg_andunsignedlongArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlongArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlongArg_(255, 1 << 30)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedcharAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedcharArg_andunsignedlonglongArg_(128, 0)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlonglongArg_(128, 42)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlonglongArg_(128, 1 << 62)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedcharArg_andunsignedlonglongArg_(255, 0)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharArg_andunsignedlonglongArg_(255, 42)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 42)
        r = o.unsignedcharArg_andunsignedlonglongArg_(255, 1 << 62)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 1 << 62)

    def testunsignedcharAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedcharArg_andfloatArg_(128, 0.128)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_andfloatArg_(128, 1.0)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_andfloatArg_(128, 42.0)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_andfloatArg_(128, 1e10)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedcharArg_andfloatArg_(255, 0.128)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_andfloatArg_(255, 1.0)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_andfloatArg_(255, 42.0)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_andfloatArg_(255, 1e10)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedcharAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedcharArg_anddoubleArg_(128, 0.128)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_anddoubleArg_(128, 1.0)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_anddoubleArg_(128, 42.0)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_anddoubleArg_(128, 1e10)
        self.assertEqual(r[0], 128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedcharArg_anddoubleArg_(255, 0.128)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedcharArg_anddoubleArg_(255, 1.0)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedcharArg_anddoubleArg_(255, 42.0)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedcharArg_anddoubleArg_(255, 1e10)
        self.assertEqual(r[0], 255)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedcharAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedcharArg_andidArg_(128, NSPriorDayDesignations)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedcharArg_andidArg_(255, NSPriorDayDesignations)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testunsignedcharAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedcharArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.unsignedcharArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedcharArg_andcharPtrArg_(128, b"hello")
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedcharArg_andcharPtrArg_(128, b"world")
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], b"world")
        r = o.unsignedcharArg_andcharPtrArg_(128, b"foobar")
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedcharArg_andcharPtrArg_(255, b"hello")
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedcharArg_andcharPtrArg_(255, b"world")
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], b"world")
        r = o.unsignedcharArg_andcharPtrArg_(255, b"foobar")
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], b"foobar")

    def testunsignedcharAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedcharArg_andNSPointArg_(128, (1, 2))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andNSPointArg_(128, (3, 4))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedcharArg_andNSPointArg_(255, (1, 2))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andNSPointArg_(255, (3, 4))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (3, 4))

    def testunsignedcharAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedcharArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedcharArg_andNSRectArg_(128, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedcharArg_andNSRectArg_(128, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedcharArg_andNSRectArg_(255, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedcharArg_andNSRectArg_(255, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testunsignedcharAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedcharArg_andstructTestStruct1Arg_(128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct1Arg_(
            128, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedcharArg_andstructTestStruct1Arg_(255, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct1Arg_(
            255, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedcharAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedcharArg_andstructTestStruct2Arg_(128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct2Arg_(
            128, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedcharArg_andstructTestStruct2Arg_(255, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedcharArg_andstructTestStruct2Arg_(
            255, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedcharAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedcharArg_andstructTestStruct3Arg_(128, (1, 2))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andstructTestStruct3Arg_(128, (2, 4))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedcharArg_andstructTestStruct3Arg_(255, (1, 2))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedcharArg_andstructTestStruct3Arg_(255, (2, 4))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (2, 4))

    def testunsignedcharAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedcharArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedcharArg_andstructTestStruct4Arg_(128, (1, 1 << 60))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedcharArg_andstructTestStruct4Arg_(128, (2, 4))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedcharArg_andstructTestStruct4Arg_(255, (1, 1 << 60))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedcharArg_andstructTestStruct4Arg_(255, (2, 4))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (2, 4))

    def testunsignedcharAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedcharArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedcharArg_andstructTestStruct5Arg_(128, (1, 2.5))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedcharArg_andstructTestStruct5Arg_(128, (2, 4.5))
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedcharArg_andstructTestStruct5Arg_(255, (1, 2.5))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedcharArg_andstructTestStruct5Arg_(255, (2, 4.5))
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], (2, 4.5))

    def testunsignedshortAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedshortArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedshortArg_andboolArg_(1 << 14, YES)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andboolArg_(1 << 14, NO)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NO)

    def testunsignedshortAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedshortArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedshortArg_andBOOLArg_(1 << 14, YES)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], YES)
        r = o.unsignedshortArg_andBOOLArg_(1 << 14, NO)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NO)

    def testunsignedshortAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.unsignedshortArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.unsignedshortArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.unsignedshortArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.unsignedshortArg_andcharArg_(1 << 14, -128)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -128)
        r = o.unsignedshortArg_andcharArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andcharArg_(1 << 14, 127)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 127)

    def testunsignedshortAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedshortArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedshortArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedshortArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedshortArg_andsignedshortArg_(1 << 14, -(1 << 14))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedshortArg_andsignedshortArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedshortArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedshortArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedshortArg_(1 << 14, 1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedshortAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andsignedintArg_(1 << 14, -(1 << 30))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedintArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedintArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedintArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedintArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedshortAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andsignedlongArg_(1 << 14, -(1 << 30))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedshortArg_andsignedlongArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlongArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedshortAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedshortArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedshortArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedshortArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedshortArg_andsignedlonglongArg_(1 << 14, -(1 << 60))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedshortArg_andsignedlonglongArg_(1 << 14, -42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -42)
        r = o.unsignedshortArg_andsignedlonglongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andsignedlonglongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andsignedlonglongArg_(1 << 14, 1 << 60)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 60)

    def testunsignedshortAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.unsignedshortArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.unsignedshortArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.unsignedshortArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.unsignedshortArg_andunsignedcharArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedcharArg_(1 << 14, 128)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 128)
        r = o.unsignedshortArg_andunsignedcharArg_(1 << 14, 255)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 255)

    def testunsignedshortAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedshortArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedshortArg_andunsignedshortArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedshortArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedshortArg_(1 << 14, 1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedshortAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andunsignedintArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedintArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedintArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedshortAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedshortArg_andunsignedlongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlongArg_(1 << 14, 1 << 30)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedshortAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedshortArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedshortArg_andunsignedlonglongArg_(1 << 14, 0)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortArg_andunsignedlonglongArg_(1 << 14, 42)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortArg_andunsignedlonglongArg_(1 << 14, 1 << 62)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 1 << 62)

    def testunsignedshortAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedshortArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedshortArg_andfloatArg_(1 << 14, 0.128)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_andfloatArg_(1 << 14, 1.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_andfloatArg_(1 << 14, 42.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_andfloatArg_(1 << 14, 1e10)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedshortAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedshortArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedshortArg_anddoubleArg_(1 << 14, 0.128)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedshortArg_anddoubleArg_(1 << 14, 1.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedshortArg_anddoubleArg_(1 << 14, 42.0)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedshortArg_anddoubleArg_(1 << 14, 1e10)
        self.assertEqual(r[0], 1 << 14)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedshortAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedshortArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedshortArg_andidArg_(1 << 14, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testunsignedshortAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedshortArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.unsignedshortArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedshortArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedshortArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.unsignedshortArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedshortArg_andcharPtrArg_(1 << 14, b"hello")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedshortArg_andcharPtrArg_(1 << 14, b"world")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"world")
        r = o.unsignedshortArg_andcharPtrArg_(1 << 14, b"foobar")
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], b"foobar")

    def testunsignedshortAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedshortArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedshortArg_andNSPointArg_(1 << 14, (1, 2))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andNSPointArg_(1 << 14, (3, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (3, 4))

    def testunsignedshortAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedshortArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedshortArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedshortArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedshortArg_andNSRectArg_(1 << 14, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedshortArg_andNSRectArg_(1 << 14, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testunsignedshortAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedshortArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct1Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedshortArg_andstructTestStruct1Arg_(
            1 << 14, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct1Arg_(
            1 << 14, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedshortAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedshortArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct2Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedshortArg_andstructTestStruct2Arg_(
            1 << 14, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedshortArg_andstructTestStruct2Arg_(
            1 << 14, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedshortAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedshortArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedshortArg_andstructTestStruct3Arg_(1 << 14, (1, 2))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedshortArg_andstructTestStruct3Arg_(1 << 14, (2, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4))

    def testunsignedshortAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedshortArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedshortArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedshortArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedshortArg_andstructTestStruct4Arg_(1 << 14, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedshortArg_andstructTestStruct4Arg_(1 << 14, (2, 4))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4))

    def testunsignedshortAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedshortArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedshortArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedshortArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedshortArg_andstructTestStruct5Arg_(1 << 14, (1, 2.5))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedshortArg_andstructTestStruct5Arg_(1 << 14, (2, 4.5))
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], (2, 4.5))

    def testunsignedintAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedintArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedintArg_andboolArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andboolArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testunsignedintAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedintArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedintArg_andBOOLArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.unsignedintArg_andBOOLArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testunsignedintAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.unsignedintArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.unsignedintArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.unsignedintArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.unsignedintArg_andcharArg_(1 << 30, -128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -128)
        r = o.unsignedintArg_andcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andcharArg_(1 << 30, 127)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 127)

    def testunsignedintAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedintArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedintArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedintArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedintArg_andsignedshortArg_(1 << 30, -(1 << 14))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedintArg_andsignedshortArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedintAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andsignedintArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedintArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedintAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andsignedlongArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedintArg_andsignedlongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedintAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedintArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedintArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedintArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, -(1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 1 << 60)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 60)

    def testunsignedintAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.unsignedintArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.unsignedintArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.unsignedintArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 128)
        r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 255)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 255)

    def testunsignedintAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedintArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedintAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andunsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedintAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedintAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedintArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 1 << 62)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 62)

    def testunsignedintAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedintArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedintArg_andfloatArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_andfloatArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_andfloatArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_andfloatArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedintAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedintArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedintArg_anddoubleArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedintArg_anddoubleArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedintArg_anddoubleArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedintArg_anddoubleArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedintAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedintArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedintArg_andidArg_(1 << 30, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testunsignedintAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedintArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.unsignedintArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedintArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedintArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.unsignedintArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedintArg_andcharPtrArg_(1 << 30, b"hello")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedintArg_andcharPtrArg_(1 << 30, b"world")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"world")
        r = o.unsignedintArg_andcharPtrArg_(1 << 30, b"foobar")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"foobar")

    def testunsignedintAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedintArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedintArg_andNSPointArg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andNSPointArg_(1 << 30, (3, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (3, 4))

    def testunsignedintAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedintArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedintArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedintArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedintArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedintArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testunsignedintAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedintArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedintArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct1Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedintAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedintArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedintArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedintArg_andstructTestStruct2Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedintAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedintArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedintArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedintArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testunsignedintAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedintArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedintArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedintArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedintArg_andstructTestStruct4Arg_(1 << 30, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedintArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testunsignedintAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedintArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedintArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedintArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedintArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedintArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4.5))

    def testunsignedlongAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedlongArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedlongArg_andboolArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andboolArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testunsignedlongAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedlongArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedlongArg_andBOOLArg_(1 << 30, YES)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], YES)
        r = o.unsignedlongArg_andBOOLArg_(1 << 30, NO)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NO)

    def testunsignedlongAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.unsignedlongArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.unsignedlongArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.unsignedlongArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.unsignedlongArg_andcharArg_(1 << 30, -128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -128)
        r = o.unsignedlongArg_andcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andcharArg_(1 << 30, 127)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 127)

    def testunsignedlongAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlongArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlongArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlongArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlongArg_andsignedshortArg_(1 << 30, -(1 << 14))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlongArg_andsignedshortArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedlongAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andsignedintArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedintArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlongAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andsignedlongArg_(1 << 30, -(1 << 30))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlongArg_andsignedlongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlongAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlongArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedlongArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlongArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedlongArg_andsignedlonglongArg_(1 << 30, -(1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlongArg_andsignedlonglongArg_(1 << 30, -42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -42)
        r = o.unsignedlongArg_andsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andsignedlonglongArg_(1 << 30, 1 << 60)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 60)

    def testunsignedlongAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.unsignedlongArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.unsignedlongArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.unsignedlongArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.unsignedlongArg_andunsignedcharArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedcharArg_(1 << 30, 128)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 128)
        r = o.unsignedlongArg_andunsignedcharArg_(1 << 30, 255)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 255)

    def testunsignedlongAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlongArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlongArg_andunsignedshortArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedshortArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedshortArg_(1 << 30, 1 << 14)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedlongAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andunsignedintArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedintArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedintArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlongAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlongArg_andunsignedlongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlongArg_(1 << 30, 1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlongAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedlongArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedlongArg_andunsignedlonglongArg_(1 << 30, 0)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongArg_andunsignedlonglongArg_(1 << 30, 42)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongArg_andunsignedlonglongArg_(1 << 30, 1 << 62)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 1 << 62)

    def testunsignedlongAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlongArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlongArg_andfloatArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_andfloatArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_andfloatArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_andfloatArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedlongAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlongArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlongArg_anddoubleArg_(1 << 30, 0.128)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlongArg_anddoubleArg_(1 << 30, 1.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlongArg_anddoubleArg_(1 << 30, 42.0)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlongArg_anddoubleArg_(1 << 30, 1e10)
        self.assertEqual(r[0], 1 << 30)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedlongAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedlongArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedlongArg_andidArg_(1 << 30, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testunsignedlongAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlongArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlongArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedlongArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlongArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlongArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedlongArg_andcharPtrArg_(1 << 30, b"hello")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlongArg_andcharPtrArg_(1 << 30, b"world")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlongArg_andcharPtrArg_(1 << 30, b"foobar")
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], b"foobar")

    def testunsignedlongAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedlongArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedlongArg_andNSPointArg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andNSPointArg_(1 << 30, (3, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (3, 4))

    def testunsignedlongAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedlongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedlongArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlongArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testunsignedlongAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlongArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct1Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedlongAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlongArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlongArg_andstructTestStruct2Arg_(
            1 << 30, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedlongAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlongArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlongArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlongArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testunsignedlongAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlongArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlongArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlongArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlongArg_andstructTestStruct4Arg_(1 << 30, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlongArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4))

    def testunsignedlongAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlongArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedlongArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlongArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedlongArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlongArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], (2, 4.5))

    def testunsignedlonglongAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andboolArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andboolArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedlonglongArg_andboolArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andboolArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedlonglongArg_andboolArg_(1 << 62, YES)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andboolArg_(1 << 62, NO)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], NO)

    def testunsignedlonglongAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andBOOLArg_(0, YES)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andBOOLArg_(0, NO)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NO)
        r = o.unsignedlonglongArg_andBOOLArg_(42, YES)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andBOOLArg_(42, NO)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NO)
        r = o.unsignedlonglongArg_andBOOLArg_(1 << 62, YES)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], YES)
        r = o.unsignedlonglongArg_andBOOLArg_(1 << 62, NO)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], NO)

    def testunsignedlonglongAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andcharArg_(0, -128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -128)
        r = o.unsignedlonglongArg_andcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andcharArg_(0, 127)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 127)
        r = o.unsignedlonglongArg_andcharArg_(42, -128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -128)
        r = o.unsignedlonglongArg_andcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andcharArg_(42, 127)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 127)
        r = o.unsignedlonglongArg_andcharArg_(1 << 62, -128)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -128)
        r = o.unsignedlonglongArg_andcharArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andcharArg_(1 << 62, 127)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 127)

    def testunsignedlonglongAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andsignedshortArg_(0, -(1 << 14))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlonglongArg_andsignedshortArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlonglongArg_andsignedshortArg_(42, -(1 << 14))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlonglongArg_andsignedshortArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlonglongArg_andsignedshortArg_(1 << 62, -(1 << 14))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -(1 << 14))
        r = o.unsignedlonglongArg_andsignedshortArg_(1 << 62, -42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedshortArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedshortArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedshortArg_(1 << 62, 1 << 14)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedlonglongAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andsignedintArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedintArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andsignedintArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedintArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andsignedintArg_(1 << 62, -(1 << 30))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedintArg_(1 << 62, -42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedintArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedintArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedintArg_(1 << 62, 1 << 30)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlonglongAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andsignedlongArg_(0, -(1 << 30))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedlongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andsignedlongArg_(42, -(1 << 30))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedlongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andsignedlongArg_(1 << 62, -(1 << 30))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -(1 << 30))
        r = o.unsignedlonglongArg_andsignedlongArg_(1 << 62, -42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlongArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlongArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlongArg_(1 << 62, 1 << 30)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlonglongAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(0, -(1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlonglongArg_andsignedlonglongArg_(0, -42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 1 << 60)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(42, -(1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlonglongArg_andsignedlonglongArg_(42, -42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 1 << 60)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 60)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(1 << 62, -(1 << 60))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -(1 << 60))
        r = o.unsignedlonglongArg_andsignedlonglongArg_(1 << 62, -42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], -42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andsignedlonglongArg_(1 << 62, 1 << 60)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 60)

    def testunsignedlonglongAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andunsignedcharArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedcharArg_(0, 128)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 128)
        r = o.unsignedlonglongArg_andunsignedcharArg_(0, 255)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)
        r = o.unsignedlonglongArg_andunsignedcharArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedcharArg_(42, 128)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 128)
        r = o.unsignedlonglongArg_andunsignedcharArg_(42, 255)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 255)
        r = o.unsignedlonglongArg_andunsignedcharArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedcharArg_(1 << 62, 128)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 128)
        r = o.unsignedlonglongArg_andunsignedcharArg_(1 << 62, 255)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 255)

    def testunsignedlonglongAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andunsignedshortArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedshortArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedshortArg_(0, 1 << 14)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlonglongArg_andunsignedshortArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedshortArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedshortArg_(42, 1 << 14)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 14)
        r = o.unsignedlonglongArg_andunsignedshortArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedshortArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedshortArg_(1 << 62, 1 << 14)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedlonglongAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andunsignedintArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedintArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedintArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andunsignedintArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedintArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedintArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andunsignedintArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedintArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedintArg_(1 << 62, 1 << 30)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlonglongAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andunsignedlongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlongArg_(0, 1 << 30)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andunsignedlongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlongArg_(42, 1 << 30)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 30)
        r = o.unsignedlonglongArg_andunsignedlongArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlongArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlongArg_(1 << 62, 1 << 30)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlonglongAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 42)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 1 << 62)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 0)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 1 << 62)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 1 << 62)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(1 << 62, 0)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(1 << 62, 42)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongArg_andunsignedlonglongArg_(1 << 62, 1 << 62)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 1 << 62)

    def testunsignedlonglongAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andfloatArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_andfloatArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_andfloatArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_andfloatArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlonglongArg_andfloatArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_andfloatArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_andfloatArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_andfloatArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlonglongArg_andfloatArg_(1 << 62, 0.128)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_andfloatArg_(1 << 62, 1.0)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_andfloatArg_(1 << 62, 42.0)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_andfloatArg_(1 << 62, 1e10)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedlonglongAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_anddoubleArg_(0, 0.128)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_anddoubleArg_(0, 1.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_anddoubleArg_(0, 42.0)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_anddoubleArg_(0, 1e10)
        self.assertEqual(r[0], 0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlonglongArg_anddoubleArg_(42, 0.128)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_anddoubleArg_(42, 1.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_anddoubleArg_(42, 42.0)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_anddoubleArg_(42, 1e10)
        self.assertEqual(r[0], 42)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.unsignedlonglongArg_anddoubleArg_(1 << 62, 0.128)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.unsignedlonglongArg_anddoubleArg_(1 << 62, 1.0)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.unsignedlonglongArg_anddoubleArg_(1 << 62, 42.0)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.unsignedlonglongArg_anddoubleArg_(1 << 62, 1e10)
        self.assertEqual(r[0], 1 << 62)
        self.assertAlmostEqual(r[1], 1e10)

    def testunsignedlonglongAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andidArg_(0, NSPriorDayDesignations)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedlonglongArg_andidArg_(42, NSPriorDayDesignations)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.unsignedlonglongArg_andidArg_(1 << 62, NSPriorDayDesignations)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testunsignedlonglongAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andcharPtrArg_(0, b"hello")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlonglongArg_andcharPtrArg_(0, b"world")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlonglongArg_andcharPtrArg_(0, b"foobar")
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedlonglongArg_andcharPtrArg_(42, b"hello")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlonglongArg_andcharPtrArg_(42, b"world")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlonglongArg_andcharPtrArg_(42, b"foobar")
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], b"foobar")
        r = o.unsignedlonglongArg_andcharPtrArg_(1 << 62, b"hello")
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], b"hello")
        r = o.unsignedlonglongArg_andcharPtrArg_(1 << 62, b"world")
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], b"world")
        r = o.unsignedlonglongArg_andcharPtrArg_(1 << 62, b"foobar")
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], b"foobar")

    def testunsignedlonglongAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andNSPointArg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andNSPointArg_(0, (3, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedlonglongArg_andNSPointArg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andNSPointArg_(42, (3, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (3, 4))
        r = o.unsignedlonglongArg_andNSPointArg_(1 << 62, (1, 2))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andNSPointArg_(1 << 62, (3, 4))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (3, 4))

    def testunsignedlonglongAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlonglongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedlonglongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlonglongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.unsignedlonglongArg_andNSRectArg_(1 << 62, ((1, 2), (3, 4)))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.unsignedlonglongArg_andNSRectArg_(1 << 62, ((7, 8), (9, 10)))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testunsignedlonglongAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(
            0, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(
            1 << 62, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct1Arg_(
            1 << 62, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedlonglongAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(
            0, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(
            42, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(
            1 << 62, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.unsignedlonglongArg_andstructTestStruct2Arg_(
            1 << 62, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testunsignedlonglongAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(0, (1, 2))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(42, (1, 2))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(1 << 62, (1, 2))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 2))
        r = o.unsignedlonglongArg_andstructTestStruct3Arg_(1 << 62, (2, 4))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (2, 4))

    def testunsignedlonglongAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(0, (1, 1 << 60))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(0, (2, 4))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(42, (1, 1 << 60))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(42, (2, 4))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4))
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(1 << 62, (1, 1 << 60))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.unsignedlonglongArg_andstructTestStruct4Arg_(1 << 62, (2, 4))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (2, 4))

    def testunsignedlonglongAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(0, (1, 2.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(0, (2, 4.5))
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(42, (1, 2.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(42, (2, 4.5))
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], (2, 4.5))
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(1 << 62, (1, 2.5))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (1, 2.5))
        r = o.unsignedlonglongArg_andstructTestStruct5Arg_(1 << 62, (2, 4.5))
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], (2, 4.5))

    def testfloatAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andboolArg_(0.128, YES)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andboolArg_(0.128, NO)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andboolArg_(1.0, YES)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andboolArg_(1.0, NO)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andboolArg_(42.0, YES)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andboolArg_(42.0, NO)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andboolArg_(1e10, YES)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andboolArg_(1e10, NO)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NO)

    def testfloatAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andBOOLArg_(0.128, YES)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andBOOLArg_(0.128, NO)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andBOOLArg_(1.0, YES)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andBOOLArg_(1.0, NO)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andBOOLArg_(42.0, YES)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andBOOLArg_(42.0, NO)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NO)
        r = o.floatArg_andBOOLArg_(1e10, YES)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], YES)
        r = o.floatArg_andBOOLArg_(1e10, NO)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NO)

    def testfloatAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andcharArg_(0.128, -128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -128)
        r = o.floatArg_andcharArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andcharArg_(0.128, 127)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 127)
        r = o.floatArg_andcharArg_(1.0, -128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -128)
        r = o.floatArg_andcharArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andcharArg_(1.0, 127)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 127)
        r = o.floatArg_andcharArg_(42.0, -128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -128)
        r = o.floatArg_andcharArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andcharArg_(42.0, 127)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 127)
        r = o.floatArg_andcharArg_(1e10, -128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -128)
        r = o.floatArg_andcharArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andcharArg_(1e10, 127)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 127)

    def testfloatAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andsignedshortArg_(0.128, -(1 << 14))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 14))
        r = o.floatArg_andsignedshortArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedshortArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedshortArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedshortArg_(0.128, 1 << 14)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andsignedshortArg_(1.0, -(1 << 14))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.floatArg_andsignedshortArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedshortArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedshortArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedshortArg_(1.0, 1 << 14)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andsignedshortArg_(42.0, -(1 << 14))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.floatArg_andsignedshortArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedshortArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedshortArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedshortArg_(42.0, 1 << 14)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andsignedshortArg_(1e10, -(1 << 14))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 14))
        r = o.floatArg_andsignedshortArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedshortArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedshortArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedshortArg_(1e10, 1 << 14)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 14)

    def testfloatAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andsignedintArg_(0.128, -(1 << 30))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedintArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedintArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedintArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedintArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedintArg_(1.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedintArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedintArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedintArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedintArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedintArg_(42.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedintArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedintArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedintArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedintArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedintArg_(1e10, -(1 << 30))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedintArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedintArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedintArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedintArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testfloatAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andsignedlongArg_(0.128, -(1 << 30))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedlongArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlongArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedlongArg_(1.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedlongArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlongArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedlongArg_(42.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedlongArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlongArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andsignedlongArg_(1e10, -(1 << 30))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 30))
        r = o.floatArg_andsignedlongArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlongArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testfloatAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andsignedlonglongArg_(0.128, -(1 << 60))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 60))
        r = o.floatArg_andsignedlonglongArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlonglongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlonglongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlonglongArg_(0.128, 1 << 60)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 60)
        r = o.floatArg_andsignedlonglongArg_(1.0, -(1 << 60))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.floatArg_andsignedlonglongArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlonglongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlonglongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlonglongArg_(1.0, 1 << 60)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 60)
        r = o.floatArg_andsignedlonglongArg_(42.0, -(1 << 60))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.floatArg_andsignedlonglongArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlonglongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlonglongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlonglongArg_(42.0, 1 << 60)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 60)
        r = o.floatArg_andsignedlonglongArg_(1e10, -(1 << 60))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 60))
        r = o.floatArg_andsignedlonglongArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.floatArg_andsignedlonglongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andsignedlonglongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andsignedlonglongArg_(1e10, 1 << 60)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 60)

    def testfloatAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andunsignedcharArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedcharArg_(0.128, 128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 128)
        r = o.floatArg_andunsignedcharArg_(0.128, 255)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 255)
        r = o.floatArg_andunsignedcharArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedcharArg_(1.0, 128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 128)
        r = o.floatArg_andunsignedcharArg_(1.0, 255)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 255)
        r = o.floatArg_andunsignedcharArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedcharArg_(42.0, 128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 128)
        r = o.floatArg_andunsignedcharArg_(42.0, 255)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 255)
        r = o.floatArg_andunsignedcharArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedcharArg_(1e10, 128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 128)
        r = o.floatArg_andunsignedcharArg_(1e10, 255)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 255)

    def testfloatAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andunsignedshortArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedshortArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedshortArg_(0.128, 1 << 14)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andunsignedshortArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedshortArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedshortArg_(1.0, 1 << 14)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andunsignedshortArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedshortArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedshortArg_(42.0, 1 << 14)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.floatArg_andunsignedshortArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedshortArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedshortArg_(1e10, 1 << 14)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 14)

    def testfloatAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andunsignedintArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedintArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedintArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedintArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedintArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedintArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedintArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedintArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedintArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedintArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedintArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedintArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testfloatAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andunsignedlongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlongArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedlongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlongArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedlongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlongArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.floatArg_andunsignedlongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlongArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testfloatAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andunsignedlonglongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlonglongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlonglongArg_(0.128, 1 << 62)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 62)
        r = o.floatArg_andunsignedlonglongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlonglongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlonglongArg_(1.0, 1 << 62)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 62)
        r = o.floatArg_andunsignedlonglongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlonglongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlonglongArg_(42.0, 1 << 62)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 62)
        r = o.floatArg_andunsignedlonglongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.floatArg_andunsignedlonglongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.floatArg_andunsignedlonglongArg_(1e10, 1 << 62)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 62)

    def testfloatAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andfloatArg_(0.128, 0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_andfloatArg_(0.128, 1.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_andfloatArg_(0.128, 42.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_andfloatArg_(0.128, 1e10)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_andfloatArg_(1.0, 0.128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_andfloatArg_(1.0, 1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_andfloatArg_(1.0, 42.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_andfloatArg_(1.0, 1e10)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_andfloatArg_(42.0, 0.128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_andfloatArg_(42.0, 1.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_andfloatArg_(42.0, 42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_andfloatArg_(42.0, 1e10)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_andfloatArg_(1e10, 0.128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_andfloatArg_(1e10, 1.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_andfloatArg_(1e10, 42.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_andfloatArg_(1e10, 1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1e10)

    def testfloatAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_anddoubleArg_(0.128, 0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_anddoubleArg_(0.128, 1.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_anddoubleArg_(0.128, 42.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_anddoubleArg_(0.128, 1e10)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_anddoubleArg_(1.0, 0.128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_anddoubleArg_(1.0, 1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_anddoubleArg_(1.0, 42.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_anddoubleArg_(1.0, 1e10)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_anddoubleArg_(42.0, 0.128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_anddoubleArg_(42.0, 1.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_anddoubleArg_(42.0, 42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_anddoubleArg_(42.0, 1e10)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.floatArg_anddoubleArg_(1e10, 0.128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatArg_anddoubleArg_(1e10, 1.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatArg_anddoubleArg_(1e10, 42.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatArg_anddoubleArg_(1e10, 1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1e10)

    def testfloatAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andidArg_(0.128, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.floatArg_andidArg_(1.0, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.floatArg_andidArg_(42.0, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.floatArg_andidArg_(1e10, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testfloatAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andcharPtrArg_(0.128, b"hello")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"hello")
        r = o.floatArg_andcharPtrArg_(0.128, b"world")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"world")
        r = o.floatArg_andcharPtrArg_(0.128, b"foobar")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"foobar")
        r = o.floatArg_andcharPtrArg_(1.0, b"hello")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"hello")
        r = o.floatArg_andcharPtrArg_(1.0, b"world")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"world")
        r = o.floatArg_andcharPtrArg_(1.0, b"foobar")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"foobar")
        r = o.floatArg_andcharPtrArg_(42.0, b"hello")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"hello")
        r = o.floatArg_andcharPtrArg_(42.0, b"world")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"world")
        r = o.floatArg_andcharPtrArg_(42.0, b"foobar")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"foobar")
        r = o.floatArg_andcharPtrArg_(1e10, b"hello")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"hello")
        r = o.floatArg_andcharPtrArg_(1e10, b"world")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"world")
        r = o.floatArg_andcharPtrArg_(1e10, b"foobar")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"foobar")

    def testfloatAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andNSPointArg_(0.128, (1, 2))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andNSPointArg_(0.128, (3, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (3, 4))
        r = o.floatArg_andNSPointArg_(1.0, (1, 2))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andNSPointArg_(1.0, (3, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (3, 4))
        r = o.floatArg_andNSPointArg_(42.0, (1, 2))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andNSPointArg_(42.0, (3, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (3, 4))
        r = o.floatArg_andNSPointArg_(1e10, (1, 2))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andNSPointArg_(1e10, (3, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (3, 4))

    def testfloatAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andNSRectArg_(0.128, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.floatArg_andNSRectArg_(0.128, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.floatArg_andNSRectArg_(1.0, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.floatArg_andNSRectArg_(1.0, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.floatArg_andNSRectArg_(42.0, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.floatArg_andNSRectArg_(42.0, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.floatArg_andNSRectArg_(1e10, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.floatArg_andNSRectArg_(1e10, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testfloatAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andstructTestStruct1Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct1Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct1Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct1Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct1Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct1Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct1Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct1Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testfloatAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andstructTestStruct2Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct2Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct2Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct2Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct2Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct2Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.floatArg_andstructTestStruct2Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.floatArg_andstructTestStruct2Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testfloatAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andstructTestStruct3Arg_(0.128, (1, 2))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andstructTestStruct3Arg_(0.128, (2, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct3Arg_(1.0, (1, 2))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andstructTestStruct3Arg_(1.0, (2, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct3Arg_(42.0, (1, 2))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andstructTestStruct3Arg_(42.0, (2, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct3Arg_(1e10, (1, 2))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2))
        r = o.floatArg_andstructTestStruct3Arg_(1e10, (2, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4))

    def testfloatAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andstructTestStruct4Arg_(0.128, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.floatArg_andstructTestStruct4Arg_(0.128, (2, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct4Arg_(1.0, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.floatArg_andstructTestStruct4Arg_(1.0, (2, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct4Arg_(42.0, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.floatArg_andstructTestStruct4Arg_(42.0, (2, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4))
        r = o.floatArg_andstructTestStruct4Arg_(1e10, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.floatArg_andstructTestStruct4Arg_(1e10, (2, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4))

    def testfloatAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatArg_andstructTestStruct5Arg_(0.128, (1, 2.5))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2.5))
        r = o.floatArg_andstructTestStruct5Arg_(0.128, (2, 4.5))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4.5))
        r = o.floatArg_andstructTestStruct5Arg_(1.0, (1, 2.5))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.floatArg_andstructTestStruct5Arg_(1.0, (2, 4.5))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.floatArg_andstructTestStruct5Arg_(42.0, (1, 2.5))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.floatArg_andstructTestStruct5Arg_(42.0, (2, 4.5))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.floatArg_andstructTestStruct5Arg_(1e10, (1, 2.5))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2.5))
        r = o.floatArg_andstructTestStruct5Arg_(1e10, (2, 4.5))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4.5))

    def testdoubleAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andboolArg_(0.128, YES)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andboolArg_(0.128, NO)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andboolArg_(1.0, YES)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andboolArg_(1.0, NO)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andboolArg_(42.0, YES)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andboolArg_(42.0, NO)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andboolArg_(1e10, YES)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andboolArg_(1e10, NO)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NO)

    def testdoubleAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andBOOLArg_(0.128, YES)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andBOOLArg_(0.128, NO)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andBOOLArg_(1.0, YES)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andBOOLArg_(1.0, NO)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andBOOLArg_(42.0, YES)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andBOOLArg_(42.0, NO)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NO)
        r = o.doubleArg_andBOOLArg_(1e10, YES)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], YES)
        r = o.doubleArg_andBOOLArg_(1e10, NO)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NO)

    def testdoubleAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andcharArg_(0.128, -128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -128)
        r = o.doubleArg_andcharArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andcharArg_(0.128, 127)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 127)
        r = o.doubleArg_andcharArg_(1.0, -128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -128)
        r = o.doubleArg_andcharArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andcharArg_(1.0, 127)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 127)
        r = o.doubleArg_andcharArg_(42.0, -128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -128)
        r = o.doubleArg_andcharArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andcharArg_(42.0, 127)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 127)
        r = o.doubleArg_andcharArg_(1e10, -128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -128)
        r = o.doubleArg_andcharArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andcharArg_(1e10, 127)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 127)

    def testdoubleAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andsignedshortArg_(0.128, -(1 << 14))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 14))
        r = o.doubleArg_andsignedshortArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedshortArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedshortArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedshortArg_(0.128, 1 << 14)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andsignedshortArg_(1.0, -(1 << 14))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.doubleArg_andsignedshortArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedshortArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedshortArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedshortArg_(1.0, 1 << 14)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andsignedshortArg_(42.0, -(1 << 14))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 14))
        r = o.doubleArg_andsignedshortArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedshortArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedshortArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedshortArg_(42.0, 1 << 14)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andsignedshortArg_(1e10, -(1 << 14))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 14))
        r = o.doubleArg_andsignedshortArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedshortArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedshortArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedshortArg_(1e10, 1 << 14)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 14)

    def testdoubleAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andsignedintArg_(0.128, -(1 << 30))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedintArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedintArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedintArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedintArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedintArg_(1.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedintArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedintArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedintArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedintArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedintArg_(42.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedintArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedintArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedintArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedintArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedintArg_(1e10, -(1 << 30))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedintArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedintArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedintArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedintArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testdoubleAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andsignedlongArg_(0.128, -(1 << 30))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedlongArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlongArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedlongArg_(1.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedlongArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlongArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedlongArg_(42.0, -(1 << 30))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedlongArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlongArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andsignedlongArg_(1e10, -(1 << 30))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 30))
        r = o.doubleArg_andsignedlongArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlongArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testdoubleAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andsignedlonglongArg_(0.128, -(1 << 60))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -(1 << 60))
        r = o.doubleArg_andsignedlonglongArg_(0.128, -42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlonglongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlonglongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlonglongArg_(0.128, 1 << 60)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 60)
        r = o.doubleArg_andsignedlonglongArg_(1.0, -(1 << 60))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.doubleArg_andsignedlonglongArg_(1.0, -42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlonglongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlonglongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlonglongArg_(1.0, 1 << 60)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 60)
        r = o.doubleArg_andsignedlonglongArg_(42.0, -(1 << 60))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -(1 << 60))
        r = o.doubleArg_andsignedlonglongArg_(42.0, -42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlonglongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlonglongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlonglongArg_(42.0, 1 << 60)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 60)
        r = o.doubleArg_andsignedlonglongArg_(1e10, -(1 << 60))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -(1 << 60))
        r = o.doubleArg_andsignedlonglongArg_(1e10, -42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], -42)
        r = o.doubleArg_andsignedlonglongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andsignedlonglongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andsignedlonglongArg_(1e10, 1 << 60)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 60)

    def testdoubleAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andunsignedcharArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedcharArg_(0.128, 128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 128)
        r = o.doubleArg_andunsignedcharArg_(0.128, 255)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 255)
        r = o.doubleArg_andunsignedcharArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedcharArg_(1.0, 128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 128)
        r = o.doubleArg_andunsignedcharArg_(1.0, 255)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 255)
        r = o.doubleArg_andunsignedcharArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedcharArg_(42.0, 128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 128)
        r = o.doubleArg_andunsignedcharArg_(42.0, 255)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 255)
        r = o.doubleArg_andunsignedcharArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedcharArg_(1e10, 128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 128)
        r = o.doubleArg_andunsignedcharArg_(1e10, 255)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 255)

    def testdoubleAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andunsignedshortArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedshortArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedshortArg_(0.128, 1 << 14)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andunsignedshortArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedshortArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedshortArg_(1.0, 1 << 14)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andunsignedshortArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedshortArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedshortArg_(42.0, 1 << 14)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 14)
        r = o.doubleArg_andunsignedshortArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedshortArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedshortArg_(1e10, 1 << 14)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 14)

    def testdoubleAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andunsignedintArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedintArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedintArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedintArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedintArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedintArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedintArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedintArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedintArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedintArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedintArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedintArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testdoubleAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andunsignedlongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlongArg_(0.128, 1 << 30)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedlongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlongArg_(1.0, 1 << 30)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedlongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlongArg_(42.0, 1 << 30)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 30)
        r = o.doubleArg_andunsignedlongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlongArg_(1e10, 1 << 30)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 30)

    def testdoubleAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andunsignedlonglongArg_(0.128, 0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlonglongArg_(0.128, 42)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlonglongArg_(0.128, 1 << 62)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], 1 << 62)
        r = o.doubleArg_andunsignedlonglongArg_(1.0, 0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlonglongArg_(1.0, 42)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlonglongArg_(1.0, 1 << 62)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], 1 << 62)
        r = o.doubleArg_andunsignedlonglongArg_(42.0, 0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlonglongArg_(42.0, 42)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlonglongArg_(42.0, 1 << 62)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], 1 << 62)
        r = o.doubleArg_andunsignedlonglongArg_(1e10, 0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 0)
        r = o.doubleArg_andunsignedlonglongArg_(1e10, 42)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 42)
        r = o.doubleArg_andunsignedlonglongArg_(1e10, 1 << 62)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], 1 << 62)

    def testdoubleAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andfloatArg_(0.128, 0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_andfloatArg_(0.128, 1.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_andfloatArg_(0.128, 42.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_andfloatArg_(0.128, 1e10)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_andfloatArg_(1.0, 0.128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_andfloatArg_(1.0, 1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_andfloatArg_(1.0, 42.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_andfloatArg_(1.0, 1e10)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_andfloatArg_(42.0, 0.128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_andfloatArg_(42.0, 1.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_andfloatArg_(42.0, 42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_andfloatArg_(42.0, 1e10)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_andfloatArg_(1e10, 0.128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_andfloatArg_(1e10, 1.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_andfloatArg_(1e10, 42.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_andfloatArg_(1e10, 1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1e10)

    def testdoubleAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_anddoubleArg_(0.128, 0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_anddoubleArg_(0.128, 1.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_anddoubleArg_(0.128, 42.0)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_anddoubleArg_(0.128, 1e10)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_anddoubleArg_(1.0, 0.128)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_anddoubleArg_(1.0, 1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_anddoubleArg_(1.0, 42.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_anddoubleArg_(1.0, 1e10)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_anddoubleArg_(42.0, 0.128)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_anddoubleArg_(42.0, 1.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_anddoubleArg_(42.0, 42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_anddoubleArg_(42.0, 1e10)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1e10)
        r = o.doubleArg_anddoubleArg_(1e10, 0.128)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleArg_anddoubleArg_(1e10, 1.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleArg_anddoubleArg_(1e10, 42.0)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleArg_anddoubleArg_(1e10, 1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 1e10)

    def testdoubleAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andidArg_(0.128, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.doubleArg_andidArg_(1.0, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.doubleArg_andidArg_(42.0, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.doubleArg_andidArg_(1e10, NSPriorDayDesignations)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testdoubleAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andcharPtrArg_(0.128, b"hello")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"hello")
        r = o.doubleArg_andcharPtrArg_(0.128, b"world")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"world")
        r = o.doubleArg_andcharPtrArg_(0.128, b"foobar")
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], b"foobar")
        r = o.doubleArg_andcharPtrArg_(1.0, b"hello")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"hello")
        r = o.doubleArg_andcharPtrArg_(1.0, b"world")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"world")
        r = o.doubleArg_andcharPtrArg_(1.0, b"foobar")
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], b"foobar")
        r = o.doubleArg_andcharPtrArg_(42.0, b"hello")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"hello")
        r = o.doubleArg_andcharPtrArg_(42.0, b"world")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"world")
        r = o.doubleArg_andcharPtrArg_(42.0, b"foobar")
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], b"foobar")
        r = o.doubleArg_andcharPtrArg_(1e10, b"hello")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"hello")
        r = o.doubleArg_andcharPtrArg_(1e10, b"world")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"world")
        r = o.doubleArg_andcharPtrArg_(1e10, b"foobar")
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], b"foobar")

    def testdoubleAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andNSPointArg_(0.128, (1, 2))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andNSPointArg_(0.128, (3, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (3, 4))
        r = o.doubleArg_andNSPointArg_(1.0, (1, 2))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andNSPointArg_(1.0, (3, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (3, 4))
        r = o.doubleArg_andNSPointArg_(42.0, (1, 2))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andNSPointArg_(42.0, (3, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (3, 4))
        r = o.doubleArg_andNSPointArg_(1e10, (1, 2))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andNSPointArg_(1e10, (3, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (3, 4))

    def testdoubleAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andNSRectArg_(0.128, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.doubleArg_andNSRectArg_(0.128, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.doubleArg_andNSRectArg_(1.0, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.doubleArg_andNSRectArg_(1.0, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.doubleArg_andNSRectArg_(42.0, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.doubleArg_andNSRectArg_(42.0, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.doubleArg_andNSRectArg_(1e10, ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.doubleArg_andNSRectArg_(1e10, ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testdoubleAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andstructTestStruct1Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct1Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct1Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct1Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct1Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct1Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct1Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct1Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testdoubleAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andstructTestStruct2Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct2Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct2Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct2Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct2Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct2Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.doubleArg_andstructTestStruct2Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.doubleArg_andstructTestStruct2Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testdoubleAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andstructTestStruct3Arg_(0.128, (1, 2))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andstructTestStruct3Arg_(0.128, (2, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct3Arg_(1.0, (1, 2))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andstructTestStruct3Arg_(1.0, (2, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct3Arg_(42.0, (1, 2))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andstructTestStruct3Arg_(42.0, (2, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct3Arg_(1e10, (1, 2))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2))
        r = o.doubleArg_andstructTestStruct3Arg_(1e10, (2, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4))

    def testdoubleAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andstructTestStruct4Arg_(0.128, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.doubleArg_andstructTestStruct4Arg_(0.128, (2, 4))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct4Arg_(1.0, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.doubleArg_andstructTestStruct4Arg_(1.0, (2, 4))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct4Arg_(42.0, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.doubleArg_andstructTestStruct4Arg_(42.0, (2, 4))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4))
        r = o.doubleArg_andstructTestStruct4Arg_(1e10, (1, 1 << 60))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.doubleArg_andstructTestStruct4Arg_(1e10, (2, 4))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4))

    def testdoubleAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleArg_andstructTestStruct5Arg_(0.128, (1, 2.5))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (1, 2.5))
        r = o.doubleArg_andstructTestStruct5Arg_(0.128, (2, 4.5))
        self.assertAlmostEqual(r[0], 0.128)
        self.assertEqual(r[1], (2, 4.5))
        r = o.doubleArg_andstructTestStruct5Arg_(1.0, (1, 2.5))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.doubleArg_andstructTestStruct5Arg_(1.0, (2, 4.5))
        self.assertAlmostEqual(r[0], 1.0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.doubleArg_andstructTestStruct5Arg_(42.0, (1, 2.5))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (1, 2.5))
        r = o.doubleArg_andstructTestStruct5Arg_(42.0, (2, 4.5))
        self.assertAlmostEqual(r[0], 42.0)
        self.assertEqual(r[1], (2, 4.5))
        r = o.doubleArg_andstructTestStruct5Arg_(1e10, (1, 2.5))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (1, 2.5))
        r = o.doubleArg_andstructTestStruct5Arg_(1e10, (2, 4.5))
        self.assertAlmostEqual(r[0], 1e10)
        self.assertEqual(r[1], (2, 4.5))

    def testidAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andboolArg_(NSPriorDayDesignations, YES)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], YES)
        r = o.idArg_andboolArg_(NSPriorDayDesignations, NO)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], NO)

    def testidAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andBOOLArg_(NSPriorDayDesignations, YES)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], YES)
        r = o.idArg_andBOOLArg_(NSPriorDayDesignations, NO)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], NO)

    def testidAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andcharArg_(NSPriorDayDesignations, -128)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -128)
        r = o.idArg_andcharArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andcharArg_(NSPriorDayDesignations, 127)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 127)

    def testidAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, -(1 << 14))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -(1 << 14))
        r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, -42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -42)
        r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 1 << 14)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 14)

    def testidAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andsignedintArg_(NSPriorDayDesignations, -(1 << 30))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -(1 << 30))
        r = o.idArg_andsignedintArg_(NSPriorDayDesignations, -42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -42)
        r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 1 << 30)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 30)

    def testidAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, -(1 << 30))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -(1 << 30))
        r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, -42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -42)
        r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 1 << 30)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 30)

    def testidAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, -(1 << 60))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -(1 << 60))
        r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, -42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], -42)
        r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 1 << 60)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 60)

    def testidAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 128)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 128)
        r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 255)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 255)

    def testidAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 1 << 14)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 14)

    def testidAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 1 << 30)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 30)

    def testidAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 1 << 30)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 30)

    def testidAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 0)
        r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 42)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 42)
        r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 1 << 62)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], 1 << 62)

    def testidAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andfloatArg_(NSPriorDayDesignations, 0.128)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.idArg_andfloatArg_(NSPriorDayDesignations, 1.0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.idArg_andfloatArg_(NSPriorDayDesignations, 42.0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.idArg_andfloatArg_(NSPriorDayDesignations, 1e10)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 1e10)

    def testidAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 0.128)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 1.0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 42.0)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 1e10)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertAlmostEqual(r[1], 1e10)

    def testidAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andidArg_(NSPriorDayDesignations, NSPriorDayDesignations)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testidAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, b"hello")
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], b"hello")
        r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, b"world")
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], b"world")
        r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, b"foobar")
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], b"foobar")

    def testidAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andNSPointArg_(NSPriorDayDesignations, (1, 2))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 2))
        r = o.idArg_andNSPointArg_(NSPriorDayDesignations, (3, 4))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (3, 4))

    def testidAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andNSRectArg_(NSPriorDayDesignations, ((1, 2), (3, 4)))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.idArg_andNSRectArg_(NSPriorDayDesignations, ((7, 8), (9, 10)))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testidAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andstructTestStruct1Arg_(
            NSPriorDayDesignations, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.idArg_andstructTestStruct1Arg_(
            NSPriorDayDesignations, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testidAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andstructTestStruct2Arg_(
            NSPriorDayDesignations, (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.idArg_andstructTestStruct2Arg_(
            NSPriorDayDesignations, (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testidAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andstructTestStruct3Arg_(NSPriorDayDesignations, (1, 2))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 2))
        r = o.idArg_andstructTestStruct3Arg_(NSPriorDayDesignations, (2, 4))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (2, 4))

    def testidAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andstructTestStruct4Arg_(NSPriorDayDesignations, (1, 1 << 60))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.idArg_andstructTestStruct4Arg_(NSPriorDayDesignations, (2, 4))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (2, 4))

    def testidAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idArg_andstructTestStruct5Arg_(NSPriorDayDesignations, (1, 2.5))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (1, 2.5))
        r = o.idArg_andstructTestStruct5Arg_(NSPriorDayDesignations, (2, 4.5))
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], (2, 4.5))

    def testcharPtrAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andboolArg_(b"hello", YES)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andboolArg_(b"hello", NO)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], NO)
        r = o.charPtrArg_andboolArg_(b"world", YES)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andboolArg_(b"world", NO)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], NO)
        r = o.charPtrArg_andboolArg_(b"foobar", YES)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andboolArg_(b"foobar", NO)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], NO)

    def testcharPtrAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andBOOLArg_(b"hello", YES)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andBOOLArg_(b"hello", NO)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], NO)
        r = o.charPtrArg_andBOOLArg_(b"world", YES)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andBOOLArg_(b"world", NO)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], NO)
        r = o.charPtrArg_andBOOLArg_(b"foobar", YES)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], YES)
        r = o.charPtrArg_andBOOLArg_(b"foobar", NO)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], NO)

    def testcharPtrAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andcharArg_(b"hello", -128)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -128)
        r = o.charPtrArg_andcharArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andcharArg_(b"hello", 127)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 127)
        r = o.charPtrArg_andcharArg_(b"world", -128)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -128)
        r = o.charPtrArg_andcharArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andcharArg_(b"world", 127)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 127)
        r = o.charPtrArg_andcharArg_(b"foobar", -128)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -128)
        r = o.charPtrArg_andcharArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andcharArg_(b"foobar", 127)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 127)

    def testcharPtrAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andsignedshortArg_(b"hello", -(1 << 14))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -(1 << 14))
        r = o.charPtrArg_andsignedshortArg_(b"hello", -42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedshortArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedshortArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedshortArg_(b"hello", 1 << 14)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 14)
        r = o.charPtrArg_andsignedshortArg_(b"world", -(1 << 14))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -(1 << 14))
        r = o.charPtrArg_andsignedshortArg_(b"world", -42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedshortArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedshortArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedshortArg_(b"world", 1 << 14)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 14)
        r = o.charPtrArg_andsignedshortArg_(b"foobar", -(1 << 14))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -(1 << 14))
        r = o.charPtrArg_andsignedshortArg_(b"foobar", -42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedshortArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedshortArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedshortArg_(b"foobar", 1 << 14)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 14)

    def testcharPtrAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andsignedintArg_(b"hello", -(1 << 30))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedintArg_(b"hello", -42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedintArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedintArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedintArg_(b"hello", 1 << 30)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andsignedintArg_(b"world", -(1 << 30))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedintArg_(b"world", -42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedintArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedintArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedintArg_(b"world", 1 << 30)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andsignedintArg_(b"foobar", -(1 << 30))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedintArg_(b"foobar", -42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedintArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedintArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedintArg_(b"foobar", 1 << 30)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 30)

    def testcharPtrAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andsignedlongArg_(b"hello", -(1 << 30))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedlongArg_(b"hello", -42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlongArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlongArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlongArg_(b"hello", 1 << 30)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andsignedlongArg_(b"world", -(1 << 30))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedlongArg_(b"world", -42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlongArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlongArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlongArg_(b"world", 1 << 30)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andsignedlongArg_(b"foobar", -(1 << 30))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -(1 << 30))
        r = o.charPtrArg_andsignedlongArg_(b"foobar", -42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlongArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlongArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlongArg_(b"foobar", 1 << 30)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 30)

    def testcharPtrAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andsignedlonglongArg_(b"hello", -(1 << 60))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -(1 << 60))
        r = o.charPtrArg_andsignedlonglongArg_(b"hello", -42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlonglongArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlonglongArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlonglongArg_(b"hello", 1 << 60)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 60)
        r = o.charPtrArg_andsignedlonglongArg_(b"world", -(1 << 60))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -(1 << 60))
        r = o.charPtrArg_andsignedlonglongArg_(b"world", -42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlonglongArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlonglongArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlonglongArg_(b"world", 1 << 60)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 60)
        r = o.charPtrArg_andsignedlonglongArg_(b"foobar", -(1 << 60))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -(1 << 60))
        r = o.charPtrArg_andsignedlonglongArg_(b"foobar", -42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], -42)
        r = o.charPtrArg_andsignedlonglongArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andsignedlonglongArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andsignedlonglongArg_(b"foobar", 1 << 60)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 60)

    def testcharPtrAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andunsignedcharArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedcharArg_(b"hello", 128)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 128)
        r = o.charPtrArg_andunsignedcharArg_(b"hello", 255)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 255)
        r = o.charPtrArg_andunsignedcharArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedcharArg_(b"world", 128)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 128)
        r = o.charPtrArg_andunsignedcharArg_(b"world", 255)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 255)
        r = o.charPtrArg_andunsignedcharArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedcharArg_(b"foobar", 128)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 128)
        r = o.charPtrArg_andunsignedcharArg_(b"foobar", 255)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 255)

    def testcharPtrAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andunsignedshortArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedshortArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedshortArg_(b"hello", 1 << 14)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 14)
        r = o.charPtrArg_andunsignedshortArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedshortArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedshortArg_(b"world", 1 << 14)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 14)
        r = o.charPtrArg_andunsignedshortArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedshortArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedshortArg_(b"foobar", 1 << 14)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 14)

    def testcharPtrAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andunsignedintArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedintArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedintArg_(b"hello", 1 << 30)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andunsignedintArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedintArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedintArg_(b"world", 1 << 30)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andunsignedintArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedintArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedintArg_(b"foobar", 1 << 30)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 30)

    def testcharPtrAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andunsignedlongArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlongArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlongArg_(b"hello", 1 << 30)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andunsignedlongArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlongArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlongArg_(b"world", 1 << 30)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 30)
        r = o.charPtrArg_andunsignedlongArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlongArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlongArg_(b"foobar", 1 << 30)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 30)

    def testcharPtrAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andunsignedlonglongArg_(b"hello", 0)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlonglongArg_(b"hello", 42)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlonglongArg_(b"hello", 1 << 62)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], 1 << 62)
        r = o.charPtrArg_andunsignedlonglongArg_(b"world", 0)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlonglongArg_(b"world", 42)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlonglongArg_(b"world", 1 << 62)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], 1 << 62)
        r = o.charPtrArg_andunsignedlonglongArg_(b"foobar", 0)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 0)
        r = o.charPtrArg_andunsignedlonglongArg_(b"foobar", 42)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 42)
        r = o.charPtrArg_andunsignedlonglongArg_(b"foobar", 1 << 62)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], 1 << 62)

    def testcharPtrAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andfloatArg_(b"hello", 0.128)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_andfloatArg_(b"hello", 1.0)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_andfloatArg_(b"hello", 42.0)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_andfloatArg_(b"hello", 1e10)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charPtrArg_andfloatArg_(b"world", 0.128)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_andfloatArg_(b"world", 1.0)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_andfloatArg_(b"world", 42.0)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_andfloatArg_(b"world", 1e10)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charPtrArg_andfloatArg_(b"foobar", 0.128)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_andfloatArg_(b"foobar", 1.0)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_andfloatArg_(b"foobar", 42.0)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_andfloatArg_(b"foobar", 1e10)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 1e10)

    def testcharPtrAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_anddoubleArg_(b"hello", 0.128)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_anddoubleArg_(b"hello", 1.0)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_anddoubleArg_(b"hello", 42.0)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_anddoubleArg_(b"hello", 1e10)
        self.assertEqual(r[0], b"hello")
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charPtrArg_anddoubleArg_(b"world", 0.128)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_anddoubleArg_(b"world", 1.0)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_anddoubleArg_(b"world", 42.0)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_anddoubleArg_(b"world", 1e10)
        self.assertEqual(r[0], b"world")
        self.assertAlmostEqual(r[1], 1e10)
        r = o.charPtrArg_anddoubleArg_(b"foobar", 0.128)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 0.128)
        r = o.charPtrArg_anddoubleArg_(b"foobar", 1.0)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 1.0)
        r = o.charPtrArg_anddoubleArg_(b"foobar", 42.0)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 42.0)
        r = o.charPtrArg_anddoubleArg_(b"foobar", 1e10)
        self.assertEqual(r[0], b"foobar")
        self.assertAlmostEqual(r[1], 1e10)

    def testcharPtrAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andidArg_(b"hello", NSPriorDayDesignations)
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.charPtrArg_andidArg_(b"world", NSPriorDayDesignations)
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.charPtrArg_andidArg_(b"foobar", NSPriorDayDesignations)
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testcharPtrAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andcharPtrArg_(b"hello", b"hello")
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], b"hello")
        r = o.charPtrArg_andcharPtrArg_(b"hello", b"world")
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], b"world")
        r = o.charPtrArg_andcharPtrArg_(b"hello", b"foobar")
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], b"foobar")
        r = o.charPtrArg_andcharPtrArg_(b"world", b"hello")
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], b"hello")
        r = o.charPtrArg_andcharPtrArg_(b"world", b"world")
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], b"world")
        r = o.charPtrArg_andcharPtrArg_(b"world", b"foobar")
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], b"foobar")
        r = o.charPtrArg_andcharPtrArg_(b"foobar", b"hello")
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], b"hello")
        r = o.charPtrArg_andcharPtrArg_(b"foobar", b"world")
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], b"world")
        r = o.charPtrArg_andcharPtrArg_(b"foobar", b"foobar")
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], b"foobar")

    def testcharPtrAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andNSPointArg_(b"hello", (1, 2))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andNSPointArg_(b"hello", (3, 4))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (3, 4))
        r = o.charPtrArg_andNSPointArg_(b"world", (1, 2))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andNSPointArg_(b"world", (3, 4))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (3, 4))
        r = o.charPtrArg_andNSPointArg_(b"foobar", (1, 2))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andNSPointArg_(b"foobar", (3, 4))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (3, 4))

    def testcharPtrAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andNSRectArg_(b"hello", ((1, 2), (3, 4)))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charPtrArg_andNSRectArg_(b"hello", ((7, 8), (9, 10)))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.charPtrArg_andNSRectArg_(b"world", ((1, 2), (3, 4)))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charPtrArg_andNSRectArg_(b"world", ((7, 8), (9, 10)))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.charPtrArg_andNSRectArg_(b"foobar", ((1, 2), (3, 4)))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.charPtrArg_andNSRectArg_(b"foobar", ((7, 8), (9, 10)))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testcharPtrAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andstructTestStruct1Arg_(b"hello", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct1Arg_(
            b"hello", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charPtrArg_andstructTestStruct1Arg_(b"world", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct1Arg_(
            b"world", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charPtrArg_andstructTestStruct1Arg_(b"foobar", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct1Arg_(
            b"foobar", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testcharPtrAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andstructTestStruct2Arg_(b"hello", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct2Arg_(
            b"hello", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charPtrArg_andstructTestStruct2Arg_(b"world", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct2Arg_(
            b"world", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.charPtrArg_andstructTestStruct2Arg_(b"foobar", (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.charPtrArg_andstructTestStruct2Arg_(
            b"foobar", (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testcharPtrAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andstructTestStruct3Arg_(b"hello", (1, 2))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andstructTestStruct3Arg_(b"hello", (2, 4))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (2, 4))
        r = o.charPtrArg_andstructTestStruct3Arg_(b"world", (1, 2))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andstructTestStruct3Arg_(b"world", (2, 4))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (2, 4))
        r = o.charPtrArg_andstructTestStruct3Arg_(b"foobar", (1, 2))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 2))
        r = o.charPtrArg_andstructTestStruct3Arg_(b"foobar", (2, 4))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (2, 4))

    def testcharPtrAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andstructTestStruct4Arg_(b"hello", (1, 1 << 60))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charPtrArg_andstructTestStruct4Arg_(b"hello", (2, 4))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (2, 4))
        r = o.charPtrArg_andstructTestStruct4Arg_(b"world", (1, 1 << 60))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charPtrArg_andstructTestStruct4Arg_(b"world", (2, 4))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (2, 4))
        r = o.charPtrArg_andstructTestStruct4Arg_(b"foobar", (1, 1 << 60))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.charPtrArg_andstructTestStruct4Arg_(b"foobar", (2, 4))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (2, 4))

    def testcharPtrAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrArg_andstructTestStruct5Arg_(b"hello", (1, 2.5))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (1, 2.5))
        r = o.charPtrArg_andstructTestStruct5Arg_(b"hello", (2, 4.5))
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], (2, 4.5))
        r = o.charPtrArg_andstructTestStruct5Arg_(b"world", (1, 2.5))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (1, 2.5))
        r = o.charPtrArg_andstructTestStruct5Arg_(b"world", (2, 4.5))
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], (2, 4.5))
        r = o.charPtrArg_andstructTestStruct5Arg_(b"foobar", (1, 2.5))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (1, 2.5))
        r = o.charPtrArg_andstructTestStruct5Arg_(b"foobar", (2, 4.5))
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], (2, 4.5))

    def testNSPointAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andboolArg_((1, 2), YES)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], YES)
        r = o.NSPointArg_andboolArg_((1, 2), NO)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NO)
        r = o.NSPointArg_andboolArg_((3, 4), YES)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], YES)
        r = o.NSPointArg_andboolArg_((3, 4), NO)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], NO)

    def testNSPointAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andBOOLArg_((1, 2), YES)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], YES)
        r = o.NSPointArg_andBOOLArg_((1, 2), NO)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NO)
        r = o.NSPointArg_andBOOLArg_((3, 4), YES)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], YES)
        r = o.NSPointArg_andBOOLArg_((3, 4), NO)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], NO)

    def testNSPointAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andcharArg_((1, 2), -128)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -128)
        r = o.NSPointArg_andcharArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andcharArg_((1, 2), 127)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 127)
        r = o.NSPointArg_andcharArg_((3, 4), -128)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -128)
        r = o.NSPointArg_andcharArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andcharArg_((3, 4), 127)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 127)

    def testNSPointAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andsignedshortArg_((1, 2), -(1 << 14))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 14))
        r = o.NSPointArg_andsignedshortArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedshortArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedshortArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedshortArg_((1, 2), 1 << 14)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 14)
        r = o.NSPointArg_andsignedshortArg_((3, 4), -(1 << 14))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -(1 << 14))
        r = o.NSPointArg_andsignedshortArg_((3, 4), -42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedshortArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedshortArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedshortArg_((3, 4), 1 << 14)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 14)

    def testNSPointAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andsignedintArg_((1, 2), -(1 << 30))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSPointArg_andsignedintArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedintArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedintArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedintArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSPointArg_andsignedintArg_((3, 4), -(1 << 30))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSPointArg_andsignedintArg_((3, 4), -42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedintArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedintArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedintArg_((3, 4), 1 << 30)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 30)

    def testNSPointAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andsignedlongArg_((1, 2), -(1 << 30))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSPointArg_andsignedlongArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedlongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedlongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedlongArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSPointArg_andsignedlongArg_((3, 4), -(1 << 30))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSPointArg_andsignedlongArg_((3, 4), -42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedlongArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedlongArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedlongArg_((3, 4), 1 << 30)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 30)

    def testNSPointAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andsignedlonglongArg_((1, 2), -(1 << 60))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 60))
        r = o.NSPointArg_andsignedlonglongArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedlonglongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedlonglongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedlonglongArg_((1, 2), 1 << 60)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 60)
        r = o.NSPointArg_andsignedlonglongArg_((3, 4), -(1 << 60))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -(1 << 60))
        r = o.NSPointArg_andsignedlonglongArg_((3, 4), -42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], -42)
        r = o.NSPointArg_andsignedlonglongArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andsignedlonglongArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andsignedlonglongArg_((3, 4), 1 << 60)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 60)

    def testNSPointAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andunsignedcharArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedcharArg_((1, 2), 128)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 128)
        r = o.NSPointArg_andunsignedcharArg_((1, 2), 255)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 255)
        r = o.NSPointArg_andunsignedcharArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedcharArg_((3, 4), 128)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 128)
        r = o.NSPointArg_andunsignedcharArg_((3, 4), 255)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 255)

    def testNSPointAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andunsignedshortArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedshortArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedshortArg_((1, 2), 1 << 14)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 14)
        r = o.NSPointArg_andunsignedshortArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedshortArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedshortArg_((3, 4), 1 << 14)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 14)

    def testNSPointAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andunsignedintArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedintArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedintArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSPointArg_andunsignedintArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedintArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedintArg_((3, 4), 1 << 30)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 30)

    def testNSPointAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andunsignedlongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedlongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedlongArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSPointArg_andunsignedlongArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedlongArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedlongArg_((3, 4), 1 << 30)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 30)

    def testNSPointAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 1 << 62)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 62)
        r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 0)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 0)
        r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 42)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 42)
        r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 1 << 62)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], 1 << 62)

    def testNSPointAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andfloatArg_((1, 2), 0.128)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSPointArg_andfloatArg_((1, 2), 1.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSPointArg_andfloatArg_((1, 2), 42.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSPointArg_andfloatArg_((1, 2), 1e10)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.NSPointArg_andfloatArg_((3, 4), 0.128)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSPointArg_andfloatArg_((3, 4), 1.0)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSPointArg_andfloatArg_((3, 4), 42.0)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSPointArg_andfloatArg_((3, 4), 1e10)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def testNSPointAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_anddoubleArg_((1, 2), 0.128)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSPointArg_anddoubleArg_((1, 2), 1.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSPointArg_anddoubleArg_((1, 2), 42.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSPointArg_anddoubleArg_((1, 2), 1e10)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.NSPointArg_anddoubleArg_((3, 4), 0.128)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSPointArg_anddoubleArg_((3, 4), 1.0)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSPointArg_anddoubleArg_((3, 4), 42.0)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSPointArg_anddoubleArg_((3, 4), 1e10)
        self.assertEqual(r[0], (3, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def testNSPointAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andidArg_((1, 2), NSPriorDayDesignations)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.NSPointArg_andidArg_((3, 4), NSPriorDayDesignations)
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testNSPointAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andcharPtrArg_((1, 2), b"hello")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"hello")
        r = o.NSPointArg_andcharPtrArg_((1, 2), b"world")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"world")
        r = o.NSPointArg_andcharPtrArg_((1, 2), b"foobar")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"foobar")
        r = o.NSPointArg_andcharPtrArg_((3, 4), b"hello")
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], b"hello")
        r = o.NSPointArg_andcharPtrArg_((3, 4), b"world")
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], b"world")
        r = o.NSPointArg_andcharPtrArg_((3, 4), b"foobar")
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], b"foobar")

    def testNSPointAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andNSPointArg_((1, 2), (1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2))
        r = o.NSPointArg_andNSPointArg_((1, 2), (3, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (3, 4))
        r = o.NSPointArg_andNSPointArg_((3, 4), (1, 2))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.NSPointArg_andNSPointArg_((3, 4), (3, 4))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (3, 4))

    def testNSPointAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andNSRectArg_((1, 2), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.NSPointArg_andNSRectArg_((1, 2), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.NSPointArg_andNSRectArg_((3, 4), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.NSPointArg_andNSRectArg_((3, 4), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testNSPointAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andstructTestStruct1Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSPointArg_andstructTestStruct1Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.NSPointArg_andstructTestStruct1Arg_((3, 4), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSPointArg_andstructTestStruct1Arg_((3, 4), (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testNSPointAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andstructTestStruct2Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSPointArg_andstructTestStruct2Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.NSPointArg_andstructTestStruct2Arg_((3, 4), (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSPointArg_andstructTestStruct2Arg_((3, 4), (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testNSPointAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andstructTestStruct3Arg_((1, 2), (1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2))
        r = o.NSPointArg_andstructTestStruct3Arg_((1, 2), (2, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4))
        r = o.NSPointArg_andstructTestStruct3Arg_((3, 4), (1, 2))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.NSPointArg_andstructTestStruct3Arg_((3, 4), (2, 4))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (2, 4))

    def testNSPointAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andstructTestStruct4Arg_((1, 2), (1, 1 << 60))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.NSPointArg_andstructTestStruct4Arg_((1, 2), (2, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4))
        r = o.NSPointArg_andstructTestStruct4Arg_((3, 4), (1, 1 << 60))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.NSPointArg_andstructTestStruct4Arg_((3, 4), (2, 4))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (2, 4))

    def testNSPointAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointArg_andstructTestStruct5Arg_((1, 2), (1, 2.5))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2.5))
        r = o.NSPointArg_andstructTestStruct5Arg_((1, 2), (2, 4.5))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4.5))
        r = o.NSPointArg_andstructTestStruct5Arg_((3, 4), (1, 2.5))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2.5))
        r = o.NSPointArg_andstructTestStruct5Arg_((3, 4), (2, 4.5))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (2, 4.5))

    def testNSRectAndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andboolArg_(((1, 2), (3, 4)), YES)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], YES)
        r = o.NSRectArg_andboolArg_(((1, 2), (3, 4)), NO)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], NO)
        r = o.NSRectArg_andboolArg_(((7, 8), (9, 10)), YES)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], YES)
        r = o.NSRectArg_andboolArg_(((7, 8), (9, 10)), NO)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], NO)

    def testNSRectAndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andBOOLArg_(((1, 2), (3, 4)), YES)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], YES)
        r = o.NSRectArg_andBOOLArg_(((1, 2), (3, 4)), NO)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], NO)
        r = o.NSRectArg_andBOOLArg_(((7, 8), (9, 10)), YES)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], YES)
        r = o.NSRectArg_andBOOLArg_(((7, 8), (9, 10)), NO)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], NO)

    def testNSRectAndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), -128)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -128)
        r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), 127)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 127)
        r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), -128)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -128)
        r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), 127)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 127)

    def testNSRectAndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), -(1 << 14))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), -42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 1 << 14)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 14)
        r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), -(1 << 14))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), -42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 1 << 14)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 14)

    def testNSRectAndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), -(1 << 30))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), -42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 1 << 30)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), -(1 << 30))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), -42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 1 << 30)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 30)

    def testNSRectAndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), -(1 << 30))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), -42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 1 << 30)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), -(1 << 30))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), -42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 1 << 30)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 30)

    def testNSRectAndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), -(1 << 60))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), -42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 1 << 60)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 60)
        r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), -(1 << 60))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), -42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], -42)
        r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 1 << 60)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 60)

    def testNSRectAndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 128)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 128)
        r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 255)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 255)
        r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 128)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 128)
        r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 255)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 255)

    def testNSRectAndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 1 << 14)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 14)
        r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 1 << 14)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 14)

    def testNSRectAndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 1 << 30)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 1 << 30)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 30)

    def testNSRectAndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 1 << 30)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 30)
        r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 1 << 30)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 30)

    def testNSRectAndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 42)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 1 << 62)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], 1 << 62)
        r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 0)
        r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 42)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 42)
        r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 1 << 62)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], 1 << 62)

    def testNSRectAndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 0.128)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 1.0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 42.0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 1e10)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 0.128)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 1.0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 42.0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 1e10)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 1e10)

    def testNSRectAnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 0.128)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 1.0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 42.0)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 1e10)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 0.128)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 1.0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 42.0)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 1e10)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertAlmostEqual(r[1], 1e10)

    def testNSRectAndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andidArg_(((1, 2), (3, 4)), NSPriorDayDesignations)
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.NSRectArg_andidArg_(((7, 8), (9, 10)), NSPriorDayDesignations)
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testNSRectAndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), b"hello")
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], b"hello")
        r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), b"world")
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], b"world")
        r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), b"foobar")
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], b"foobar")
        r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), b"hello")
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], b"hello")
        r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), b"world")
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], b"world")
        r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), b"foobar")
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], b"foobar")

    def testNSRectAndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andNSPointArg_(((1, 2), (3, 4)), (1, 2))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 2))
        r = o.NSRectArg_andNSPointArg_(((1, 2), (3, 4)), (3, 4))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (3, 4))
        r = o.NSRectArg_andNSPointArg_(((7, 8), (9, 10)), (1, 2))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 2))
        r = o.NSRectArg_andNSPointArg_(((7, 8), (9, 10)), (3, 4))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (3, 4))

    def testNSRectAndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andNSRectArg_(((1, 2), (3, 4)), ((1, 2), (3, 4)))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.NSRectArg_andNSRectArg_(((1, 2), (3, 4)), ((7, 8), (9, 10)))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.NSRectArg_andNSRectArg_(((7, 8), (9, 10)), ((1, 2), (3, 4)))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.NSRectArg_andNSRectArg_(((7, 8), (9, 10)), ((7, 8), (9, 10)))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def testNSRectAndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andstructTestStruct1Arg_(
            ((1, 2), (3, 4)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSRectArg_andstructTestStruct1Arg_(
            ((1, 2), (3, 4)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.NSRectArg_andstructTestStruct1Arg_(
            ((7, 8), (9, 10)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSRectArg_andstructTestStruct1Arg_(
            ((7, 8), (9, 10)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testNSRectAndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andstructTestStruct2Arg_(
            ((1, 2), (3, 4)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSRectArg_andstructTestStruct2Arg_(
            ((1, 2), (3, 4)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.NSRectArg_andstructTestStruct2Arg_(
            ((7, 8), (9, 10)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.NSRectArg_andstructTestStruct2Arg_(
            ((7, 8), (9, 10)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def testNSRectAndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andstructTestStruct3Arg_(((1, 2), (3, 4)), (1, 2))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 2))
        r = o.NSRectArg_andstructTestStruct3Arg_(((1, 2), (3, 4)), (2, 4))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (2, 4))
        r = o.NSRectArg_andstructTestStruct3Arg_(((7, 8), (9, 10)), (1, 2))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 2))
        r = o.NSRectArg_andstructTestStruct3Arg_(((7, 8), (9, 10)), (2, 4))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (2, 4))

    def testNSRectAndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andstructTestStruct4Arg_(((1, 2), (3, 4)), (1, 1 << 60))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.NSRectArg_andstructTestStruct4Arg_(((1, 2), (3, 4)), (2, 4))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (2, 4))
        r = o.NSRectArg_andstructTestStruct4Arg_(((7, 8), (9, 10)), (1, 1 << 60))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.NSRectArg_andstructTestStruct4Arg_(((7, 8), (9, 10)), (2, 4))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (2, 4))

    def testNSRectAndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectArg_andstructTestStruct5Arg_(((1, 2), (3, 4)), (1, 2.5))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.NSRectArg_andstructTestStruct5Arg_(((1, 2), (3, 4)), (2, 4.5))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], (2, 4.5))
        r = o.NSRectArg_andstructTestStruct5Arg_(((7, 8), (9, 10)), (1, 2.5))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.NSRectArg_andstructTestStruct5Arg_(((7, 8), (9, 10)), (2, 4.5))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], (2, 4.5))

    def teststructTestStruct1AndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), YES)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct1Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), NO)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct1Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct1Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NO)

    def teststructTestStruct1AndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), YES)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct1Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), NO)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct1Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct1Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NO)

    def teststructTestStruct1AndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), -128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 127)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 127)
        r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), -128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 127)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 127)

    def teststructTestStruct1AndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andsignedshortArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 14)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 14)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct1Arg_andsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 14)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 14
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct1AndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -(1 << 30))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct1Arg_andsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 30)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct1AndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andsignedlongArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 30)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct1Arg_andsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 30)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct1AndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 60)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 60
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 60)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 60)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 0
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 60
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 60)

    def teststructTestStruct1AndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 255)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 255)
        r = o.structTestStruct1Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedcharArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 128
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct1Arg_andunsignedcharArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 255
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 255)

    def teststructTestStruct1AndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedshortArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 14
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct1Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 14
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct1AndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct1Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct1AndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct1Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct1AndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 62
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 62)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 0
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct1Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 62
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 62)

    def teststructTestStruct1AndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct1AnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct1AndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andidArg_(
            (1, 2, (1, 2, 3, 4, 5)), NSPriorDayDesignations
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.structTestStruct1Arg_andidArg_(
            (9, 8, (-1, -2, -3, -4, -5)), NSPriorDayDesignations
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def teststructTestStruct1AndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"hello")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"world")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"foobar")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"foobar")
        r = o.structTestStruct1Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"hello"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct1Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"world"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct1Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"foobar"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"foobar")

    def teststructTestStruct1AndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct1Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (3, 4))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (3, 4))
        r = o.structTestStruct1Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct1Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (3, 4))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (3, 4))

    def teststructTestStruct1AndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andNSRectArg_(
            (1, 2, (1, 2, 3, 4, 5)), ((1, 2), (3, 4))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct1Arg_andNSRectArg_(
            (1, 2, (1, 2, 3, 4, 5)), ((7, 8), (9, 10))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.structTestStruct1Arg_andNSRectArg_(
            (9, 8, (-1, -2, -3, -4, -5)), ((1, 2), (3, 4))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct1Arg_andNSRectArg_(
            (9, 8, (-1, -2, -3, -4, -5)), ((7, 8), (9, 10))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct1AndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andstructTestStruct1Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1Arg_andstructTestStruct1Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct1Arg_andstructTestStruct1Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1Arg_andstructTestStruct1Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct1AndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andstructTestStruct2Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1Arg_andstructTestStruct2Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct1Arg_andstructTestStruct2Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1Arg_andstructTestStruct2Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct1AndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andstructTestStruct3Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct1Arg_andstructTestStruct3Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct1Arg_andstructTestStruct3Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct1Arg_andstructTestStruct3Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct1AndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andstructTestStruct4Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 1 << 60)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct1Arg_andstructTestStruct4Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct1Arg_andstructTestStruct4Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 1 << 60)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct1Arg_andstructTestStruct4Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct1AndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1Arg_andstructTestStruct5Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2.5)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct1Arg_andstructTestStruct5Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4.5)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4.5))
        r = o.structTestStruct1Arg_andstructTestStruct5Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2.5)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct1Arg_andstructTestStruct5Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4.5)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4.5))

    def teststructTestStruct2AndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), YES)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct2Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), NO)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct2Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct2Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NO)

    def teststructTestStruct2AndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), YES)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct2Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), NO)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct2Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct2Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NO)

    def teststructTestStruct2AndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), -128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 127)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 127)
        r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), -128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 127)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 127)

    def teststructTestStruct2AndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andsignedshortArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 14)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 14)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct2Arg_andsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 14)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 14
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct2AndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -(1 << 30))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct2Arg_andsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 30)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct2AndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andsignedlongArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 30)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct2Arg_andsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 30)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct2AndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), -(1 << 60)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 60
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 60)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -(1 << 60)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), -42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 0
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 60
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 60)

    def teststructTestStruct2AndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 255)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 255)
        r = o.structTestStruct2Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedcharArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 128
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct2Arg_andunsignedcharArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 255
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 255)

    def teststructTestStruct2AndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedshortArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 14
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct2Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedshortArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 14
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct2AndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct2Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedintArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct2AndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct2Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedlongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 30
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct2AndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_(
            (1, 2, (1, 2, 3, 4, 5)), 1 << 62
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], 1 << 62)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 0
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 42
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct2Arg_andunsignedlonglongArg_(
            (9, 8, (-1, -2, -3, -4, -5)), 1 << 62
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], 1 << 62)

    def teststructTestStruct2AndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct2AnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct2AndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andidArg_(
            (1, 2, (1, 2, 3, 4, 5)), NSPriorDayDesignations
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.structTestStruct2Arg_andidArg_(
            (9, 8, (-1, -2, -3, -4, -5)), NSPriorDayDesignations
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def teststructTestStruct2AndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"hello")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"world")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), b"foobar")
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], b"foobar")
        r = o.structTestStruct2Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"hello"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct2Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"world"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct2Arg_andcharPtrArg_(
            (9, 8, (-1, -2, -3, -4, -5)), b"foobar"
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], b"foobar")

    def teststructTestStruct2AndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct2Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (3, 4))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (3, 4))
        r = o.structTestStruct2Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct2Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (3, 4))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (3, 4))

    def teststructTestStruct2AndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andNSRectArg_(
            (1, 2, (1, 2, 3, 4, 5)), ((1, 2), (3, 4))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct2Arg_andNSRectArg_(
            (1, 2, (1, 2, 3, 4, 5)), ((7, 8), (9, 10))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.structTestStruct2Arg_andNSRectArg_(
            (9, 8, (-1, -2, -3, -4, -5)), ((1, 2), (3, 4))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct2Arg_andNSRectArg_(
            (9, 8, (-1, -2, -3, -4, -5)), ((7, 8), (9, 10))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct2AndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andstructTestStruct1Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2Arg_andstructTestStruct1Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct2Arg_andstructTestStruct1Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2Arg_andstructTestStruct1Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2AndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andstructTestStruct2Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2Arg_andstructTestStruct2Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct2Arg_andstructTestStruct2Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2Arg_andstructTestStruct2Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2AndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andstructTestStruct3Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct2Arg_andstructTestStruct3Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct2Arg_andstructTestStruct3Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct2Arg_andstructTestStruct3Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct2AndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andstructTestStruct4Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 1 << 60)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct2Arg_andstructTestStruct4Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct2Arg_andstructTestStruct4Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 1 << 60)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct2Arg_andstructTestStruct4Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct2AndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2Arg_andstructTestStruct5Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (1, 2.5)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct2Arg_andstructTestStruct5Arg_(
            (1, 2, (1, 2, 3, 4, 5)), (2, 4.5)
        )
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (2, 4.5))
        r = o.structTestStruct2Arg_andstructTestStruct5Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (1, 2.5)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct2Arg_andstructTestStruct5Arg_(
            (9, 8, (-1, -2, -3, -4, -5)), (2, 4.5)
        )
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (2, 4.5))

    def teststructTestStruct3AndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andboolArg_((1, 2), YES)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct3Arg_andboolArg_((1, 2), NO)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct3Arg_andboolArg_((2, 4), YES)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct3Arg_andboolArg_((2, 4), NO)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NO)

    def teststructTestStruct3AndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andBOOLArg_((1, 2), YES)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct3Arg_andBOOLArg_((1, 2), NO)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct3Arg_andBOOLArg_((2, 4), YES)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct3Arg_andBOOLArg_((2, 4), NO)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NO)

    def teststructTestStruct3AndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andcharArg_((1, 2), -128)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct3Arg_andcharArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andcharArg_((1, 2), 127)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 127)
        r = o.structTestStruct3Arg_andcharArg_((2, 4), -128)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct3Arg_andcharArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andcharArg_((2, 4), 127)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 127)

    def teststructTestStruct3AndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), -(1 << 14))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 1 << 14)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), -(1 << 14))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 1 << 14)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct3AndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andsignedintArg_((1, 2), -(1 << 30))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct3Arg_andsignedintArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct3Arg_andsignedintArg_((2, 4), -(1 << 30))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct3Arg_andsignedintArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct3AndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), -(1 << 30))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), -(1 << 30))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct3AndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), -(1 << 60))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), -42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 1 << 60)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 60)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), -(1 << 60))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 1 << 60)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 60)

    def teststructTestStruct3AndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 128)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 255)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 255)
        r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 128)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 255)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 255)

    def teststructTestStruct3AndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 1 << 14)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 1 << 14)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct3AndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct3AndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 1 << 30)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct3AndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 0)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 42)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 1 << 62)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], 1 << 62)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 1 << 62)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 62)

    def teststructTestStruct3AndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andfloatArg_((1, 2), 0.128)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct3Arg_andfloatArg_((1, 2), 1.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct3Arg_andfloatArg_((1, 2), 42.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct3Arg_andfloatArg_((1, 2), 1e10)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct3Arg_andfloatArg_((2, 4), 0.128)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct3Arg_andfloatArg_((2, 4), 1.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct3Arg_andfloatArg_((2, 4), 42.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct3Arg_andfloatArg_((2, 4), 1e10)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct3AnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 0.128)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 1.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 42.0)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 1e10)
        self.assertEqual(r[0], (1, 2))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 0.128)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 1.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 42.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 1e10)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct3AndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andidArg_((1, 2), NSPriorDayDesignations)
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.structTestStruct3Arg_andidArg_((2, 4), NSPriorDayDesignations)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def teststructTestStruct3AndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), b"hello")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), b"world")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), b"foobar")
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], b"foobar")
        r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), b"hello")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), b"world")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), b"foobar")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"foobar")

    def teststructTestStruct3AndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andNSPointArg_((1, 2), (1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct3Arg_andNSPointArg_((1, 2), (3, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (3, 4))
        r = o.structTestStruct3Arg_andNSPointArg_((2, 4), (1, 2))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct3Arg_andNSPointArg_((2, 4), (3, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (3, 4))

    def teststructTestStruct3AndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andNSRectArg_((1, 2), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct3Arg_andNSRectArg_((1, 2), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.structTestStruct3Arg_andNSRectArg_((2, 4), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct3Arg_andNSRectArg_((2, 4), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct3AndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andstructTestStruct1Arg_(
            (1, 2), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct3Arg_andstructTestStruct1Arg_(
            (1, 2), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct3Arg_andstructTestStruct1Arg_(
            (2, 4), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct3Arg_andstructTestStruct1Arg_(
            (2, 4), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3AndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andstructTestStruct2Arg_(
            (1, 2), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct3Arg_andstructTestStruct2Arg_(
            (1, 2), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct3Arg_andstructTestStruct2Arg_(
            (2, 4), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct3Arg_andstructTestStruct2Arg_(
            (2, 4), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3AndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andstructTestStruct3Arg_((1, 2), (1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct3Arg_andstructTestStruct3Arg_((1, 2), (2, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct3Arg_andstructTestStruct3Arg_((2, 4), (1, 2))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct3Arg_andstructTestStruct3Arg_((2, 4), (2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct3AndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andstructTestStruct4Arg_((1, 2), (1, 1 << 60))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct3Arg_andstructTestStruct4Arg_((1, 2), (2, 4))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct3Arg_andstructTestStruct4Arg_((2, 4), (1, 1 << 60))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct3Arg_andstructTestStruct4Arg_((2, 4), (2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct3AndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3Arg_andstructTestStruct5Arg_((1, 2), (1, 2.5))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct3Arg_andstructTestStruct5Arg_((1, 2), (2, 4.5))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4.5))
        r = o.structTestStruct3Arg_andstructTestStruct5Arg_((2, 4), (1, 2.5))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct3Arg_andstructTestStruct5Arg_((2, 4), (2, 4.5))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4.5))

    def teststructTestStruct4AndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andboolArg_((1, 1 << 60), YES)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct4Arg_andboolArg_((1, 1 << 60), NO)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct4Arg_andboolArg_((2, 4), YES)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct4Arg_andboolArg_((2, 4), NO)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NO)

    def teststructTestStruct4AndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andBOOLArg_((1, 1 << 60), YES)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct4Arg_andBOOLArg_((1, 1 << 60), NO)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct4Arg_andBOOLArg_((2, 4), YES)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct4Arg_andBOOLArg_((2, 4), NO)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NO)

    def teststructTestStruct4AndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andcharArg_((1, 1 << 60), -128)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct4Arg_andcharArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andcharArg_((1, 1 << 60), 127)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 127)
        r = o.structTestStruct4Arg_andcharArg_((2, 4), -128)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct4Arg_andcharArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andcharArg_((2, 4), 127)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 127)

    def teststructTestStruct4AndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andsignedshortArg_((1, 1 << 60), -(1 << 14))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct4Arg_andsignedshortArg_((1, 1 << 60), -42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedshortArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedshortArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedshortArg_((1, 1 << 60), 1 << 14)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), -(1 << 14))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 1 << 14)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct4AndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andsignedintArg_((1, 1 << 60), -(1 << 30))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct4Arg_andsignedintArg_((1, 1 << 60), -42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedintArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedintArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedintArg_((1, 1 << 60), 1 << 30)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct4Arg_andsignedintArg_((2, 4), -(1 << 30))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct4Arg_andsignedintArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct4AndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andsignedlongArg_((1, 1 << 60), -(1 << 30))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct4Arg_andsignedlongArg_((1, 1 << 60), -42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedlongArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedlongArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedlongArg_((1, 1 << 60), 1 << 30)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), -(1 << 30))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct4AndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1 << 60), -(1 << 60))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1 << 60), -42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1 << 60), 1 << 60)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 60)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), -(1 << 60))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), -42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 1 << 60)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 60)

    def teststructTestStruct4AndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1 << 60), 128)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1 << 60), 255)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 255)
        r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 128)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 255)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 255)

    def teststructTestStruct4AndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1 << 60), 1 << 14)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 1 << 14)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct4AndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andunsignedintArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedintArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedintArg_((1, 1 << 60), 1 << 30)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct4AndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1 << 60), 1 << 30)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 1 << 30)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct4AndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1 << 60), 0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1 << 60), 42)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1 << 60), 1 << 62)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], 1 << 62)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 0)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 42)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 1 << 62)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], 1 << 62)

    def teststructTestStruct4AndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andfloatArg_((1, 1 << 60), 0.128)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct4Arg_andfloatArg_((1, 1 << 60), 1.0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct4Arg_andfloatArg_((1, 1 << 60), 42.0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct4Arg_andfloatArg_((1, 1 << 60), 1e10)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct4Arg_andfloatArg_((2, 4), 0.128)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct4Arg_andfloatArg_((2, 4), 1.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct4Arg_andfloatArg_((2, 4), 42.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct4Arg_andfloatArg_((2, 4), 1e10)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct4AnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_anddoubleArg_((1, 1 << 60), 0.128)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct4Arg_anddoubleArg_((1, 1 << 60), 1.0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct4Arg_anddoubleArg_((1, 1 << 60), 42.0)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct4Arg_anddoubleArg_((1, 1 << 60), 1e10)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 0.128)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 1.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 42.0)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 1e10)
        self.assertEqual(r[0], (2, 4))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct4AndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andidArg_((1, 1 << 60), NSPriorDayDesignations)
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.structTestStruct4Arg_andidArg_((2, 4), NSPriorDayDesignations)
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def teststructTestStruct4AndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andcharPtrArg_((1, 1 << 60), b"hello")
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct4Arg_andcharPtrArg_((1, 1 << 60), b"world")
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct4Arg_andcharPtrArg_((1, 1 << 60), b"foobar")
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], b"foobar")
        r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), b"hello")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), b"world")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), b"foobar")
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], b"foobar")

    def teststructTestStruct4AndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andNSPointArg_((1, 1 << 60), (1, 2))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct4Arg_andNSPointArg_((1, 1 << 60), (3, 4))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (3, 4))
        r = o.structTestStruct4Arg_andNSPointArg_((2, 4), (1, 2))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct4Arg_andNSPointArg_((2, 4), (3, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (3, 4))

    def teststructTestStruct4AndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andNSRectArg_((1, 1 << 60), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct4Arg_andNSRectArg_((1, 1 << 60), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.structTestStruct4Arg_andNSRectArg_((2, 4), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct4Arg_andNSRectArg_((2, 4), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct4AndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andstructTestStruct1Arg_(
            (1, 1 << 60), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct4Arg_andstructTestStruct1Arg_(
            (1, 1 << 60), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct4Arg_andstructTestStruct1Arg_(
            (2, 4), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct4Arg_andstructTestStruct1Arg_(
            (2, 4), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct4AndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andstructTestStruct2Arg_(
            (1, 1 << 60), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct4Arg_andstructTestStruct2Arg_(
            (1, 1 << 60), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct4Arg_andstructTestStruct2Arg_(
            (2, 4), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct4Arg_andstructTestStruct2Arg_(
            (2, 4), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct4AndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andstructTestStruct3Arg_((1, 1 << 60), (1, 2))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct4Arg_andstructTestStruct3Arg_((1, 1 << 60), (2, 4))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct4Arg_andstructTestStruct3Arg_((2, 4), (1, 2))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct4Arg_andstructTestStruct3Arg_((2, 4), (2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct4AndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andstructTestStruct4Arg_((1, 1 << 60), (1, 1 << 60))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct4Arg_andstructTestStruct4Arg_((1, 1 << 60), (2, 4))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct4Arg_andstructTestStruct4Arg_((2, 4), (1, 1 << 60))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct4Arg_andstructTestStruct4Arg_((2, 4), (2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct4AndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4Arg_andstructTestStruct5Arg_((1, 1 << 60), (1, 2.5))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct4Arg_andstructTestStruct5Arg_((1, 1 << 60), (2, 4.5))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (2, 4.5))
        r = o.structTestStruct4Arg_andstructTestStruct5Arg_((2, 4), (1, 2.5))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct4Arg_andstructTestStruct5Arg_((2, 4), (2, 4.5))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (2, 4.5))

    def teststructTestStruct5AndboolArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andboolArg_((1, 2.5), YES)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct5Arg_andboolArg_((1, 2.5), NO)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct5Arg_andboolArg_((2, 4.5), YES)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct5Arg_andboolArg_((2, 4.5), NO)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], NO)

    def teststructTestStruct5AndBOOLArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andBOOLArg_((1, 2.5), YES)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct5Arg_andBOOLArg_((1, 2.5), NO)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], NO)
        r = o.structTestStruct5Arg_andBOOLArg_((2, 4.5), YES)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], YES)
        r = o.structTestStruct5Arg_andBOOLArg_((2, 4.5), NO)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], NO)

    def teststructTestStruct5AndcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andcharArg_((1, 2.5), -128)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct5Arg_andcharArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andcharArg_((1, 2.5), 127)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 127)
        r = o.structTestStruct5Arg_andcharArg_((2, 4.5), -128)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -128)
        r = o.structTestStruct5Arg_andcharArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andcharArg_((2, 4.5), 127)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 127)

    def teststructTestStruct5AndsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), -(1 << 14))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), -42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 1 << 14)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), -(1 << 14))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -(1 << 14))
        r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), -42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 1 << 14)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct5AndsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), -(1 << 30))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), -42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 1 << 30)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), -(1 << 30))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), -42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 1 << 30)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct5AndsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), -(1 << 30))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), -42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 1 << 30)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), -(1 << 30))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -(1 << 30))
        r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), -42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 1 << 30)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct5AndsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), -(1 << 60))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), -42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 1 << 60)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 60)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), -(1 << 60))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -(1 << 60))
        r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), -42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], -42)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 1 << 60)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 60)

    def teststructTestStruct5AndunsignedcharArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 128)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 255)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 255)
        r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 128)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 128)
        r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 255)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 255)

    def teststructTestStruct5AndunsignedshortArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 1 << 14)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 14)
        r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 1 << 14)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 14)

    def teststructTestStruct5AndunsignedintArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 1 << 30)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 1 << 30)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct5AndunsignedlongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 1 << 30)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 30)
        r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 1 << 30)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 30)

    def teststructTestStruct5AndunsignedlonglongArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 42)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 1 << 62)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], 1 << 62)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 0)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 42)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 42)
        r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 1 << 62)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], 1 << 62)

    def teststructTestStruct5AndfloatArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 0.128)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 1.0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 42.0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 1e10)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 0.128)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 1.0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 42.0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 1e10)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct5AnddoubleArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 0.128)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 1.0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 42.0)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 1e10)
        self.assertEqual(r[0], (1, 2.5))
        self.assertAlmostEqual(r[1], 1e10)
        r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 0.128)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 0.128)
        r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 1.0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 1.0)
        r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 42.0)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 42.0)
        r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 1e10)
        self.assertEqual(r[0], (2, 4.5))
        self.assertAlmostEqual(r[1], 1e10)

    def teststructTestStruct5AndidArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andidArg_((1, 2.5), NSPriorDayDesignations)
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], NSPriorDayDesignations)
        r = o.structTestStruct5Arg_andidArg_((2, 4.5), NSPriorDayDesignations)
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], NSPriorDayDesignations)

    def teststructTestStruct5AndcharPtrArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), b"hello")
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), b"world")
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), b"foobar")
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], b"foobar")
        r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), b"hello")
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], b"hello")
        r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), b"world")
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], b"world")
        r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), b"foobar")
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], b"foobar")

    def teststructTestStruct5AndNSPointArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andNSPointArg_((1, 2.5), (1, 2))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct5Arg_andNSPointArg_((1, 2.5), (3, 4))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (3, 4))
        r = o.structTestStruct5Arg_andNSPointArg_((2, 4.5), (1, 2))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct5Arg_andNSPointArg_((2, 4.5), (3, 4))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (3, 4))

    def teststructTestStruct5AndNSRectArg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andNSRectArg_((1, 2.5), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct5Arg_andNSRectArg_((1, 2.5), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], ((7, 8), (9, 10)))
        r = o.structTestStruct5Arg_andNSRectArg_((2, 4.5), ((1, 2), (3, 4)))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.structTestStruct5Arg_andNSRectArg_((2, 4.5), ((7, 8), (9, 10)))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct5AndstructTestStruct1Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andstructTestStruct1Arg_(
            (1, 2.5), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct5Arg_andstructTestStruct1Arg_(
            (1, 2.5), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct5Arg_andstructTestStruct1Arg_(
            (2, 4.5), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct5Arg_andstructTestStruct1Arg_(
            (2, 4.5), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct5AndstructTestStruct2Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andstructTestStruct2Arg_(
            (1, 2.5), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct5Arg_andstructTestStruct2Arg_(
            (1, 2.5), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))
        r = o.structTestStruct5Arg_andstructTestStruct2Arg_(
            (2, 4.5), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct5Arg_andstructTestStruct2Arg_(
            (2, 4.5), (9, 8, (-1, -2, -3, -4, -5))
        )
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct5AndstructTestStruct3Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andstructTestStruct3Arg_((1, 2.5), (1, 2))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct5Arg_andstructTestStruct3Arg_((1, 2.5), (2, 4))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct5Arg_andstructTestStruct3Arg_((2, 4.5), (1, 2))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct5Arg_andstructTestStruct3Arg_((2, 4.5), (2, 4))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct5AndstructTestStruct4Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andstructTestStruct4Arg_((1, 2.5), (1, 1 << 60))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct5Arg_andstructTestStruct4Arg_((1, 2.5), (2, 4))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (2, 4))
        r = o.structTestStruct5Arg_andstructTestStruct4Arg_((2, 4.5), (1, 1 << 60))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct5Arg_andstructTestStruct4Arg_((2, 4.5), (2, 4))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct5AndstructTestStruct5Arg(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5Arg_andstructTestStruct5Arg_((1, 2.5), (1, 2.5))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct5Arg_andstructTestStruct5Arg_((1, 2.5), (2, 4.5))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (2, 4.5))
        r = o.structTestStruct5Arg_andstructTestStruct5Arg_((2, 4.5), (1, 2.5))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct5Arg_andstructTestStruct5Arg_((2, 4.5), (2, 4.5))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (2, 4.5))

    # Pass by reference arguments (in)

    def testboolIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.boolInArg_(YES)
        self.assertEqual(r, YES)
        r = o.boolInArg_(NO)
        self.assertEqual(r, NO)

    def testBOOLIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.BOOLInArg_(YES)
        self.assertEqual(r, YES)
        r = o.BOOLInArg_(NO)
        self.assertEqual(r, NO)

    def testcharIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charInArg_(-128)
        self.assertEqual(r, -128)
        r = o.charInArg_(0)
        self.assertEqual(r, 0)
        r = o.charInArg_(127)
        self.assertEqual(r, 127)

    def testsignedshortIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedshortInArg_(-(1 << 14))
        self.assertEqual(r, -(1 << 14))
        r = o.signedshortInArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedshortInArg_(0)
        self.assertEqual(r, 0)
        r = o.signedshortInArg_(42)
        self.assertEqual(r, 42)
        r = o.signedshortInArg_(1 << 14)
        self.assertEqual(r, 1 << 14)

    def testsignedintIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedintInArg_(-(1 << 30))
        self.assertEqual(r, -(1 << 30))
        r = o.signedintInArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedintInArg_(0)
        self.assertEqual(r, 0)
        r = o.signedintInArg_(42)
        self.assertEqual(r, 42)
        r = o.signedintInArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testsignedlongIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlongInArg_(-(1 << 30))
        self.assertEqual(r, -(1 << 30))
        r = o.signedlongInArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedlongInArg_(0)
        self.assertEqual(r, 0)
        r = o.signedlongInArg_(42)
        self.assertEqual(r, 42)
        r = o.signedlongInArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testsignedlonglongIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.signedlonglongInArg_(-(1 << 60))
        self.assertEqual(r, -(1 << 60))
        r = o.signedlonglongInArg_(-42)
        self.assertEqual(r, -42)
        r = o.signedlonglongInArg_(0)
        self.assertEqual(r, 0)
        r = o.signedlonglongInArg_(42)
        self.assertEqual(r, 42)
        r = o.signedlonglongInArg_(1 << 60)
        self.assertEqual(r, 1 << 60)

    def testunsignedcharIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedcharInArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedcharInArg_(128)
        self.assertEqual(r, 128)
        r = o.unsignedcharInArg_(255)
        self.assertEqual(r, 255)

    def testunsignedshortIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedshortInArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedshortInArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedshortInArg_(1 << 14)
        self.assertEqual(r, 1 << 14)

    def testunsignedintIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedintInArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedintInArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedintInArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testunsignedlongIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlongInArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedlongInArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedlongInArg_(1 << 30)
        self.assertEqual(r, 1 << 30)

    def testunsignedlonglongIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.unsignedlonglongInArg_(0)
        self.assertEqual(r, 0)
        r = o.unsignedlonglongInArg_(42)
        self.assertEqual(r, 42)
        r = o.unsignedlonglongInArg_(1 << 62)
        self.assertEqual(r, 1 << 62)

    def testfloatIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.floatInArg_(0.128)
        self.assertAlmostEqual(r, 0.128)
        r = o.floatInArg_(1.0)
        self.assertAlmostEqual(r, 1.0)
        r = o.floatInArg_(42.0)
        self.assertAlmostEqual(r, 42.0)
        r = o.floatInArg_(1e10)
        self.assertAlmostEqual(r, 1e10)

    def testdoubleIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.doubleInArg_(0.128)
        self.assertAlmostEqual(r, 0.128)
        r = o.doubleInArg_(1.0)
        self.assertAlmostEqual(r, 1.0)
        r = o.doubleInArg_(42.0)
        self.assertAlmostEqual(r, 42.0)
        r = o.doubleInArg_(1e10)
        self.assertAlmostEqual(r, 1e10)

    def testidIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.idInArg_(NSPriorDayDesignations)
        self.assertEqual(r, NSPriorDayDesignations)

    def testcharPtrIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.charPtrInArg_(b"hello")
        self.assertEqual(r, b"hello")
        r = o.charPtrInArg_(b"world")
        self.assertEqual(r, b"world")
        r = o.charPtrInArg_(b"foobar")
        self.assertEqual(r, b"foobar")

    def testNSPointIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSPointInArg_((1, 2))
        self.assertEqual(r, (1, 2))
        r = o.NSPointInArg_((3, 4))
        self.assertEqual(r, (3, 4))

    def testNSRectIn(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.NSRectInArg_(((1, 2), (3, 4)))
        self.assertEqual(r, ((1, 2), (3, 4)))
        r = o.NSRectInArg_(((7, 8), (9, 10)))
        self.assertEqual(r, ((7, 8), (9, 10)))

    def teststructTestStruct1In(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct1InArg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1InArg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2In(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct2InArg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2InArg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3In(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct3InArg_((1, 2))
        self.assertEqual(r, (1, 2))
        r = o.structTestStruct3InArg_((2, 4))
        self.assertEqual(r, (2, 4))

    def teststructTestStruct4In(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct4InArg_((1, 1 << 60))
        self.assertEqual(r, (1, 1 << 60))
        r = o.structTestStruct4InArg_((2, 4))
        self.assertEqual(r, (2, 4))

    def teststructTestStruct5In(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        r = o.structTestStruct5InArg_((1, 2.5))
        self.assertEqual(r, (1, 2.5))
        r = o.structTestStruct5InArg_((2, 4.5))
        self.assertEqual(r, (2, 4.5))

    # Pass by reference arguments (out)

    if 0:

        def testboolOut(self):
            o = PyObjC_TestClass1.alloc().init()
            self.assertIsNotNone(o)
            o.reset()
            r = o.boolOutArg_(None)
            self.assertEqual(r, YES)
            r = o.boolOutArg_(None)
            self.assertEqual(r, NO)

    def testBOOLOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.BOOLOutArg_(None)
        self.assertEqual(r, YES)
        r = o.BOOLOutArg_(None)
        self.assertEqual(r, NO)

    def testcharOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.charOutArg_(None)
        self.assertEqual(r, -128)
        r = o.charOutArg_(None)
        self.assertEqual(r, 0)
        r = o.charOutArg_(None)
        self.assertEqual(r, 127)

    def testsignedshortOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedshortOutArg_(None)
        self.assertEqual(r, -(1 << 14))
        r = o.signedshortOutArg_(None)
        self.assertEqual(r, -42)
        r = o.signedshortOutArg_(None)
        self.assertEqual(r, 0)
        r = o.signedshortOutArg_(None)
        self.assertEqual(r, 42)
        r = o.signedshortOutArg_(None)
        self.assertEqual(r, 1 << 14)

    def testsignedintOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedintOutArg_(None)
        self.assertEqual(r, -(1 << 30))
        r = o.signedintOutArg_(None)
        self.assertEqual(r, -42)
        r = o.signedintOutArg_(None)
        self.assertEqual(r, 0)
        r = o.signedintOutArg_(None)
        self.assertEqual(r, 42)
        r = o.signedintOutArg_(None)
        self.assertEqual(r, 1 << 30)

    def testsignedlongOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedlongOutArg_(None)
        self.assertEqual(r, -(1 << 30))
        r = o.signedlongOutArg_(None)
        self.assertEqual(r, -42)
        r = o.signedlongOutArg_(None)
        self.assertEqual(r, 0)
        r = o.signedlongOutArg_(None)
        self.assertEqual(r, 42)
        r = o.signedlongOutArg_(None)
        self.assertEqual(r, 1 << 30)

    def testsignedlonglongOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedlonglongOutArg_(None)
        self.assertEqual(r, -(1 << 60))
        r = o.signedlonglongOutArg_(None)
        self.assertEqual(r, -42)
        r = o.signedlonglongOutArg_(None)
        self.assertEqual(r, 0)
        r = o.signedlonglongOutArg_(None)
        self.assertEqual(r, 42)
        r = o.signedlonglongOutArg_(None)
        self.assertEqual(r, 1 << 60)

    def testunsignedcharOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedcharOutArg_(None)
        self.assertEqual(r, 0)
        r = o.unsignedcharOutArg_(None)
        self.assertEqual(r, 128)
        r = o.unsignedcharOutArg_(None)
        self.assertEqual(r, 255)

    def testunsignedshortOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedshortOutArg_(None)
        self.assertEqual(r, 0)
        r = o.unsignedshortOutArg_(None)
        self.assertEqual(r, 42)
        r = o.unsignedshortOutArg_(None)
        self.assertEqual(r, 1 << 14)

    def testunsignedintOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedintOutArg_(None)
        self.assertEqual(r, 0)
        r = o.unsignedintOutArg_(None)
        self.assertEqual(r, 42)
        r = o.unsignedintOutArg_(None)
        self.assertEqual(r, 1 << 30)

    def testunsignedlongOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedlongOutArg_(None)
        self.assertEqual(r, 0)
        r = o.unsignedlongOutArg_(None)
        self.assertEqual(r, 42)
        r = o.unsignedlongOutArg_(None)
        self.assertEqual(r, 1 << 30)

    def testunsignedlonglongOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedlonglongOutArg_(None)
        self.assertEqual(r, 0)
        r = o.unsignedlonglongOutArg_(None)
        self.assertEqual(r, 42)
        r = o.unsignedlonglongOutArg_(None)
        self.assertEqual(r, 1 << 62)

    def testfloatOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.floatOutArg_(None)
        self.assertAlmostEqual(r, 0.128)
        r = o.floatOutArg_(None)
        self.assertAlmostEqual(r, 1.0)
        r = o.floatOutArg_(None)
        self.assertAlmostEqual(r, 42.0)
        r = o.floatOutArg_(None)
        self.assertAlmostEqual(r, 1e10)

    def testdoubleOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.doubleOutArg_(None)
        self.assertAlmostEqual(r, 0.128)
        r = o.doubleOutArg_(None)
        self.assertAlmostEqual(r, 1.0)
        r = o.doubleOutArg_(None)
        self.assertAlmostEqual(r, 42.0)
        r = o.doubleOutArg_(None)
        self.assertAlmostEqual(r, 1e10)

    def testidOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.idOutArg_(None)
        self.assertEqual(r, NSPriorDayDesignations)

    def testcharPtrOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.charPtrOutArg_(None)
        self.assertEqual(r, b"hello")
        r = o.charPtrOutArg_(None)
        self.assertEqual(r, b"world")
        r = o.charPtrOutArg_(None)
        self.assertEqual(r, b"foobar")

    def testNSPointOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.NSPointOutArg_(None)
        self.assertEqual(r, (1, 2))
        r = o.NSPointOutArg_(None)
        self.assertEqual(r, (3, 4))

    def testNSRectOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.NSRectOutArg_(None)
        self.assertEqual(r, ((1, 2), (3, 4)))
        r = o.NSRectOutArg_(None)
        self.assertEqual(r, ((7, 8), (9, 10)))

    def teststructTestStruct1Out(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct1OutArg_(None)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1OutArg_(None)
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2Out(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct2OutArg_(None)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2OutArg_(None)
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3Out(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct3OutArg_(None)
        self.assertEqual(r, (1, 2))
        r = o.structTestStruct3OutArg_(None)
        self.assertEqual(r, (2, 4))

    def teststructTestStruct4Out(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct4OutArg_(None)
        self.assertEqual(r, (1, 1 << 60))
        r = o.structTestStruct4OutArg_(None)
        self.assertEqual(r, (2, 4))

    def teststructTestStruct5Out(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct5OutArg_(None)
        self.assertEqual(r, (1, 2.5))
        r = o.structTestStruct5OutArg_(None)
        self.assertEqual(r, (2, 4.5))

    # Pass by reference arguments (inout)

    if 0:

        def testboolInOut(self):
            o = PyObjC_TestClass1.alloc().init()
            self.assertIsNotNone(o)
            o.reset()
            r = o.boolInOutArg_(NO)
            self.assertEqual(r[0], NO)
            self.assertEqual(r[1], YES)
            r = o.boolInOutArg_(YES)
            self.assertEqual(r[0], YES)
            self.assertEqual(r[1], NO)

    def testBOOLInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.BOOLInOutArg_(NO)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = o.BOOLInOutArg_(YES)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)

    def testcharInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.charInOutArg_(127)
        self.assertEqual(r[0], 127)
        self.assertEqual(r[1], -128)
        r = o.charInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.charInOutArg_(-128)
        self.assertEqual(r[0], -128)
        self.assertEqual(r[1], 127)

    def testsignedshortInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedshortInOutArg_(1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], -(1 << 14))
        r = o.signedshortInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedshortInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedshortInOutArg_(-42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedshortInOutArg_(-(1 << 14))
        self.assertEqual(r[0], -(1 << 14))
        self.assertEqual(r[1], 1 << 14)

    def testsignedintInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedintInOutArg_(1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedintInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedintInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedintInOutArg_(-42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedintInOutArg_(-(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)

    def testsignedlongInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedlongInOutArg_(1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], -(1 << 30))
        r = o.signedlongInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlongInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlongInOutArg_(-42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlongInOutArg_(-(1 << 30))
        self.assertEqual(r[0], -(1 << 30))
        self.assertEqual(r[1], 1 << 30)

    def testsignedlonglongInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.signedlonglongInOutArg_(1 << 60)
        self.assertEqual(r[0], 1 << 60)
        self.assertEqual(r[1], -(1 << 60))
        r = o.signedlonglongInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], -42)
        r = o.signedlonglongInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 0)
        r = o.signedlonglongInOutArg_(-42)
        self.assertEqual(r[0], -42)
        self.assertEqual(r[1], 42)
        r = o.signedlonglongInOutArg_(-(1 << 60))
        self.assertEqual(r[0], -(1 << 60))
        self.assertEqual(r[1], 1 << 60)

    def testunsignedcharInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedcharInOutArg_(255)
        self.assertEqual(r[0], 255)
        self.assertEqual(r[1], 0)
        r = o.unsignedcharInOutArg_(128)
        self.assertEqual(r[0], 128)
        self.assertEqual(r[1], 128)
        r = o.unsignedcharInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 255)

    def testunsignedshortInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedshortInOutArg_(1 << 14)
        self.assertEqual(r[0], 1 << 14)
        self.assertEqual(r[1], 0)
        r = o.unsignedshortInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedshortInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 14)

    def testunsignedintInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedintInOutArg_(1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedintInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedintInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlongInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedlongInOutArg_(1 << 30)
        self.assertEqual(r[0], 1 << 30)
        self.assertEqual(r[1], 0)
        r = o.unsignedlongInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlongInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 30)

    def testunsignedlonglongInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.unsignedlonglongInOutArg_(1 << 62)
        self.assertEqual(r[0], 1 << 62)
        self.assertEqual(r[1], 0)
        r = o.unsignedlonglongInOutArg_(42)
        self.assertEqual(r[0], 42)
        self.assertEqual(r[1], 42)
        r = o.unsignedlonglongInOutArg_(0)
        self.assertEqual(r[0], 0)
        self.assertEqual(r[1], 1 << 62)

    def testfloatInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.floatInOutArg_(1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.floatInOutArg_(42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.floatInOutArg_(1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.floatInOutArg_(0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)

    def testdoubleInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.doubleInOutArg_(1e10)
        self.assertAlmostEqual(r[0], 1e10)
        self.assertAlmostEqual(r[1], 0.128)
        r = o.doubleInOutArg_(42.0)
        self.assertAlmostEqual(r[0], 42.0)
        self.assertAlmostEqual(r[1], 1.0)
        r = o.doubleInOutArg_(1.0)
        self.assertAlmostEqual(r[0], 1.0)
        self.assertAlmostEqual(r[1], 42.0)
        r = o.doubleInOutArg_(0.128)
        self.assertAlmostEqual(r[0], 0.128)
        self.assertAlmostEqual(r[1], 1e10)

    def testidInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.idInOutArg_(NSPriorDayDesignations)
        self.assertEqual(r[0], NSPriorDayDesignations)
        self.assertEqual(r[1], NSPriorDayDesignations)

    def testcharPtrInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.charPtrInOutArg_(b"foobar")
        self.assertEqual(r[0], b"foobar")
        self.assertEqual(r[1], b"hello")
        r = o.charPtrInOutArg_(b"world")
        self.assertEqual(r[0], b"world")
        self.assertEqual(r[1], b"world")
        r = o.charPtrInOutArg_(b"hello")
        self.assertEqual(r[0], b"hello")
        self.assertEqual(r[1], b"foobar")

    def testNSPointInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.NSPointInOutArg_((3, 4))
        self.assertEqual(r[0], (3, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.NSPointInOutArg_((1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (3, 4))

    def testNSRectInOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.NSRectInOutArg_(((7, 8), (9, 10)))
        self.assertEqual(r[0], ((7, 8), (9, 10)))
        self.assertEqual(r[1], ((1, 2), (3, 4)))
        r = o.NSRectInOutArg_(((1, 2), (3, 4)))
        self.assertEqual(r[0], ((1, 2), (3, 4)))
        self.assertEqual(r[1], ((7, 8), (9, 10)))

    def teststructTestStruct1InOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct1InOutArg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct1InOutArg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct2InOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct2InOutArg_((9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[0], (9, 8, (-1, -2, -3, -4, -5)))
        self.assertEqual(r[1], (1, 2, (1, 2, 3, 4, 5)))
        r = o.structTestStruct2InOutArg_((1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[0], (1, 2, (1, 2, 3, 4, 5)))
        self.assertEqual(r[1], (9, 8, (-1, -2, -3, -4, -5)))

    def teststructTestStruct3InOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct3InOutArg_((2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 2))
        r = o.structTestStruct3InOutArg_((1, 2))
        self.assertEqual(r[0], (1, 2))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct4InOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct4InOutArg_((2, 4))
        self.assertEqual(r[0], (2, 4))
        self.assertEqual(r[1], (1, 1 << 60))
        r = o.structTestStruct4InOutArg_((1, 1 << 60))
        self.assertEqual(r[0], (1, 1 << 60))
        self.assertEqual(r[1], (2, 4))

    def teststructTestStruct5InOut(self):
        o = PyObjC_TestClass1.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        r = o.structTestStruct5InOutArg_((2, 4.5))
        self.assertEqual(r[0], (2, 4.5))
        self.assertEqual(r[1], (1, 2.5))
        r = o.structTestStruct5InOutArg_((1, 2.5))
        self.assertEqual(r[0], (1, 2.5))
        self.assertEqual(r[1], (2, 4.5))


# Helper arrays
g_bool_values = (YES, NO)
g_BOOL_values = (YES, NO)
g_char_values = (-128, 0, 127)
g_signedshort_values = (-(1 << 14), -42, 0, 42, 1 << 14)
g_signedint_values = (-(1 << 30), -42, 0, 42, 1 << 30)
g_signedlong_values = (-(1 << 30), -42, 0, 42, 1 << 30)
g_signedlonglong_values = (-(1 << 60), -42, 0, 42, 1 << 60)
g_unsignedchar_values = (0, 128, 255)
g_unsignedshort_values = (0, 42, 1 << 14)
g_unsignedint_values = (0, 42, 1 << 30)
g_unsignedlong_values = (0, 42, 1 << 30)
g_unsignedlonglong_values = (0, 42, 1 << 62)
g_float_values = (0.128, 1.0, 42.0, 1e10)
g_double_values = (0.128, 1.0, 42.0, 1e10)
g_id_values = (NSPriorDayDesignations,)
g_charPtr_values = (b"hello", b"world", b"foobar")
g_NSPoint_values = ((1, 2), (3, 4))
g_NSRect_values = (((1, 2), (3, 4)), ((7, 8), (9, 10)))
g_structTestStruct1_values = ((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
g_structTestStruct2_values = ((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
g_structTestStruct3_values = ((1, 2), (2, 4))
g_structTestStruct4_values = ((1, 1 << 60), (2, 4))
g_structTestStruct5_values = ((1, 2.5), (2, 4.5))


class Python_TestClass(objc.lookUpClass("NSObject")):
    def init(self):
        self = objc.super(Python_TestClass, self).init()
        self.reset()
        return self

    def reset(self):
        self.counter = 0

    def boolMethod(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_bool_values[idx]

    boolMethod = objc.selector(boolMethod, signature=b"B@:")

    def BOOLMethod(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_BOOL_values[idx]

    BOOLMethod = objc.selector(BOOLMethod, signature=b"c@:")

    def charMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_char_values[idx]

    charMethod = objc.selector(charMethod, signature=b"c@:")

    def signedshortMethod(self):
        if self.counter > 5:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_signedshort_values[idx]

    signedshortMethod = objc.selector(signedshortMethod, signature=b"s@:")

    def signedintMethod(self):
        if self.counter > 5:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_signedint_values[idx]

    signedintMethod = objc.selector(signedintMethod, signature=b"i@:")

    def signedlongMethod(self):
        if self.counter > 5:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_signedlong_values[idx]

    signedlongMethod = objc.selector(signedlongMethod, signature=b"" + long_tp + b"@:")

    def signedlonglongMethod(self):
        if self.counter > 5:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_signedlonglong_values[idx]

    signedlonglongMethod = objc.selector(signedlonglongMethod, signature=b"q@:")

    def unsignedcharMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_unsignedchar_values[idx]

    unsignedcharMethod = objc.selector(unsignedcharMethod, signature=b"C@:")

    def unsignedshortMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_unsignedshort_values[idx]

    unsignedshortMethod = objc.selector(unsignedshortMethod, signature=b"S@:")

    def unsignedintMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_unsignedint_values[idx]

    unsignedintMethod = objc.selector(unsignedintMethod, signature=b"I@:")

    def unsignedlongMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_unsignedlong_values[idx]

    unsignedlongMethod = objc.selector(
        unsignedlongMethod, signature=b"" + ulong_tp + b"@:"
    )

    def unsignedlonglongMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_unsignedlonglong_values[idx]

    unsignedlonglongMethod = objc.selector(unsignedlonglongMethod, signature=b"Q@:")

    def floatMethod(self):
        if self.counter > 4:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_float_values[idx]

    floatMethod = objc.selector(floatMethod, signature=b"f@:")

    def doubleMethod(self):
        if self.counter > 4:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_double_values[idx]

    doubleMethod = objc.selector(doubleMethod, signature=b"d@:")

    def idMethod(self):
        if self.counter > 1:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_id_values[idx]

    idMethod = objc.selector(idMethod, signature=b"@@:")

    def charPtrMethod(self):
        if self.counter > 3:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_charPtr_values[idx]

    charPtrMethod = objc.selector(charPtrMethod, signature=b"*@:")

    def NSPointMethod(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_NSPoint_values[idx]

    NSPointMethod = objc.selector(NSPointMethod, signature=NSPoint_tp + b"@:")

    def NSRectMethod(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_NSRect_values[idx]

    NSRectMethod = objc.selector(NSRectMethod, signature=NSRect_tp + b"@:")

    def structTestStruct1Method(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_structTestStruct1_values[idx]

    structTestStruct1Method = objc.selector(
        structTestStruct1Method, signature=b"{_TestStruct1=ii[5s]}@:"
    )

    def structTestStruct2Method(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_structTestStruct2_values[idx]

    structTestStruct2Method = objc.selector(
        structTestStruct2Method, signature=b"{_TestStruct2=id[5s]}@:"
    )

    def structTestStruct3Method(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_structTestStruct3_values[idx]

    structTestStruct3Method = objc.selector(
        structTestStruct3Method, signature=b"{_TestStruct3=ci}@:"
    )

    def structTestStruct4Method(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_structTestStruct4_values[idx]

    structTestStruct4Method = objc.selector(
        structTestStruct4Method, signature=b"{_TestStruct4=cq}@:"
    )

    def structTestStruct5Method(self):
        if self.counter > 2:
            self.reset()
        idx = self.counter
        self.counter += 1
        return g_structTestStruct5_values[idx]

    structTestStruct5Method = objc.selector(
        structTestStruct5Method, signature=b"{_TestStruct5=cd}@:"
    )

    def boolArg_(self, arg):
        return arg  # return the same

    boolArg_ = objc.selector(boolArg_, signature=b"@@:B")

    def BOOLArg_(self, arg):
        return arg  # return the same

    BOOLArg_ = objc.selector(BOOLArg_, signature=b"@@:c")

    def charArg_(self, arg):
        return arg  # return the same

    charArg_ = objc.selector(charArg_, signature=b"@@:c")

    def signedshortArg_(self, arg):
        return arg  # return the same

    signedshortArg_ = objc.selector(signedshortArg_, signature=b"@@:s")

    def signedintArg_(self, arg):
        return arg  # return the same

    signedintArg_ = objc.selector(signedintArg_, signature=b"@@:i")

    def signedlongArg_(self, arg):
        return arg  # return the same

    signedlongArg_ = objc.selector(signedlongArg_, signature=b"@@:" + long_tp)

    def signedlonglongArg_(self, arg):
        return arg  # return the same

    signedlonglongArg_ = objc.selector(signedlonglongArg_, signature=b"@@:q")

    def unsignedcharArg_(self, arg):
        return arg  # return the same

    unsignedcharArg_ = objc.selector(unsignedcharArg_, signature=b"@@:C")

    def unsignedshortArg_(self, arg):
        return arg  # return the same

    unsignedshortArg_ = objc.selector(unsignedshortArg_, signature=b"@@:S")

    def unsignedintArg_(self, arg):
        return arg  # return the same

    unsignedintArg_ = objc.selector(unsignedintArg_, signature=b"@@:I")

    def unsignedlongArg_(self, arg):
        return arg  # return the same

    unsignedlongArg_ = objc.selector(unsignedlongArg_, signature=b"@@:" + ulong_tp)

    def unsignedlonglongArg_(self, arg):
        return arg  # return the same

    unsignedlonglongArg_ = objc.selector(unsignedlonglongArg_, signature=b"@@:Q")

    def floatArg_(self, arg):
        return arg  # return the same

    floatArg_ = objc.selector(floatArg_, signature=b"@@:f")

    def doubleArg_(self, arg):
        return arg  # return the same

    doubleArg_ = objc.selector(doubleArg_, signature=b"@@:d")

    def idArg_(self, arg):
        return arg  # return the same

    idArg_ = objc.selector(idArg_, signature=b"@@:@")

    def charPtrArg_(self, arg):
        return str(arg)  # return the value as str

    charPtrArg_ = objc.selector(charPtrArg_, signature=b"@@:*")

    def NSPointArg_(self, arg):
        return arg  # return the same

    NSPointArg_ = objc.selector(NSPointArg_, signature=b"@@:" + NSPoint_tp)

    def NSRectArg_(self, arg):
        return arg  # return the same

    NSRectArg_ = objc.selector(NSRectArg_, signature=b"@@:" + NSRect_tp)

    def structTestStruct1Arg_(self, arg):
        return arg  # return the same

    structTestStruct1Arg_ = objc.selector(
        structTestStruct1Arg_, signature=b"@@:{_TestStruct1=ii[5s]}"
    )

    def structTestStruct2Arg_(self, arg):
        return arg  # return the same

    structTestStruct2Arg_ = objc.selector(
        structTestStruct2Arg_, signature=b"@@:{_TestStruct2=id[5s]}"
    )

    def structTestStruct3Arg_(self, arg):
        return arg  # return the same

    structTestStruct3Arg_ = objc.selector(
        structTestStruct3Arg_, signature=b"@@:{_TestStruct3=ci}"
    )

    def structTestStruct4Arg_(self, arg):
        return arg  # return the same

    structTestStruct4Arg_ = objc.selector(
        structTestStruct4Arg_, signature=b"@@:{_TestStruct4=cq}"
    )

    def structTestStruct5Arg_(self, arg):
        return arg  # return the same

    structTestStruct5Arg_ = objc.selector(
        structTestStruct5Arg_, signature=b"@@:{_TestStruct5=cd}"
    )

    def boolArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andboolArg_ = objc.selector(boolArg_andboolArg_, signature=b"@@:BB")

    def boolArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andBOOLArg_ = objc.selector(boolArg_andBOOLArg_, signature=b"@@:Bc")

    def boolArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andcharArg_ = objc.selector(boolArg_andcharArg_, signature=b"@@:Bc")

    def boolArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andsignedshortArg_ = objc.selector(
        boolArg_andsignedshortArg_, signature=b"@@:Bs"
    )

    def boolArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andsignedintArg_ = objc.selector(
        boolArg_andsignedintArg_, signature=b"@@:Bi"
    )

    def boolArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andsignedlongArg_ = objc.selector(
        boolArg_andsignedlongArg_, signature=b"@@:B" + long_tp
    )

    def boolArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andsignedlonglongArg_ = objc.selector(
        boolArg_andsignedlonglongArg_, signature=b"@@:Bq"
    )

    def boolArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andunsignedcharArg_ = objc.selector(
        boolArg_andunsignedcharArg_, signature=b"@@:BC"
    )

    def boolArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andunsignedshortArg_ = objc.selector(
        boolArg_andunsignedshortArg_, signature=b"@@:BS"
    )

    def boolArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andunsignedintArg_ = objc.selector(
        boolArg_andunsignedintArg_, signature=b"@@:BI"
    )

    def boolArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andunsignedlongArg_ = objc.selector(
        boolArg_andunsignedlongArg_, signature=b"@@:B" + ulong_tp
    )

    def boolArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andunsignedlonglongArg_ = objc.selector(
        boolArg_andunsignedlonglongArg_, signature=b"@@:BQ"
    )

    def boolArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andfloatArg_ = objc.selector(boolArg_andfloatArg_, signature=b"@@:Bf")

    def boolArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_anddoubleArg_ = objc.selector(boolArg_anddoubleArg_, signature=b"@@:Bd")

    def boolArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andidArg_ = objc.selector(boolArg_andidArg_, signature=b"@@:B@")

    def boolArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    boolArg_andcharPtrArg_ = objc.selector(boolArg_andcharPtrArg_, signature=b"@@:B*")

    def boolArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andNSPointArg_ = objc.selector(
        boolArg_andNSPointArg_, signature=b"@@:B" + NSPoint_tp
    )

    def boolArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andNSRectArg_ = objc.selector(
        boolArg_andNSRectArg_, signature=b"@@:B" + NSRect_tp
    )

    def boolArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andstructTestStruct1Arg_ = objc.selector(
        boolArg_andstructTestStruct1Arg_, signature=b"@@:B{_TestStruct1=ii[5s]}"
    )

    def boolArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andstructTestStruct2Arg_ = objc.selector(
        boolArg_andstructTestStruct2Arg_, signature=b"@@:B{_TestStruct2=id[5s]}"
    )

    def boolArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andstructTestStruct3Arg_ = objc.selector(
        boolArg_andstructTestStruct3Arg_, signature=b"@@:B{_TestStruct3=ci}"
    )

    def boolArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andstructTestStruct4Arg_ = objc.selector(
        boolArg_andstructTestStruct4Arg_, signature=b"@@:B{_TestStruct4=cq}"
    )

    def boolArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    boolArg_andstructTestStruct5Arg_ = objc.selector(
        boolArg_andstructTestStruct5Arg_, signature=b"@@:B{_TestStruct5=cd}"
    )

    def BOOLArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andboolArg_ = objc.selector(BOOLArg_andboolArg_, signature=b"@@:cB")

    def BOOLArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andBOOLArg_ = objc.selector(BOOLArg_andBOOLArg_, signature=b"@@:cc")

    def BOOLArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andcharArg_ = objc.selector(BOOLArg_andcharArg_, signature=b"@@:cc")

    def BOOLArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andsignedshortArg_ = objc.selector(
        BOOLArg_andsignedshortArg_, signature=b"@@:cs"
    )

    def BOOLArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andsignedintArg_ = objc.selector(
        BOOLArg_andsignedintArg_, signature=b"@@:ci"
    )

    def BOOLArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andsignedlongArg_ = objc.selector(
        BOOLArg_andsignedlongArg_, signature=b"@@:c" + long_tp
    )

    def BOOLArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andsignedlonglongArg_ = objc.selector(
        BOOLArg_andsignedlonglongArg_, signature=b"@@:cq"
    )

    def BOOLArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andunsignedcharArg_ = objc.selector(
        BOOLArg_andunsignedcharArg_, signature=b"@@:cC"
    )

    def BOOLArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andunsignedshortArg_ = objc.selector(
        BOOLArg_andunsignedshortArg_, signature=b"@@:cS"
    )

    def BOOLArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andunsignedintArg_ = objc.selector(
        BOOLArg_andunsignedintArg_, signature=b"@@:cI"
    )

    def BOOLArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andunsignedlongArg_ = objc.selector(
        BOOLArg_andunsignedlongArg_, signature=b"@@:c" + ulong_tp
    )

    def BOOLArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andunsignedlonglongArg_ = objc.selector(
        BOOLArg_andunsignedlonglongArg_, signature=b"@@:cQ"
    )

    def BOOLArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andfloatArg_ = objc.selector(BOOLArg_andfloatArg_, signature=b"@@:cf")

    def BOOLArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_anddoubleArg_ = objc.selector(BOOLArg_anddoubleArg_, signature=b"@@:cd")

    def BOOLArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andidArg_ = objc.selector(BOOLArg_andidArg_, signature=b"@@:c@")

    def BOOLArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    BOOLArg_andcharPtrArg_ = objc.selector(BOOLArg_andcharPtrArg_, signature=b"@@:c*")

    def BOOLArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andNSPointArg_ = objc.selector(
        BOOLArg_andNSPointArg_, signature=b"@@:c" + NSPoint_tp
    )

    def BOOLArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andNSRectArg_ = objc.selector(
        BOOLArg_andNSRectArg_, signature=b"@@:c" + NSRect_tp
    )

    def BOOLArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andstructTestStruct1Arg_ = objc.selector(
        BOOLArg_andstructTestStruct1Arg_, signature=b"@@:c{_TestStruct1=ii[5s]}"
    )

    def BOOLArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andstructTestStruct2Arg_ = objc.selector(
        BOOLArg_andstructTestStruct2Arg_, signature=b"@@:c{_TestStruct2=id[5s]}"
    )

    def BOOLArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andstructTestStruct3Arg_ = objc.selector(
        BOOLArg_andstructTestStruct3Arg_, signature=b"@@:c{_TestStruct3=ci}"
    )

    def BOOLArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andstructTestStruct4Arg_ = objc.selector(
        BOOLArg_andstructTestStruct4Arg_, signature=b"@@:c{_TestStruct4=cq}"
    )

    def BOOLArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    BOOLArg_andstructTestStruct5Arg_ = objc.selector(
        BOOLArg_andstructTestStruct5Arg_, signature=b"@@:c{_TestStruct5=cd}"
    )

    def charArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andboolArg_ = objc.selector(charArg_andboolArg_, signature=b"@@:cB")

    def charArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andBOOLArg_ = objc.selector(charArg_andBOOLArg_, signature=b"@@:cc")

    def charArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andcharArg_ = objc.selector(charArg_andcharArg_, signature=b"@@:cc")

    def charArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andsignedshortArg_ = objc.selector(
        charArg_andsignedshortArg_, signature=b"@@:cs"
    )

    def charArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andsignedintArg_ = objc.selector(
        charArg_andsignedintArg_, signature=b"@@:ci"
    )

    def charArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andsignedlongArg_ = objc.selector(
        charArg_andsignedlongArg_, signature=b"@@:c" + long_tp
    )

    def charArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andsignedlonglongArg_ = objc.selector(
        charArg_andsignedlonglongArg_, signature=b"@@:cq"
    )

    def charArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andunsignedcharArg_ = objc.selector(
        charArg_andunsignedcharArg_, signature=b"@@:cC"
    )

    def charArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andunsignedshortArg_ = objc.selector(
        charArg_andunsignedshortArg_, signature=b"@@:cS"
    )

    def charArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andunsignedintArg_ = objc.selector(
        charArg_andunsignedintArg_, signature=b"@@:cI"
    )

    def charArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andunsignedlongArg_ = objc.selector(
        charArg_andunsignedlongArg_, signature=b"@@:c" + ulong_tp
    )

    def charArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andunsignedlonglongArg_ = objc.selector(
        charArg_andunsignedlonglongArg_, signature=b"@@:cQ"
    )

    def charArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andfloatArg_ = objc.selector(charArg_andfloatArg_, signature=b"@@:cf")

    def charArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_anddoubleArg_ = objc.selector(charArg_anddoubleArg_, signature=b"@@:cd")

    def charArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andidArg_ = objc.selector(charArg_andidArg_, signature=b"@@:c@")

    def charArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    charArg_andcharPtrArg_ = objc.selector(charArg_andcharPtrArg_, signature=b"@@:c*")

    def charArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andNSPointArg_ = objc.selector(
        charArg_andNSPointArg_, signature=b"@@:c" + NSPoint_tp
    )

    def charArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andNSRectArg_ = objc.selector(
        charArg_andNSRectArg_, signature=b"@@:c" + NSRect_tp
    )

    def charArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andstructTestStruct1Arg_ = objc.selector(
        charArg_andstructTestStruct1Arg_, signature=b"@@:c{_TestStruct1=ii[5s]}"
    )

    def charArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andstructTestStruct2Arg_ = objc.selector(
        charArg_andstructTestStruct2Arg_, signature=b"@@:c{_TestStruct2=id[5s]}"
    )

    def charArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andstructTestStruct3Arg_ = objc.selector(
        charArg_andstructTestStruct3Arg_, signature=b"@@:c{_TestStruct3=ci}"
    )

    def charArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andstructTestStruct4Arg_ = objc.selector(
        charArg_andstructTestStruct4Arg_, signature=b"@@:c{_TestStruct4=cq}"
    )

    def charArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    charArg_andstructTestStruct5Arg_ = objc.selector(
        charArg_andstructTestStruct5Arg_, signature=b"@@:c{_TestStruct5=cd}"
    )

    def signedshortArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andboolArg_ = objc.selector(
        signedshortArg_andboolArg_, signature=b"@@:sB"
    )

    def signedshortArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andBOOLArg_ = objc.selector(
        signedshortArg_andBOOLArg_, signature=b"@@:sc"
    )

    def signedshortArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andcharArg_ = objc.selector(
        signedshortArg_andcharArg_, signature=b"@@:sc"
    )

    def signedshortArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andsignedshortArg_ = objc.selector(
        signedshortArg_andsignedshortArg_, signature=b"@@:ss"
    )

    def signedshortArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andsignedintArg_ = objc.selector(
        signedshortArg_andsignedintArg_, signature=b"@@:si"
    )

    def signedshortArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andsignedlongArg_ = objc.selector(
        signedshortArg_andsignedlongArg_, signature=b"@@:s" + long_tp
    )

    def signedshortArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andsignedlonglongArg_ = objc.selector(
        signedshortArg_andsignedlonglongArg_, signature=b"@@:sq"
    )

    def signedshortArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andunsignedcharArg_ = objc.selector(
        signedshortArg_andunsignedcharArg_, signature=b"@@:sC"
    )

    def signedshortArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andunsignedshortArg_ = objc.selector(
        signedshortArg_andunsignedshortArg_, signature=b"@@:sS"
    )

    def signedshortArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andunsignedintArg_ = objc.selector(
        signedshortArg_andunsignedintArg_, signature=b"@@:sI"
    )

    def signedshortArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andunsignedlongArg_ = objc.selector(
        signedshortArg_andunsignedlongArg_, signature=b"@@:s" + ulong_tp
    )

    def signedshortArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andunsignedlonglongArg_ = objc.selector(
        signedshortArg_andunsignedlonglongArg_, signature=b"@@:sQ"
    )

    def signedshortArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andfloatArg_ = objc.selector(
        signedshortArg_andfloatArg_, signature=b"@@:sf"
    )

    def signedshortArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_anddoubleArg_ = objc.selector(
        signedshortArg_anddoubleArg_, signature=b"@@:sd"
    )

    def signedshortArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andidArg_ = objc.selector(
        signedshortArg_andidArg_, signature=b"@@:s@"
    )

    def signedshortArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    signedshortArg_andcharPtrArg_ = objc.selector(
        signedshortArg_andcharPtrArg_, signature=b"@@:s*"
    )

    def signedshortArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andNSPointArg_ = objc.selector(
        signedshortArg_andNSPointArg_, signature=b"@@:s" + NSPoint_tp
    )

    def signedshortArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andNSRectArg_ = objc.selector(
        signedshortArg_andNSRectArg_, signature=b"@@:s" + NSRect_tp
    )

    def signedshortArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andstructTestStruct1Arg_ = objc.selector(
        signedshortArg_andstructTestStruct1Arg_, signature=b"@@:s{_TestStruct1=ii[5s]}"
    )

    def signedshortArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andstructTestStruct2Arg_ = objc.selector(
        signedshortArg_andstructTestStruct2Arg_, signature=b"@@:s{_TestStruct2=id[5s]}"
    )

    def signedshortArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andstructTestStruct3Arg_ = objc.selector(
        signedshortArg_andstructTestStruct3Arg_, signature=b"@@:s{_TestStruct3=ci}"
    )

    def signedshortArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andstructTestStruct4Arg_ = objc.selector(
        signedshortArg_andstructTestStruct4Arg_, signature=b"@@:s{_TestStruct4=cq}"
    )

    def signedshortArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedshortArg_andstructTestStruct5Arg_ = objc.selector(
        signedshortArg_andstructTestStruct5Arg_, signature=b"@@:s{_TestStruct5=cd}"
    )

    def signedintArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andboolArg_ = objc.selector(
        signedintArg_andboolArg_, signature=b"@@:iB"
    )

    def signedintArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andBOOLArg_ = objc.selector(
        signedintArg_andBOOLArg_, signature=b"@@:ic"
    )

    def signedintArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andcharArg_ = objc.selector(
        signedintArg_andcharArg_, signature=b"@@:ic"
    )

    def signedintArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andsignedshortArg_ = objc.selector(
        signedintArg_andsignedshortArg_, signature=b"@@:is"
    )

    def signedintArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andsignedintArg_ = objc.selector(
        signedintArg_andsignedintArg_, signature=b"@@:ii"
    )

    def signedintArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andsignedlongArg_ = objc.selector(
        signedintArg_andsignedlongArg_, signature=b"@@:i" + long_tp
    )

    def signedintArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andsignedlonglongArg_ = objc.selector(
        signedintArg_andsignedlonglongArg_, signature=b"@@:iq"
    )

    def signedintArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andunsignedcharArg_ = objc.selector(
        signedintArg_andunsignedcharArg_, signature=b"@@:iC"
    )

    def signedintArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andunsignedshortArg_ = objc.selector(
        signedintArg_andunsignedshortArg_, signature=b"@@:iS"
    )

    def signedintArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andunsignedintArg_ = objc.selector(
        signedintArg_andunsignedintArg_, signature=b"@@:iI"
    )

    def signedintArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andunsignedlongArg_ = objc.selector(
        signedintArg_andunsignedlongArg_, signature=b"@@:i" + ulong_tp
    )

    def signedintArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andunsignedlonglongArg_ = objc.selector(
        signedintArg_andunsignedlonglongArg_, signature=b"@@:iQ"
    )

    def signedintArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andfloatArg_ = objc.selector(
        signedintArg_andfloatArg_, signature=b"@@:if"
    )

    def signedintArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_anddoubleArg_ = objc.selector(
        signedintArg_anddoubleArg_, signature=b"@@:id"
    )

    def signedintArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andidArg_ = objc.selector(signedintArg_andidArg_, signature=b"@@:i@")

    def signedintArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    signedintArg_andcharPtrArg_ = objc.selector(
        signedintArg_andcharPtrArg_, signature=b"@@:i*"
    )

    def signedintArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andNSPointArg_ = objc.selector(
        signedintArg_andNSPointArg_, signature=b"@@:i" + NSPoint_tp
    )

    def signedintArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andNSRectArg_ = objc.selector(
        signedintArg_andNSRectArg_, signature=b"@@:i" + NSRect_tp
    )

    def signedintArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andstructTestStruct1Arg_ = objc.selector(
        signedintArg_andstructTestStruct1Arg_, signature=b"@@:i{_TestStruct1=ii[5s]}"
    )

    def signedintArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andstructTestStruct2Arg_ = objc.selector(
        signedintArg_andstructTestStruct2Arg_, signature=b"@@:i{_TestStruct2=id[5s]}"
    )

    def signedintArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andstructTestStruct3Arg_ = objc.selector(
        signedintArg_andstructTestStruct3Arg_, signature=b"@@:i{_TestStruct3=ci}"
    )

    def signedintArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andstructTestStruct4Arg_ = objc.selector(
        signedintArg_andstructTestStruct4Arg_, signature=b"@@:i{_TestStruct4=cq}"
    )

    def signedintArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedintArg_andstructTestStruct5Arg_ = objc.selector(
        signedintArg_andstructTestStruct5Arg_, signature=b"@@:i{_TestStruct5=cd}"
    )

    def signedlongArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andboolArg_ = objc.selector(
        signedlongArg_andboolArg_, signature=b"@@:" + long_tp + b"B"
    )

    def signedlongArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andBOOLArg_ = objc.selector(
        signedlongArg_andBOOLArg_, signature=b"@@:" + long_tp + b"c"
    )

    def signedlongArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andcharArg_ = objc.selector(
        signedlongArg_andcharArg_, signature=b"@@:" + long_tp + b"c"
    )

    def signedlongArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andsignedshortArg_ = objc.selector(
        signedlongArg_andsignedshortArg_, signature=b"@@:" + long_tp + b"s"
    )

    def signedlongArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andsignedintArg_ = objc.selector(
        signedlongArg_andsignedintArg_, signature=b"@@:" + long_tp + b"i"
    )

    def signedlongArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andsignedlongArg_ = objc.selector(
        signedlongArg_andsignedlongArg_, signature=b"@@:" + long_tp + long_tp
    )

    def signedlongArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andsignedlonglongArg_ = objc.selector(
        signedlongArg_andsignedlonglongArg_, signature=b"@@:" + long_tp + b"q"
    )

    def signedlongArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andunsignedcharArg_ = objc.selector(
        signedlongArg_andunsignedcharArg_, signature=b"@@:" + long_tp + b"C"
    )

    def signedlongArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andunsignedshortArg_ = objc.selector(
        signedlongArg_andunsignedshortArg_, signature=b"@@:" + long_tp + b"S"
    )

    def signedlongArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andunsignedintArg_ = objc.selector(
        signedlongArg_andunsignedintArg_, signature=b"@@:" + long_tp + b"I"
    )

    def signedlongArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andunsignedlongArg_ = objc.selector(
        signedlongArg_andunsignedlongArg_, signature=b"@@:" + long_tp + ulong_tp
    )

    def signedlongArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andunsignedlonglongArg_ = objc.selector(
        signedlongArg_andunsignedlonglongArg_, signature=b"@@:" + long_tp + b"Q"
    )

    def signedlongArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andfloatArg_ = objc.selector(
        signedlongArg_andfloatArg_, signature=b"@@:" + long_tp + b"f"
    )

    def signedlongArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_anddoubleArg_ = objc.selector(
        signedlongArg_anddoubleArg_, signature=b"@@:" + long_tp + b"d"
    )

    def signedlongArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andidArg_ = objc.selector(
        signedlongArg_andidArg_, signature=b"@@:" + long_tp + b"@"
    )

    def signedlongArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    signedlongArg_andcharPtrArg_ = objc.selector(
        signedlongArg_andcharPtrArg_, signature=b"@@:" + long_tp + b"*"
    )

    def signedlongArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andNSPointArg_ = objc.selector(
        signedlongArg_andNSPointArg_, signature=b"@@:" + long_tp + NSPoint_tp
    )

    def signedlongArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andNSRectArg_ = objc.selector(
        signedlongArg_andNSRectArg_, signature=b"@@:" + long_tp + NSRect_tp
    )

    def signedlongArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andstructTestStruct1Arg_ = objc.selector(
        signedlongArg_andstructTestStruct1Arg_,
        signature=b"@@:" + long_tp + b"{_TestStruct1=ii[5s]}",
    )

    def signedlongArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andstructTestStruct2Arg_ = objc.selector(
        signedlongArg_andstructTestStruct2Arg_,
        signature=b"@@:" + long_tp + b"{_TestStruct2=id[5s]}",
    )

    def signedlongArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andstructTestStruct3Arg_ = objc.selector(
        signedlongArg_andstructTestStruct3Arg_,
        signature=b"@@:" + long_tp + b"{_TestStruct3=ci}",
    )

    def signedlongArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andstructTestStruct4Arg_ = objc.selector(
        signedlongArg_andstructTestStruct4Arg_,
        signature=b"@@:" + long_tp + b"{_TestStruct4=cq}",
    )

    def signedlongArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlongArg_andstructTestStruct5Arg_ = objc.selector(
        signedlongArg_andstructTestStruct5Arg_,
        signature=b"@@:" + long_tp + b"{_TestStruct5=cd}",
    )

    def signedlonglongArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andboolArg_ = objc.selector(
        signedlonglongArg_andboolArg_, signature=b"@@:qB"
    )

    def signedlonglongArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andBOOLArg_ = objc.selector(
        signedlonglongArg_andBOOLArg_, signature=b"@@:qc"
    )

    def signedlonglongArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andcharArg_ = objc.selector(
        signedlonglongArg_andcharArg_, signature=b"@@:qc"
    )

    def signedlonglongArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andsignedshortArg_ = objc.selector(
        signedlonglongArg_andsignedshortArg_, signature=b"@@:qs"
    )

    def signedlonglongArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andsignedintArg_ = objc.selector(
        signedlonglongArg_andsignedintArg_, signature=b"@@:qi"
    )

    def signedlonglongArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andsignedlongArg_ = objc.selector(
        signedlonglongArg_andsignedlongArg_, signature=b"@@:q" + long_tp
    )

    def signedlonglongArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andsignedlonglongArg_ = objc.selector(
        signedlonglongArg_andsignedlonglongArg_, signature=b"@@:qq"
    )

    def signedlonglongArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andunsignedcharArg_ = objc.selector(
        signedlonglongArg_andunsignedcharArg_, signature=b"@@:qC"
    )

    def signedlonglongArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andunsignedshortArg_ = objc.selector(
        signedlonglongArg_andunsignedshortArg_, signature=b"@@:qS"
    )

    def signedlonglongArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andunsignedintArg_ = objc.selector(
        signedlonglongArg_andunsignedintArg_, signature=b"@@:qI"
    )

    def signedlonglongArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andunsignedlongArg_ = objc.selector(
        signedlonglongArg_andunsignedlongArg_, signature=b"@@:q" + ulong_tp
    )

    def signedlonglongArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andunsignedlonglongArg_ = objc.selector(
        signedlonglongArg_andunsignedlonglongArg_, signature=b"@@:qQ"
    )

    def signedlonglongArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andfloatArg_ = objc.selector(
        signedlonglongArg_andfloatArg_, signature=b"@@:qf"
    )

    def signedlonglongArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_anddoubleArg_ = objc.selector(
        signedlonglongArg_anddoubleArg_, signature=b"@@:qd"
    )

    def signedlonglongArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andidArg_ = objc.selector(
        signedlonglongArg_andidArg_, signature=b"@@:q@"
    )

    def signedlonglongArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    signedlonglongArg_andcharPtrArg_ = objc.selector(
        signedlonglongArg_andcharPtrArg_, signature=b"@@:q*"
    )

    def signedlonglongArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andNSPointArg_ = objc.selector(
        signedlonglongArg_andNSPointArg_, signature=b"@@:q" + NSPoint_tp
    )

    def signedlonglongArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andNSRectArg_ = objc.selector(
        signedlonglongArg_andNSRectArg_, signature=b"@@:q" + NSRect_tp
    )

    def signedlonglongArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andstructTestStruct1Arg_ = objc.selector(
        signedlonglongArg_andstructTestStruct1Arg_,
        signature=b"@@:q{_TestStruct1=ii[5s]}",
    )

    def signedlonglongArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andstructTestStruct2Arg_ = objc.selector(
        signedlonglongArg_andstructTestStruct2Arg_,
        signature=b"@@:q{_TestStruct2=id[5s]}",
    )

    def signedlonglongArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andstructTestStruct3Arg_ = objc.selector(
        signedlonglongArg_andstructTestStruct3Arg_, signature=b"@@:q{_TestStruct3=ci}"
    )

    def signedlonglongArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andstructTestStruct4Arg_ = objc.selector(
        signedlonglongArg_andstructTestStruct4Arg_, signature=b"@@:q{_TestStruct4=cq}"
    )

    def signedlonglongArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    signedlonglongArg_andstructTestStruct5Arg_ = objc.selector(
        signedlonglongArg_andstructTestStruct5Arg_, signature=b"@@:q{_TestStruct5=cd}"
    )

    def unsignedcharArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andboolArg_ = objc.selector(
        unsignedcharArg_andboolArg_, signature=b"@@:CB"
    )

    def unsignedcharArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andBOOLArg_ = objc.selector(
        unsignedcharArg_andBOOLArg_, signature=b"@@:Cc"
    )

    def unsignedcharArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andcharArg_ = objc.selector(
        unsignedcharArg_andcharArg_, signature=b"@@:Cc"
    )

    def unsignedcharArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andsignedshortArg_ = objc.selector(
        unsignedcharArg_andsignedshortArg_, signature=b"@@:Cs"
    )

    def unsignedcharArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andsignedintArg_ = objc.selector(
        unsignedcharArg_andsignedintArg_, signature=b"@@:Ci"
    )

    def unsignedcharArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andsignedlongArg_ = objc.selector(
        unsignedcharArg_andsignedlongArg_, signature=b"@@:C" + long_tp
    )

    def unsignedcharArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andsignedlonglongArg_ = objc.selector(
        unsignedcharArg_andsignedlonglongArg_, signature=b"@@:Cq"
    )

    def unsignedcharArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andunsignedcharArg_ = objc.selector(
        unsignedcharArg_andunsignedcharArg_, signature=b"@@:CC"
    )

    def unsignedcharArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andunsignedshortArg_ = objc.selector(
        unsignedcharArg_andunsignedshortArg_, signature=b"@@:CS"
    )

    def unsignedcharArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andunsignedintArg_ = objc.selector(
        unsignedcharArg_andunsignedintArg_, signature=b"@@:CI"
    )

    def unsignedcharArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andunsignedlongArg_ = objc.selector(
        unsignedcharArg_andunsignedlongArg_, signature=b"@@:C" + ulong_tp
    )

    def unsignedcharArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andunsignedlonglongArg_ = objc.selector(
        unsignedcharArg_andunsignedlonglongArg_, signature=b"@@:CQ"
    )

    def unsignedcharArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andfloatArg_ = objc.selector(
        unsignedcharArg_andfloatArg_, signature=b"@@:Cf"
    )

    def unsignedcharArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_anddoubleArg_ = objc.selector(
        unsignedcharArg_anddoubleArg_, signature=b"@@:Cd"
    )

    def unsignedcharArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andidArg_ = objc.selector(
        unsignedcharArg_andidArg_, signature=b"@@:C@"
    )

    def unsignedcharArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    unsignedcharArg_andcharPtrArg_ = objc.selector(
        unsignedcharArg_andcharPtrArg_, signature=b"@@:C*"
    )

    def unsignedcharArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andNSPointArg_ = objc.selector(
        unsignedcharArg_andNSPointArg_, signature=b"@@:C" + NSPoint_tp
    )

    def unsignedcharArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andNSRectArg_ = objc.selector(
        unsignedcharArg_andNSRectArg_, signature=b"@@:C" + NSRect_tp
    )

    def unsignedcharArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andstructTestStruct1Arg_ = objc.selector(
        unsignedcharArg_andstructTestStruct1Arg_, signature=b"@@:C{_TestStruct1=ii[5s]}"
    )

    def unsignedcharArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andstructTestStruct2Arg_ = objc.selector(
        unsignedcharArg_andstructTestStruct2Arg_, signature=b"@@:C{_TestStruct2=id[5s]}"
    )

    def unsignedcharArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andstructTestStruct3Arg_ = objc.selector(
        unsignedcharArg_andstructTestStruct3Arg_, signature=b"@@:C{_TestStruct3=ci}"
    )

    def unsignedcharArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andstructTestStruct4Arg_ = objc.selector(
        unsignedcharArg_andstructTestStruct4Arg_, signature=b"@@:C{_TestStruct4=cq}"
    )

    def unsignedcharArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedcharArg_andstructTestStruct5Arg_ = objc.selector(
        unsignedcharArg_andstructTestStruct5Arg_, signature=b"@@:C{_TestStruct5=cd}"
    )

    def unsignedshortArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andboolArg_ = objc.selector(
        unsignedshortArg_andboolArg_, signature=b"@@:SB"
    )

    def unsignedshortArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andBOOLArg_ = objc.selector(
        unsignedshortArg_andBOOLArg_, signature=b"@@:Sc"
    )

    def unsignedshortArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andcharArg_ = objc.selector(
        unsignedshortArg_andcharArg_, signature=b"@@:Sc"
    )

    def unsignedshortArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andsignedshortArg_ = objc.selector(
        unsignedshortArg_andsignedshortArg_, signature=b"@@:Ss"
    )

    def unsignedshortArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andsignedintArg_ = objc.selector(
        unsignedshortArg_andsignedintArg_, signature=b"@@:Si"
    )

    def unsignedshortArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andsignedlongArg_ = objc.selector(
        unsignedshortArg_andsignedlongArg_, signature=b"@@:S" + long_tp
    )

    def unsignedshortArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andsignedlonglongArg_ = objc.selector(
        unsignedshortArg_andsignedlonglongArg_, signature=b"@@:Sq"
    )

    def unsignedshortArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andunsignedcharArg_ = objc.selector(
        unsignedshortArg_andunsignedcharArg_, signature=b"@@:SC"
    )

    def unsignedshortArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andunsignedshortArg_ = objc.selector(
        unsignedshortArg_andunsignedshortArg_, signature=b"@@:SS"
    )

    def unsignedshortArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andunsignedintArg_ = objc.selector(
        unsignedshortArg_andunsignedintArg_, signature=b"@@:SI"
    )

    def unsignedshortArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andunsignedlongArg_ = objc.selector(
        unsignedshortArg_andunsignedlongArg_, signature=b"@@:S" + ulong_tp
    )

    def unsignedshortArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andunsignedlonglongArg_ = objc.selector(
        unsignedshortArg_andunsignedlonglongArg_, signature=b"@@:SQ"
    )

    def unsignedshortArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andfloatArg_ = objc.selector(
        unsignedshortArg_andfloatArg_, signature=b"@@:Sf"
    )

    def unsignedshortArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_anddoubleArg_ = objc.selector(
        unsignedshortArg_anddoubleArg_, signature=b"@@:Sd"
    )

    def unsignedshortArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andidArg_ = objc.selector(
        unsignedshortArg_andidArg_, signature=b"@@:S@"
    )

    def unsignedshortArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    unsignedshortArg_andcharPtrArg_ = objc.selector(
        unsignedshortArg_andcharPtrArg_, signature=b"@@:S*"
    )

    def unsignedshortArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andNSPointArg_ = objc.selector(
        unsignedshortArg_andNSPointArg_, signature=b"@@:S" + NSPoint_tp
    )

    def unsignedshortArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andNSRectArg_ = objc.selector(
        unsignedshortArg_andNSRectArg_, signature=b"@@:S" + NSRect_tp
    )

    def unsignedshortArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andstructTestStruct1Arg_ = objc.selector(
        unsignedshortArg_andstructTestStruct1Arg_,
        signature=b"@@:S{_TestStruct1=ii[5s]}",
    )

    def unsignedshortArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andstructTestStruct2Arg_ = objc.selector(
        unsignedshortArg_andstructTestStruct2Arg_,
        signature=b"@@:S{_TestStruct2=id[5s]}",
    )

    def unsignedshortArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andstructTestStruct3Arg_ = objc.selector(
        unsignedshortArg_andstructTestStruct3Arg_, signature=b"@@:S{_TestStruct3=ci}"
    )

    def unsignedshortArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andstructTestStruct4Arg_ = objc.selector(
        unsignedshortArg_andstructTestStruct4Arg_, signature=b"@@:S{_TestStruct4=cq}"
    )

    def unsignedshortArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedshortArg_andstructTestStruct5Arg_ = objc.selector(
        unsignedshortArg_andstructTestStruct5Arg_, signature=b"@@:S{_TestStruct5=cd}"
    )

    def unsignedintArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andboolArg_ = objc.selector(
        unsignedintArg_andboolArg_, signature=b"@@:IB"
    )

    def unsignedintArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andBOOLArg_ = objc.selector(
        unsignedintArg_andBOOLArg_, signature=b"@@:Ic"
    )

    def unsignedintArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andcharArg_ = objc.selector(
        unsignedintArg_andcharArg_, signature=b"@@:Ic"
    )

    def unsignedintArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andsignedshortArg_ = objc.selector(
        unsignedintArg_andsignedshortArg_, signature=b"@@:Is"
    )

    def unsignedintArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andsignedintArg_ = objc.selector(
        unsignedintArg_andsignedintArg_, signature=b"@@:Ii"
    )

    def unsignedintArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andsignedlongArg_ = objc.selector(
        unsignedintArg_andsignedlongArg_, signature=b"@@:I" + long_tp
    )

    def unsignedintArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andsignedlonglongArg_ = objc.selector(
        unsignedintArg_andsignedlonglongArg_, signature=b"@@:Iq"
    )

    def unsignedintArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andunsignedcharArg_ = objc.selector(
        unsignedintArg_andunsignedcharArg_, signature=b"@@:IC"
    )

    def unsignedintArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andunsignedshortArg_ = objc.selector(
        unsignedintArg_andunsignedshortArg_, signature=b"@@:IS"
    )

    def unsignedintArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andunsignedintArg_ = objc.selector(
        unsignedintArg_andunsignedintArg_, signature=b"@@:II"
    )

    def unsignedintArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andunsignedlongArg_ = objc.selector(
        unsignedintArg_andunsignedlongArg_, signature=b"@@:I" + ulong_tp
    )

    def unsignedintArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andunsignedlonglongArg_ = objc.selector(
        unsignedintArg_andunsignedlonglongArg_, signature=b"@@:IQ"
    )

    def unsignedintArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andfloatArg_ = objc.selector(
        unsignedintArg_andfloatArg_, signature=b"@@:If"
    )

    def unsignedintArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_anddoubleArg_ = objc.selector(
        unsignedintArg_anddoubleArg_, signature=b"@@:Id"
    )

    def unsignedintArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andidArg_ = objc.selector(
        unsignedintArg_andidArg_, signature=b"@@:I@"
    )

    def unsignedintArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    unsignedintArg_andcharPtrArg_ = objc.selector(
        unsignedintArg_andcharPtrArg_, signature=b"@@:I*"
    )

    def unsignedintArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andNSPointArg_ = objc.selector(
        unsignedintArg_andNSPointArg_, signature=b"@@:I" + NSPoint_tp
    )

    def unsignedintArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andNSRectArg_ = objc.selector(
        unsignedintArg_andNSRectArg_, signature=b"@@:I" + NSRect_tp
    )

    def unsignedintArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andstructTestStruct1Arg_ = objc.selector(
        unsignedintArg_andstructTestStruct1Arg_, signature=b"@@:I{_TestStruct1=ii[5s]}"
    )

    def unsignedintArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andstructTestStruct2Arg_ = objc.selector(
        unsignedintArg_andstructTestStruct2Arg_, signature=b"@@:I{_TestStruct2=id[5s]}"
    )

    def unsignedintArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andstructTestStruct3Arg_ = objc.selector(
        unsignedintArg_andstructTestStruct3Arg_, signature=b"@@:I{_TestStruct3=ci}"
    )

    def unsignedintArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andstructTestStruct4Arg_ = objc.selector(
        unsignedintArg_andstructTestStruct4Arg_, signature=b"@@:I{_TestStruct4=cq}"
    )

    def unsignedintArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedintArg_andstructTestStruct5Arg_ = objc.selector(
        unsignedintArg_andstructTestStruct5Arg_, signature=b"@@:I{_TestStruct5=cd}"
    )

    def unsignedlongArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andboolArg_ = objc.selector(
        unsignedlongArg_andboolArg_, signature=b"@@:" + ulong_tp + b"B"
    )

    def unsignedlongArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andBOOLArg_ = objc.selector(
        unsignedlongArg_andBOOLArg_, signature=b"@@:" + ulong_tp + b"c"
    )

    def unsignedlongArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andcharArg_ = objc.selector(
        unsignedlongArg_andcharArg_, signature=b"@@:" + ulong_tp + b"c"
    )

    def unsignedlongArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andsignedshortArg_ = objc.selector(
        unsignedlongArg_andsignedshortArg_, signature=b"@@:" + ulong_tp + b"s"
    )

    def unsignedlongArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andsignedintArg_ = objc.selector(
        unsignedlongArg_andsignedintArg_, signature=b"@@:" + ulong_tp + b"i"
    )

    def unsignedlongArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andsignedlongArg_ = objc.selector(
        unsignedlongArg_andsignedlongArg_, signature=b"@@:" + ulong_tp + long_tp
    )

    def unsignedlongArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andsignedlonglongArg_ = objc.selector(
        unsignedlongArg_andsignedlonglongArg_, signature=b"@@:" + ulong_tp + b"q"
    )

    def unsignedlongArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andunsignedcharArg_ = objc.selector(
        unsignedlongArg_andunsignedcharArg_, signature=b"@@:" + ulong_tp + b"C"
    )

    def unsignedlongArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andunsignedshortArg_ = objc.selector(
        unsignedlongArg_andunsignedshortArg_, signature=b"@@:" + ulong_tp + b"S"
    )

    def unsignedlongArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andunsignedintArg_ = objc.selector(
        unsignedlongArg_andunsignedintArg_, signature=b"@@:" + ulong_tp + b"I"
    )

    def unsignedlongArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andunsignedlongArg_ = objc.selector(
        unsignedlongArg_andunsignedlongArg_, signature=b"@@:" + ulong_tp + ulong_tp
    )

    def unsignedlongArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andunsignedlonglongArg_ = objc.selector(
        unsignedlongArg_andunsignedlonglongArg_, signature=b"@@:" + ulong_tp + b"Q"
    )

    def unsignedlongArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andfloatArg_ = objc.selector(
        unsignedlongArg_andfloatArg_, signature=b"@@:" + ulong_tp + b"f"
    )

    def unsignedlongArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_anddoubleArg_ = objc.selector(
        unsignedlongArg_anddoubleArg_, signature=b"@@:" + ulong_tp + b"d"
    )

    def unsignedlongArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andidArg_ = objc.selector(
        unsignedlongArg_andidArg_, signature=b"@@:" + ulong_tp + b"@"
    )

    def unsignedlongArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    unsignedlongArg_andcharPtrArg_ = objc.selector(
        unsignedlongArg_andcharPtrArg_, signature=b"@@:" + ulong_tp + b"*"
    )

    def unsignedlongArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andNSPointArg_ = objc.selector(
        unsignedlongArg_andNSPointArg_, signature=b"@@:" + ulong_tp + NSPoint_tp
    )

    def unsignedlongArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andNSRectArg_ = objc.selector(
        unsignedlongArg_andNSRectArg_, signature=b"@@:" + ulong_tp + NSRect_tp
    )

    def unsignedlongArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andstructTestStruct1Arg_ = objc.selector(
        unsignedlongArg_andstructTestStruct1Arg_,
        signature=b"@@:" + ulong_tp + b"{_TestStruct1=ii[5s]}",
    )

    def unsignedlongArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andstructTestStruct2Arg_ = objc.selector(
        unsignedlongArg_andstructTestStruct2Arg_,
        signature=b"@@:" + ulong_tp + b"{_TestStruct2=id[5s]}",
    )

    def unsignedlongArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andstructTestStruct3Arg_ = objc.selector(
        unsignedlongArg_andstructTestStruct3Arg_,
        signature=b"@@:" + ulong_tp + b"{_TestStruct3=ci}",
    )

    def unsignedlongArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andstructTestStruct4Arg_ = objc.selector(
        unsignedlongArg_andstructTestStruct4Arg_,
        signature=b"@@:" + ulong_tp + b"{_TestStruct4=cq}",
    )

    def unsignedlongArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlongArg_andstructTestStruct5Arg_ = objc.selector(
        unsignedlongArg_andstructTestStruct5Arg_,
        signature=b"@@:" + ulong_tp + b"{_TestStruct5=cd}",
    )

    def unsignedlonglongArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andboolArg_ = objc.selector(
        unsignedlonglongArg_andboolArg_, signature=b"@@:QB"
    )

    def unsignedlonglongArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andBOOLArg_ = objc.selector(
        unsignedlonglongArg_andBOOLArg_, signature=b"@@:Qc"
    )

    def unsignedlonglongArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andcharArg_ = objc.selector(
        unsignedlonglongArg_andcharArg_, signature=b"@@:Qc"
    )

    def unsignedlonglongArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andsignedshortArg_ = objc.selector(
        unsignedlonglongArg_andsignedshortArg_, signature=b"@@:Qs"
    )

    def unsignedlonglongArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andsignedintArg_ = objc.selector(
        unsignedlonglongArg_andsignedintArg_, signature=b"@@:Qi"
    )

    def unsignedlonglongArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andsignedlongArg_ = objc.selector(
        unsignedlonglongArg_andsignedlongArg_, signature=b"@@:Q" + long_tp
    )

    def unsignedlonglongArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andsignedlonglongArg_ = objc.selector(
        unsignedlonglongArg_andsignedlonglongArg_, signature=b"@@:Qq"
    )

    def unsignedlonglongArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andunsignedcharArg_ = objc.selector(
        unsignedlonglongArg_andunsignedcharArg_, signature=b"@@:QC"
    )

    def unsignedlonglongArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andunsignedshortArg_ = objc.selector(
        unsignedlonglongArg_andunsignedshortArg_, signature=b"@@:QS"
    )

    def unsignedlonglongArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andunsignedintArg_ = objc.selector(
        unsignedlonglongArg_andunsignedintArg_, signature=b"@@:QI"
    )

    def unsignedlonglongArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andunsignedlongArg_ = objc.selector(
        unsignedlonglongArg_andunsignedlongArg_, signature=b"@@:Q" + ulong_tp
    )

    def unsignedlonglongArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andunsignedlonglongArg_ = objc.selector(
        unsignedlonglongArg_andunsignedlonglongArg_, signature=b"@@:QQ"
    )

    def unsignedlonglongArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andfloatArg_ = objc.selector(
        unsignedlonglongArg_andfloatArg_, signature=b"@@:Qf"
    )

    def unsignedlonglongArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_anddoubleArg_ = objc.selector(
        unsignedlonglongArg_anddoubleArg_, signature=b"@@:Qd"
    )

    def unsignedlonglongArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andidArg_ = objc.selector(
        unsignedlonglongArg_andidArg_, signature=b"@@:Q@"
    )

    def unsignedlonglongArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    unsignedlonglongArg_andcharPtrArg_ = objc.selector(
        unsignedlonglongArg_andcharPtrArg_, signature=b"@@:Q*"
    )

    def unsignedlonglongArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andNSPointArg_ = objc.selector(
        unsignedlonglongArg_andNSPointArg_, signature=b"@@:Q" + NSPoint_tp
    )

    def unsignedlonglongArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andNSRectArg_ = objc.selector(
        unsignedlonglongArg_andNSRectArg_, signature=b"@@:Q" + NSRect_tp
    )

    def unsignedlonglongArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andstructTestStruct1Arg_ = objc.selector(
        unsignedlonglongArg_andstructTestStruct1Arg_,
        signature=b"@@:Q{_TestStruct1=ii[5s]}",
    )

    def unsignedlonglongArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andstructTestStruct2Arg_ = objc.selector(
        unsignedlonglongArg_andstructTestStruct2Arg_,
        signature=b"@@:Q{_TestStruct2=id[5s]}",
    )

    def unsignedlonglongArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andstructTestStruct3Arg_ = objc.selector(
        unsignedlonglongArg_andstructTestStruct3Arg_, signature=b"@@:Q{_TestStruct3=ci}"
    )

    def unsignedlonglongArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andstructTestStruct4Arg_ = objc.selector(
        unsignedlonglongArg_andstructTestStruct4Arg_, signature=b"@@:Q{_TestStruct4=cq}"
    )

    def unsignedlonglongArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    unsignedlonglongArg_andstructTestStruct5Arg_ = objc.selector(
        unsignedlonglongArg_andstructTestStruct5Arg_, signature=b"@@:Q{_TestStruct5=cd}"
    )

    def floatArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andboolArg_ = objc.selector(floatArg_andboolArg_, signature=b"@@:fB")

    def floatArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andBOOLArg_ = objc.selector(floatArg_andBOOLArg_, signature=b"@@:fc")

    def floatArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andcharArg_ = objc.selector(floatArg_andcharArg_, signature=b"@@:fc")

    def floatArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andsignedshortArg_ = objc.selector(
        floatArg_andsignedshortArg_, signature=b"@@:fs"
    )

    def floatArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andsignedintArg_ = objc.selector(
        floatArg_andsignedintArg_, signature=b"@@:fi"
    )

    def floatArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andsignedlongArg_ = objc.selector(
        floatArg_andsignedlongArg_, signature=b"@@:f" + long_tp
    )

    def floatArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andsignedlonglongArg_ = objc.selector(
        floatArg_andsignedlonglongArg_, signature=b"@@:fq"
    )

    def floatArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andunsignedcharArg_ = objc.selector(
        floatArg_andunsignedcharArg_, signature=b"@@:fC"
    )

    def floatArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andunsignedshortArg_ = objc.selector(
        floatArg_andunsignedshortArg_, signature=b"@@:fS"
    )

    def floatArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andunsignedintArg_ = objc.selector(
        floatArg_andunsignedintArg_, signature=b"@@:fI"
    )

    def floatArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andunsignedlongArg_ = objc.selector(
        floatArg_andunsignedlongArg_, signature=b"@@:f" + ulong_tp
    )

    def floatArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andunsignedlonglongArg_ = objc.selector(
        floatArg_andunsignedlonglongArg_, signature=b"@@:fQ"
    )

    def floatArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andfloatArg_ = objc.selector(floatArg_andfloatArg_, signature=b"@@:ff")

    def floatArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_anddoubleArg_ = objc.selector(floatArg_anddoubleArg_, signature=b"@@:fd")

    def floatArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andidArg_ = objc.selector(floatArg_andidArg_, signature=b"@@:f@")

    def floatArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    floatArg_andcharPtrArg_ = objc.selector(floatArg_andcharPtrArg_, signature=b"@@:f*")

    def floatArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andNSPointArg_ = objc.selector(
        floatArg_andNSPointArg_, signature=b"@@:f" + NSPoint_tp
    )

    def floatArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andNSRectArg_ = objc.selector(
        floatArg_andNSRectArg_, signature=b"@@:f" + NSRect_tp
    )

    def floatArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andstructTestStruct1Arg_ = objc.selector(
        floatArg_andstructTestStruct1Arg_, signature=b"@@:f{_TestStruct1=ii[5s]}"
    )

    def floatArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andstructTestStruct2Arg_ = objc.selector(
        floatArg_andstructTestStruct2Arg_, signature=b"@@:f{_TestStruct2=id[5s]}"
    )

    def floatArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andstructTestStruct3Arg_ = objc.selector(
        floatArg_andstructTestStruct3Arg_, signature=b"@@:f{_TestStruct3=ci}"
    )

    def floatArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andstructTestStruct4Arg_ = objc.selector(
        floatArg_andstructTestStruct4Arg_, signature=b"@@:f{_TestStruct4=cq}"
    )

    def floatArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    floatArg_andstructTestStruct5Arg_ = objc.selector(
        floatArg_andstructTestStruct5Arg_, signature=b"@@:f{_TestStruct5=cd}"
    )

    def doubleArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andboolArg_ = objc.selector(doubleArg_andboolArg_, signature=b"@@:dB")

    def doubleArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andBOOLArg_ = objc.selector(doubleArg_andBOOLArg_, signature=b"@@:dc")

    def doubleArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andcharArg_ = objc.selector(doubleArg_andcharArg_, signature=b"@@:dc")

    def doubleArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andsignedshortArg_ = objc.selector(
        doubleArg_andsignedshortArg_, signature=b"@@:ds"
    )

    def doubleArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andsignedintArg_ = objc.selector(
        doubleArg_andsignedintArg_, signature=b"@@:di"
    )

    def doubleArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andsignedlongArg_ = objc.selector(
        doubleArg_andsignedlongArg_, signature=b"@@:d" + long_tp
    )

    def doubleArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andsignedlonglongArg_ = objc.selector(
        doubleArg_andsignedlonglongArg_, signature=b"@@:dq"
    )

    def doubleArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andunsignedcharArg_ = objc.selector(
        doubleArg_andunsignedcharArg_, signature=b"@@:dC"
    )

    def doubleArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andunsignedshortArg_ = objc.selector(
        doubleArg_andunsignedshortArg_, signature=b"@@:dS"
    )

    def doubleArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andunsignedintArg_ = objc.selector(
        doubleArg_andunsignedintArg_, signature=b"@@:dI"
    )

    def doubleArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andunsignedlongArg_ = objc.selector(
        doubleArg_andunsignedlongArg_, signature=b"@@:d" + ulong_tp
    )

    def doubleArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andunsignedlonglongArg_ = objc.selector(
        doubleArg_andunsignedlonglongArg_, signature=b"@@:dQ"
    )

    def doubleArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andfloatArg_ = objc.selector(doubleArg_andfloatArg_, signature=b"@@:df")

    def doubleArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_anddoubleArg_ = objc.selector(doubleArg_anddoubleArg_, signature=b"@@:dd")

    def doubleArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andidArg_ = objc.selector(doubleArg_andidArg_, signature=b"@@:d@")

    def doubleArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    doubleArg_andcharPtrArg_ = objc.selector(
        doubleArg_andcharPtrArg_, signature=b"@@:d*"
    )

    def doubleArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andNSPointArg_ = objc.selector(
        doubleArg_andNSPointArg_, signature=b"@@:d" + NSPoint_tp
    )

    def doubleArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andNSRectArg_ = objc.selector(
        doubleArg_andNSRectArg_, signature=b"@@:d" + NSRect_tp
    )

    def doubleArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andstructTestStruct1Arg_ = objc.selector(
        doubleArg_andstructTestStruct1Arg_, signature=b"@@:d{_TestStruct1=ii[5s]}"
    )

    def doubleArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andstructTestStruct2Arg_ = objc.selector(
        doubleArg_andstructTestStruct2Arg_, signature=b"@@:d{_TestStruct2=id[5s]}"
    )

    def doubleArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andstructTestStruct3Arg_ = objc.selector(
        doubleArg_andstructTestStruct3Arg_, signature=b"@@:d{_TestStruct3=ci}"
    )

    def doubleArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andstructTestStruct4Arg_ = objc.selector(
        doubleArg_andstructTestStruct4Arg_, signature=b"@@:d{_TestStruct4=cq}"
    )

    def doubleArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    doubleArg_andstructTestStruct5Arg_ = objc.selector(
        doubleArg_andstructTestStruct5Arg_, signature=b"@@:d{_TestStruct5=cd}"
    )

    def idArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andboolArg_ = objc.selector(idArg_andboolArg_, signature=b"@@:@B")

    def idArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andBOOLArg_ = objc.selector(idArg_andBOOLArg_, signature=b"@@:@c")

    def idArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andcharArg_ = objc.selector(idArg_andcharArg_, signature=b"@@:@c")

    def idArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andsignedshortArg_ = objc.selector(
        idArg_andsignedshortArg_, signature=b"@@:@s"
    )

    def idArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andsignedintArg_ = objc.selector(idArg_andsignedintArg_, signature=b"@@:@i")

    def idArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andsignedlongArg_ = objc.selector(
        idArg_andsignedlongArg_, signature=b"@@:@" + long_tp
    )

    def idArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andsignedlonglongArg_ = objc.selector(
        idArg_andsignedlonglongArg_, signature=b"@@:@q"
    )

    def idArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andunsignedcharArg_ = objc.selector(
        idArg_andunsignedcharArg_, signature=b"@@:@C"
    )

    def idArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andunsignedshortArg_ = objc.selector(
        idArg_andunsignedshortArg_, signature=b"@@:@S"
    )

    def idArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andunsignedintArg_ = objc.selector(
        idArg_andunsignedintArg_, signature=b"@@:@I"
    )

    def idArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andunsignedlongArg_ = objc.selector(
        idArg_andunsignedlongArg_, signature=b"@@:@" + ulong_tp
    )

    def idArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andunsignedlonglongArg_ = objc.selector(
        idArg_andunsignedlonglongArg_, signature=b"@@:@Q"
    )

    def idArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andfloatArg_ = objc.selector(idArg_andfloatArg_, signature=b"@@:@f")

    def idArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_anddoubleArg_ = objc.selector(idArg_anddoubleArg_, signature=b"@@:@d")

    def idArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andidArg_ = objc.selector(idArg_andidArg_, signature=b"@@:@@")

    def idArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    idArg_andcharPtrArg_ = objc.selector(idArg_andcharPtrArg_, signature=b"@@:@*")

    def idArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andNSPointArg_ = objc.selector(
        idArg_andNSPointArg_, signature=b"@@:@" + NSPoint_tp
    )

    def idArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andNSRectArg_ = objc.selector(
        idArg_andNSRectArg_, signature=b"@@:@" + NSRect_tp
    )

    def idArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andstructTestStruct1Arg_ = objc.selector(
        idArg_andstructTestStruct1Arg_, signature=b"@@:@{_TestStruct1=ii[5s]}"
    )

    def idArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andstructTestStruct2Arg_ = objc.selector(
        idArg_andstructTestStruct2Arg_, signature=b"@@:@{_TestStruct2=id[5s]}"
    )

    def idArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andstructTestStruct3Arg_ = objc.selector(
        idArg_andstructTestStruct3Arg_, signature=b"@@:@{_TestStruct3=ci}"
    )

    def idArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andstructTestStruct4Arg_ = objc.selector(
        idArg_andstructTestStruct4Arg_, signature=b"@@:@{_TestStruct4=cq}"
    )

    def idArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    idArg_andstructTestStruct5Arg_ = objc.selector(
        idArg_andstructTestStruct5Arg_, signature=b"@@:@{_TestStruct5=cd}"
    )

    def charPtrArg_andboolArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andboolArg_ = objc.selector(charPtrArg_andboolArg_, signature=b"@@:*B")

    def charPtrArg_andBOOLArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andBOOLArg_ = objc.selector(charPtrArg_andBOOLArg_, signature=b"@@:*c")

    def charPtrArg_andcharArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andcharArg_ = objc.selector(charPtrArg_andcharArg_, signature=b"@@:*c")

    def charPtrArg_andsignedshortArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andsignedshortArg_ = objc.selector(
        charPtrArg_andsignedshortArg_, signature=b"@@:*s"
    )

    def charPtrArg_andsignedintArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andsignedintArg_ = objc.selector(
        charPtrArg_andsignedintArg_, signature=b"@@:*i"
    )

    def charPtrArg_andsignedlongArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andsignedlongArg_ = objc.selector(
        charPtrArg_andsignedlongArg_, signature=b"@@:*" + long_tp
    )

    def charPtrArg_andsignedlonglongArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andsignedlonglongArg_ = objc.selector(
        charPtrArg_andsignedlonglongArg_, signature=b"@@:*q"
    )

    def charPtrArg_andunsignedcharArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andunsignedcharArg_ = objc.selector(
        charPtrArg_andunsignedcharArg_, signature=b"@@:*C"
    )

    def charPtrArg_andunsignedshortArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andunsignedshortArg_ = objc.selector(
        charPtrArg_andunsignedshortArg_, signature=b"@@:*S"
    )

    def charPtrArg_andunsignedintArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andunsignedintArg_ = objc.selector(
        charPtrArg_andunsignedintArg_, signature=b"@@:*I"
    )

    def charPtrArg_andunsignedlongArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andunsignedlongArg_ = objc.selector(
        charPtrArg_andunsignedlongArg_, signature=b"@@:*" + ulong_tp
    )

    def charPtrArg_andunsignedlonglongArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andunsignedlonglongArg_ = objc.selector(
        charPtrArg_andunsignedlonglongArg_, signature=b"@@:*Q"
    )

    def charPtrArg_andfloatArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andfloatArg_ = objc.selector(charPtrArg_andfloatArg_, signature=b"@@:*f")

    def charPtrArg_anddoubleArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_anddoubleArg_ = objc.selector(
        charPtrArg_anddoubleArg_, signature=b"@@:*d"
    )

    def charPtrArg_andidArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andidArg_ = objc.selector(charPtrArg_andidArg_, signature=b"@@:*@")

    def charPtrArg_andcharPtrArg_(self, arg1, arg2):
        arg1 = str(arg1)
        arg2 = str(arg2)
        return [arg1, arg2]

    charPtrArg_andcharPtrArg_ = objc.selector(
        charPtrArg_andcharPtrArg_, signature=b"@@:**"
    )

    def charPtrArg_andNSPointArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andNSPointArg_ = objc.selector(
        charPtrArg_andNSPointArg_, signature=b"@@:*" + NSPoint_tp
    )

    def charPtrArg_andNSRectArg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andNSRectArg_ = objc.selector(
        charPtrArg_andNSRectArg_, signature=b"@@:*" + NSRect_tp
    )

    def charPtrArg_andstructTestStruct1Arg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andstructTestStruct1Arg_ = objc.selector(
        charPtrArg_andstructTestStruct1Arg_, signature=b"@@:*{_TestStruct1=ii[5s]}"
    )

    def charPtrArg_andstructTestStruct2Arg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andstructTestStruct2Arg_ = objc.selector(
        charPtrArg_andstructTestStruct2Arg_, signature=b"@@:*{_TestStruct2=id[5s]}"
    )

    def charPtrArg_andstructTestStruct3Arg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andstructTestStruct3Arg_ = objc.selector(
        charPtrArg_andstructTestStruct3Arg_, signature=b"@@:*{_TestStruct3=ci}"
    )

    def charPtrArg_andstructTestStruct4Arg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andstructTestStruct4Arg_ = objc.selector(
        charPtrArg_andstructTestStruct4Arg_, signature=b"@@:*{_TestStruct4=cq}"
    )

    def charPtrArg_andstructTestStruct5Arg_(self, arg1, arg2):
        arg1 = str(arg1)
        return [arg1, arg2]

    charPtrArg_andstructTestStruct5Arg_ = objc.selector(
        charPtrArg_andstructTestStruct5Arg_, signature=b"@@:*{_TestStruct5=cd}"
    )

    def NSPointArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andboolArg_ = objc.selector(
        NSPointArg_andboolArg_, signature=b"@@:" + NSPoint_tp + b"B"
    )

    def NSPointArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andBOOLArg_ = objc.selector(
        NSPointArg_andBOOLArg_, signature=b"@@:" + NSPoint_tp + b"c"
    )

    def NSPointArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andcharArg_ = objc.selector(
        NSPointArg_andcharArg_, signature=b"@@:" + NSPoint_tp + b"c"
    )

    def NSPointArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andsignedshortArg_ = objc.selector(
        NSPointArg_andsignedshortArg_, signature=b"@@:" + NSPoint_tp + b"s"
    )

    def NSPointArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andsignedintArg_ = objc.selector(
        NSPointArg_andsignedintArg_, signature=b"@@:" + NSPoint_tp + b"i"
    )

    def NSPointArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andsignedlongArg_ = objc.selector(
        NSPointArg_andsignedlongArg_, signature=b"@@:" + NSPoint_tp + long_tp
    )

    def NSPointArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andsignedlonglongArg_ = objc.selector(
        NSPointArg_andsignedlonglongArg_, signature=b"@@:" + NSPoint_tp + b"q"
    )

    def NSPointArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andunsignedcharArg_ = objc.selector(
        NSPointArg_andunsignedcharArg_, signature=b"@@:" + NSPoint_tp + b"C"
    )

    def NSPointArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andunsignedshortArg_ = objc.selector(
        NSPointArg_andunsignedshortArg_, signature=b"@@:" + NSPoint_tp + b"S"
    )

    def NSPointArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andunsignedintArg_ = objc.selector(
        NSPointArg_andunsignedintArg_, signature=b"@@:" + NSPoint_tp + b"I"
    )

    def NSPointArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andunsignedlongArg_ = objc.selector(
        NSPointArg_andunsignedlongArg_, signature=b"@@:" + NSPoint_tp + ulong_tp
    )

    def NSPointArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andunsignedlonglongArg_ = objc.selector(
        NSPointArg_andunsignedlonglongArg_, signature=b"@@:" + NSPoint_tp + b"Q"
    )

    def NSPointArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andfloatArg_ = objc.selector(
        NSPointArg_andfloatArg_, signature=b"@@:" + NSPoint_tp + b"f"
    )

    def NSPointArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_anddoubleArg_ = objc.selector(
        NSPointArg_anddoubleArg_, signature=b"@@:" + NSPoint_tp + b"d"
    )

    def NSPointArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andidArg_ = objc.selector(
        NSPointArg_andidArg_, signature=b"@@:" + NSPoint_tp + b"@"
    )

    def NSPointArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    NSPointArg_andcharPtrArg_ = objc.selector(
        NSPointArg_andcharPtrArg_, signature=b"@@:" + NSPoint_tp + b"*"
    )

    def NSPointArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andNSPointArg_ = objc.selector(
        NSPointArg_andNSPointArg_, signature=b"@@:" + NSPoint_tp + NSPoint_tp
    )

    def NSPointArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andNSRectArg_ = objc.selector(
        NSPointArg_andNSRectArg_, signature=b"@@:" + NSPoint_tp + NSRect_tp
    )

    def NSPointArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andstructTestStruct1Arg_ = objc.selector(
        NSPointArg_andstructTestStruct1Arg_,
        signature=b"@@:" + NSPoint_tp + b"{_TestStruct1=ii[5s]}",
    )

    def NSPointArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andstructTestStruct2Arg_ = objc.selector(
        NSPointArg_andstructTestStruct2Arg_,
        signature=b"@@:" + NSPoint_tp + b"{_TestStruct2=id[5s]}",
    )

    def NSPointArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andstructTestStruct3Arg_ = objc.selector(
        NSPointArg_andstructTestStruct3Arg_,
        signature=b"@@:" + NSPoint_tp + b"{_TestStruct3=ci}",
    )

    def NSPointArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andstructTestStruct4Arg_ = objc.selector(
        NSPointArg_andstructTestStruct4Arg_,
        signature=b"@@:" + NSPoint_tp + b"{_TestStruct4=cq}",
    )

    def NSPointArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSPointArg_andstructTestStruct5Arg_ = objc.selector(
        NSPointArg_andstructTestStruct5Arg_,
        signature=b"@@:" + NSPoint_tp + b"{_TestStruct5=cd}",
    )

    def NSRectArg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andboolArg_ = objc.selector(
        NSRectArg_andboolArg_, signature=b"@@:" + NSRect_tp + b"B"
    )

    def NSRectArg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andBOOLArg_ = objc.selector(
        NSRectArg_andBOOLArg_, signature=b"@@:" + NSRect_tp + b"c"
    )

    def NSRectArg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andcharArg_ = objc.selector(
        NSRectArg_andcharArg_, signature=b"@@:" + NSRect_tp + b"c"
    )

    def NSRectArg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andsignedshortArg_ = objc.selector(
        NSRectArg_andsignedshortArg_, signature=b"@@:" + NSRect_tp + b"s"
    )

    def NSRectArg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andsignedintArg_ = objc.selector(
        NSRectArg_andsignedintArg_, signature=b"@@:" + NSRect_tp + b"i"
    )

    def NSRectArg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andsignedlongArg_ = objc.selector(
        NSRectArg_andsignedlongArg_, signature=b"@@:" + NSRect_tp + long_tp
    )

    def NSRectArg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andsignedlonglongArg_ = objc.selector(
        NSRectArg_andsignedlonglongArg_, signature=b"@@:" + NSRect_tp + b"q"
    )

    def NSRectArg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andunsignedcharArg_ = objc.selector(
        NSRectArg_andunsignedcharArg_, signature=b"@@:" + NSRect_tp + b"C"
    )

    def NSRectArg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andunsignedshortArg_ = objc.selector(
        NSRectArg_andunsignedshortArg_, signature=b"@@:" + NSRect_tp + b"S"
    )

    def NSRectArg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andunsignedintArg_ = objc.selector(
        NSRectArg_andunsignedintArg_, signature=b"@@:" + NSRect_tp + b"I"
    )

    def NSRectArg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andunsignedlongArg_ = objc.selector(
        NSRectArg_andunsignedlongArg_, signature=b"@@:" + NSRect_tp + ulong_tp
    )

    def NSRectArg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andunsignedlonglongArg_ = objc.selector(
        NSRectArg_andunsignedlonglongArg_, signature=b"@@:" + NSRect_tp + b"Q"
    )

    def NSRectArg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andfloatArg_ = objc.selector(
        NSRectArg_andfloatArg_, signature=b"@@:" + NSRect_tp + b"f"
    )

    def NSRectArg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_anddoubleArg_ = objc.selector(
        NSRectArg_anddoubleArg_, signature=b"@@:" + NSRect_tp + b"d"
    )

    def NSRectArg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andidArg_ = objc.selector(
        NSRectArg_andidArg_, signature=b"@@:" + NSRect_tp + b"@"
    )

    def NSRectArg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    NSRectArg_andcharPtrArg_ = objc.selector(
        NSRectArg_andcharPtrArg_, signature=b"@@:" + NSRect_tp + b"*"
    )

    def NSRectArg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andNSPointArg_ = objc.selector(
        NSRectArg_andNSPointArg_, signature=b"@@:" + NSRect_tp + NSPoint_tp
    )

    def NSRectArg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andNSRectArg_ = objc.selector(
        NSRectArg_andNSRectArg_, signature=b"@@:" + NSRect_tp + NSRect_tp
    )

    def NSRectArg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andstructTestStruct1Arg_ = objc.selector(
        NSRectArg_andstructTestStruct1Arg_,
        signature=b"@@:" + NSRect_tp + b"{_TestStruct1=ii[5s]}",
    )

    def NSRectArg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andstructTestStruct2Arg_ = objc.selector(
        NSRectArg_andstructTestStruct2Arg_,
        signature=b"@@:" + NSRect_tp + b"{_TestStruct2=id[5s]}",
    )

    def NSRectArg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andstructTestStruct3Arg_ = objc.selector(
        NSRectArg_andstructTestStruct3Arg_,
        signature=b"@@:" + NSRect_tp + b"{_TestStruct3=ci}",
    )

    def NSRectArg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andstructTestStruct4Arg_ = objc.selector(
        NSRectArg_andstructTestStruct4Arg_,
        signature=b"@@:" + NSRect_tp + b"{_TestStruct4=cq}",
    )

    def NSRectArg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    NSRectArg_andstructTestStruct5Arg_ = objc.selector(
        NSRectArg_andstructTestStruct5Arg_,
        signature=b"@@:" + NSRect_tp + b"{_TestStruct5=cd}",
    )

    def structTestStruct1Arg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andboolArg_ = objc.selector(
        structTestStruct1Arg_andboolArg_, signature=b"@@:{_TestStruct1=ii[5s]}B"
    )

    def structTestStruct1Arg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andBOOLArg_ = objc.selector(
        structTestStruct1Arg_andBOOLArg_, signature=b"@@:{_TestStruct1=ii[5s]}c"
    )

    def structTestStruct1Arg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andcharArg_ = objc.selector(
        structTestStruct1Arg_andcharArg_, signature=b"@@:{_TestStruct1=ii[5s]}c"
    )

    def structTestStruct1Arg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andsignedshortArg_ = objc.selector(
        structTestStruct1Arg_andsignedshortArg_, signature=b"@@:{_TestStruct1=ii[5s]}s"
    )

    def structTestStruct1Arg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andsignedintArg_ = objc.selector(
        structTestStruct1Arg_andsignedintArg_, signature=b"@@:{_TestStruct1=ii[5s]}i"
    )

    def structTestStruct1Arg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andsignedlongArg_ = objc.selector(
        structTestStruct1Arg_andsignedlongArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}" + long_tp,
    )

    def structTestStruct1Arg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andsignedlonglongArg_ = objc.selector(
        structTestStruct1Arg_andsignedlonglongArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}q",
    )

    def structTestStruct1Arg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andunsignedcharArg_ = objc.selector(
        structTestStruct1Arg_andunsignedcharArg_, signature=b"@@:{_TestStruct1=ii[5s]}C"
    )

    def structTestStruct1Arg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andunsignedshortArg_ = objc.selector(
        structTestStruct1Arg_andunsignedshortArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}S",
    )

    def structTestStruct1Arg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andunsignedintArg_ = objc.selector(
        structTestStruct1Arg_andunsignedintArg_, signature=b"@@:{_TestStruct1=ii[5s]}I"
    )

    def structTestStruct1Arg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andunsignedlongArg_ = objc.selector(
        structTestStruct1Arg_andunsignedlongArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}" + ulong_tp,
    )

    def structTestStruct1Arg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andunsignedlonglongArg_ = objc.selector(
        structTestStruct1Arg_andunsignedlonglongArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}Q",
    )

    def structTestStruct1Arg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andfloatArg_ = objc.selector(
        structTestStruct1Arg_andfloatArg_, signature=b"@@:{_TestStruct1=ii[5s]}f"
    )

    def structTestStruct1Arg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_anddoubleArg_ = objc.selector(
        structTestStruct1Arg_anddoubleArg_, signature=b"@@:{_TestStruct1=ii[5s]}d"
    )

    def structTestStruct1Arg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andidArg_ = objc.selector(
        structTestStruct1Arg_andidArg_, signature=b"@@:{_TestStruct1=ii[5s]}@"
    )

    def structTestStruct1Arg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    structTestStruct1Arg_andcharPtrArg_ = objc.selector(
        structTestStruct1Arg_andcharPtrArg_, signature=b"@@:{_TestStruct1=ii[5s]}*"
    )

    def structTestStruct1Arg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andNSPointArg_ = objc.selector(
        structTestStruct1Arg_andNSPointArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}" + NSPoint_tp,
    )

    def structTestStruct1Arg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andNSRectArg_ = objc.selector(
        structTestStruct1Arg_andNSRectArg_,
        signature=b"@@:{_TestStruct1=ii[5s]}" + NSRect_tp,
    )

    def structTestStruct1Arg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andstructTestStruct1Arg_ = objc.selector(
        structTestStruct1Arg_andstructTestStruct1Arg_,
        signature=b"@@:{_TestStruct1=ii[5s]}{_TestStruct1=ii[5s]}",
    )

    def structTestStruct1Arg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andstructTestStruct2Arg_ = objc.selector(
        structTestStruct1Arg_andstructTestStruct2Arg_,
        signature=b"@@:{_TestStruct1=ii[5s]}{_TestStruct2=id[5s]}",
    )

    def structTestStruct1Arg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andstructTestStruct3Arg_ = objc.selector(
        structTestStruct1Arg_andstructTestStruct3Arg_,
        signature=b"@@:{_TestStruct1=ii[5s]}{_TestStruct3=ci}",
    )

    def structTestStruct1Arg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andstructTestStruct4Arg_ = objc.selector(
        structTestStruct1Arg_andstructTestStruct4Arg_,
        signature=b"@@:{_TestStruct1=ii[5s]}{_TestStruct4=cq}",
    )

    def structTestStruct1Arg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct1Arg_andstructTestStruct5Arg_ = objc.selector(
        structTestStruct1Arg_andstructTestStruct5Arg_,
        signature=b"@@:{_TestStruct1=ii[5s]}{_TestStruct5=cd}",
    )

    def structTestStruct2Arg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andboolArg_ = objc.selector(
        structTestStruct2Arg_andboolArg_, signature=b"@@:{_TestStruct2=id[5s]}B"
    )

    def structTestStruct2Arg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andBOOLArg_ = objc.selector(
        structTestStruct2Arg_andBOOLArg_, signature=b"@@:{_TestStruct2=id[5s]}c"
    )

    def structTestStruct2Arg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andcharArg_ = objc.selector(
        structTestStruct2Arg_andcharArg_, signature=b"@@:{_TestStruct2=id[5s]}c"
    )

    def structTestStruct2Arg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andsignedshortArg_ = objc.selector(
        structTestStruct2Arg_andsignedshortArg_, signature=b"@@:{_TestStruct2=id[5s]}s"
    )

    def structTestStruct2Arg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andsignedintArg_ = objc.selector(
        structTestStruct2Arg_andsignedintArg_, signature=b"@@:{_TestStruct2=id[5s]}i"
    )

    def structTestStruct2Arg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andsignedlongArg_ = objc.selector(
        structTestStruct2Arg_andsignedlongArg_,
        signature=b"@@:{_TestStruct2=id[5s]}" + long_tp,
    )

    def structTestStruct2Arg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andsignedlonglongArg_ = objc.selector(
        structTestStruct2Arg_andsignedlonglongArg_,
        signature=b"@@:{_TestStruct2=id[5s]}q",
    )

    def structTestStruct2Arg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andunsignedcharArg_ = objc.selector(
        structTestStruct2Arg_andunsignedcharArg_, signature=b"@@:{_TestStruct2=id[5s]}C"
    )

    def structTestStruct2Arg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andunsignedshortArg_ = objc.selector(
        structTestStruct2Arg_andunsignedshortArg_,
        signature=b"@@:{_TestStruct2=id[5s]}S",
    )

    def structTestStruct2Arg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andunsignedintArg_ = objc.selector(
        structTestStruct2Arg_andunsignedintArg_, signature=b"@@:{_TestStruct2=id[5s]}I"
    )

    def structTestStruct2Arg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andunsignedlongArg_ = objc.selector(
        structTestStruct2Arg_andunsignedlongArg_,
        signature=b"@@:{_TestStruct2=id[5s]}" + ulong_tp,
    )

    def structTestStruct2Arg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andunsignedlonglongArg_ = objc.selector(
        structTestStruct2Arg_andunsignedlonglongArg_,
        signature=b"@@:{_TestStruct2=id[5s]}Q",
    )

    def structTestStruct2Arg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andfloatArg_ = objc.selector(
        structTestStruct2Arg_andfloatArg_, signature=b"@@:{_TestStruct2=id[5s]}f"
    )

    def structTestStruct2Arg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_anddoubleArg_ = objc.selector(
        structTestStruct2Arg_anddoubleArg_, signature=b"@@:{_TestStruct2=id[5s]}d"
    )

    def structTestStruct2Arg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andidArg_ = objc.selector(
        structTestStruct2Arg_andidArg_, signature=b"@@:{_TestStruct2=id[5s]}@"
    )

    def structTestStruct2Arg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    structTestStruct2Arg_andcharPtrArg_ = objc.selector(
        structTestStruct2Arg_andcharPtrArg_, signature=b"@@:{_TestStruct2=id[5s]}*"
    )

    def structTestStruct2Arg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andNSPointArg_ = objc.selector(
        structTestStruct2Arg_andNSPointArg_,
        signature=b"@@:{_TestStruct2=id[5s]}" + NSPoint_tp,
    )

    def structTestStruct2Arg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andNSRectArg_ = objc.selector(
        structTestStruct2Arg_andNSRectArg_,
        signature=b"@@:{_TestStruct2=id[5s]}" + NSRect_tp,
    )

    def structTestStruct2Arg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andstructTestStruct1Arg_ = objc.selector(
        structTestStruct2Arg_andstructTestStruct1Arg_,
        signature=b"@@:{_TestStruct2=id[5s]}{_TestStruct1=ii[5s]}",
    )

    def structTestStruct2Arg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andstructTestStruct2Arg_ = objc.selector(
        structTestStruct2Arg_andstructTestStruct2Arg_,
        signature=b"@@:{_TestStruct2=id[5s]}{_TestStruct2=id[5s]}",
    )

    def structTestStruct2Arg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andstructTestStruct3Arg_ = objc.selector(
        structTestStruct2Arg_andstructTestStruct3Arg_,
        signature=b"@@:{_TestStruct2=id[5s]}{_TestStruct3=ci}",
    )

    def structTestStruct2Arg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andstructTestStruct4Arg_ = objc.selector(
        structTestStruct2Arg_andstructTestStruct4Arg_,
        signature=b"@@:{_TestStruct2=id[5s]}{_TestStruct4=cq}",
    )

    def structTestStruct2Arg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct2Arg_andstructTestStruct5Arg_ = objc.selector(
        structTestStruct2Arg_andstructTestStruct5Arg_,
        signature=b"@@:{_TestStruct2=id[5s]}{_TestStruct5=cd}",
    )

    def structTestStruct3Arg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andboolArg_ = objc.selector(
        structTestStruct3Arg_andboolArg_, signature=b"@@:{_TestStruct3=ci}B"
    )

    def structTestStruct3Arg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andBOOLArg_ = objc.selector(
        structTestStruct3Arg_andBOOLArg_, signature=b"@@:{_TestStruct3=ci}c"
    )

    def structTestStruct3Arg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andcharArg_ = objc.selector(
        structTestStruct3Arg_andcharArg_, signature=b"@@:{_TestStruct3=ci}c"
    )

    def structTestStruct3Arg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andsignedshortArg_ = objc.selector(
        structTestStruct3Arg_andsignedshortArg_, signature=b"@@:{_TestStruct3=ci}s"
    )

    def structTestStruct3Arg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andsignedintArg_ = objc.selector(
        structTestStruct3Arg_andsignedintArg_, signature=b"@@:{_TestStruct3=ci}i"
    )

    def structTestStruct3Arg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andsignedlongArg_ = objc.selector(
        structTestStruct3Arg_andsignedlongArg_,
        signature=b"@@:{_TestStruct3=ci}" + long_tp,
    )

    def structTestStruct3Arg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andsignedlonglongArg_ = objc.selector(
        structTestStruct3Arg_andsignedlonglongArg_, signature=b"@@:{_TestStruct3=ci}q"
    )

    def structTestStruct3Arg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andunsignedcharArg_ = objc.selector(
        structTestStruct3Arg_andunsignedcharArg_, signature=b"@@:{_TestStruct3=ci}C"
    )

    def structTestStruct3Arg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andunsignedshortArg_ = objc.selector(
        structTestStruct3Arg_andunsignedshortArg_, signature=b"@@:{_TestStruct3=ci}S"
    )

    def structTestStruct3Arg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andunsignedintArg_ = objc.selector(
        structTestStruct3Arg_andunsignedintArg_, signature=b"@@:{_TestStruct3=ci}I"
    )

    def structTestStruct3Arg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andunsignedlongArg_ = objc.selector(
        structTestStruct3Arg_andunsignedlongArg_,
        signature=b"@@:{_TestStruct3=ci}" + ulong_tp,
    )

    def structTestStruct3Arg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andunsignedlonglongArg_ = objc.selector(
        structTestStruct3Arg_andunsignedlonglongArg_, signature=b"@@:{_TestStruct3=ci}Q"
    )

    def structTestStruct3Arg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andfloatArg_ = objc.selector(
        structTestStruct3Arg_andfloatArg_, signature=b"@@:{_TestStruct3=ci}f"
    )

    def structTestStruct3Arg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_anddoubleArg_ = objc.selector(
        structTestStruct3Arg_anddoubleArg_, signature=b"@@:{_TestStruct3=ci}d"
    )

    def structTestStruct3Arg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andidArg_ = objc.selector(
        structTestStruct3Arg_andidArg_, signature=b"@@:{_TestStruct3=ci}@"
    )

    def structTestStruct3Arg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    structTestStruct3Arg_andcharPtrArg_ = objc.selector(
        structTestStruct3Arg_andcharPtrArg_, signature=b"@@:{_TestStruct3=ci}*"
    )

    def structTestStruct3Arg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andNSPointArg_ = objc.selector(
        structTestStruct3Arg_andNSPointArg_,
        signature=b"@@:{_TestStruct3=ci}" + NSPoint_tp,
    )

    def structTestStruct3Arg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andNSRectArg_ = objc.selector(
        structTestStruct3Arg_andNSRectArg_,
        signature=b"@@:{_TestStruct3=ci}" + NSRect_tp,
    )

    def structTestStruct3Arg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andstructTestStruct1Arg_ = objc.selector(
        structTestStruct3Arg_andstructTestStruct1Arg_,
        signature=b"@@:{_TestStruct3=ci}{_TestStruct1=ii[5s]}",
    )

    def structTestStruct3Arg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andstructTestStruct2Arg_ = objc.selector(
        structTestStruct3Arg_andstructTestStruct2Arg_,
        signature=b"@@:{_TestStruct3=ci}{_TestStruct2=id[5s]}",
    )

    def structTestStruct3Arg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andstructTestStruct3Arg_ = objc.selector(
        structTestStruct3Arg_andstructTestStruct3Arg_,
        signature=b"@@:{_TestStruct3=ci}{_TestStruct3=ci}",
    )

    def structTestStruct3Arg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andstructTestStruct4Arg_ = objc.selector(
        structTestStruct3Arg_andstructTestStruct4Arg_,
        signature=b"@@:{_TestStruct3=ci}{_TestStruct4=cq}",
    )

    def structTestStruct3Arg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct3Arg_andstructTestStruct5Arg_ = objc.selector(
        structTestStruct3Arg_andstructTestStruct5Arg_,
        signature=b"@@:{_TestStruct3=ci}{_TestStruct5=cd}",
    )

    def structTestStruct4Arg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andboolArg_ = objc.selector(
        structTestStruct4Arg_andboolArg_, signature=b"@@:{_TestStruct4=cq}B"
    )

    def structTestStruct4Arg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andBOOLArg_ = objc.selector(
        structTestStruct4Arg_andBOOLArg_, signature=b"@@:{_TestStruct4=cq}c"
    )

    def structTestStruct4Arg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andcharArg_ = objc.selector(
        structTestStruct4Arg_andcharArg_, signature=b"@@:{_TestStruct4=cq}c"
    )

    def structTestStruct4Arg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andsignedshortArg_ = objc.selector(
        structTestStruct4Arg_andsignedshortArg_, signature=b"@@:{_TestStruct4=cq}s"
    )

    def structTestStruct4Arg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andsignedintArg_ = objc.selector(
        structTestStruct4Arg_andsignedintArg_, signature=b"@@:{_TestStruct4=cq}i"
    )

    def structTestStruct4Arg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andsignedlongArg_ = objc.selector(
        structTestStruct4Arg_andsignedlongArg_,
        signature=b"@@:{_TestStruct4=cq}" + long_tp,
    )

    def structTestStruct4Arg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andsignedlonglongArg_ = objc.selector(
        structTestStruct4Arg_andsignedlonglongArg_, signature=b"@@:{_TestStruct4=cq}q"
    )

    def structTestStruct4Arg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andunsignedcharArg_ = objc.selector(
        structTestStruct4Arg_andunsignedcharArg_, signature=b"@@:{_TestStruct4=cq}C"
    )

    def structTestStruct4Arg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andunsignedshortArg_ = objc.selector(
        structTestStruct4Arg_andunsignedshortArg_, signature=b"@@:{_TestStruct4=cq}S"
    )

    def structTestStruct4Arg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andunsignedintArg_ = objc.selector(
        structTestStruct4Arg_andunsignedintArg_, signature=b"@@:{_TestStruct4=cq}I"
    )

    def structTestStruct4Arg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andunsignedlongArg_ = objc.selector(
        structTestStruct4Arg_andunsignedlongArg_,
        signature=b"@@:{_TestStruct4=cq}" + ulong_tp,
    )

    def structTestStruct4Arg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andunsignedlonglongArg_ = objc.selector(
        structTestStruct4Arg_andunsignedlonglongArg_, signature=b"@@:{_TestStruct4=cq}Q"
    )

    def structTestStruct4Arg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andfloatArg_ = objc.selector(
        structTestStruct4Arg_andfloatArg_, signature=b"@@:{_TestStruct4=cq}f"
    )

    def structTestStruct4Arg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_anddoubleArg_ = objc.selector(
        structTestStruct4Arg_anddoubleArg_, signature=b"@@:{_TestStruct4=cq}d"
    )

    def structTestStruct4Arg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andidArg_ = objc.selector(
        structTestStruct4Arg_andidArg_, signature=b"@@:{_TestStruct4=cq}@"
    )

    def structTestStruct4Arg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    structTestStruct4Arg_andcharPtrArg_ = objc.selector(
        structTestStruct4Arg_andcharPtrArg_, signature=b"@@:{_TestStruct4=cq}*"
    )

    def structTestStruct4Arg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andNSPointArg_ = objc.selector(
        structTestStruct4Arg_andNSPointArg_,
        signature=b"@@:{_TestStruct4=cq}" + NSPoint_tp,
    )

    def structTestStruct4Arg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andNSRectArg_ = objc.selector(
        structTestStruct4Arg_andNSRectArg_,
        signature=b"@@:{_TestStruct4=cq}" + NSRect_tp,
    )

    def structTestStruct4Arg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andstructTestStruct1Arg_ = objc.selector(
        structTestStruct4Arg_andstructTestStruct1Arg_,
        signature=b"@@:{_TestStruct4=cq}{_TestStruct1=ii[5s]}",
    )

    def structTestStruct4Arg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andstructTestStruct2Arg_ = objc.selector(
        structTestStruct4Arg_andstructTestStruct2Arg_,
        signature=b"@@:{_TestStruct4=cq}{_TestStruct2=id[5s]}",
    )

    def structTestStruct4Arg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andstructTestStruct3Arg_ = objc.selector(
        structTestStruct4Arg_andstructTestStruct3Arg_,
        signature=b"@@:{_TestStruct4=cq}{_TestStruct3=ci}",
    )

    def structTestStruct4Arg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andstructTestStruct4Arg_ = objc.selector(
        structTestStruct4Arg_andstructTestStruct4Arg_,
        signature=b"@@:{_TestStruct4=cq}{_TestStruct4=cq}",
    )

    def structTestStruct4Arg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct4Arg_andstructTestStruct5Arg_ = objc.selector(
        structTestStruct4Arg_andstructTestStruct5Arg_,
        signature=b"@@:{_TestStruct4=cq}{_TestStruct5=cd}",
    )

    def structTestStruct5Arg_andboolArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andboolArg_ = objc.selector(
        structTestStruct5Arg_andboolArg_, signature=b"@@:{_TestStruct5=cd}B"
    )

    def structTestStruct5Arg_andBOOLArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andBOOLArg_ = objc.selector(
        structTestStruct5Arg_andBOOLArg_, signature=b"@@:{_TestStruct5=cd}c"
    )

    def structTestStruct5Arg_andcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andcharArg_ = objc.selector(
        structTestStruct5Arg_andcharArg_, signature=b"@@:{_TestStruct5=cd}c"
    )

    def structTestStruct5Arg_andsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andsignedshortArg_ = objc.selector(
        structTestStruct5Arg_andsignedshortArg_, signature=b"@@:{_TestStruct5=cd}s"
    )

    def structTestStruct5Arg_andsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andsignedintArg_ = objc.selector(
        structTestStruct5Arg_andsignedintArg_, signature=b"@@:{_TestStruct5=cd}i"
    )

    def structTestStruct5Arg_andsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andsignedlongArg_ = objc.selector(
        structTestStruct5Arg_andsignedlongArg_,
        signature=b"@@:{_TestStruct5=cd}" + long_tp,
    )

    def structTestStruct5Arg_andsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andsignedlonglongArg_ = objc.selector(
        structTestStruct5Arg_andsignedlonglongArg_, signature=b"@@:{_TestStruct5=cd}q"
    )

    def structTestStruct5Arg_andunsignedcharArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andunsignedcharArg_ = objc.selector(
        structTestStruct5Arg_andunsignedcharArg_, signature=b"@@:{_TestStruct5=cd}C"
    )

    def structTestStruct5Arg_andunsignedshortArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andunsignedshortArg_ = objc.selector(
        structTestStruct5Arg_andunsignedshortArg_, signature=b"@@:{_TestStruct5=cd}S"
    )

    def structTestStruct5Arg_andunsignedintArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andunsignedintArg_ = objc.selector(
        structTestStruct5Arg_andunsignedintArg_, signature=b"@@:{_TestStruct5=cd}I"
    )

    def structTestStruct5Arg_andunsignedlongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andunsignedlongArg_ = objc.selector(
        structTestStruct5Arg_andunsignedlongArg_,
        signature=b"@@:{_TestStruct5=cd}" + ulong_tp,
    )

    def structTestStruct5Arg_andunsignedlonglongArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andunsignedlonglongArg_ = objc.selector(
        structTestStruct5Arg_andunsignedlonglongArg_, signature=b"@@:{_TestStruct5=cd}Q"
    )

    def structTestStruct5Arg_andfloatArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andfloatArg_ = objc.selector(
        structTestStruct5Arg_andfloatArg_, signature=b"@@:{_TestStruct5=cd}f"
    )

    def structTestStruct5Arg_anddoubleArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_anddoubleArg_ = objc.selector(
        structTestStruct5Arg_anddoubleArg_, signature=b"@@:{_TestStruct5=cd}d"
    )

    def structTestStruct5Arg_andidArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andidArg_ = objc.selector(
        structTestStruct5Arg_andidArg_, signature=b"@@:{_TestStruct5=cd}@"
    )

    def structTestStruct5Arg_andcharPtrArg_(self, arg1, arg2):
        arg2 = str(arg2)
        return [arg1, arg2]

    structTestStruct5Arg_andcharPtrArg_ = objc.selector(
        structTestStruct5Arg_andcharPtrArg_, signature=b"@@:{_TestStruct5=cd}*"
    )

    def structTestStruct5Arg_andNSPointArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andNSPointArg_ = objc.selector(
        structTestStruct5Arg_andNSPointArg_,
        signature=b"@@:{_TestStruct5=cd}" + NSPoint_tp,
    )

    def structTestStruct5Arg_andNSRectArg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andNSRectArg_ = objc.selector(
        structTestStruct5Arg_andNSRectArg_,
        signature=b"@@:{_TestStruct5=cd}" + NSRect_tp,
    )

    def structTestStruct5Arg_andstructTestStruct1Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andstructTestStruct1Arg_ = objc.selector(
        structTestStruct5Arg_andstructTestStruct1Arg_,
        signature=b"@@:{_TestStruct5=cd}{_TestStruct1=ii[5s]}",
    )

    def structTestStruct5Arg_andstructTestStruct2Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andstructTestStruct2Arg_ = objc.selector(
        structTestStruct5Arg_andstructTestStruct2Arg_,
        signature=b"@@:{_TestStruct5=cd}{_TestStruct2=id[5s]}",
    )

    def structTestStruct5Arg_andstructTestStruct3Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andstructTestStruct3Arg_ = objc.selector(
        structTestStruct5Arg_andstructTestStruct3Arg_,
        signature=b"@@:{_TestStruct5=cd}{_TestStruct3=ci}",
    )

    def structTestStruct5Arg_andstructTestStruct4Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andstructTestStruct4Arg_ = objc.selector(
        structTestStruct5Arg_andstructTestStruct4Arg_,
        signature=b"@@:{_TestStruct5=cd}{_TestStruct4=cq}",
    )

    def structTestStruct5Arg_andstructTestStruct5Arg_(self, arg1, arg2):
        return [arg1, arg2]

    structTestStruct5Arg_andstructTestStruct5Arg_ = objc.selector(
        structTestStruct5Arg_andstructTestStruct5Arg_,
        signature=b"@@:{_TestStruct5=cd}{_TestStruct5=cd}",
    )

    def boolInArg_(self, arg):
        return arg  # return the same

    boolInArg_ = objc.selector(boolInArg_, signature=b"@@:n^B")

    def boolOutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_bool_values[self.counter]
        self.counter += 1
        return res

    boolOutArg_ = objc.selector(boolOutArg_, signature=b"v@:o^B")

    def boolInOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_bool_values[self.counter]
        self.counter += 1
        return (arg, res)

    boolInOutArg_ = objc.selector(boolInOutArg_, signature=b"@@:N^B")

    def BOOLInArg_(self, arg):
        return arg  # return the same

    BOOLInArg_ = objc.selector(BOOLInArg_, signature=b"@@:n^c")

    def BOOLOutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_BOOL_values[self.counter]
        self.counter += 1
        return res

    BOOLOutArg_ = objc.selector(BOOLOutArg_, signature=b"v@:o^c")

    def BOOLInOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_BOOL_values[self.counter]
        self.counter += 1
        return (arg, res)

    BOOLInOutArg_ = objc.selector(BOOLInOutArg_, signature=b"@@:N^c")

    def charInArg_(self, arg):
        return arg  # return the same

    charInArg_ = objc.selector(charInArg_, signature=b"@@:n^c")

    def charOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_char_values[self.counter]
        self.counter += 1
        return res

    charOutArg_ = objc.selector(charOutArg_, signature=b"v@:o^c")

    def charInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_char_values[self.counter]
        self.counter += 1
        return (arg, res)

    charInOutArg_ = objc.selector(charInOutArg_, signature=b"@@:N^c")

    def signedshortInArg_(self, arg):
        return arg  # return the same

    signedshortInArg_ = objc.selector(signedshortInArg_, signature=b"@@:n^s")

    def signedshortOutArg_(self, arg):
        assert arg is None
        if self.counter > 5:
            self.reset()
        res = g_signedshort_values[self.counter]
        self.counter += 1
        return res

    signedshortOutArg_ = objc.selector(signedshortOutArg_, signature=b"v@:o^s")

    def signedshortInOutArg_(self, arg):
        if self.counter > 5:
            self.reset()
        res = g_signedshort_values[self.counter]
        self.counter += 1
        return (arg, res)

    signedshortInOutArg_ = objc.selector(signedshortInOutArg_, signature=b"@@:N^s")

    def signedintInArg_(self, arg):
        return arg  # return the same

    signedintInArg_ = objc.selector(signedintInArg_, signature=b"@@:n^i")

    def signedintOutArg_(self, arg):
        assert arg is None
        if self.counter > 5:
            self.reset()
        res = g_signedint_values[self.counter]
        self.counter += 1
        return res

    signedintOutArg_ = objc.selector(signedintOutArg_, signature=b"v@:o^i")

    def signedintInOutArg_(self, arg):
        if self.counter > 5:
            self.reset()
        res = g_signedint_values[self.counter]
        self.counter += 1
        return (arg, res)

    signedintInOutArg_ = objc.selector(signedintInOutArg_, signature=b"@@:N^i")

    def signedlongInArg_(self, arg):
        return arg  # return the same

    signedlongInArg_ = objc.selector(signedlongInArg_, signature=b"@@:n^" + long_tp)

    def signedlongOutArg_(self, arg):
        assert arg is None
        if self.counter > 5:
            self.reset()
        res = g_signedlong_values[self.counter]
        self.counter += 1
        return res

    signedlongOutArg_ = objc.selector(signedlongOutArg_, signature=b"v@:o^" + long_tp)

    def signedlongInOutArg_(self, arg):
        if self.counter > 5:
            self.reset()
        res = g_signedlong_values[self.counter]
        self.counter += 1
        return (arg, res)

    signedlongInOutArg_ = objc.selector(
        signedlongInOutArg_, signature=b"@@:N^" + long_tp
    )

    def signedlonglongInArg_(self, arg):
        return arg  # return the same

    signedlonglongInArg_ = objc.selector(signedlonglongInArg_, signature=b"@@:n^q")

    def signedlonglongOutArg_(self, arg):
        assert arg is None
        if self.counter > 5:
            self.reset()
        res = g_signedlonglong_values[self.counter]
        self.counter += 1
        return res

    signedlonglongOutArg_ = objc.selector(signedlonglongOutArg_, signature=b"v@:o^q")

    def signedlonglongInOutArg_(self, arg):
        if self.counter > 5:
            self.reset()
        res = g_signedlonglong_values[self.counter]
        self.counter += 1
        return (arg, res)

    signedlonglongInOutArg_ = objc.selector(
        signedlonglongInOutArg_, signature=b"@@:N^q"
    )

    def unsignedcharInArg_(self, arg):
        return arg  # return the same

    unsignedcharInArg_ = objc.selector(unsignedcharInArg_, signature=b"@@:n^C")

    def unsignedcharOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_unsignedchar_values[self.counter]
        self.counter += 1
        return res

    unsignedcharOutArg_ = objc.selector(unsignedcharOutArg_, signature=b"v@:o^C")

    def unsignedcharInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_unsignedchar_values[self.counter]
        self.counter += 1
        return (arg, res)

    unsignedcharInOutArg_ = objc.selector(unsignedcharInOutArg_, signature=b"@@:N^C")

    def unsignedshortInArg_(self, arg):
        return arg  # return the same

    unsignedshortInArg_ = objc.selector(unsignedshortInArg_, signature=b"@@:n^S")

    def unsignedshortOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_unsignedshort_values[self.counter]
        self.counter += 1
        return res

    unsignedshortOutArg_ = objc.selector(unsignedshortOutArg_, signature=b"v@:o^S")

    def unsignedshortInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_unsignedshort_values[self.counter]
        self.counter += 1
        return (arg, res)

    unsignedshortInOutArg_ = objc.selector(unsignedshortInOutArg_, signature=b"@@:N^S")

    def unsignedintInArg_(self, arg):
        return arg  # return the same

    unsignedintInArg_ = objc.selector(unsignedintInArg_, signature=b"@@:n^I")

    def unsignedintOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_unsignedint_values[self.counter]
        self.counter += 1
        return res

    unsignedintOutArg_ = objc.selector(unsignedintOutArg_, signature=b"v@:o^I")

    def unsignedintInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_unsignedint_values[self.counter]
        self.counter += 1
        return (arg, res)

    unsignedintInOutArg_ = objc.selector(unsignedintInOutArg_, signature=b"@@:N^I")

    def unsignedlongInArg_(self, arg):
        return arg  # return the same

    unsignedlongInArg_ = objc.selector(
        unsignedlongInArg_, signature=b"@@:n^" + ulong_tp
    )

    def unsignedlongOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_unsignedlong_values[self.counter]
        self.counter += 1
        return res

    unsignedlongOutArg_ = objc.selector(
        unsignedlongOutArg_, signature=b"v@:o^" + ulong_tp
    )

    def unsignedlongInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_unsignedlong_values[self.counter]
        self.counter += 1
        return (arg, res)

    unsignedlongInOutArg_ = objc.selector(
        unsignedlongInOutArg_, signature=b"@@:N^" + ulong_tp
    )

    def unsignedlonglongInArg_(self, arg):
        return arg  # return the same

    unsignedlonglongInArg_ = objc.selector(unsignedlonglongInArg_, signature=b"@@:n^Q")

    def unsignedlonglongOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_unsignedlonglong_values[self.counter]
        self.counter += 1
        return res

    unsignedlonglongOutArg_ = objc.selector(
        unsignedlonglongOutArg_, signature=b"v@:o^Q"
    )

    def unsignedlonglongInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_unsignedlonglong_values[self.counter]
        self.counter += 1
        return (arg, res)

    unsignedlonglongInOutArg_ = objc.selector(
        unsignedlonglongInOutArg_, signature=b"@@:N^Q"
    )

    def floatInArg_(self, arg):
        return arg  # return the same

    floatInArg_ = objc.selector(floatInArg_, signature=b"@@:n^f")

    def floatOutArg_(self, arg):
        assert arg is None
        if self.counter > 4:
            self.reset()
        res = g_float_values[self.counter]
        self.counter += 1
        return res

    floatOutArg_ = objc.selector(floatOutArg_, signature=b"v@:o^f")

    def floatInOutArg_(self, arg):
        if self.counter > 4:
            self.reset()
        res = g_float_values[self.counter]
        self.counter += 1
        return (arg, res)

    floatInOutArg_ = objc.selector(floatInOutArg_, signature=b"@@:N^f")

    def doubleInArg_(self, arg):
        return arg  # return the same

    doubleInArg_ = objc.selector(doubleInArg_, signature=b"@@:n^d")

    def doubleOutArg_(self, arg):
        assert arg is None
        if self.counter > 4:
            self.reset()
        res = g_double_values[self.counter]
        self.counter += 1
        return res

    doubleOutArg_ = objc.selector(doubleOutArg_, signature=b"v@:o^d")

    def doubleInOutArg_(self, arg):
        if self.counter > 4:
            self.reset()
        res = g_double_values[self.counter]
        self.counter += 1
        return (arg, res)

    doubleInOutArg_ = objc.selector(doubleInOutArg_, signature=b"@@:N^d")

    def idInArg_(self, arg):
        return arg  # return the same

    idInArg_ = objc.selector(idInArg_, signature=b"@@:n^@")

    def idOutArg_(self, arg):
        assert arg is None
        if self.counter > 1:
            self.reset()
        res = g_id_values[self.counter]
        self.counter += 1
        return res

    idOutArg_ = objc.selector(idOutArg_, signature=b"v@:o^@")

    def idInOutArg_(self, arg):
        if self.counter > 1:
            self.reset()
        res = g_id_values[self.counter]
        self.counter += 1
        return (arg, res)

    idInOutArg_ = objc.selector(idInOutArg_, signature=b"@@:N^@")

    def charPtrInArg_(self, arg):
        return str(arg)  # return the value as str

    charPtrInArg_ = objc.selector(charPtrInArg_, signature=b"@@:n^*")

    def charPtrOutArg_(self, arg):
        assert arg is None
        if self.counter > 3:
            self.reset()
        res = g_charPtr_values[self.counter]
        self.counter += 1
        return res

    charPtrOutArg_ = objc.selector(charPtrOutArg_, signature=b"v@:o^*")

    def charPtrInOutArg_(self, arg):
        if self.counter > 3:
            self.reset()
        res = g_charPtr_values[self.counter]
        self.counter += 1
        return (arg, res)

    charPtrInOutArg_ = objc.selector(charPtrInOutArg_, signature=b"@@:N^*")

    def NSPointInArg_(self, arg):
        return arg  # return the same

    NSPointInArg_ = objc.selector(NSPointInArg_, signature=b"@@:n^" + NSPoint_tp)

    def NSPointOutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_NSPoint_values[self.counter]
        self.counter += 1
        return res

    NSPointOutArg_ = objc.selector(NSPointOutArg_, signature=b"v@:o^" + NSPoint_tp)

    def NSPointInOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_NSPoint_values[self.counter]
        self.counter += 1
        return (arg, res)

    NSPointInOutArg_ = objc.selector(NSPointInOutArg_, signature=b"@@:N^" + NSPoint_tp)

    def NSRectInArg_(self, arg):
        return arg  # return the same

    NSRectInArg_ = objc.selector(NSRectInArg_, signature=b"@@:n^" + NSRect_tp)

    def NSRectOutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_NSRect_values[self.counter]
        self.counter += 1
        return res

    NSRectOutArg_ = objc.selector(NSRectOutArg_, signature=b"v@:o^" + NSRect_tp)

    def NSRectInOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_NSRect_values[self.counter]
        self.counter += 1
        return (arg, res)

    NSRectInOutArg_ = objc.selector(NSRectInOutArg_, signature=b"@@:N^" + NSRect_tp)

    def structTestStruct1InArg_(self, arg):
        return arg  # return the same

    structTestStruct1InArg_ = objc.selector(
        structTestStruct1InArg_, signature=b"@@:n^{_TestStruct1=ii[5s]}"
    )

    def structTestStruct1OutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct1_values[self.counter]
        self.counter += 1
        return res

    structTestStruct1OutArg_ = objc.selector(
        structTestStruct1OutArg_, signature=b"v@:o^{_TestStruct1=ii[5s]}"
    )

    def structTestStruct1InOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct1_values[self.counter]
        self.counter += 1
        return (arg, res)

    structTestStruct1InOutArg_ = objc.selector(
        structTestStruct1InOutArg_, signature=b"@@:N^{_TestStruct1=ii[5s]}"
    )

    def structTestStruct2InArg_(self, arg):
        return arg  # return the same

    structTestStruct2InArg_ = objc.selector(
        structTestStruct2InArg_, signature=b"@@:n^{_TestStruct2=id[5s]}"
    )

    def structTestStruct2OutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct2_values[self.counter]
        self.counter += 1
        return res

    structTestStruct2OutArg_ = objc.selector(
        structTestStruct2OutArg_, signature=b"v@:o^{_TestStruct2=id[5s]}"
    )

    def structTestStruct2InOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct2_values[self.counter]
        self.counter += 1
        return (arg, res)

    structTestStruct2InOutArg_ = objc.selector(
        structTestStruct2InOutArg_, signature=b"@@:N^{_TestStruct2=id[5s]}"
    )

    def structTestStruct3InArg_(self, arg):
        return arg  # return the same

    structTestStruct3InArg_ = objc.selector(
        structTestStruct3InArg_, signature=b"@@:n^{_TestStruct3=ci}"
    )

    def structTestStruct3OutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct3_values[self.counter]
        self.counter += 1
        return res

    structTestStruct3OutArg_ = objc.selector(
        structTestStruct3OutArg_, signature=b"v@:o^{_TestStruct3=ci}"
    )

    def structTestStruct3InOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct3_values[self.counter]
        self.counter += 1
        return (arg, res)

    structTestStruct3InOutArg_ = objc.selector(
        structTestStruct3InOutArg_, signature=b"@@:N^{_TestStruct3=ci}"
    )

    def structTestStruct4InArg_(self, arg):
        return arg  # return the same

    structTestStruct4InArg_ = objc.selector(
        structTestStruct4InArg_, signature=b"@@:n^{_TestStruct4=cq}"
    )

    def structTestStruct4OutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct4_values[self.counter]
        self.counter += 1
        return res

    structTestStruct4OutArg_ = objc.selector(
        structTestStruct4OutArg_, signature=b"v@:o^{_TestStruct4=cq}"
    )

    def structTestStruct4InOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct4_values[self.counter]
        self.counter += 1
        return (arg, res)

    structTestStruct4InOutArg_ = objc.selector(
        structTestStruct4InOutArg_, signature=b"@@:N^{_TestStruct4=cq}"
    )

    def structTestStruct5InArg_(self, arg):
        return arg  # return the same

    structTestStruct5InArg_ = objc.selector(
        structTestStruct5InArg_, signature=b"@@:n^{_TestStruct5=cd}"
    )

    def structTestStruct5OutArg_(self, arg):
        assert arg is None
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct5_values[self.counter]
        self.counter += 1
        return res

    structTestStruct5OutArg_ = objc.selector(
        structTestStruct5OutArg_, signature=b"v@:o^{_TestStruct5=cd}"
    )

    def structTestStruct5InOutArg_(self, arg):
        if self.counter > 2:
            self.reset()
        res = g_structTestStruct5_values[self.counter]
        self.counter += 1
        return (arg, res)

    structTestStruct5InOutArg_ = objc.selector(
        structTestStruct5InOutArg_, signature=b"@@:N^{_TestStruct5=cd}"
    )


class ObjCToPy(TestCase):
    # Test calling Python from Objective-C
    # Simple returns from instance methods

    def testcallboolResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callboolMethodOf_(o), YES)
        self.assertEqual(PyObjC_TestClass2.callboolMethodOf_(o), NO)

    def testinvokeboolResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeboolMethodOf_(o), YES)
        self.assertEqual(PyObjC_TestClass2.invokeboolMethodOf_(o), NO)

    def testcallBOOLResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callBOOLMethodOf_(o), YES)
        self.assertEqual(PyObjC_TestClass2.callBOOLMethodOf_(o), NO)

    def testinvokeBOOLResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeBOOLMethodOf_(o), YES)
        self.assertEqual(PyObjC_TestClass2.invokeBOOLMethodOf_(o), NO)

    def testcallcharResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callcharMethodOf_(o), -128)
        self.assertEqual(PyObjC_TestClass2.callcharMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callcharMethodOf_(o), 127)

    def testinvokecharResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokecharMethodOf_(o), -128)
        self.assertEqual(PyObjC_TestClass2.invokecharMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokecharMethodOf_(o), 127)

    def testcallsignedshortResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callsignedshortMethodOf_(o), -(1 << 14))
        self.assertEqual(PyObjC_TestClass2.callsignedshortMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.callsignedshortMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callsignedshortMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callsignedshortMethodOf_(o), 1 << 14)

    def testinvokesignedshortResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokesignedshortMethodOf_(o), -(1 << 14))
        self.assertEqual(PyObjC_TestClass2.invokesignedshortMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 1 << 14)

    def testcallsignedintResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callsignedintMethodOf_(o), -(1 << 30))
        self.assertEqual(PyObjC_TestClass2.callsignedintMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.callsignedintMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callsignedintMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callsignedintMethodOf_(o), 1 << 30)

    def testinvokesignedintResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokesignedintMethodOf_(o), -(1 << 30))
        self.assertEqual(PyObjC_TestClass2.invokesignedintMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.invokesignedintMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokesignedintMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokesignedintMethodOf_(o), 1 << 30)

    def testcallsignedlongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callsignedlongMethodOf_(o), -(1 << 30))
        self.assertEqual(PyObjC_TestClass2.callsignedlongMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.callsignedlongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callsignedlongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callsignedlongMethodOf_(o), 1 << 30)

    def testinvokesignedlongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokesignedlongMethodOf_(o), -(1 << 30))
        self.assertEqual(PyObjC_TestClass2.invokesignedlongMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 1 << 30)

    def testcallsignedlonglongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), -(1 << 60))
        self.assertEqual(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 1 << 60)

    def testinvokesignedlonglongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), -(1 << 60))
        self.assertEqual(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), -42)
        self.assertEqual(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 1 << 60)

    def testcallunsignedcharResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 128)
        self.assertEqual(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 255)

    def testinvokeunsignedcharResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 128)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 255)

    def testcallunsignedshortResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 1 << 14)

    def testinvokeunsignedshortResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 1 << 14)

    def testcallunsignedintResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callunsignedintMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callunsignedintMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callunsignedintMethodOf_(o), 1 << 30)

    def testinvokeunsignedintResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 1 << 30)

    def testcallunsignedlongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 1 << 30)

    def testinvokeunsignedlongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 1 << 30)

    def testcallunsignedlonglongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 1 << 62)

    def testinvokeunsignedlonglongResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 0)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 42)
        self.assertEqual(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 1 << 62)

    def testcallfloatResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(PyObjC_TestClass2.callfloatMethodOf_(o), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass2.callfloatMethodOf_(o), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass2.callfloatMethodOf_(o), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass2.callfloatMethodOf_(o), 1e10)

    def testinvokefloatResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(PyObjC_TestClass2.invokefloatMethodOf_(o), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass2.invokefloatMethodOf_(o), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass2.invokefloatMethodOf_(o), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass2.invokefloatMethodOf_(o), 1e10)

    def testcalldoubleResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(PyObjC_TestClass2.calldoubleMethodOf_(o), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass2.calldoubleMethodOf_(o), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass2.calldoubleMethodOf_(o), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass2.calldoubleMethodOf_(o), 1e10)

    def testinvokedoubleResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertAlmostEqual(PyObjC_TestClass2.invokedoubleMethodOf_(o), 0.128)
        self.assertAlmostEqual(PyObjC_TestClass2.invokedoubleMethodOf_(o), 1.0)
        self.assertAlmostEqual(PyObjC_TestClass2.invokedoubleMethodOf_(o), 42.0)
        self.assertAlmostEqual(PyObjC_TestClass2.invokedoubleMethodOf_(o), 1e10)

    def testcallidResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callidMethodOf_(o), NSPriorDayDesignations)

    def testinvokeidResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeidMethodOf_(o), NSPriorDayDesignations)

    def testcallcharPtrResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callcharPtrMethodOf_(o), b"hello")
        self.assertEqual(PyObjC_TestClass2.callcharPtrMethodOf_(o), b"world")
        self.assertEqual(PyObjC_TestClass2.callcharPtrMethodOf_(o), b"foobar")

    def testinvokecharPtrResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokecharPtrMethodOf_(o), (b"hello"))
        self.assertEqual(PyObjC_TestClass2.invokecharPtrMethodOf_(o), (b"world"))
        self.assertEqual(PyObjC_TestClass2.invokecharPtrMethodOf_(o), (b"foobar"))

    def testcallNSPointResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callNSPointMethodOf_(o), (1, 2))
        self.assertEqual(PyObjC_TestClass2.callNSPointMethodOf_(o), (3, 4))

    def testinvokeNSPointResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeNSPointMethodOf_(o), (1, 2))
        self.assertEqual(PyObjC_TestClass2.invokeNSPointMethodOf_(o), (3, 4))

    def testcallNSRectResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callNSRectMethodOf_(o), ((1, 2), (3, 4)))
        self.assertEqual(PyObjC_TestClass2.callNSRectMethodOf_(o), ((7, 8), (9, 10)))

    def testinvokeNSRectResult(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokeNSRectMethodOf_(o), ((1, 2), (3, 4)))
        self.assertEqual(PyObjC_TestClass2.invokeNSRectMethodOf_(o), ((7, 8), (9, 10)))

    def testcallstructTestStruct1Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.callstructTestStruct1MethodOf_(o), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(
            PyObjC_TestClass2.callstructTestStruct1MethodOf_(o),
            (9, 8, (-1, -2, -3, -4, -5)),
        )

    def testinvokestructTestStruct1Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct1MethodOf_(o),
            (1, 2, (1, 2, 3, 4, 5)),
        )
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct1MethodOf_(o),
            (9, 8, (-1, -2, -3, -4, -5)),
        )

    def testcallstructTestStruct2Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.callstructTestStruct2MethodOf_(o), (1, 2, (1, 2, 3, 4, 5))
        )
        self.assertEqual(
            PyObjC_TestClass2.callstructTestStruct2MethodOf_(o),
            (9, 8, (-1, -2, -3, -4, -5)),
        )

    def testinvokestructTestStruct2Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct2MethodOf_(o),
            (1, 2, (1, 2, 3, 4, 5)),
        )
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct2MethodOf_(o),
            (9, 8, (-1, -2, -3, -4, -5)),
        )

    def testcallstructTestStruct3Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callstructTestStruct3MethodOf_(o), (1, 2))
        self.assertEqual(PyObjC_TestClass2.callstructTestStruct3MethodOf_(o), (2, 4))

    def testinvokestructTestStruct3Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.invokestructTestStruct3MethodOf_(o), (1, 2))
        self.assertEqual(PyObjC_TestClass2.invokestructTestStruct3MethodOf_(o), (2, 4))

    def testcallstructTestStruct4Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.callstructTestStruct4MethodOf_(o), (1, 1 << 60)
        )
        self.assertEqual(PyObjC_TestClass2.callstructTestStruct4MethodOf_(o), (2, 4))

    def testinvokestructTestStruct4Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct4MethodOf_(o), (1, 1 << 60)
        )
        self.assertEqual(PyObjC_TestClass2.invokestructTestStruct4MethodOf_(o), (2, 4))

    def testcallstructTestStruct5Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(PyObjC_TestClass2.callstructTestStruct5MethodOf_(o), (1, 2.5))
        self.assertEqual(PyObjC_TestClass2.callstructTestStruct5MethodOf_(o), (2, 4.5))

    def testinvokestructTestStruct5Result(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        o.reset()
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct5MethodOf_(o), (1, 2.5)
        )
        self.assertEqual(
            PyObjC_TestClass2.invokestructTestStruct5MethodOf_(o), (2, 4.5)
        )

    # One argument

    def testcallboolArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_of_(YES, o)
        self.assertEqual(r, YES)
        r = PyObjC_TestClass2.invokeboolArg_of_(NO, o)
        self.assertEqual(r, NO)

    def testinvokeboolArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_of_(YES, o)
        self.assertEqual(r, YES)
        r = PyObjC_TestClass2.invokeboolArg_of_(NO, o)
        self.assertEqual(r, NO)

    def testcallBOOLArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeBOOLArg_of_(YES, o)
        self.assertEqual(r, YES)
        r = PyObjC_TestClass2.invokeBOOLArg_of_(NO, o)
        self.assertEqual(r, NO)

    def testinvokeBOOLArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeBOOLArg_of_(YES, o)
        self.assertEqual(r, YES)
        r = PyObjC_TestClass2.invokeBOOLArg_of_(NO, o)
        self.assertEqual(r, NO)

    def testcallcharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokecharArg_of_(-128, o)
        self.assertEqual(r, -128)
        r = PyObjC_TestClass2.invokecharArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokecharArg_of_(127, o)
        self.assertEqual(r, 127)

    def testinvokecharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokecharArg_of_(-128, o)
        self.assertEqual(r, -128)
        r = PyObjC_TestClass2.invokecharArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokecharArg_of_(127, o)
        self.assertEqual(r, 127)

    def testcallsignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(-(1 << 14), o)
        self.assertEqual(r, -(1 << 14))
        r = PyObjC_TestClass2.invokesignedshortArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(1 << 14, o)
        self.assertEqual(r, 1 << 14)

    def testinvokesignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(-(1 << 14), o)
        self.assertEqual(r, -(1 << 14))
        r = PyObjC_TestClass2.invokesignedshortArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedshortArg_of_(1 << 14, o)
        self.assertEqual(r, 1 << 14)

    def testcallsignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedintArg_of_(-(1 << 30), o)
        self.assertEqual(r, -(1 << 30))
        r = PyObjC_TestClass2.invokesignedintArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedintArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedintArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedintArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testinvokesignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedintArg_of_(-(1 << 30), o)
        self.assertEqual(r, -(1 << 30))
        r = PyObjC_TestClass2.invokesignedintArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedintArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedintArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedintArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testcallsignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(-(1 << 30), o)
        self.assertEqual(r, -(1 << 30))
        r = PyObjC_TestClass2.invokesignedlongArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testinvokesignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(-(1 << 30), o)
        self.assertEqual(r, -(1 << 30))
        r = PyObjC_TestClass2.invokesignedlongArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedlongArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testcallsignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-(1 << 60), o)
        self.assertEqual(r, -(1 << 60))
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(1 << 60, o)
        self.assertEqual(r, 1 << 60)

    def testinvokesignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-(1 << 60), o)
        self.assertEqual(r, -(1 << 60))
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-42, o)
        self.assertEqual(r, -42)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokesignedlonglongArg_of_(1 << 60, o)
        self.assertEqual(r, 1 << 60)

    def testcallunsignedcharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(128, o)
        self.assertEqual(r, 128)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(255, o)
        self.assertEqual(r, 255)

    def testinvokeunsignedcharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(128, o)
        self.assertEqual(r, 128)
        r = PyObjC_TestClass2.invokeunsignedcharArg_of_(255, o)
        self.assertEqual(r, 255)

    def testcallunsignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(1 << 14, o)
        self.assertEqual(r, 1 << 14)

    def testinvokeunsignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedshortArg_of_(1 << 14, o)
        self.assertEqual(r, 1 << 14)

    def testcallunsignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testinvokeunsignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedintArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testcallunsignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testinvokeunsignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedlongArg_of_(1 << 30, o)
        self.assertEqual(r, 1 << 30)

    def testcallunsignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(1 << 62, o)
        self.assertEqual(r, 1 << 62)

    def testinvokeunsignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(0, o)
        self.assertEqual(r, 0)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(42, o)
        self.assertEqual(r, 42)
        r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(1 << 62, o)
        self.assertEqual(r, 1 << 62)

    def testcallfloatArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokefloatArg_of_(0.128, o)
        self.assertAlmostEqual(r, 0.128)
        r = PyObjC_TestClass2.invokefloatArg_of_(1.0, o)
        self.assertAlmostEqual(r, 1.0)
        r = PyObjC_TestClass2.invokefloatArg_of_(42.0, o)
        self.assertAlmostEqual(r, 42.0)
        r = PyObjC_TestClass2.invokefloatArg_of_(1e10, o)
        self.assertAlmostEqual(r, 1e10)

    def testinvokefloatArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokefloatArg_of_(0.128, o)
        self.assertAlmostEqual(r, 0.128)
        r = PyObjC_TestClass2.invokefloatArg_of_(1.0, o)
        self.assertAlmostEqual(r, 1.0)
        r = PyObjC_TestClass2.invokefloatArg_of_(42.0, o)
        self.assertAlmostEqual(r, 42.0)
        r = PyObjC_TestClass2.invokefloatArg_of_(1e10, o)
        self.assertAlmostEqual(r, 1e10)

    def testcalldoubleArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokedoubleArg_of_(0.128, o)
        self.assertAlmostEqual(r, 0.128)
        r = PyObjC_TestClass2.invokedoubleArg_of_(1.0, o)
        self.assertAlmostEqual(r, 1.0)
        r = PyObjC_TestClass2.invokedoubleArg_of_(42.0, o)
        self.assertAlmostEqual(r, 42.0)
        r = PyObjC_TestClass2.invokedoubleArg_of_(1e10, o)
        self.assertAlmostEqual(r, 1e10)

    def testinvokedoubleArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokedoubleArg_of_(0.128, o)
        self.assertAlmostEqual(r, 0.128)
        r = PyObjC_TestClass2.invokedoubleArg_of_(1.0, o)
        self.assertAlmostEqual(r, 1.0)
        r = PyObjC_TestClass2.invokedoubleArg_of_(42.0, o)
        self.assertAlmostEqual(r, 42.0)
        r = PyObjC_TestClass2.invokedoubleArg_of_(1e10, o)
        self.assertAlmostEqual(r, 1e10)

    def testcallidArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeidArg_of_(NSPriorDayDesignations, o)
        self.assertEqual(r, NSPriorDayDesignations)

    def testinvokeidArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeidArg_of_(NSPriorDayDesignations, o)
        self.assertEqual(r, NSPriorDayDesignations)

    def testcallcharPtrArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"hello", o)
        self.assertEqual(r, str(b"hello"))
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"world", o)
        self.assertEqual(r, str(b"world"))
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"foobar", o)
        self.assertEqual(r, str(b"foobar"))

    def testinvokecharPtrArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"hello", o)
        self.assertEqual(r, str(b"hello"))
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"world", o)
        self.assertEqual(r, str(b"world"))
        r = PyObjC_TestClass2.invokecharPtrArg_of_(b"foobar", o)
        self.assertEqual(r, str(b"foobar"))

    def testcallNSPointArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeNSPointArg_of_((1, 2), o)
        self.assertEqual(r, (1, 2))
        r = PyObjC_TestClass2.invokeNSPointArg_of_((3, 4), o)
        self.assertEqual(r, (3, 4))

    def testinvokeNSPointArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeNSPointArg_of_((1, 2), o)
        self.assertEqual(r, (1, 2))
        r = PyObjC_TestClass2.invokeNSPointArg_of_((3, 4), o)
        self.assertEqual(r, (3, 4))

    def testcallNSRectArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeNSRectArg_of_(((1, 2), (3, 4)), o)
        self.assertEqual(r, ((1, 2), (3, 4)))
        r = PyObjC_TestClass2.invokeNSRectArg_of_(((7, 8), (9, 10)), o)
        self.assertEqual(r, ((7, 8), (9, 10)))

    def testinvokeNSRectArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeNSRectArg_of_(((1, 2), (3, 4)), o)
        self.assertEqual(r, ((1, 2), (3, 4)))
        r = PyObjC_TestClass2.invokeNSRectArg_of_(((7, 8), (9, 10)), o)
        self.assertEqual(r, ((7, 8), (9, 10)))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testcallstructTestStruct1Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_(
            (9, 8, (-1, -2, -3, -4, -5)), o
        )
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testinvokestructTestStruct1Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_(
            (9, 8, (-1, -2, -3, -4, -5)), o
        )
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testcallstructTestStruct2Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_(
            (9, 8, (-1, -2, -3, -4, -5)), o
        )
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testinvokestructTestStruct2Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
        self.assertEqual(r, (1, 2, (1, 2, 3, 4, 5)))
        r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_(
            (9, 8, (-1, -2, -3, -4, -5)), o
        )
        self.assertEqual(r, (9, 8, (-1, -2, -3, -4, -5)))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testcallstructTestStruct3Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((1, 2), o)
        self.assertEqual(r, (1, 2))
        r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((2, 4), o)
        self.assertEqual(r, (2, 4))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testinvokestructTestStruct3Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((1, 2), o)
        self.assertEqual(r, (1, 2))
        r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((2, 4), o)
        self.assertEqual(r, (2, 4))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testcallstructTestStruct4Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((1, 1 << 60), o)
        self.assertEqual(r, (1, 1 << 60))
        r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((2, 4), o)
        self.assertEqual(r, (2, 4))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testinvokestructTestStruct4Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((1, 1 << 60), o)
        self.assertEqual(r, (1, 1 << 60))
        r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((2, 4), o)
        self.assertEqual(r, (2, 4))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testcallstructTestStruct5Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((1, 2.5), o)
        self.assertEqual(r, (1, 2.5))
        r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((2, 4.5), o)
        self.assertEqual(r, (2, 4.5))

    @onlyIf(nsinvoke_ok, "NSInvocation doesn't work with some structs")
    def testinvokestructTestStruct5Arg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((1, 2.5), o)
        self.assertEqual(r, (1, 2.5))
        r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((2, 4.5), o)
        self.assertEqual(r, (2, 4.5))

    # Two arguments

    def testcallboolAndboolArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andboolArg_of_(YES, YES, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.callboolArg_andboolArg_of_(YES, NO, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = PyObjC_TestClass2.callboolArg_andboolArg_of_(NO, YES, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.callboolArg_andboolArg_of_(NO, NO, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testinvokeboolAndboolArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(YES, YES, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(YES, NO, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(NO, YES, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(NO, NO, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testcallboolAndBOOLArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(YES, YES, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(YES, NO, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(NO, YES, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(NO, NO, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testinvokeboolAndBOOLArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(YES, YES, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(YES, NO, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], NO)
        r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(NO, YES, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], YES)
        r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(NO, NO, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], NO)

    def testcallboolAndcharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, -128, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -128)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, 127, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 127)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, -128, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -128)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, 127, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 127)

    def testinvokeboolAndcharArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, -128, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -128)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, 127, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 127)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, -128, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -128)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, 127, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 127)

    def testcallboolAndsignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, -(1 << 14), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 14))
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 1 << 14, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, -(1 << 14), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 14))
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 1 << 14, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testinvokeboolAndsignedshortArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, -(1 << 14), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 14))
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 1 << 14, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 14)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, -(1 << 14), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 14))
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 1 << 14, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 14)

    def testcallboolAndsignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, -(1 << 30), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 1 << 30, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, -(1 << 30), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 1 << 30, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testinvokeboolAndsignedintArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, -(1 << 30), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 1 << 30, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, -(1 << 30), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 1 << 30, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testcallboolAndsignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, -(1 << 30), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 1 << 30, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, -(1 << 30), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 1 << 30, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testinvokeboolAndsignedlongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, -(1 << 30), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 1 << 30, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 30)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, -(1 << 30), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 30))
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 1 << 30, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 30)

    def testcallboolAndsignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, -(1 << 60), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 60))
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 1 << 60, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 60)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, -(1 << 60), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 60))
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 1 << 60, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 1 << 60)

    def testinvokeboolAndsignedlonglongArg(self):
        o = Python_TestClass.alloc().init()
        self.assertIsNotNone(o)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, -(1 << 60), o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -(1 << 60))
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, -42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 0, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 42, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 1 << 60, o)
        self.assertEqual(r[0], YES)
        self.assertEqual(r[1], 1 << 60)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, -(1 << 60), o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -(1 << 60))
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, -42, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], -42)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, 0, o)
        self.assertEqual(r[0], NO)
        self.assertEqual(r[1], 0)
        r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(N