# -*- coding: utf-8 -*-
# Copyright 2016 Yelp
# Copyright 2017 Yelp
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Job that runs a single spark JAR, specified on the command line."""

from mrjob.job import MRJob
from mrjob.step import SparkJarStep


class MRSparkJar(MRJob):

    def configure_args(self):
        super(MRSparkJar, self).configure_args()

        self.add_passthru_arg(
            '--jar', dest='jar')
        self.add_passthru_arg(
            '--jar-main-class', dest='jar_main_class')
        self.add_passthru_arg(
            '--jar-arg', dest='jar_args',
            action='append', default=[])
        self.add_passthru_arg(
            '--jar-spark-arg', dest='jar_spark_args',
            action='append', default=[])

    def steps(self):
        return [SparkJarStep(
            jar=self.options.jar,
            main_class=self.options.jar_main_class,
            args=self.options.jar_args,
            spark_args=self.options.jar_spark_args,
        )]


if __name__ == '__main__':
    MRSparkJar.run()
