'use strict';

const cssTree = require('css-tree');

const ATKEYWORD = cssTree.tokenTypes.AtKeyword;

const name = 'LessVariable';
const structure = {
    name: 'Identifier'
};
function parse() {
    const start = this.tokenStart;

    this.eat(ATKEYWORD);

    return {
        type: 'LessVariable',
        loc: this.getLocation(start, this.tokenEnd),
        name: this.substrToCursor(start + 1)
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
