function make
%MAKE Make PRIMME's Matlab module

   % Get the path of this directory
   [p,~,~] = fileparts(mfilename('fullpath'));

   % Save the current path and changed the working path to here
   w = pwd;
   cd(p);

   flags = {'-O', '-I../include', '-I../src/include'};
   libs = {};
   
   % If not is Windows, add underscore for blas/lapack calls
   if ~ispc
      flags{end+1} = '-DF77UNDERSCORE';
   end

   % If using octave, blas/lapack' int is 32bits and they are linked by default
   if ~exist('OCTAVE_VERSION')
      flags{end+1} = '-DPRIMME_BLASINT_SIZE=64';
      % If is Windows, add the paths to blas/lapack libraries
      if ispc
         libs{end+1} = ['-L' fullfile(matlabroot,'extern','lib','win64','mingw64')];
         libs{end+1} = ['-L' fullfile(matlabroot,'extern','lib','win64','microsoft')];
      end
      libs{end+1} = '-lmwlapack';
      libs{end+1} = '-lmwblas';
   end

   % Sources
   sources = { '../src/eigs/auxiliary_eigs.c', ...
               '../src/eigs/auxiliary_eigs_normal.c', ...
               '../src/eigs/convergence.c', ...
               '../src/eigs/correction.c', ...
               '../src/eigs/factorize.c', ...
               '../src/eigs/init.c', ...
               '../src/eigs/inner_solve.c', ...
               '../src/eigs/main_iter.c', ...
               '../src/eigs/ortho.c', ...
               '../src/eigs/primme_c.c', ...
               '../src/eigs/primme_f77.c', ...
               '../src/eigs/primme_interface.c', ...
               '../src/eigs/restart.c', ...
               '../src/eigs/solve_projection.c', ...
               '../src/eigs/update_projection.c', ...
               '../src/eigs/update_W.c', ...
               '../src/linalg/auxiliary.c', ...
               '../src/linalg/blaslapack.c', ...
               '../src/linalg/magma_wrapper.c', ...
               '../src/linalg/memman.c', ...
               '../src/linalg/wtime.c', ...
               '../src/svds/primme_svds_c.c', ...
               '../src/svds/primme_svds_f77.c', ...
               '../src/svds/primme_svds_interface.c', ...
               'primme_mex.cpp'};

   % Compile PRIMME
   try
      mex(flags{:}, sources{:}, '-largeArrayDims', libs{:}, '-output', 'primme_mex');
   catch me
      cd(w);
      rethrow(me);
   end

   % Change back the current path
   cd(w)
