--
-- tests/actions/vstudio/sln2026/test_dependencies.lua
-- Validate generation of Visual Studio 2026+ solution project dependencies.
-- Author Nick Clark
-- Copyright (c) 2025 Jess Perkins and the Premake project
--

local p = premake
local suite = test.declare("vstudio_sln2026_dependencies")
local sln2026 = p.vstudio.sln2026


function suite.setup()
	p.action.set("vs2026")
end


function suite.solution_header()
	sln2026.solution()

	test.capture [[
<Solution Description="Visual Studio slnx file generated by Premake" Version="1.4">
	]]
end


function suite.default_configurations()
	local wks = workspace "MyWorkspace"

	sln2026.configurations(wks)

	test.capture [[
<Configurations>
</Configurations>
	]]
end


function suite.multiple_configurations()
	local wks = workspace "MyWorkspace"

	configurations { "Debug", "Release" }

	sln2026.configurations(wks)

	test.capture [[
<Configurations>
	<BuildType Name="Debug" />
	<BuildType Name="Release" />
	<Platform Name="Win32" />
</Configurations>
	]]
end


function suite.default_platforms()
	local wks = workspace "MyWorkspace"

	sln2026.configurations(wks)

	test.capture [[
<Configurations>
</Configurations>
	]]
end


function suite.multiple_platforms()
	local wks = workspace "MyWorkspace"

	configurations { "Debug" }
	platforms { "x86", "x64" }

	sln2026.configurations(wks)

	test.capture [[
<Configurations>
	<BuildType Name="Debug" />
	<Platform Name="Win32" />
	<Platform Name="x64" />
</Configurations>
	]]
end
