/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.examples.util.TempFileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.temp.AesZipFileZipEntrySource;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class LoadPasswordProtectedXlsx {
    private LoadPasswordProtectedXlsx() {
    }

    public static void main(String[] args) throws Exception {
        LoadPasswordProtectedXlsx.execute(args, LoadPasswordProtectedXlsx::printSheetCount);
    }

    public static void execute(String[] args, EncryptionHandler handler) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected 2 params: filename and password");
        }
        TempFileUtils.checkTempFiles();
        String filename = args[0];
        String password = args[1];
        try (FileInputStream fis = new FileInputStream(filename);
             POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);){
            EncryptionInfo info = new EncryptionInfo(fs);
            Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
            if (!d.verifyPassword(password)) {
                throw new RuntimeException("incorrect password");
            }
            try (InputStream unencryptedStream = d.getDataStream(fs);){
                handler.handle(unencryptedStream);
            }
        }
        TempFileUtils.checkTempFiles();
    }

    private static void printSheetCount(InputStream inputStream) throws Exception {
        try (AesZipFileZipEntrySource source = AesZipFileZipEntrySource.createZipEntrySource((InputStream)inputStream);
             OPCPackage pkg = OPCPackage.open((ZipEntrySource)source);
             XSSFWorkbook workbook = new XSSFWorkbook(pkg);){
            System.out.println("sheet count: " + workbook.getNumberOfSheets());
        }
    }

    public static interface EncryptionHandler {
        public void handle(InputStream var1) throws Exception;
    }
}

