@page CHANGES-2-9 Version 2.9
  
## Version 2.9 (May 25, 2023)

Changes from version 2.8 which are relevant for users:

- Changes leading to differences with previous versions:
  - Number of bins in \ref METAD, \ref PBMETAD and \ref sum_hills is now computed correctly
    when setting a spacing that divide exactly the range. See \issue{868}.
  - \ref SAXS in the ISDB module does not have the `SCALEINT` keyword anymore and the default normalisation of the intensity is to set the intensity at q=0 to 1.

- New contributed modules:
  - A new pytorch module by Luigi Bonati
     - \ref PYTORCH_MODEL
  - A new membranefusion model by Ary Lautaro Di Bartolo
     - \ref MEMFUSIONP
     - \ref FUSIONPORENUCLEATIONP
     - \ref FUSIONPOREEXPANSIONP

- Other improvements:
  - \ref PBMETAD now supports partitioned families bias thanks to @lemmoi @pfaendtner
  - Construction of atom lists have been optimized (see \issue{811}).
  - SimpleMD has been parallelized with OpenMP. Keyword `maxneighbor` has been removed (not needed anymore).
    In addition, SimpleMD now supports custom values for `epsilon` and `sigma`
  - \ref CENTER and \ref COM have new options `SET_CHARGE` and `SET_MASS` to assign them ad hoc charge and mass values
  - A tool to compute time-averaged bias potentials has been added in the python module (see `help(plumed.hills_time_average)`).

- New in LogMFD module:
  - `TEMPPD` keyword has been newly introduced, which allows for manually setting the temperature of the Boltzmann factor in the Jarzynski weight in LogPD.
  - The output format has been modified to present the CV data in a more consistent way.
  - The algorithm for evaluating the mean force at the initial MFD step has been modified to handle a continued MD trajectory that begins with non-zero timestep number.

- New in ISDB module:
  - the \ref SAXS CV now includes a new very efficient and accurate hybrid SAXS (hySAXS) algorithm that can be activated using the keyword `ONEBEAD`.
  - a new \ref SANS CV to calculate small-angles neutron scattering has been added, including both the `ATOMISTIC` and hySAXS `ONEBEAD` approaches.

- New in DRR module:
  - The module now writes the .zgrad file for inspecting and debugging the $\boldsymbol{\xi}$-averaged spring forces.

- New Patches:
  - Patch for GROMACS 2023 (preliminary, in particular for replica-exchange, expanded ensemble, hrex features). 
  - Patch for QEspresso 7.0 has been added.
  - Patch for GROMACS 2019 has been removed.

- Changes relevant for developers:
  - Nested exception can be passed to calling codes using C/C++/Fortran/Python interfaces \issue{879}.
  - Lepton has been updated with OpenMM 7.7.0
  - All explicit destructors that could be removed were removed, including in contributed modules. This might guarantee basic exception safety.
    Notice that this is not enforced, so that new code might violate this.
  - Improvements towards thread-safety:
    - Added thread-safe reference counter to wrapper.
    - Added locks for thread-unsafe molfile plugins.
  - Plumed patch now accepts the `--include` option. Might become the default in a future version.
  - Python (cython) wrappers now only use plain C instead of C++. Plumed exceptions are mapped to python exceptions.
  - Step number is now stored as a `long long int`. Might facilitate Windows compatibility.

## Version 2.9.1 (Jun 3, 2024)
- Includes all fixes up to 2.8.4
- Fixed a size check in python interface when passing native arrays.
  
## Version 2.9.2 (Sep 3, 2024)
  - Patch for GROMACS 2023 updated to the latest version
  - new patch for GROMACS 2024 
  - Small optimization of \ref COORDINATION and related collective variables (\issue{1096}).

## Version 2.9.3 (Jan 15, 2025)
  - Patch for GROMACS 2024 was updated to fix a big issue preventing its use

## Version 2.9.4 (May 23, 2025)
  - Fixed an issue that might lead to a crash when using multicolvars implemented with linked cells and no PBCs, apparently
    only showing up with Intel Mac. See \issue{1181}.
  - Fixed compatibility with cython 3.11. See \issue{1256}.
  - Small fixes to documentation.
  - Code reformatting, to maintain mergeability with v2.10, see \issue{1157}.
