import "pkl:test"

res1 = new Mapping {
  for (n: Int in IntSeq(1, 5)) {
    when (n.isOdd) {
      [n * 2] = n * 2
    }
  }
}

res1b = test.catch(() -> new Mapping {
  for (n: String in IntSeq(1, 5)) {
    when (n.isOdd) {
      [n * 2] = n * 2
    }
  }
})

res1c = new Mapping {
  for (i: Int, n: Int in IntSeq(1, 5)) {
    when (n.isOdd) {
      [i * n] = i * n
    }
  }
}

res1d = test.catch(() -> new Mapping {
  for (i: Int, n: String in IntSeq(1, 5)) {
    when (n.isOdd) {
      [i * n] = i * n
    }
  }
})

res2 = new Dynamic {
  for (n: Number in List(1, 2, 3, 4, 5)) {
    when (n.isOdd) {
      [n * 2] = n * 2
    }
  }
}

res2b = test.catch(() -> new Dynamic {
  for (n: Number in List(1, 2, "other", 4, 5)) {
    when (n.isOdd) {
      [n * 2] = n * 2
    }
  }
})

res2c = new Dynamic {
  for (i: Number, n: Number in List(1, 2, 3, 4, 5)) {
    when (n.isOdd) {
      [i * n] = i * n
    }
  }
}

res2d = test.catch(() -> new Dynamic {
  for (i: Number, n: Number in List(1, 2, "other", 4, 5)) {
    when (n.isOdd) {
      [i * n] = i * n
    }
  }
})

res6 = new Mapping {
  for (x: Any in List("a", "b", "c")) {
    for (y: String in List("e", "f")) {
      [x + y] = x + y
    }
  }
}

res6b = test.catch(() -> new Mapping {
  for (x: Any in List("a", "b", "c")) {
    for (y: String in List("e", 42)) {
      [x + y] = x + y
    }
  }
})

res6c = new Mapping {
  for (i1: Int, x: Any in List("a", "b", "c")) {
    for (i2: Number, y: String in List("e", "f")) {
      [x + y] = Pair(i1 + i2, x + y)
    }
  }
}

res6d = test.catch(() -> new Mapping {
  for (i1: Int, x: Any in List("a", "b", "c")) {
    for (i2: Number, y: String in List("e", 42)) {
      [x + y] = Pair(i1 + i2, x + y)
    }
  }
})

res7 = new Dynamic {
  ["one"] = 1
  for (n: Int in IntSeq(1, 5)) {
    when (n.isOdd) {
      [n * 2] = n * 2
    }
  }
  ["two"] = 2
  for (x: unknown in List("a", "b", "c")) {
    for (y: String in List("e", "f")) {
      [x + y] = x + y
    }
  }
  ["three"] = 3
}

res7b = test.catch(() -> new Dynamic {
  ["one"] = 1
  for (n: Int in IntSeq(1, 5)) {
    when (n.isOdd){
      [n * 2] = n * 2
    }
  }
  ["two"] = 2
  for (x: unknown in List("a", "b", "c")) {
    for (y: String in List(42, "f")) {
      [x + y] = x + y
    }
  }
  ["three"] = 3
})

// reuse same loop variable
res8 = new Mapping {
  for (n: Int in IntSeq(1, 3)) { [n] = n }
  for (n: String in List("a", "b", "c")) { [n] = n }
  for (n: Number in IntSeq(4, 6)) { [n] = n }
}

// reuse same loop variable
res8b = test.catch(() -> new Mapping {
  for (n: Int in IntSeq(1, 3)) { [n] = n }
  for (n: String in List(42.min, "b", "c")) { [n] = n }
  for (n: Number in IntSeq(4, 6)) { [n] = n }
})

// reuse same loop variable
res8c = new Mapping {
  for (i: Int, n: Int in IntSeq(1, 3)) { [n] = Pair(i, n) }
  for (i: Number, n: String in List("a", "b", "c")) { [n] = Pair(i, n) }
  for (i: Int, n: Number in IntSeq(4, 6)) { [n] = Pair(i, n) }
}

// reuse same loop variable
res8d = test.catch(() -> new Mapping {
  for (i: Int, n: Int in IntSeq(1, 3)) { [n] = Pair(i, n) }
  for (i: Number, n: String in List(42.min, "b", "c")) { [n] = Pair(i, n) }
  for (i: Int, n: Number in IntSeq(4, 6)) { [n] = Pair(i, n) }
})
forWithMultipleMembers = new Dynamic {
  for (ch: String in List("a", "b", "c")) {
    [ch] = ch
    [ch + "x"] = ch + "x"
    [ch + "y"] = ch + "y"
  }
}

forWithMultipleMembersNested = new Dynamic {
  for (ch: String in List("a", "b")) {
    for (k: String, v: Int in Map("x", 1, "y", 2)) {
      [ch + k + v.toString()] = ch + k + v.toString()
      [v.toString() + k + ch] = v.toString() + k + ch
    }
    for (k: String, v: Number in Map("xx", 11, "yy", 22)) {
      [ch + k + v.toString()] = ch + k + v.toString()
      [v.toString() + k + ch] = v.toString() + k + ch
    }
  }
}

whenWithMultipleMembers = new Dynamic {
  for (i: Int, n: Int in new Listing { 1; 2; 3; 4; 5 }) {
    when (n.isOdd) {
      [(i + 1) * n] = (i + 1) * n
      [(i + 1) * n * 2] = (i + 1) * n * 2
    }
  }
}

whenWithMultipleMembersNested = new Mapping {
  for (i: Int, n: Int in new Listing { 1; 2; 3; 4; 5 }) {
    when (n.isOdd) {
      when (n > 3) {
        [(i + 1) * n] = (i + 1) * n
        [(i + 1) * n * 2] = (i + 1) * n * 2
      }
    }
  }
}

whenWithElse = new Dynamic {
  for (i: Int, n: Int in new Listing { 1; 2; 3; 4; 5 }) {
    when (n.isOdd) {
      [(i + 1) * n] = (i + 1) * n
      [(i + 1) * n * 2] = (i + 1) * n * 2
    } else {
      [((i + 1) * n).toString()] = ((i + 1) * n).toString()
      [((i + 1) * n * 2).toString()] = ((i + 1) * n * 2).toString()
    }
  }
}
