amends "../snippetTest.pkl"

facts {
  ["List"] {
    List(1, 2, 3) is List<Int>
    !(List(1, 2, 3) is List<String>)
    !(Set(1, 2, 3) is List<Int>)
  }

  ["Set"] {
    Set(1, 2, 3) is Set<Int>
    !(List(1, 2, 3) is Set<Int>)
    !(Set(1, 2, 3) is Set<String>)
  }

  ["Map"] {
    Map("Pigeon", 42, "Barn Owl", 21) is Map<String, Int>
    !(Map("Pigeon", 42, "Barn Owl", 21) is Map<Int, String>)
  }

  ["Listing"] {
    new Listing { 1; 2; 3 } is Listing<Int>
    !(new Listing { 1; 2; 3 } is Listing<String>)
  }

  ["Mapping"] {
    new Mapping { ["Pigeon"] = 42; ["Barn Owl"] = 21 } is Mapping<String, Int>
    !(new Listing { 1; 2; 3 } is Mapping<Int, String>)
    !(new Mapping { ["Pigeon"] = 42; ["Barn Owl"] = 21 } is Mapping<Int, String>)
  }

  ["union type"] {
    42 is Int|String
    42 is String|Int
    42 is Number|String
    !(42 is String|Duration)

    List(1, 2, 3) is List<String>|List<Int>
    List(1, 2, 3) is List<String|Int>
    !(List(1, 2, 3) is List<String>|Set<Int>)
  }

  ["nullable type"] {
    null is String?
    null is Map<String, Int>?
    !(null is Map<String, Int?>)
  }

  // currently only tests arity
  ["function type"] {
    ((x) -> x) is (Int) -> Int
    ((x) -> x) is (String) -> String
    !(((x, y) -> x) is (Int) -> Int)
  }

  ["string literal type"] {
    "Pigeon" is "Pigeon"|"Barn Owl"
    !("Pigeon" is "Piggy"|"Barn Owl")
  }

  ["constraint"] {
    "abc" is String(length == 3)
    List("a", "b", "c") is List<String(length == 1)>
    "abc" is String(this is String(this is String(length == 3)))
    !("abc" is String(length == 4))
  }
}
