import "pkl:test"

class Person {
  name: String
  age: Int
}

typealias Email = String

local renderer = new YamlRenderer {}

res1 = renderer.renderDocument(123)
res2 = renderer.renderDocument(1.23)
res3 = renderer.renderDocument(false)
res4 = renderer.renderDocument("pigeon")
res6 = renderer.renderDocument(List("pigeon", "parrot"))
res7 = renderer.renderDocument(Set("pigeon", "parrot"))
res8 = renderer.renderDocument(Map("name", "pigeon", "age", 42))
res9 = renderer.renderDocument(new Listing { "pigeon"; "parrot" })
res10 = renderer.renderDocument(new Mapping { ["name"] = "pigeon"; ["age"] = 42 })
res11 = renderer.renderDocument(new Dynamic { name = "pigeon"; age = 42 })
res12 = renderer.renderDocument(new Person { name = "pigeon"; age = 42 })
res13 = renderer.renderDocument(null)

res14 = test.catch(() -> renderer.renderDocument(1.min))
res15 = test.catch(() -> renderer.renderDocument(Pair(1, 2)))
res16 = test.catch(() -> renderer.renderDocument(1.mb))
res17 = test.catch(() -> renderer.renderDocument(Person))
res17b = test.catch(() -> renderer.renderDocument(Email))
res18 = test.catch(() -> renderer.renderDocument((x) -> x))
res19 = test.catch(() -> new YamlRenderer { converters { [Int] = (_) -> throw("ouch") } }.renderDocument(42))
res20 = test.catch(() -> renderer.renderDocument(IntSeq(1, 4)))
res21 = test.catch(() -> renderer.renderDocument(new Dynamic { foo = "foo"; 5 }))
res22 = test.catch(() -> renderer.renderDocument(new Dynamic { ["foo"] = "foo"; 5 }))
