amends "../snippetTest.pkl"

examples {
  ["construction"] {
    Regex("abc")
    Regex("abc") is Regex
  }

  ["pattern"] {
    Regex("").pattern
    Regex(#"(?i)abc"#).pattern
    Regex(#"a(\s*)b(\s*)c"#).pattern
    Regex(#"a(?:\s*)b\(c\)"#).pattern
  }

  ["groupCount"] {
    Regex("").groupCount
    Regex(#"(?i)abc"#).groupCount
    Regex(#"a(\s*)b(\s*)c"#).groupCount
    Regex(#"a(?:\s*)b\(c\)"#).groupCount
  }

  ["findMatchesIn()"] {
    Regex(#"\]\*\["#).findMatchesIn("[*] ... [*]")
    Regex(#"\[\*\]"#).findMatchesIn("[*] ... [*]")
    Regex(#""#).findMatchesIn("[*] ... [*]")
    Regex(#".*"#).findMatchesIn("[*] ... [*]")
    module.catch(() -> Regex(#"*"#).findMatchesIn("[*] ... [*]"))

    Regex(#"foo(\w*)bar(\w*)"#).findMatchesIn("fooPigeonbarBarnOwl")
    Regex(#"foo(\w*)bar(\w*)"#).findMatchesIn("other fooPigeonbarBarnOwl other fooParrotbarElfOwl")
    Regex(#"(abc)|(def)"#).findMatchesIn("xxxabcxxxdefxxxabc")

    Regex(#"\w+"#).findMatchesIn("!!!abc!!!def!!!").map((it) -> it.toString())
    Regex(#"(\w)(\w\w)"#).findMatchesIn("abc").single.groups.map((it) -> it.toString())
  }

  ["matchEntire()"] {
    Regex(#"(\d+)\w+"#).matchEntire("123abc")
    Regex(#"(\d+)\w+"#).matchEntire("123abc!!!")
  }
}
