res01 = "\t\n\u{000C}\r"         // i.e., \t\n\f\r
res02 =  "!#:=\\\t\n\u{000C}\r"  // almost all escapes (except leading space)
res03 = " !#:=\\\t\n\u{000C}\r"  // all escapes

// ASCII ranges splits in the following categories/counts of characters:
hidden escapedAscii = 9
hidden escapedUnicode = 29
hidden nonEscapedAscii = 90

res04 = escapedAscii*1 == renderAndCount(res02, false, (value) -> countCharacters(value))
res05 = escapedAscii*2 == renderAndCount(res02, true,  (value) -> countCharacters(value))

res06 = escapedAscii*0 + 1 == renderAndCount(res02, false, (value) -> countBackslashes(value))
res07 = escapedAscii*1 + 1 == renderAndCount(res02, true,  (value) -> countBackslashes(value))

res08 = "!#: =\\"        // value: not escaping middle space
res09 = "!#:=\\ "        // value: not escaping trailing space
res10 = " !#:=\\"        // value: escaping leading space

`!#: =\\` = "res11"      // key: escaping middle space
`!#:=\\ ` = "res12"      // key: escaping trailing space
` !#:=\\` = "res13"      // key: escaping leading space

res14 = "\u{00}\u{01}\u{02}\u{03}\u{04}\u{05}\u{06}\u{07}\u{08}\t\n\u{0B}\u{0C}\r\u{0E}\u{0F}\u{10}\u{11}\u{12}\u{13}\u{14}\u{15}\u{16}\u{17}\u{18}\u{19}\u{1A}\u{1B}\u{1C}\u{1D}\u{1E}\u{1F} !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u{7F}"

res15 = escapedUnicode*1 + escapedAscii*1 + nonEscapedAscii*1 == renderAndCount(res14, false, (value) -> countCharacters(value))
res16 = escapedUnicode*1 + escapedAscii*2 + nonEscapedAscii*1 == renderAndCount(res14, true,  (value) -> countCharacters(value))

res17 = escapedUnicode*0 + escapedAscii*0 + 1 == renderAndCount(res14, false, (value) -> countBackslashes(value))
res18 = escapedUnicode*0 + escapedAscii*1 + 1 == renderAndCount(res14, true,  (value) -> countBackslashes(value))

output {
  renderer = new PropertiesRenderer {
    restrictCharset = false
  }
}

local function renderAndCount(value: String, render: Boolean, counter: (String) -> Int): Int =
  counter.apply(if (render) new PropertiesRenderer { restrictCharset = false }.renderValue(value) else value)

local function countCharacters(value: String): Int = value.length

local function countBackslashes(value: String): Int = value.chars.count((c) -> c == "\\")
