amends "../snippetTest.pkl"

import "pkl:math"

local id = (it) -> it

examples {
  ["construction"] {
    IntSeq(-3, 2)
    IntSeq(5, 5)
    IntSeq(5, 0)
    IntSeq(0, 0)
    IntSeq(0, 10)
    IntSeq(-10, 0)
  }

  ["construction with step"] {
    IntSeq(-3, 2).step(2)
    IntSeq(2, -3).step(-2)
    IntSeq(2, -3).step(-5)
    IntSeq(2, -3).step(-7)

    IntSeq(0, 1).step(math.minInt)
    IntSeq(math.maxInt, math.minInt).step(math.minInt)
    IntSeq(math.minInt, math.maxInt).step(math.maxInt)

    module.catch(() -> IntSeq(-3, 2).step(0))
  }

  ["start"] {
    IntSeq(-3, 2).start
    IntSeq(2, -3).start
  }

  ["end"] {
    IntSeq(-3, 2).end
    IntSeq(2, -3).end
  }

  ["step"] {
    IntSeq(-3, 2).step
    IntSeq(-3, 2).step(2).step
    IntSeq(2, -3).step
    IntSeq(2, -3).step(-2).step
  }

  ["fold"] {
    IntSeq(-3, 2).fold(List(), (l, e) -> l.add(e))
    IntSeq(5, 5).fold(List(), (l, e) -> l.add(e))
    IntSeq(5, 0).fold(List(), (l, e) -> l.add(e))
    IntSeq(0, 0).fold(List(), (l, e) -> l.add(e))
    IntSeq(0, 10).fold(List(), (l, e) -> l.add(e))
    IntSeq(-10, 0).fold(List(), (l, e) -> l.add(e))

    IntSeq(-3, 2).step(2).fold(List(), (l, e) -> l.add(e))
    IntSeq(2, -3).step(-2).fold(List(), (l, e) -> l.add(e))
    IntSeq(2, -3).step(-5).fold(List(), (l, e) -> l.add(e))
    IntSeq(2, -3).step(-7).fold(List(), (l, e) -> l.add(e))
  }

  ["map"] {
    IntSeq(-3, 2).map(id)
    IntSeq(5, 5).map(id)
    IntSeq(5, 0).map(id)
    IntSeq(0, 0).map(id)
    IntSeq(0, 10).map(id)
    IntSeq(-10, 0).map(id)

    IntSeq(-3, 2).step(2).map(id)
    IntSeq(2, -3).step(-2).map(id)
    IntSeq(2, -3).step(-5).map(id)
    IntSeq(2, -3).step(-7).map(id)

    IntSeq(0, 1).step(math.minInt).map(id)
    IntSeq(math.maxInt, math.minInt).step(math.minInt).map(id)
    IntSeq(math.minInt, math.maxInt).step(math.maxInt).map(id)
  }

  ["cannot instantiate"] {
    module.catch(() -> new IntSeq {})
  }

  ["toList"] {
    IntSeq(0, 3).toList() == List(0, 1, 2, 3)
    IntSeq(-3, 2).step(2).toList() == List(-3, -1, 1)
    IntSeq(5, 1).step(-2).toList() == List(5, 3, 1)
  }

  ["toListing"] {
    IntSeq(0, 3).toListing() == new Listing { 0; 1; 2; 3 }
    IntSeq(-3, 2).step(2).toListing() == new Listing { -3; -1; 1 }
    IntSeq(5, 1).step(-2).toListing() == new Listing { 5; 3; 1 }
  }
}
