/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.pdfbox.util.TextPosition;

public class PDFText2HTML
extends PDFTextStripper {
    private static final int INITIAL_PDF_TO_HTML_BYTES = 8192;
    private TextPosition beginTitle = null;
    private TextPosition afterEndTitle = null;
    private String titleGuess = "";
    private boolean suppressParagraphs = false;
    private boolean onFirstPage = true;

    protected void writeHeader() throws IOException {
        StringBuffer buf = new StringBuffer(8192);
        buf.append("<html><head>");
        buf.append("<title>");
        buf.append(this.getTitleGuess());
        buf.append("</title>");
        buf.append("</head>");
        buf.append("<body>\n");
        this.getOutput().write(buf.toString());
    }

    protected String getTitleGuess() {
        return this.titleGuess;
    }

    protected void flushText() throws IOException {
        Iterator textIter = this.getCharactersByArticle().iterator();
        if (this.onFirstPage) {
            this.guessTitle(textIter);
            this.writeHeader();
            this.onFirstPage = false;
        }
        super.flushText();
    }

    public void endDocument(PDDocument pdf) throws IOException {
        this.output.write("</body></html>");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TextPosition guessTitle(Iterator textIter) {
        float lastFontSize = -1.0f;
        int stringsInFont = 0;
        StringBuffer titleText = new StringBuffer();
        block0: while (textIter.hasNext()) {
            Iterator textByArticle = ((List)textIter.next()).iterator();
            while (true) {
                if (!textByArticle.hasNext()) continue block0;
                TextPosition position = (TextPosition)textByArticle.next();
                float currentFontSize = position.getFontSize();
                if (currentFontSize != lastFontSize) {
                    if (this.beginTitle != null) {
                        if (stringsInFont != 0) {
                            this.titleGuess = titleText.toString();
                            this.afterEndTitle = position;
                            return this.beginTitle;
                        }
                        this.beginTitle = null;
                        titleText.setLength(0);
                    } else if (currentFontSize > 13.0f) {
                        this.beginTitle = position;
                    }
                    lastFontSize = currentFontSize;
                    stringsInFont = 0;
                }
                ++stringsInFont;
                if (this.beginTitle == null) continue;
                titleText.append(position.getCharacter() + " ");
            }
            break;
        }
        return this.beginTitle;
    }

    protected void startParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.getOutput().write("<p>");
        }
    }

    protected void endParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.getOutput().write("</p>");
        }
    }

    protected void writeCharacters(TextPosition position) throws IOException {
        if (position == this.beginTitle) {
            this.output.write("<H1>");
            this.suppressParagraphs = true;
        }
        if (position == this.afterEndTitle) {
            this.output.write("</H1>");
            this.suppressParagraphs = false;
        }
        String chars = position.getCharacter();
        block6: for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                this.output.write("&#" + charAsInt + ";");
                continue;
            }
            switch (c) {
                case '\"': {
                    this.output.write("&quot;");
                    continue block6;
                }
                case '&': {
                    this.output.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.output.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.output.write("&gt;");
                    continue block6;
                }
                default: {
                    this.output.write(c);
                }
            }
        }
    }

    public boolean isSuppressParagraphs() {
        return this.suppressParagraphs;
    }

    public void setSuppressParagraphs(boolean shouldSuppressParagraphs) {
        this.suppressParagraphs = shouldSuppressParagraphs;
    }
}

