#include "qt_EventFilterSubject.h"

// Library headers.
#include <cassert>
#include <QObject>

// PCRaster library headers.

// Module headers.



/*!
  \file
  This file contains the implementation of the EventFilterSubject class.
*/



//------------------------------------------------------------------------------
// DEFINITION OF STATIC EVENTFILTERSUBJECT MEMBERS
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// DEFINITION OF EVENTFILTERSUBJECT MEMBERS
//------------------------------------------------------------------------------

//! Constructor.
/*!
  \param     filterSubject The actual, layered filter subject.
*/
qt::EventFilterSubject::EventFilterSubject(QObject* filterSubject)

  : d_filterSubject(filterSubject), d_filter(nullptr)

{
  assert(d_filterSubject);
}



//! Destructor.
/*!
  If a filter object is installed, we remove ourselves from it here. (This is
  not realy needed since qt will do it for us.)
*/
qt::EventFilterSubject::~EventFilterSubject()
{
  removeEventFilter();
}



//! Installs an event filter for this subject.
/*!
  \param     filter The event filter object.

  If an event filter already exists for this subject, it is removed first.

  This function calls redirectChildEventsTo(QObject*) with the same
  filter object.
*/
void qt::EventFilterSubject::redirectEventsTo(QObject* filter)
{
  removeEventFilter();

  assert(filter);
  d_filter = filter;
  d_filterSubject->installEventFilter(d_filter);

  redirectChildEventsTo(d_filter);
}



//! Installs the event filter on the child subjects.
/*!
  \param     filter The event filter object.
  \warning   First remove yourself from previous filters, if present!

  Override this if events generated by children have to be filtered too.

  The default does nothing.
*/
void qt::EventFilterSubject::redirectChildEventsTo(
                   QObject* /* filter */)
{
}



//! Removes the event filter from the child subjects.
/*!
  \param     filter The event filter object.

  Override this if events generated by children have been filtered too.

  The default does nothing.
*/
void qt::EventFilterSubject::removeChildEventFilter(QObject* /* filter */)
{
}



//! Removes the event subject from the filter.
/*!
*/
void qt::EventFilterSubject::removeEventFilter()
{
  if(d_filter) {
    d_filterSubject->removeEventFilter(d_filter);
    removeChildEventFilter(d_filter);
    d_filter = nullptr;
  }
}



//! Returns the layered filter subject.
/*!
  \return    Filter subject.
*/
QObject* qt::EventFilterSubject::eventFilterSubject() const
{
  return d_filterSubject;
}



//! Returns the filter.
/*!
  \return    Event filter or 0 if no filter is installed.
*/
const QObject* qt::EventFilterSubject::eventFilter() const
{
  return d_filter;
}



//------------------------------------------------------------------------------
// DEFINITION OF FREE OPERATORS
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// DEFINITION OF FREE FUNCTIONS
//------------------------------------------------------------------------------



