/*
 * Copyright (c) 2023, Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2023, IBM Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Note: the include below is not strictly required, as dependencies will be pulled using linker flags.
// Adding at least one #include removes unwanted warnings on some platforms.
#include <string.h>
#include <math.h>

// Addresses of functions to be referenced using static linking.
void* funcs[] = {
    //string.h
    &strlen,
    &strcat,
    //math.h
    &abs,
    &fabs,
    &fabsf,
    &fabsl,
    &fmod,
    &fmodf,
    &fmodl,
    &remainder,
    &remainderf,
    &remainderl,
    &remquo,
    &remquof,
    &remquol,
    &fma,
    &fmaf,
    &fmal,
    &fmax,
    &fmaxf,
    &fmaxl,
    &fmin,
    &fminf,
    &fminl,
    &fdim,
    &fdimf,
    &fdiml,
    &nan,
    &nanf,
    &nanl,
    &exp,
    &expf,
    &expl,
    &exp2,
    &exp2f,
    &exp2l,
    &expm1,
    &expm1f,
    &expm1l,
    &log,
    &logf,
    &logl,
    &log10,
    &log10f,
    &log10l,
    &log2,
    &log2f,
    &log2l,
    &log1p,
    &log1pf,
    &log1pl,
    &pow,
    &powf,
    &powl,
    &sqrt,
    &sqrtf,
    &sqrtl,
    &cbrt,
    &cbrtf,
    &cbrtl,
    &hypot,
    &hypotf,
    &hypotl,
    &sin,
    &sinf,
    &sinl,
    &cos,
    &cosf,
    &cosl,
    &tan,
    &tanf,
    &tanl,
    &asin,
    &asinf,
    &asinl,
    &acos,
    &acosf,
    &acosl,
    &atan,
    &atanf,
    &atanl,
    &atan2,
    &atan2f,
    &atan2l,
    &sinh,
    &sinhf,
    &sinhl,
    &cosh,
    &coshf,
    &coshl,
    &tanh,
    &tanhf,
    &tanhl,
    &asinh,
    &asinhf,
    &asinhl,
    &acosh,
    &acoshf,
    &acoshl,
    &atanh,
    &atanhf,
    &atanhl,
    &erf,
    &erff,
    &erfl,
    &erfc,
    &erfcf,
    &erfcl,
    &tgamma,
    &tgammaf,
    &tgammal,
    &lgamma,
    &lgammaf,
    &lgammal,
    &ceil,
    &ceilf,
    &ceill,
    &floor,
    &floorf,
    &floorl,
    &trunc,
    &truncf,
    &truncl,
    &round,
    &roundf,
    &roundl,
    &lround,
    &lroundf,
    &lroundl,
    &llround,
    &llroundf,
    &llroundl,
    &nearbyint,
    &nearbyintf,
    &nearbyintl,
    &rintf,
    &rintl,
    &lrint,
    &lrintf,
    &lrintl,
    &llrint,
    &llrintf,
    &llrintl,
    &frexpf,
    &ldexpf,
    &modff,
    &scalbn,
    &scalbnf,
    &scalbnl,
    &scalbln,
    &scalblnf,
    &scalblnl,
    &ilogb,
    &ilogbf,
    &ilogbl,
    &logb,
    &logbf,
    &logbl,
    &nextafter,
    &nextafterf,
    &nextafterl,
    &nexttoward,
    &nexttowardf,
    &nexttowardl,
    &copysign,
    &copysignf,
    &copysignl,
    &isnan
};
