/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_pa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARA", "ARA" },
            { "ARL", "ARL" },
            { "ARM", "ARM" },
            { "ARP", "ARP" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BOL", "BOL" },
            { "BOP", "BOP" },
            { "BOV", "BOV" },
            { "BRB", "BRB" },
            { "BRC", "BRC" },
            { "BRE", "BRE" },
            { "BRN", "BRN" },
            { "BRR", "BRR" },
            { "BRZ", "BRZ" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DEM", "DEM" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILP", "ILP" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SUR", "SUR" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYI", "UYI" },
            { "UYP", "UYP" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEB", "VEB" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VNN", "VNN" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XAG", "XAG" },
            { "XAU", "XAU" },
            { "XBA", "XBA" },
            { "XBB", "XBB" },
            { "XBC", "XBC" },
            { "XBD", "XBD" },
            { "XEU", "XEU" },
            { "XXX", "XXX" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a05\u0a30\u0a2c \u0a05\u0a2e\u0a40\u0a30\u0a3e\u0a24 \u0a26\u0a3f\u0a30\u0a39\u0a3e\u0a2e" },
            { "afn", "\u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28 \u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28\u0a40" },
            { "all", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06\u0a08 \u0a32\u0a47\u0a15" },
            { "amd", "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08 \u0a26\u0a30\u0a3e\u0a2e" },
            { "ang", "\u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21\u0a38 \u0a10\u0a02\u0a1f\u0a40\u0a32\u0a40\u0a05\u0a28 \u0a17\u0a3f\u0a32\u0a21\u0a30" },
            { "aoa", "\u0a05\u0a70\u0a17\u0a4b\u0a32\u0a3e \u0a15\u0a35\u0a3e\u0a02\u0a1c\u0a3e" },
            { "ara", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a40 \u0a05\u0a38\u0a1f\u0a30\u0a3e\u0a32" },
            { "arl", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a40 \u0a2a\u0a47\u0a38\u0a4b \u0a32\u0a47 (1970\u20131983)" },
            { "arm", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a40 \u0a2a\u0a47\u0a38\u0a4b (1881\u20131970)" },
            { "arp", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a40 \u0a2a\u0a47\u0a38\u0a4b (1983\u20131985)" },
            { "ars", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a40 \u0a2a\u0a47\u0a38\u0a4b" },
            { "aud", "\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "awg", "\u0a05\u0a30\u0a42\u0a2c\u0a28 \u0a2b\u0a32\u0a4b\u0a30\u0a3f\u0a28" },
            { "azn", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28 \u0a2e\u0a3e\u0a28\u0a24" },
            { "bam", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06-\u0a39\u0a30\u0a1c\u0a3c\u0a47\u0a17\u0a4b\u0a35\u0a40\u0a28\u0a3e \u0a2c\u0a26\u0a32\u0a23\u0a2f\u0a4b\u0a17 \u0a2e\u0a3e\u0a30\u0a15" },
            { "bbd", "\u0a2c\u0a3e\u0a30\u0a2c\u0a3e\u0a21\u0a40\u0a05\u0a28 \u0a21\u0a3e\u0a32\u0a30" },
            { "bdt", "\u0a2c\u0a70\u0a17\u0a32\u0a3e\u0a26\u0a47\u0a38\u0a3c\u0a40 \u0a1f\u0a15\u0a3e" },
            { "bgn", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06\u0a08 \u0a32\u0a47\u0a35" },
            { "bhd", "\u0a2c\u0a39\u0a3f\u0a30\u0a40\u0a28\u0a40 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "bif", "\u0a2c\u0a41\u0a30\u0a41\u0a70\u0a21\u0a40\u0a06\u0a08 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "bmd", "\u0a2c\u0a30\u0a2e\u0a42\u0a21\u0a3e \u0a21\u0a3e\u0a32\u0a30" },
            { "bnd", "\u0a2c\u0a30\u0a42\u0a28\u0a47\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "bob", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a05\u0a28 \u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a05\u0a28\u0a4b" },
            { "bol", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06\u0a08 \u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a05\u0a28\u0a4b (1863\u20131963)" },
            { "bop", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06\u0a08 \u0a2a\u0a47\u0a38\u0a4b" },
            { "bov", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06\u0a08 \u0a2e\u0a35\u0a21\u0a4b\u0a32" },
            { "brb", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a28\u0a3f\u0a0a \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3f\u0a30\u0a4b\u0a38 (1967\u20131986)" },
            { "brc", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3e\u0a21\u0a42 (1986\u20131989)" },
            { "bre", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3f\u0a30\u0a4b\u0a38 (1990\u20131993)" },
            { "brl", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a30\u0a40\u0a05\u0a32" },
            { "brn", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a28\u0a3f\u0a0a \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3e\u0a21\u0a42 (1989\u20131990)" },
            { "brr", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3f\u0a30\u0a4b\u0a38 (1993\u20131994)" },
            { "brz", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40\u0a06\u0a08 \u0a15\u0a30\u0a41\u0a1c\u0a3c\u0a3f\u0a30\u0a4b\u0a38 (1942\u20131967)" },
            { "bsd", "\u0a2c\u0a3e\u0a39\u0a3e\u0a2e\u0a40\u0a05\u0a28 \u0a21\u0a3e\u0a32\u0a30" },
            { "btn", "\u0a2d\u0a42\u0a1f\u0a3e\u0a28\u0a40 \u0a10\u0a02\u0a17\u0a32\u0a1f\u0a4d\u0a30\u0a2e" },
            { "bwp", "\u0a2c\u0a4b\u0a1f\u0a38\u0a35\u0a3e\u0a28\u0a3e \u0a2a\u0a41\u0a32\u0a3e" },
            { "byn", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38\u0a40 \u0a30\u0a42\u0a2c\u0a32" },
            { "byr", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38\u0a40 \u0a30\u0a42\u0a2c\u0a32 (2000\u20132016)" },
            { "bzd", "\u0a2c\u0a47\u0a32\u0a40\u0a1c\u0a3c \u0a21\u0a3e\u0a32\u0a30" },
            { "cad", "\u0a15\u0a47\u0a28\u0a47\u0a21\u0a3f\u0a06\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "cdf", "\u0a15\u0a3e\u0a02\u0a17\u0a4b\u0a32\u0a40\u0a1c\u0a3c \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "chf", "\u0a38\u0a35\u0a3f\u0a38 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "clp", "\u0a1a\u0a3f\u0a32\u0a40 \u0a2a\u0a47\u0a38\u0a4b" },
            { "cnh", "\u0a1a\u0a40\u0a28\u0a40 \u0a2f\u0a41\u0a06\u0a28 (\u0a14\u0a2b\u0a3c\u0a38\u0a3c\u0a4b\u0a30)" },
            { "cny", "\u0a1a\u0a40\u0a28\u0a40 \u0a2f\u0a41\u0a06\u0a28" },
            { "cop", "\u0a15\u0a4b\u0a32\u0a70\u0a2c\u0a3f\u0a06\u0a08 \u0a2a\u0a47\u0a38\u0a4b" },
            { "crc", "\u0a15\u0a4b\u0a38\u0a1f\u0a3e \u0a30\u0a40\u0a15\u0a28 \u0a15\u0a4b\u0a32\u0a28" },
            { "cuc", "\u0a15\u0a3f\u0a0a\u0a2c\u0a28 \u0a2c\u0a26\u0a32\u0a23\u0a2f\u0a4b\u0a17 \u0a2a\u0a47\u0a38\u0a4b" },
            { "cup", "\u0a15\u0a3f\u0a0a\u0a2c\u0a28 \u0a2a\u0a47\u0a38\u0a4b" },
            { "cve", "\u0a15\u0a47\u0a2a \u0a35\u0a30\u0a21\u0a40\u0a05\u0a28 \u0a38\u0a15\u0a42\u0a21\u0a4b" },
            { "czk", "\u0a1a\u0a48\u0a15 \u0a17\u0a23\u0a30\u0a3e\u0a1c \u0a15\u0a4b\u0a30\u0a41\u0a28\u0a3e" },
            { "dem", "\u0a1c\u0a30\u0a2e\u0a28 \u0a2e\u0a3e\u0a30\u0a15" },
            { "djf", "\u0a1c\u0a3c\u0a40\u0a2c\u0a42\u0a24\u0a40\u0a05\u0a28 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "dkk", "\u0a21\u0a48\u0a28\u0a3f\u0a38\u0a3c \u0a15\u0a30\u0a4c\u0a28" },
            { "dop", "\u0a21\u0a4c\u0a2e\u0a3f\u0a28\u0a3f\u0a15\u0a28 \u0a2a\u0a47\u0a38\u0a4b" },
            { "dzd", "\u0a05\u0a32\u0a1c\u0a40\u0a30\u0a3f\u0a06\u0a08 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "egp", "\u0a2e\u0a3f\u0a38\u0a30\u0a40 \u0a2a\u0a4c\u0a02\u0a21" },
            { "ern", "\u0a07\u0a30\u0a40\u0a1f\u0a4d\u0a30\u0a3f\u0a06\u0a08 \u0a28\u0a3e\u0a2b\u0a3c\u0a3e" },
            { "etb", "\u0a07\u0a25\u0a4b\u0a2a\u0a40\u0a06\u0a08 \u0a2c\u0a3f\u0a30" },
            { "eur", "\u0a2f\u0a42\u0a30\u0a4b" },
            { "fjd", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a3c\u0a40 \u0a21\u0a3e\u0a32\u0a30" },
            { "fkp", "\u0a2b\u0a3c\u0a3e\u0a15\u0a32\u0a48\u0a02\u0a21 \u0a06\u0a08\u0a32\u0a48\u0a02\u0a21\u0a38 \u0a2a\u0a4c\u0a02\u0a21" },
            { "gbp", "\u0a2c\u0a4d\u0a30\u0a3f\u0a1f\u0a3f\u0a38\u0a3c \u0a2a\u0a4c\u0a02\u0a21" },
            { "gel", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06\u0a08 \u0a32\u0a3e\u0a30\u0a40" },
            { "ghs", "\u0a18\u0a3e\u0a28\u0a3e\u0a08 \u0a38\u0a47\u0a21\u0a40" },
            { "gip", "\u0a1c\u0a3f\u0a2c\u0a30\u0a3e\u0a32\u0a1f\u0a30 \u0a2a\u0a4c\u0a02\u0a21" },
            { "gmd", "\u0a17\u0a48\u0a02\u0a2c\u0a40\u0a06\u0a08 \u0a26\u0a32\u0a3e\u0a38\u0a40" },
            { "gnf", "\u0a17\u0a3f\u0a28\u0a40 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "gtq", "\u0a17\u0a41\u0a06\u0a1f\u0a47\u0a2e\u0a3e\u0a32\u0a3e \u0a15\u0a41\u0a0f\u0a1f\u0a1c\u0a3c\u0a32" },
            { "gyd", "\u0a17\u0a41\u0a06\u0a28\u0a3e\u0a06\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "hkd", "\u0a39\u0a3e\u0a02\u0a17 \u0a15\u0a3e\u0a02\u0a17 \u0a21\u0a3e\u0a32\u0a30" },
            { "hnl", "\u0a39\u0a3e\u0a28\u0a21\u0a42\u0a30\u0a28 \u0a32\u0a47\u0a2e\u0a2a\u0a3f\u0a30\u0a3e" },
            { "hrk", "\u0a15\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a15\u0a41\u0a28\u0a3e" },
            { "htg", "\u0a39\u0a48\u0a24\u0a40 \u0a17\u0a4c\u0a30\u0a21\u0a47" },
            { "huf", "\u0a39\u0a70\u0a17\u0a30\u0a40 \u0a2b\u0a4b\u0a30\u0a3f\u0a70\u0a1f" },
            { "idr", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a30\u0a41\u0a2a\u0a3f\u0a06\u0a39" },
            { "iep", "\u0a06\u0a07\u0a30\u0a3f\u0a38\u0a3c \u0a2a\u0a4c\u0a02\u0a21" },
            { "ilp", "\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32\u0a40 \u0a2a\u0a4c\u0a02\u0a21" },
            { "ils", "\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32\u0a40 \u0a28\u0a35\u0a40\u0a02 \u0a38\u0a3c\u0a47\u0a15\u0a47\u0a32" },
            { "inr", "\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "iqd", "\u0a07\u0a30\u0a3e\u0a15\u0a40 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "irr", "\u0a08\u0a30\u0a3e\u0a28\u0a40 \u0a30\u0a3f\u0a06\u0a32" },
            { "isk", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21\u0a40 \u0a15\u0a30\u0a4b\u0a28\u0a3e" },
            { "jmd", "\u0a1c\u0a2e\u0a3e\u0a07\u0a15\u0a28 \u0a21\u0a3e\u0a32\u0a30" },
            { "jod", "\u0a1c\u0a3e\u0a30\u0a21\u0a28 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "jpy", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a2f\u0a47\u0a28" },
            { "kes", "\u0a15\u0a40\u0a28\u0a40\u0a06\u0a08 \u0a38\u0a3c\u0a3f\u0a32\u0a3f\u0a70\u0a17" },
            { "kgs", "\u0a15\u0a3f\u0a30\u0a17\u0a3f\u0a38\u0a24\u0a3e\u0a28\u0a40 \u0a38\u0a4b\u0a2e" },
            { "khr", "\u0a15\u0a70\u0a2c\u0a4b\u0a21\u0a40\u0a06\u0a08 \u0a30\u0a40\u0a05\u0a32" },
            { "kmf", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a40\u0a05\u0a28 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "kpw", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a15\u0a4b\u0a30\u0a40\u0a06\u0a08 \u0a35\u0a4b\u0a28" },
            { "krw", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a15\u0a4b\u0a30\u0a40\u0a06\u0a08 \u0a35\u0a4b\u0a28" },
            { "kwd", "\u0a15\u0a41\u0a35\u0a48\u0a24\u0a40 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "kyd", "\u0a15\u0a47\u0a2e\u0a48\u0a28 \u0a06\u0a08\u0a32\u0a48\u0a02\u0a21\u0a38 \u0a21\u0a3e\u0a32\u0a30" },
            { "kzt", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a38\u0a24\u0a3e\u0a28\u0a40 \u0a24\u0a47\u0a02\u0a17\u0a47" },
            { "lak", "\u0a32\u0a3e\u0a13\u0a1f\u0a3f\u0a06\u0a08 \u0a15\u0a3f\u0a2a" },
            { "lbp", "\u0a32\u0a48\u0a2c\u0a28\u0a3e\u0a28\u0a40 \u0a2a\u0a4c\u0a02\u0a21" },
            { "lkr", "\u0a38\u0a4d\u0a30\u0a40\u0a32\u0a70\u0a15\u0a3e\u0a08 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "lrd", "\u0a32\u0a3e\u0a08\u0a2c\u0a40\u0a30\u0a40\u0a06\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "lsl", "\u0a32\u0a47\u0a38\u0a4b\u0a25\u0a4b \u0a32\u0a4b\u0a1f\u0a40" },
            { "ltl", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a06\u0a08 \u0a32\u0a3f\u0a24\u0a3e\u0a38" },
            { "lvl", "\u0a32\u0a3e\u0a1f\u0a35\u0a3f\u0a06\u0a08 \u0a32\u0a3e\u0a1f\u0a38" },
            { "lyd", "\u0a32\u0a40\u0a2c\u0a40\u0a06\u0a08 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "mad", "\u0a2e\u0a4b\u0a30\u0a71\u0a15\u0a28 \u0a26\u0a3f\u0a30\u0a39\u0a3e\u0a2e" },
            { "mdl", "\u0a2e\u0a4b\u0a32\u0a21\u0a4b\u0a35\u0a28 \u0a32\u0a47\u0a09" },
            { "mga", "\u0a2e\u0a3e\u0a32\u0a3e\u0a17\u0a3e\u0a38\u0a40 \u0a05\u0a30\u0a3e\u0a07\u0a30\u0a40" },
            { "mkd", "\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06\u0a08 \u0a21\u0a47\u0a28\u0a3e\u0a30" },
            { "mmk", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 \u0a15\u0a3f\u0a06\u0a24" },
            { "mnt", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a06\u0a08 \u0a24\u0a41\u0a17\u0a30\u0a3f\u0a15" },
            { "mop", "\u0a2e\u0a47\u0a15\u0a3e\u0a28\u0a40 \u0a2a\u0a1f\u0a3e\u0a15\u0a3e" },
            { "mro", "\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06\u0a08 \u0a0a\u0a17\u0a40\u0a06 (1973\u20132017)" },
            { "mru", "\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06\u0a08 \u0a0a\u0a17\u0a40\u0a06" },
            { "mur", "\u0a2e\u0a4c\u0a30\u0a3f\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "mvr", "\u0a2e\u0a3e\u0a32\u0a26\u0a40\u0a35\u0a40 \u0a30\u0a41\u0a2b\u0a40\u0a06" },
            { "mwk", "\u0a2e\u0a3e\u0a32\u0a3e\u0a35\u0a40\u0a06\u0a08 \u0a15\u0a35\u0a3e\u0a1a\u0a3e" },
            { "mxn", "\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a28 \u0a2a\u0a47\u0a38\u0a4b" },
            { "myr", "\u0a2e\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a30\u0a3f\u0a70\u0a17\u0a3f\u0a1f" },
            { "mzn", "\u0a2e\u0a4b\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a15\u0a28 \u0a2e\u0a48\u0a1f\u0a40\u0a15\u0a32" },
            { "nad", "\u0a28\u0a3e\u0a2e\u0a40\u0a2c\u0a40\u0a06\u0a08 \u0a21\u0a3e\u0a32\u0a30" },
            { "ngn", "\u0a28\u0a3e\u0a07\u0a1c\u0a40\u0a30\u0a40\u0a06\u0a08 \u0a28\u0a3e\u0a07\u0a30\u0a3e" },
            { "nio", "\u0a28\u0a3f\u0a15\u0a3e\u0a30\u0a3e\u0a17\u0a41\u0a06\u0a08 \u0a15\u0a4b\u0a30\u0a21\u0a4b\u0a2c\u0a3e" },
            { "nok", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a40\u0a06\u0a08 \u0a15\u0a30\u0a4c\u0a28" },
            { "npr", "\u0a28\u0a47\u0a2a\u0a3e\u0a32\u0a40 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "nzd", "\u0a28\u0a3f\u0a0a\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21 \u0a21\u0a3e\u0a32\u0a30" },
            { "omr", "\u0a13\u0a2e\u0a3e\u0a28\u0a40 \u0a30\u0a3f\u0a06\u0a32" },
            { "pab", "\u0a2a\u0a28\u0a3e\u0a2e\u0a47\u0a28\u0a40\u0a05\u0a28 \u0a2c\u0a3e\u0a32\u0a2c\u0a4b\u0a06" },
            { "pen", "\u0a2a\u0a47\u0a30\u0a42\u0a35\u0a40\u0a05\u0a28 \u0a38\u0a4b\u0a32" },
            { "pgk", "\u0a2a\u0a3e\u0a2a\u0a42\u0a06 \u0a28\u0a3f\u0a0a \u0a17\u0a3f\u0a28\u0a40\u0a06\u0a08 \u0a15\u0a40\u0a28\u0a3e" },
            { "php", "\u0a2b\u0a3f\u0a32\u0a3f\u0a2a\u0a40\u0a28\u0a40 \u0a2a\u0a47\u0a38\u0a4b" },
            { "pkr", "\u0a2a\u0a3e\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28\u0a40 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "pln", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21\u0a40 \u0a1c\u0a3c\u0a32\u0a4c\u0a1f\u0a40" },
            { "pyg", "\u0a2a\u0a48\u0a30\u0a3e\u0a17\u0a41\u0a35\u0a3e\u0a07\u0a28 \u0a17\u0a41\u0a06\u0a30\u0a3e\u0a28\u0a40" },
            { "qar", "\u0a15\u0a24\u0a30\u0a40 \u0a30\u0a3f\u0a06\u0a32" },
            { "ron", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06\u0a08 \u0a32\u0a47\u0a09" },
            { "rsd", "\u0a38\u0a30\u0a2c\u0a40\u0a06\u0a08 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "rub", "\u0a30\u0a42\u0a38\u0a40 \u0a30\u0a42\u0a2c\u0a32" },
            { "rwf", "\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a28 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "sar", "\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a30\u0a3f\u0a06\u0a32" },
            { "sbd", "\u0a38\u0a4b\u0a32\u0a4b\u0a2e\u0a28 \u0a06\u0a08\u0a32\u0a48\u0a02\u0a21\u0a38 \u0a21\u0a3e\u0a32\u0a30" },
            { "scr", "\u0a38\u0a47\u0a38\u0a3c\u0a32\u0a38 \u0a30\u0a41\u0a2a\u0a07\u0a06" },
            { "sdg", "\u0a38\u0a42\u0a21\u0a3e\u0a28\u0a40 \u0a2a\u0a4c\u0a02\u0a21" },
            { "sek", "\u0a38\u0a35\u0a40\u0a21\u0a3f\u0a38\u0a3c \u0a15\u0a30\u0a4b\u0a28\u0a3e" },
            { "sgd", "\u0a38\u0a3f\u0a70\u0a17\u0a3e\u0a2a\u0a41\u0a30 \u0a21\u0a3e\u0a32\u0a30" },
            { "shp", "\u0a38\u0a47\u0a02\u0a1f \u0a39\u0a47\u0a32\u0a47\u0a28\u0a3e \u0a2a\u0a4c\u0a02\u0a21" },
            { "sll", "\u0a38\u0a3f\u0a0f\u0a30\u0a3e \u0a32\u0a3f\u0a13\u0a28\u0a40\u0a05\u0a28 \u0a32\u0a3f\u0a13\u0a28" },
            { "sos", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40 \u0a38\u0a3c\u0a3f\u0a32\u0a3f\u0a70\u0a17" },
            { "srd", "\u0a38\u0a42\u0a30\u0a40\u0a28\u0a3e\u0a2e\u0a40 \u0a21\u0a3e\u0a32\u0a30" },
            { "ssp", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a42\u0a21\u0a3e\u0a28\u0a40 \u0a2a\u0a4c\u0a02\u0a21" },
            { "std", "\u0a38\u0a3e\u0a09 \u0a1f\u0a4b\u0a2e\u0a40 \u0a10\u0a02\u0a21 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a2a\u0a40 \u0a21\u0a4b\u0a2c\u0a30\u0a3e (1977\u20132017)" },
            { "stn", "\u0a38\u0a3e\u0a09 \u0a1f\u0a4b\u0a2e\u0a40 \u0a10\u0a02\u0a21 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a2a\u0a40 \u0a21\u0a4b\u0a2c\u0a30\u0a3e" },
            { "sur", "\u0a38\u0a4b\u0a35\u0a40\u0a05\u0a24 \u0a30\u0a42\u0a2c\u0a32" },
            { "syp", "\u0a38\u0a40\u0a30\u0a40\u0a06\u0a08 \u0a2a\u0a4c\u0a02\u0a21" },
            { "szl", "\u0a38\u0a35\u0a3e\u0a1c\u0a3c\u0a40 \u0a32\u0a3e\u0a07\u0a32\u0a48\u0a02\u0a17\u0a28\u0a40" },
            { "thb", "\u0a25\u0a3e\u0a08 \u0a2c\u0a3e\u0a39\u0a24" },
            { "tjs", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28\u0a40 \u0a38\u0a4b\u0a2e\u0a4b\u0a28\u0a40" },
            { "tmt", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28\u0a40 \u0a2e\u0a3e\u0a28\u0a24" },
            { "tnd", "\u0a1f\u0a3f\u0a09\u0a28\u0a40\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a26\u0a3f\u0a28\u0a3e\u0a30" },
            { "top", "\u0a1f\u0a4c\u0a02\u0a17\u0a28 \u0a2a\u0a48\u0a02\u0a17\u0a3e" },
            { "try", "\u0a24\u0a41\u0a30\u0a15\u0a40 \u0a32\u0a40\u0a30\u0a3e" },
            { "ttd", "\u0a1f\u0a4d\u0a30\u0a3f\u0a28\u0a40\u0a21\u0a3e\u0a21 \u0a05\u0a24\u0a47 \u0a1f\u0a4b\u0a2c\u0a3e\u0a17\u0a4b \u0a21\u0a3e\u0a32\u0a30" },
            { "twd", "\u0a28\u0a35\u0a3e\u0a02 \u0a24\u0a3e\u0a07\u0a35\u0a3e\u0a28 \u0a21\u0a3e\u0a32\u0a30" },
            { "tzs", "\u0a24\u0a28\u0a1c\u0a3c\u0a3e\u0a28\u0a40\u0a06\u0a08 \u0a38\u0a3c\u0a3f\u0a32\u0a3f\u0a70\u0a17" },
            { "uah", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28\u0a40\u0a06\u0a08 \u0a30\u0a3f\u0a35\u0a28\u0a3f\u0a06" },
            { "ugx", "\u0a2f\u0a42\u0a17\u0a3e\u0a02\u0a21\u0a40\u0a06\u0a08 \u0a38\u0a3c\u0a3f\u0a32\u0a3f\u0a70\u0a17" },
            { "usd", "\u0a2f\u0a42.\u0a10\u0a38. \u0a21\u0a3e\u0a32\u0a30" },
            { "uyp", "\u0a09\u0a30\u0a42\u0a17\u0a41\u0a35\u0a3e\u0a07\u0a28 \u0a2a\u0a47\u0a38\u0a4b (1975\u20131993)" },
            { "uyu", "\u0a09\u0a30\u0a42\u0a17\u0a41\u0a35\u0a3e\u0a07\u0a28 \u0a2a\u0a47\u0a38\u0a4b" },
            { "uzs", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28 \u0a38\u0a4b\u0a2e" },
            { "veb", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a28 \u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a30 (1871\u20132008)" },
            { "vef", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a28 \u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a30 (2008\u20132018)" },
            { "ves", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a28 \u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a30" },
            { "vnd", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40 \u0a21\u0a4b\u0a02\u0a17" },
            { "vnn", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40 \u0a21\u0a4b\u0a02\u0a17 (1978\u20131985)" },
            { "vuv", "\u0a35\u0a3e\u0a28\u0a42\u0a06\u0a1f\u0a42 \u0a35\u0a3e\u0a1f\u0a42" },
            { "wst", "\u0a38\u0a3e\u0a2e\u0a4b\u0a06\u0a08 \u0a24\u0a3e\u0a32\u0a3e" },
            { "xaf", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 [CFA] \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "xag", "\u0a1a\u0a3e\u0a02\u0a26\u0a40" },
            { "xau", "\u0a38\u0a4b\u0a28\u0a3e" },
            { "xbb", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a07\u0a15\u0a3e\u0a08" },
            { "xcd", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a05\u0a28 \u0a21\u0a3e\u0a32\u0a30" },
            { "xeu", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a07\u0a15\u0a3e\u0a08" },
            { "xof", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 (CFA) \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15" },
            { "xpf", "\u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a15 (CFP)" },
            { "xxx", "\u0a05\u0a17\u0a3f\u0a06\u0a24 \u0a2e\u0a41\u0a26\u0a30\u0a3e" },
            { "yer", "\u0a2f\u0a2e\u0a28\u0a40 \u0a30\u0a3f\u0a06\u0a32" },
            { "zar", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a30\u0a40\u0a15\u0a40 \u0a30\u0a48\u0a02\u0a21" },
            { "zmw", "\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a06\u0a08 \u0a15\u0a35\u0a3e\u0a1a\u0a3e" },
        };
        return data;
    }
}
