# Registry

Netdata uses a **central Registry**. Together with certain browser features, it allows for unified cross-Agent dashboards. For example, when you jump from Agent to Agent using the node menu, several session settings (like the currently viewed charts, the current zoom and pan operations on the charts, etc.) are propagated to the new Agent, so that the new dashboard will come with exactly the same view.

## Default Registry

The default Registry is `https://registry.my-netdata.io`, which is currently served by `https://london.my-netdata.io`. This Registry listens to both HTTP and HTTPS requests with the default being HTTPS.

## What data is stored

The Registry keeps track of four entities:

1. **machines**: The Netdata installations (a random GUID generated by each Netdata the first time it starts, we call this **machine_guid**)

   For each Netdata installation, the Registry keeps track of the various different URLs it has accessed.

2. **people**: The web browsers accessing the Netdata installations (a random GUID generated by the Registry the first time it sees a new web browser, we call this **person_guid**)

   For each person, the Registry keeps track of the Netdata installations it has accessed and their URLs.

3. **URLs** of Netdata installations (as seen by the web browsers)

   For each URL, the Registry keeps the URL and nothing more. Each URL is linked to **people** and **machines**. The only way to find a URL is to know its **machine_guid** or have a **person_guid** that is linked to it.

4. **accounts**: The information used to sign in via one of the available sign-in methods. Depending on the method, this may include only an email or additionally a profile picture or avatar.

For **people**, **accounts** and **machines**, the Registry keeps links to **URLs**, each link with two timestamps (first time seen, last time seen) and a counter (number of times it has been seen).

**machines**, **people** and timestamps are stored in the Netdata Registry regardless of whether you sign in or not.

## Communication with the Registry

**Only** your web browser communicates with the Registry. If sending this information is against your policies, you can [run your own Registry](/src/registry/CONFIGURATION.md)

Your Agents do not talk to the Registry. This is a diagram explaining the process:

```mermaid
sequenceDiagram
    participant WebBrowser as Web Browser
    participant Netdata1 as Netdata 1
    participant Registry1 as Registry 1

    WebBrowser->>Netdata1: 1. Hi, give me the dashboard
    Netdata1-->>WebBrowser: 2. Welcome, here it is...
    Note over WebBrowser,Netdata1: a few seconds later

    WebBrowser->>Netdata1: 3. Now give me the Registry information
    Netdata1-->>WebBrowser: 4. Here it is, talk to Registry 1

    WebBrowser->>Registry1: 5. Hey Registry 1, I am accessing Netdata 1...
    Registry1-->>WebBrowser: 6. Nice! Here are other Netdata Agents you have accessed in the past

    Note over WebBrowser: Only your web browser talks to the Registry
```
