// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- CPU ---

// CPUUsageValues defines the type-safe values for CPU.Usage context
type CPUUsageValues struct {
	Process     int64
	Utilization int64
}

// CPUUsageContext provides type-safe operations for CPU.Usage context
type CPUUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for CPU.Usage context
func (c CPUUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values CPUUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"process":     values.Process,
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c CPUUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// CPUTimeValues defines the type-safe values for CPU.Time context
type CPUTimeValues struct {
	Total int64
}

// CPUTimeContext provides type-safe operations for CPU.Time context
type CPUTimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for CPU.Time context
func (c CPUTimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values CPUTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c CPUTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// CPU contains all metric contexts for CPU
var CPU = struct {
	Usage CPUUsageContext
	Time  CPUTimeContext
}{
	Usage: CPUUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.cpu_usage",
			Family:      "compute/cpu",
			Title:       "JVM CPU Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "process",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Time: CPUTimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.cpu_time",
			Family:      "compute/cpu",
			Title:       "JVM CPU Time",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    102,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- JVM ---

// JVMHeapUsageValues defines the type-safe values for JVM.HeapUsage context
type JVMHeapUsageValues struct {
	Used int64
	Free int64
}

// JVMHeapUsageContext provides type-safe operations for JVM.HeapUsage context
type JVMHeapUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapUsage context
func (c JVMHeapUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used": values.Used,
		"free": values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapCommittedValues defines the type-safe values for JVM.HeapCommitted context
type JVMHeapCommittedValues struct {
	Committed int64
}

// JVMHeapCommittedContext provides type-safe operations for JVM.HeapCommitted context
type JVMHeapCommittedContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapCommitted context
func (c JVMHeapCommittedContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapCommittedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"committed": values.Committed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapCommittedContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapMaxValues defines the type-safe values for JVM.HeapMax context
type JVMHeapMaxValues struct {
	Limit int64
}

// JVMHeapMaxContext provides type-safe operations for JVM.HeapMax context
type JVMHeapMaxContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapMax context
func (c JVMHeapMaxContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapMaxValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"limit": values.Limit,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapMaxContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapUtilizationValues defines the type-safe values for JVM.HeapUtilization context
type JVMHeapUtilizationValues struct {
	Utilization int64
}

// JVMHeapUtilizationContext provides type-safe operations for JVM.HeapUtilization context
type JVMHeapUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapUtilization context
func (c JVMHeapUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCCollectionsValues defines the type-safe values for JVM.GCCollections context
type JVMGCCollectionsValues struct {
	Rate int64
}

// JVMGCCollectionsContext provides type-safe operations for JVM.GCCollections context
type JVMGCCollectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCCollections context
func (c JVMGCCollectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCCollectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"rate": values.Rate,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCCollectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCTimeValues defines the type-safe values for JVM.GCTime context
type JVMGCTimeValues struct {
	Total     int64
	Per_cycle int64
}

// JVMGCTimeContext provides type-safe operations for JVM.GCTime context
type JVMGCTimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCTime context
func (c JVMGCTimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total":     values.Total,
		"per_cycle": values.Per_cycle,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadsCurrentValues defines the type-safe values for JVM.ThreadsCurrent context
type JVMThreadsCurrentValues struct {
	Daemon int64
	Other  int64
}

// JVMThreadsCurrentContext provides type-safe operations for JVM.ThreadsCurrent context
type JVMThreadsCurrentContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.ThreadsCurrent context
func (c JVMThreadsCurrentContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadsCurrentValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"daemon": values.Daemon,
		"other":  values.Other,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadsCurrentContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadsPeakValues defines the type-safe values for JVM.ThreadsPeak context
type JVMThreadsPeakValues struct {
	Peak int64
}

// JVMThreadsPeakContext provides type-safe operations for JVM.ThreadsPeak context
type JVMThreadsPeakContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.ThreadsPeak context
func (c JVMThreadsPeakContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadsPeakValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"peak": values.Peak,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadsPeakContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVM contains all metric contexts for JVM
var JVM = struct {
	HeapUsage       JVMHeapUsageContext
	HeapCommitted   JVMHeapCommittedContext
	HeapMax         JVMHeapMaxContext
	HeapUtilization JVMHeapUtilizationContext
	GCCollections   JVMGCCollectionsContext
	GCTime          JVMGCTimeContext
	ThreadsCurrent  JVMThreadsCurrentContext
	ThreadsPeak     JVMThreadsPeakContext
}{
	HeapUsage: JVMHeapUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_memory_heap_usage",
			Family:      "memory/heap",
			Title:       "JVM Heap Memory Usage",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    201,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapCommitted: JVMHeapCommittedContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_memory_heap_committed",
			Family:      "memory/heap",
			Title:       "JVM Heap Memory Committed",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    202,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapMax: JVMHeapMaxContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_memory_heap_max",
			Family:      "memory/heap",
			Title:       "JVM Heap Memory Maximum",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    203,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "limit",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapUtilization: JVMHeapUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_heap_utilization",
			Family:      "memory/heap",
			Title:       "JVM Heap Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    204,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCCollections: JVMGCCollectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_gc_collections",
			Family:      "compute/gc",
			Title:       "JVM Garbage Collection Rate",
			Units:       "collections/s",
			Type:        module.Line,
			Priority:    205,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "rate",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCTime: JVMGCTimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_gc_time",
			Family:      "compute/gc",
			Title:       "JVM GC Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    206,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "per_cycle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ThreadsCurrent: JVMThreadsCurrentContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_threads_current",
			Family:      "compute/threads",
			Title:       "JVM Current Threads",
			Units:       "threads",
			Type:        module.Stacked,
			Priority:    301,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "daemon",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "other",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ThreadsPeak: JVMThreadsPeakContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.jvm_threads_peak",
			Family:      "compute/threads",
			Title:       "JVM Peak Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    302,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "peak",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- RESTEndpoint ---

// RESTEndpointRequestsValues defines the type-safe values for RESTEndpoint.Requests context
type RESTEndpointRequestsValues struct {
	Requests int64
}

// RESTEndpointRequestsContext provides type-safe operations for RESTEndpoint.Requests context
type RESTEndpointRequestsContext struct {
	framework.Context[RESTEndpointLabels]
}

// Set provides type-safe dimension setting for RESTEndpoint.Requests context
func (c RESTEndpointRequestsContext) Set(state *framework.CollectorState, labels RESTEndpointLabels, values RESTEndpointRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests": values.Requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c RESTEndpointRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels RESTEndpointLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// RESTEndpointResponseTimeValues defines the type-safe values for RESTEndpoint.ResponseTime context
type RESTEndpointResponseTimeValues struct {
	Average int64
}

// RESTEndpointResponseTimeContext provides type-safe operations for RESTEndpoint.ResponseTime context
type RESTEndpointResponseTimeContext struct {
	framework.Context[RESTEndpointLabels]
}

// Set provides type-safe dimension setting for RESTEndpoint.ResponseTime context
func (c RESTEndpointResponseTimeContext) Set(state *framework.CollectorState, labels RESTEndpointLabels, values RESTEndpointResponseTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"average": values.Average,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c RESTEndpointResponseTimeContext) SetUpdateEvery(state *framework.CollectorState, labels RESTEndpointLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// RESTEndpointLabels defines the required labels for RESTEndpoint contexts
type RESTEndpointLabels struct {
	Method   string
	Endpoint string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l RESTEndpointLabels) InstanceID(contextName string) string {
	// Label order from YAML: method, endpoint
	return contextName + "." + cleanLabelValue(l.Method) + "_" + cleanLabelValue(l.Endpoint)
}

// RESTEndpoint contains all metric contexts for RESTEndpoint
var RESTEndpoint = struct {
	Requests     RESTEndpointRequestsContext
	ResponseTime RESTEndpointResponseTimeContext
}{
	Requests: RESTEndpointRequestsContext{
		Context: framework.Context[RESTEndpointLabels]{
			Name:        "websphere_mp.rest_requests",
			Family:      "workloads/rest",
			Title:       "REST Request Rate",
			Units:       "requests/s",
			Type:        module.Line,
			Priority:    501,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"method",
				"endpoint",
			},
		},
	},
	ResponseTime: RESTEndpointResponseTimeContext{
		Context: framework.Context[RESTEndpointLabels]{
			Name:        "websphere_mp.rest_response_time",
			Family:      "workloads/rest",
			Title:       "REST Response Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    502,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "average",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"method",
				"endpoint",
			},
		},
	},
}

// --- Vendor ---

// VendorThreadPoolUsageValues defines the type-safe values for Vendor.ThreadPoolUsage context
type VendorThreadPoolUsageValues struct {
	Active int64
	Idle   int64
}

// VendorThreadPoolUsageContext provides type-safe operations for Vendor.ThreadPoolUsage context
type VendorThreadPoolUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for Vendor.ThreadPoolUsage context
func (c VendorThreadPoolUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values VendorThreadPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active": values.Active,
		"idle":   values.Idle,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c VendorThreadPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// VendorThreadPoolSizeValues defines the type-safe values for Vendor.ThreadPoolSize context
type VendorThreadPoolSizeValues struct {
	Size int64
}

// VendorThreadPoolSizeContext provides type-safe operations for Vendor.ThreadPoolSize context
type VendorThreadPoolSizeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for Vendor.ThreadPoolSize context
func (c VendorThreadPoolSizeContext) Set(state *framework.CollectorState, labels EmptyLabels, values VendorThreadPoolSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"size": values.Size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c VendorThreadPoolSizeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// Vendor contains all metric contexts for Vendor
var Vendor = struct {
	ThreadPoolUsage VendorThreadPoolUsageContext
	ThreadPoolSize  VendorThreadPoolSizeContext
}{
	ThreadPoolUsage: VendorThreadPoolUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.threadpool_usage",
			Family:      "workloads/threadpools",
			Title:       "Thread Pool Usage",
			Units:       "threads",
			Type:        module.Stacked,
			Priority:    401,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ThreadPoolSize: VendorThreadPoolSizeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_mp.threadpool_size",
			Family:      "workloads/threadpools",
			Title:       "Thread Pool Size",
			Units:       "threads",
			Type:        module.Line,
			Priority:    402,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&CPU.Usage.Context,
		&CPU.Time.Context,
		&JVM.HeapUsage.Context,
		&JVM.HeapCommitted.Context,
		&JVM.HeapMax.Context,
		&JVM.HeapUtilization.Context,
		&JVM.GCCollections.Context,
		&JVM.GCTime.Context,
		&JVM.ThreadsCurrent.Context,
		&JVM.ThreadsPeak.Context,
		&RESTEndpoint.Requests.Context,
		&RESTEndpoint.ResponseTime.Context,
		&Vendor.ThreadPoolUsage.Context,
		&Vendor.ThreadPoolSize.Context,
	}
}
