<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/ping/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/ping/metadata.yaml"
sidebar_label: "Ping"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Ping


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: ping

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This module measures round-trip time and packet loss by sending ping messages to network hosts.

There are two operational modes:

- **Privileged** (send raw ICMP ping, default). Requires the necessary permissions ([CAP_NET_RAW](https://man7.org/linux/man-pages/man7/capabilities.7.html) on Linux, `setuid` bit on other systems).

  These permissions are **automatically** set during Netdata installation. However, if you need to set them manually:
    - set `CAP_NET_RAW` (Linux only).
      ```bash
      sudo setcap CAP_NET_RAW=eip <INSTALL_PREFIX>/usr/libexec/netdata/plugins.d/go.d.plugin
      ```
    - set `setuid` bit (Other OS).
      ```bash
      sudo chmod 4750 <INSTALL_PREFIX>/usr/libexec/netdata/plugins.d/go.d.plugin
      ```

- **Unprivileged** (send UDP ping, Linux only). Requires configuring [ping_group_range](https://www.man7.org/linux/man-pages/man7/icmp.7.html):

  This configuration is **not set automatically** and requires manual configuration.

  ```bash
  sudo sysctl -w net.ipv4.ping_group_range="0 2147483647"
  ```

  To persist the change add `net.ipv4.ping_group_range=0 2147483647` to `/etc/sysctl.conf` and execute `sudo sysctl -p`.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per host

These metrics refer to the remote host.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| host | remote host |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ping.host_rtt | min, max, avg | milliseconds |
| ping.host_std_dev_rtt | std_dev | milliseconds |
| ping.host_packet_loss | loss | percentage |
| ping.host_packets | received, sent | packets |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ping_host_reachable ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_packet_loss | network host ${lab1el:host} reachability status |
| [ ping_packet_loss ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_packet_loss | packet loss percentage to the network host ${label:host} over the last 10 minutes |
| [ ping_host_latency ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ping.conf) | ping.host_rtt | average latency to the network host ${label:host} over the last 10 seconds |


## Setup


You can configure the **ping** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **ping**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/ping.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 5 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | hosts | List of hosts to ping. | [] | yes |
| **Ping Settings** | network | DNS resolution mode. Options: `ip` (IPv4 or IPv6), `ip4` (IPv4 only), `ip6` (IPv6 only). | ip | no |
|  | interface | Network interface to use for ICMP echo requests (e.g., `eth0`, `wlan0`). |  | no |
|  | privileged | Ping packet type. `yes` = raw ICMP ping, `no` = unprivileged UDP ping. | yes | yes |
|  | packets | Number of ping packets to send per iteration. | 5 | no |
|  | interval | Interval between sending ping packets. | 100ms | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **ping** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the ping data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _ping_ (or scroll the list) to locate the **ping** collector.
5. Click the **+** next to the **ping** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/ping.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/ping.conf
```

##### Examples

###### IPv4 hosts

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: example
    hosts:
      - 192.0.2.0
      - 192.0.2.1

```
</details>

###### Unprivileged mode

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: example
    privileged: no
    hosts:
      - 192.0.2.0
      - 192.0.2.1

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Multiple instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: example1
    hosts:
      - 192.0.2.0
      - 192.0.2.1

  - name: example2
    packets: 10
    hosts:
      - 192.0.2.3
      - 192.0.2.4

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `ping` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m ping
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m ping -j jobName
  ```

### Getting Logs

If you're encountering problems with the `ping` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep ping
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep ping /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep ping
```


