<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/hpssa/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/hpssa/metadata.yaml"
sidebar_label: "HPE Smart Arrays"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Storage, Mount Points and Filesystems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# HPE Smart Arrays


<img src="https://netdata.cloud/img/hp.svg" width="150"/>


Plugin: go.d.plugin
Module: hpssa

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitors the health of HPE Smart Arrays by tracking the status of controllers, arrays, logical and physical drives in your storage system.
It relies on the `ssacli` CLI tool but avoids directly executing the binary.
Instead, it utilizes `ndsudo`, a Netdata helper specifically designed to run privileged commands securely within the Netdata environment.
This approach eliminates the need to use `sudo`, improving security and potentially simplifying permission management.

Executed commands:
-  `ssacli ctrl all show config detail`




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per controller

These metrics refer to the Controller.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| model | Controller model |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.controller_status | ok, nok | status |
| hpssa.controller_temperature | temperature | Celsius |
| hpssa.controller_cache_module_presence_status | present, not_present | status |
| hpssa.controller_cache_module_status | ok, nok | status |
| hpssa.controller_cache_module_temperature | temperature | Celsius |
| hpssa.controller_cache_module_battery_status | ok, nok | status |

### Per array

These metrics refer to the Array.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id |
| interface_type | Array interface type (e.g. SATA) |
| array_type | Array type (e.g. Data) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.array_status | ok, nok | status |

### Per logical drive

These metrics refer to the Logical Drive.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id |
| logical_drive_id | Logical Drive id (number) |
| disk_name | Disk name (e.g. /dev/sda) |
| drive_type | Drive type (e.g. Data) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.logical_drive_status | ok, nok | status |

### Per physical drive

These metrics refer to the Physical Drive.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| slot | Slot number |
| array_id | Array id or "na" if unassigned |
| logical_drive_id | Logical Drive id or "na" if unassigned |
| location | Drive location in port:box:bay format (e.g. 1I:1:1) |
| interface_type | Drive interface type (e.g. SATA) |
| drive_type | Drive type (e.g. Data Drive, Unassigned Drive) |
| model | Drive model |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| hpssa.physical_drive_status | ok, nok | status |
| hpssa.physical_drive_temperature | temperature | status |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **hpssa** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **hpssa**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/ssacli.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Install ssacli

See [official installation instructions](https://support.hpe.com/connect/s/softwaredetails?language=en_US&collectionId=MTX-0cb3f808e2514d3d).



### Configuration

#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update_every | Data collection frequency. | 10 | no |
| timeout | ssacli binary execution timeout. | 2 | no |


</details>


#### via UI

Configure the **hpssa** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the hpssa data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _hpssa_ (or scroll the list) to locate the **hpssa** collector.
5. Click the **+** next to the **hpssa** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/ssacli.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/ssacli.conf
```

##### Examples

###### Custom update_every

Allows you to override the default data collection interval.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: hpssa
    update_every: 5  # Collect HPE Smart Array statistics every 5 seconds

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `hpssa` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m hpssa
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m hpssa -j jobName
  ```

### Getting Logs

If you're encountering problems with the `hpssa` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep hpssa
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep hpssa /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep hpssa
```


