<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/system_load_average.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "System Load Average"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/System"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# System Load Average


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/loadavg

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

The `/proc/loadavg` file provides information about the system load average.

The load average is a measure of the amount of computational work that a system performs. It is a
representation of the average system load over a period of time.

This file contains three numbers representing the system load averages for the last 1, 5, and 15 minutes,
respectively. It also includes the currently running processes and the total number of processes.

Monitoring the load average can be used for:

- **System performance**: If the load average is too high, it may indicate that your system is overloaded.
  On a system with a single CPU, if the load average is 1, it means the single CPU is fully utilized. If the
  load averages are consistently higher than the number of CPUs/cores, it may indicate that your system is
  overloaded and tasks are waiting for CPU time.

- **Troubleshooting**: If the load average is unexpectedly high, it can be a sign of a problem. This could be
  due to a runaway process, a software bug, or a hardware issue.

- **Capacity planning**: By monitoring the load average over time, you can understand the trends in your
  system's workload. This can help with capacity planning and scaling decisions.

Remember that load average not only considers CPU usage, but also includes processes waiting for disk I/O.
Therefore, high load averages could be due to I/O contention as well as CPU contention.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per System Load Average instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.load | load1, load5, load15 | load |
| system.active_processes | active | processes |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ load_cpu_number ](https://github.com/netdata/netdata/blob/master/src/health/health.d/load.conf) | system.load | number of active CPU cores in the system |
| [ load_average_15 ](https://github.com/netdata/netdata/blob/master/src/health/health.d/load.conf) | system.load | system fifteen-minute load average |
| [ load_average_5 ](https://github.com/netdata/netdata/blob/master/src/health/health.d/load.conf) | system.load | system five-minute load average |
| [ load_average_1 ](https://github.com/netdata/netdata/blob/master/src/health/health.d/load.conf) | system.load | system one-minute load average |
| [ active_processes ](https://github.com/netdata/netdata/blob/master/src/health/health.d/processes.conf) | system.active_processes | system process IDs (PID) space utilization |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


