# Home tab

The **Home tab** offers a **real-time overview of your Room** in Netdata Cloud. Use it to quickly assess your infrastructure’s health and key metrics at a glance.

| Feature                        | Description                                                                                                                                                                                                                                                                                                                   |
|--------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Total nodes**                | Shows the total number of nodes, broken down by state: **Live**, **Offline**, or **Stale**.                                                                                                                                                                                                                                   |
| **Active alerts**              | Displays the number of active alerts in a donut chart, with counters for both **Critical** and **Warning** alerts.                                                                                                                                                                                                            |
| **Nodes map**                  | Interactive map with color-coded node statuses and hoverable details. Classify nodes by **Status**, **OS**, **Technology**, **Agent version**, **Replication factor**, **Cloud provider**, **Cloud region**, or **Instance type**. Configure color-coding by **Status**, **Connection stability**, or **Replication factor**. |
| **Data replication**           | Two bar charts: (1) Node roles as **Parents**, **Children**, and **Standalone**. (2) Replication factors as **None**, **Single**, and **Multi**.                                                                                                                                                                              |
| **Alerts overview (last 24h)** | Two views of alert activity: (1) Bar chart showing nodes with the most alerts in the last 24 hours. (2) Table of the top alerts, with instance name, number of occurrences, and duration (in seconds).                                                                                                                        |
| **Netdata Assistant shortcut** | Button to start a conversation with the [Netdata Assistant](https://github.com/netdata/netdata/edit/master/docs/netdata-assistant.md) for help and troubleshooting.                                                                                                                                                           |
| **Space metrics**              | Displays key statistics: **Metrics collected**, **Charts visualized**, and **Alerts configured**.                                                                                                                                                                                                                             |
| **Data retention per node**    | Bar chart showing the number of nodes grouped by retention period.                                                                                                                                                                                                                                                            |

:::tip

Use the Home tab regularly to stay ahead of infrastructure issues and monitor alert trends at a glance.

:::