/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;

public final class PutTask
extends TransportTask {
    private Path dataPath;
    private byte[] dataBytes = EMPTY;

    public PutTask(URI location) {
        this.setLocation(location);
    }

    public InputStream newInputStream() throws IOException {
        if (this.dataPath != null) {
            return Files.newInputStream(this.dataPath, new OpenOption[0]);
        }
        return new ByteArrayInputStream(this.dataBytes);
    }

    public long getDataLength() {
        if (this.dataPath != null) {
            try {
                return Files.size(this.dataPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.dataBytes.length;
    }

    @Deprecated
    public File getDataFile() {
        return this.dataPath != null ? this.dataPath.toFile() : null;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    @Deprecated
    public PutTask setDataFile(File dataFile) {
        return this.setDataPath(dataFile.toPath());
    }

    public PutTask setDataPath(Path dataPath) {
        this.dataPath = dataPath;
        this.dataBytes = EMPTY;
        return this;
    }

    public PutTask setDataBytes(byte[] bytes) {
        this.dataBytes = bytes != null ? bytes : EMPTY;
        this.dataPath = null;
        return this;
    }

    public PutTask setDataString(String str) {
        return this.setDataBytes(str != null ? str.getBytes(StandardCharsets.UTF_8) : null);
    }

    @Override
    public PutTask setListener(TransportListener listener) {
        super.setListener(listener);
        return this;
    }

    public String toString() {
        return ">> " + this.getLocation();
    }
}

